/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateDimFieldScopeEntry;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.collections.CollectionUtils;

public class IntrTmplDimFieldScopePlugin
extends AbstractBaseFormPlugin {
    private static final String FIXVALUE = "fixvalue";
    private static final String DIMENTRY = "dimentry";
    public static final String LIST_SHOWDIM = "showdim";
    public static final String LIST_DIM = "dim";
    public static final String LIST_DIMID = "dimid";
    public static final String LIST_DIMNUM = "dimnum";
    public static final String ISFIX = "isfix";
    public static final String MEMBERSCOPE = "memberscope";
    public static final String BTNOK = "btnok";
    public static final String LIST_DIAPLAYMODE = "diaplaymode";
    private static final String IS_MODIFY = "is_modify";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit fixvalue = (BasedataEdit)this.getControl(FIXVALUE);
        fixvalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK, FIXVALUE, MEMBERSCOPE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MEMBERSCOPE.equals(key) && (e.getChangeSet()[0].getNewValue() == null || "".equals(e.getChangeSet()[0].getNewValue()))) {
            String cacheKey = e.getChangeSet()[0].getDataEntity().getString(LIST_DIMNUM);
            this.getPageCache().remove(cacheKey);
            this.setModified(true);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{LIST_DIM, LIST_DIMID, LIST_DIMNUM});
        this.getPageCache().put("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("model").toString());
        Long mergeModelId = (Long)this.getView().getFormShowParameter().getCustomParam("mergenode");
        if (mergeModelId == null || mergeModelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u62d3\u5c55\u6570\u636e\u533a\u57df\u3002", (String)"IntrTmplDimFieldScopePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.initGrid();
        if ("true".equals(this.getFormCustomParam("noModify"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNOK});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String methodName = PlatUtil.getOpMethod();
        if ("click".equalsIgnoreCase(methodName)) {
            this.showSingleF7(event, SingleF7TypeEnum.LEAF);
        } else if ("getLookupList".equalsIgnoreCase(methodName) || "showMore".equalsIgnoreCase(methodName)) {
            QFilter filter;
            this.setModified(true);
            EntryGrid eg = (EntryGrid)this.getControl(DIMENTRY);
            DynamicObject obj = this.getModel().getEntryRowEntity(DIMENTRY, eg.getSelectRows()[0]);
            String orderBy = "id";
            if (this.isExtendFieldEnum(obj)) {
                DynamicObjectCollection enumItems = ExtDimHelper.getEnumValuesByExtendFieldId((Long)obj.getLong(LIST_DIMID));
                filter = new QFilter("id", "in", enumItems.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
                orderBy = "dseq";
            } else {
                filter = new QFilter("dimension", "=", obj.get(LIST_DIMID));
            }
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(filter);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, orderBy));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIXVALUE));
        }
    }

    private void showSingleF7(BeforeF7SelectEvent event, SingleF7TypeEnum typeEnum) {
        BasedataEdit bs = (BasedataEdit)event.getSource();
        EntryGrid eg = (EntryGrid)this.getControl(DIMENTRY);
        DynamicObject obj = this.getModel().getEntryRowEntity(DIMENTRY, eg.getSelectRows()[0]);
        if (this.isExtendFieldEnum(obj)) {
            if (event.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                DynamicObjectCollection enumItems = ExtDimHelper.getEnumValuesByExtendFieldId((Long)obj.getLong(LIST_DIMID));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                qFilters.add(new QFilter("id", "in", enumItems.stream().map(e -> e.getLong("id")).collect(Collectors.toSet())));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilters, "dseq"));
            }
        } else {
            event.setCancel(true);
            BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), obj.getLong(LIST_DIMID), bs.getKey(), null, true, typeEnum);
            f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            f7.setCallBackClassName(this.getClass().getName());
            f7.setStatus(OperationStatus.EDIT);
            f7.click();
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "memberscope": {
                EntryGrid eg = (EntryGrid)this.getControl(DIMENTRY);
                DynamicObject obj = this.getModel().getEntryRowEntity(DIMENTRY, eg.getSelectRows()[0]);
                FormShowParameter formParam = new FormShowParameter();
                if (this.isExtendFieldEnum(obj)) {
                    ListShowParameter listShowParameter = new ListShowParameter();
                    listShowParameter.setFormId("bos_listf7");
                    listShowParameter.setBillFormId("bcm_enumvalue");
                    listShowParameter.setStatus(OperationStatus.ADDNEW);
                    listShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
                    StyleCss css = new StyleCss();
                    css.setWidth("960px");
                    css.setHeight("580px");
                    listShowParameter.getOpenStyle().setInlineStyleCss(css);
                    listShowParameter.setF7Style(0);
                    listShowParameter.setShowTitle(false);
                    listShowParameter.setHasRight(true);
                    listShowParameter.setMultiSelect(true);
                    listShowParameter.setShowFilter(false);
                    listShowParameter.setShowQuickFilter(false);
                    listShowParameter.setLookUp(true);
                    listShowParameter.setSelectedRows(this.getSelectedRowIds(obj).toArray());
                    DynamicObjectCollection enumItems = ExtDimHelper.getEnumValuesByExtendFieldId((Long)obj.getLong(LIST_DIMID));
                    QFilter filter = new QFilter("id", "in", enumItems.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
                    listShowParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(filter), "dseq"));
                    formParam = listShowParameter;
                } else {
                    if (obj.getString(LIST_DIMNUM).equals(DimTypesEnum.INTERCOMPANY.getNumber())) {
                        formParam.setFormId("bcm_mulmemberf7_tem_ic");
                    } else {
                        formParam.setFormId("bcm_mulmemberf7base_tem");
                    }
                    formParam.getOpenStyle().setShowType(ShowType.Modal);
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    params.put("sign", obj.getString(LIST_DIMNUM));
                    DynamicObject doc = MemberReader.getDimensionDynById((long)obj.getLong(LIST_DIMID));
                    params.put("dimension", doc.getString("dseq"));
                    formParam.setCustomParams(params);
                    formParam.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString(LIST_SHOWDIM)));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, MEMBERSCOPE);
                formParam.setCloseCallBack(closeCallBack);
                this.getView().showForm(formParam);
                break;
            }
            case "btnok": {
                DynamicObjectCollection dimEntrys = this.getModel().getEntryEntity(DIMENTRY);
                ArrayList<PaperTemplateDimFieldScopeEntry> result = new ArrayList<PaperTemplateDimFieldScopeEntry>(16);
                for (DynamicObject dim : dimEntrys) {
                    if (!this.checkDim(dim)) {
                        return;
                    }
                    boolean isFix = dim.getBoolean(ISFIX);
                    if (isFix) {
                        result.add(this.converToEntry(dim, null));
                        continue;
                    }
                    String dimNum = dim.getString(LIST_DIMNUM);
                    String scopeStr = this.getPageCache().get(dimNum);
                    if (StringUtils.isNotEmpty((CharSequence)scopeStr)) {
                        List scopeMapList = SerializationUtils.fromJsonStringToList((String)scopeStr, Map.class);
                        if (CollectionUtils.isNotEmpty((Collection)scopeMapList)) {
                            for (Map scopeMap : scopeMapList) {
                                result.add(this.converToEntry(dim, scopeMap));
                            }
                            continue;
                        }
                        result.add(this.converToEntry(dim, null));
                        continue;
                    }
                    result.add(this.converToEntry(dim, null));
                }
                HashMap<String, Serializable> returnData = new HashMap<String, Serializable>(16);
                returnData.put("dimFieldScope", result);
                returnData.put(IS_MODIFY, Boolean.valueOf(this.isModified()));
                this.getView().returnDataToParent((Object)ObjectSerialUtil.toByteSerialized(returnData));
                this.getView().close();
                break;
            }
        }
    }

    private List<Long> getSelectedRowIds(DynamicObject obj) {
        List scopeMapList;
        ArrayList<Long> result = new ArrayList<Long>(16);
        String scopeStr = this.getPageCache().get(obj.getString(LIST_DIMNUM));
        if (StringUtils.isNotEmpty((CharSequence)scopeStr) && CollectionUtils.isNotEmpty((Collection)(scopeMapList = SerializationUtils.fromJsonStringToList((String)scopeStr, Map.class)))) {
            for (Map scopeMap : scopeMapList) {
                result.add(LongUtil.toLong(scopeMap.get("id")));
            }
        }
        return result;
    }

    private boolean checkDim(DynamicObject dim) {
        boolean isFix = dim.getBoolean(ISFIX);
        String dimNum = dim.getString(LIST_DIMNUM);
        String dimClassType = dim.getString(LIST_DIM);
        if ("bcm_structofextend".equals(dimClassType)) {
            return true;
        }
        Object joinFieldDimensionIdstr = this.getView().getFormShowParameter().getCustomParam("joinFieldDimensionIds");
        Set joinFieldDimensionIds = new HashSet(16);
        if (joinFieldDimensionIdstr != null) {
            joinFieldDimensionIds = (Set)ObjectSerialUtil.deSerializedBytes((String)joinFieldDimensionIdstr.toString());
        }
        if (PresetConstant.ENTITY_DIM.equals(dimNum) || PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum) || joinFieldDimensionIds.contains(dim.getLong(LIST_DIMID))) {
            return true;
        }
        if (isFix) {
            DynamicObject fixDoc = dim.getDynamicObject(FIXVALUE);
            if (fixDoc == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u56fa\u5b9a\u6210\u5458\u3002", (String)"IntrTmplDimFieldScopePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString(LIST_SHOWDIM)));
                return false;
            }
        } else if (StringUtils.isBlank((CharSequence)dim.getString(MEMBERSCOPE))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u6210\u5458\u8303\u56f4\u3002", (String)"IntrTmplDimFieldScopePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString(LIST_SHOWDIM)));
            return false;
        }
        return true;
    }

    private PaperTemplateDimFieldScopeEntry converToEntry(DynamicObject dim, Map<String, String> scopeMap) {
        PaperTemplateDimFieldScopeEntry entry = new PaperTemplateDimFieldScopeEntry();
        boolean isFix = dim.getBoolean(ISFIX);
        if (isFix) {
            DynamicObject fixDoc = dim.getDynamicObject(FIXVALUE);
            if (fixDoc != null) {
                entry.setFixvalueid(Long.valueOf(fixDoc.getLong("id")));
            }
        } else if (scopeMap != null) {
            Long pid = LongUtil.toLong((Object)scopeMap.get("pid"));
            if (pid != 0L) {
                entry.setPropertyid(LongUtil.toLong((Object)scopeMap.get("id")));
            } else {
                entry.setMemberid(LongUtil.toLong((Object)scopeMap.get("id")));
            }
            entry.setScope(Integer.valueOf(Integer.parseInt(scopeMap.get("scope"))));
        }
        entry.setDisplaymode(dim.getString(LIST_DIAPLAYMODE));
        if (this.isExtendFieldEnum(dim) || this.isLinkDimField(dim)) {
            entry.setExtendFieldId(Long.valueOf(dim.getLong(LIST_DIMID)));
        } else {
            entry.setDimension(Long.valueOf(dim.getLong(LIST_DIMID)));
        }
        entry.setIsFix(Boolean.valueOf(isFix));
        entry.setSeq(dim.getInt("seq"));
        return entry;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (event.getReturnData() == null) {
            return;
        }
        if (MEMBERSCOPE.equals(actionId)) {
            MultiF7Results mps = new MultiF7Results();
            EntryGrid eg = (EntryGrid)this.getControl(DIMENTRY);
            DynamicObject selobj = this.getModel().getEntryRowEntity(DIMENTRY, eg.getSelectRows()[0]);
            if (this.isExtendFieldEnum(selobj)) {
                ListSelectedRowCollection rowCollection = (ListSelectedRowCollection)event.getReturnData();
                for (ListSelectedRow row : rowCollection) {
                    MultiF7Result mp = new MultiF7Result();
                    mp.setId(LongUtil.toLong((Object)row.getPrimaryKeyValue()).longValue());
                    mp.setName(row.getName());
                    mp.setScope(RangeEnum.VALUE_10.getValue());
                    mps.getList().add(mp);
                }
            } else {
                DynamicObjectCollection doc = (DynamicObjectCollection)event.getReturnData();
                mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
                for (MultiF7Result res : mps.getList()) {
                    IDNumberTreeNode node;
                    if (res.getPid() != 0L || IDNumberTreeNode.NotFoundTreeNode == (node = MemberReader.findMemberById((long)this.getModelId(), (String)selobj.getString(LIST_DIM), (Long)res.getId())) || !node.isShare()) continue;
                    res.setId(node.getCopyfromId().longValue());
                }
            }
            this.getModel().setValue(MEMBERSCOPE, (Object)mps.getShowText(), eg.getSelectRows()[0]);
            this.setModified(true);
            this.getPageCache().put(selobj.getString(LIST_DIMNUM), SerializationUtils.toJsonString((Object)mps.toList()));
        } else if (FIXVALUE.equals(actionId)) {
            IDNumberTreeNode node;
            EntryGrid eg = (EntryGrid)this.getControl(DIMENTRY);
            DynamicObject selobj = this.getModel().getEntryRowEntity(DIMENTRY, eg.getSelectRows()[0]);
            Object pkId = null;
            pkId = event.getReturnData() instanceof ListSelectedRowCollection ? ((ListSelectedRowCollection)event.getReturnData()).get(0).getPrimaryKeyValue() : ((DynamicObject)event.getReturnData()).get("id");
            if (!this.isExtendFieldEnum(selobj) && IDNumberTreeNode.NotFoundTreeNode != (node = MemberReader.findMemberById((long)this.getModelId(), (String)selobj.getString(LIST_DIM), (Long)LongUtil.toLong((Object)pkId))) && node.isShare()) {
                pkId = node.getCopyfromId();
            }
            this.getModel().setValue(FIXVALUE, pkId, eg.getSelectRows()[0]);
            this.setModified(true);
        }
    }

    private boolean isExtendFieldEnum(DynamicObject row) {
        return "bcm_enumvalue".equals(row.getString(LIST_DIM));
    }

    private boolean isLinkDimField(DynamicObject row) {
        return "bcm_structofextend".equals(row.getString(LIST_DIM));
    }

    private void initGrid() {
        String fieldRefIdStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldRefIds");
        Set fieldRefIds = new HashSet(16);
        if (!StringUtils.isBlank((CharSequence)fieldRefIdStr)) {
            fieldRefIds = (Set)ObjectSerialUtil.deSerializedBytes((String)fieldRefIdStr);
        }
        List dimFields = ExtDimHelper.getDimFieldByRefIds(fieldRefIds);
        String extfieldIdStr = (String)this.getView().getFormShowParameter().getCustomParam("extfieldIds");
        Set extfieldRefIds = new HashSet(16);
        if (!StringUtils.isBlank((CharSequence)fieldRefIdStr)) {
            extfieldRefIds = (Set)ObjectSerialUtil.deSerializedBytes((String)extfieldIdStr);
        }
        List extFields = ExtDimHelper.getExtendFieldsByRefIds((long)this.getModelId(), extfieldRefIds).stream().filter(e -> DataTypeEnum.ENUMTP.getOIndex().equals(e.getDataType()) && !"INTR_000".equals(e.getNumber()) || e.isLinkDim()).sorted(Comparator.comparingInt(IntrField::getSeq)).collect(Collectors.toList());
        dimFields.addAll(extFields);
        dimFields = dimFields.stream().sorted(Comparator.comparing(IntrField::getSeq)).collect(Collectors.toList());
        Object dimScopeStr = this.getView().getFormShowParameter().getCustomParam("paperTemplateDimFieldScope");
        Map<Long, List<PaperTemplateDimFieldScopeEntry>> dimensionScopeMap = null;
        if (dimScopeStr != null) {
            List scopeEntrys = (List)ObjectSerialUtil.deSerializedBytes((String)dimScopeStr.toString());
            dimensionScopeMap = scopeEntrys.stream().collect(Collectors.groupingBy(e -> e.getDimension() != null && e.getDimension() != 0L ? e.getDimension() : e.getExtendFieldId()));
        }
        Object joinFieldDimensionIdstr = this.getView().getFormShowParameter().getCustomParam("joinFieldDimensionIds");
        HashSet<Long> joinFieldDimensionIds = new HashSet(16);
        if (joinFieldDimensionIdstr != null) {
            joinFieldDimensionIds = (Set)ObjectSerialUtil.deSerializedBytes((String)joinFieldDimensionIdstr.toString());
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(DIMENTRY, dimFields.size() + 2);
        Long entityDimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
        IntrField entityField = new IntrField(entityDimId, PresetConstant.ENTITY_DIM, IntrConstant.getSellerName(), LIST_DIM, null, null, null, null, null, null);
        this.initRowData(0, dimensionScopeMap, entityField, joinFieldDimensionIds);
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{FIXVALUE, ISFIX, MEMBERSCOPE});
        Long internalCompanyDimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.INTERNALCOMPANY_DIM);
        IntrField internalCompanyField = new IntrField(internalCompanyDimId, PresetConstant.INTERNALCOMPANY_DIM, IntrConstant.getBuyerName(), LIST_DIM, null, null, null, null, null, null);
        this.initRowData(1, dimensionScopeMap, internalCompanyField, joinFieldDimensionIds);
        this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{FIXVALUE, ISFIX, MEMBERSCOPE});
        int rowIndex = 2;
        for (IntrField field : dimFields) {
            this.initRowData(rowIndex, dimensionScopeMap, field, joinFieldDimensionIds);
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView(DIMENTRY);
        this.setModified(false);
    }

    private void initRowData(int rowIndex, Map<Long, List<PaperTemplateDimFieldScopeEntry>> dimensionScopeMap, IntrField field, Set<Long> joinFieldDimensionIds) {
        Long dimId = field.getId();
        String dimNum = field.getNumber();
        String dimName = field.getName();
        boolean isExtendField = "ext".equals(field.getExtFieldRefType());
        this.getModel().setValue(LIST_SHOWDIM, (Object)dimName, rowIndex);
        this.getModel().setValue(LIST_DIMID, (Object)dimId, rowIndex);
        this.getModel().setValue(LIST_DIMNUM, (Object)dimNum, rowIndex);
        DynamicObject dimDyn = null;
        if (isExtendField) {
            if (field.isLinkDim()) {
                this.getModel().setValue(LIST_DIM, (Object)"bcm_structofextend", rowIndex);
                this.getModel().setValue(LIST_DIAPLAYMODE, (Object)IntrDimDisplayModeEnum.NUMBERANDNAME.value, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISFIX, MEMBERSCOPE, FIXVALUE});
            } else {
                this.getModel().setValue(LIST_DIM, (Object)"bcm_enumvalue", rowIndex);
                this.getModel().setValue(LIST_DIAPLAYMODE, (Object)IntrDimDisplayModeEnum.NAME.value, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{LIST_DIAPLAYMODE});
            }
        } else {
            dimDyn = MemberReader.getDimensionDynById((long)dimId);
            if (dimDyn == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230id\u4e3a%1$s\u7684%2$s\uff0c\u8bf7\u6e05\u9664\u7f13\u5b58\u518d\u91cd\u8bd5\u3002", (String)"IntrTmplDimFieldScopePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimId, dimName));
                return;
            }
            this.getModel().setValue(LIST_DIM, (Object)dimDyn.getString("membermodel"), rowIndex);
        }
        if (dimensionScopeMap != null && CollectionUtils.isNotEmpty((Collection)dimensionScopeMap.get(dimId))) {
            List<PaperTemplateDimFieldScopeEntry> dimScopes = dimensionScopeMap.get(dimId);
            this.getModel().setValue(ISFIX, (Object)dimScopes.get(0).isFix(), rowIndex);
            this.getModel().setValue(FIXVALUE, (Object)dimScopes.get(0).getFixvalueid(), rowIndex);
            this.getModel().setValue(LIST_DIAPLAYMODE, (Object)dimScopes.get(0).getDisplaymode(), rowIndex);
            if (!joinFieldDimensionIds.contains(dimId)) {
                MultiF7Results f7result = null;
                f7result = !(dimScopes.size() != 1 || dimScopes.get(0).getMemberid() != null && dimScopes.get(0).getMemberid() != 0L || dimScopes.get(0).getPropertyid() != null && dimScopes.get(0).getPropertyid() != 0L || dimScopes.get(0).getFixvalueid() != null && dimScopes.get(0).getFixvalueid() != 0L || PresetConstant.ENTITY_DIM.equals(dimNum) || PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum)) ? this.buildParam(dimId, dimDyn, this.getDefaultScope(isExtendField, dimId, dimNum)) : this.buildParam(dimId, dimDyn, dimScopes);
                this.getModel().setValue(MEMBERSCOPE, (Object)f7result.getShowText(), rowIndex);
                this.getPageCache().put(dimNum, SerializationUtils.toJsonString((Object)f7result.toList()));
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{FIXVALUE, ISFIX, MEMBERSCOPE});
            }
        } else {
            if (PresetConstant.ENTITY_DIM.equals(dimNum) || PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum)) {
                return;
            }
            if (joinFieldDimensionIds.contains(dimId)) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{FIXVALUE, ISFIX, MEMBERSCOPE});
                return;
            }
            MultiF7Results f7result = this.buildParam(dimId, dimDyn, this.getDefaultScope(isExtendField, dimId, dimNum));
            this.getModel().setValue(MEMBERSCOPE, (Object)f7result.getShowText(), rowIndex);
            this.getPageCache().put(dimNum, SerializationUtils.toJsonString((Object)f7result.toList()));
        }
    }

    private List<PaperTemplateDimFieldScopeEntry> getDefaultScope(boolean isExtendField, Long dimId, String dimNum) {
        ArrayList<PaperTemplateDimFieldScopeEntry> defaultScopes = new ArrayList<PaperTemplateDimFieldScopeEntry>(16);
        if (isExtendField) {
            DynamicObjectCollection enumItems = ExtDimHelper.getEnumValuesByExtendFieldId((Long)dimId);
            for (DynamicObject enumItem : enumItems) {
                PaperTemplateDimFieldScopeEntry defaultScope = new PaperTemplateDimFieldScopeEntry();
                defaultScope.setMemberid(Long.valueOf(enumItem.getLong("id")));
                defaultScope.setName(enumItem.getString("enumvalue"));
                defaultScope.setScope(Integer.valueOf(RangeEnum.VALUE_10.getValue()));
                defaultScopes.add(defaultScope);
            }
        } else {
            PaperTemplateDimFieldScopeEntry defaultScope = new PaperTemplateDimFieldScopeEntry();
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dimNum, (String)dimNum);
            defaultScope.setMemberid(node.getId());
            defaultScope.setScope(Integer.valueOf(RangeEnum.VALUE_90.getValue()));
            defaultScopes.add(defaultScope);
        }
        return defaultScopes;
    }

    private MultiF7Results buildParam(Long dimId, DynamicObject dimDyn, List<PaperTemplateDimFieldScopeEntry> dimScopes) {
        MultiF7Results mps = new MultiF7Results();
        if (CollectionUtils.isEmpty(dimScopes)) {
            return mps;
        }
        if (dimDyn != null) {
            for (PaperTemplateDimFieldScopeEntry dimscope : dimScopes) {
                DynamicObject propertyDyn;
                IDNumberTreeNode memberNode;
                MultiF7Result mp = new MultiF7Result();
                if (dimscope.getMemberid() != null && dimscope.getMemberid() != 0L && IDNumberTreeNode.NotFoundTreeNode != (memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)dimDyn.getString("membermodel"), (Long)dimscope.getMemberid()))) {
                    mp.setId(memberNode.getId().longValue());
                    mp.setName(memberNode.getName());
                    mp.setNumber(memberNode.getNumber());
                }
                if (dimscope.getPropertyid() != null && dimscope.getPropertyid() != 0L && (propertyDyn = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimscope.getPropertyid())})) != null) {
                    mp.setId(propertyDyn.getLong("id"));
                    mp.setPid(propertyDyn.getLong("id"));
                    mp.setName(propertyDyn.getString("name"));
                    mp.setNumber(propertyDyn.getString("number"));
                }
                if (dimscope.getScope() == null || (long)dimscope.getScope().intValue() == 0L) continue;
                mp.setScope(dimscope.getScope().intValue());
                mps.getList().add(mp);
            }
        } else {
            DynamicObjectCollection enumItems = ExtDimHelper.getEnumValuesByExtendFieldId((Long)dimId);
            Map<Long, DynamicObject> enumMap = enumItems.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v2));
            for (PaperTemplateDimFieldScopeEntry dimFieldScopeEntry : dimScopes) {
                DynamicObject dynamicObject = enumMap.get(dimFieldScopeEntry.getMemberid());
                if (dynamicObject == null) continue;
                MultiF7Result mp = new MultiF7Result();
                mp.setId(dimFieldScopeEntry.getMemberid().longValue());
                mp.setName(dynamicObject.getString("enumvalue"));
                mp.setScope(dimFieldScopeEntry.getScope().intValue());
                mps.getList().add(mp);
            }
        }
        return mps;
    }

    private void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag(IS_MODIFY, isModified);
    }

    private boolean isModified() {
        return this.isTrueFlagInCache(IS_MODIFY);
    }
}

