/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.ReadOrWriteAuthFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import org.apache.commons.collections4.CollectionUtils;

public class IntrTmplOrderPlugin
extends AbstractBaseListPlugin
implements DynamicPage {
    private static String PANEL = "datapanel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok", "btncancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)modelId);
        this.listCheckTmpl();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (this.getPage(this.getView()) == null && ("btnok".equals(key) || "btncancel".equals(key))) {
            this.getView().close();
            return;
        }
        Area area = (Area)this.getPage(this.getView()).seaechSign(PANEL);
        List elementList = area.getElementListList();
        if (CollectionUtils.isEmpty((Collection)elementList)) {
            return;
        }
        switch (key) {
            case "btnok": {
                this.updateTmplsOrder(elementList);
                this.getView().setReturnData((Object)true);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
                break;
            }
            case "btncancel": {
                if (this.checkChangedSeq(elementList)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u987a\u5e8f\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"CheckTmplOrderPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exit_save", (IFormPlugin)this));
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkChangedSeq(List<Element> elementList) {
        for (int i = 0; i < elementList.size(); ++i) {
            if (Long.parseLong(elementList.get(i).getUserObject("seq").toString()) == (long)(i + 1)) continue;
            return true;
        }
        return false;
    }

    private void listCheckTmpl() {
        Long sceneId = null;
        Object sceneObj = this.getView().getFormShowParameter().getCustomParam("KEY_SCENARIO_ID");
        if (sceneObj != null && LongUtil.toLong((Object)sceneObj) != 0L) {
            sceneId = LongUtil.toLong((Object)sceneObj);
        }
        PaperTmplChainFilter filter = new PaperTmplChainFilter(Long.valueOf(this.getModelId()), PaperTemplateTypeEnum.INNERTRADE, true);
        filter.addFilter((AbstractPaperFilter)new SceneFilter(sceneId));
        filter.addFilter((AbstractPaperFilter)new ReadOrWriteAuthFilter(Long.valueOf(this.getUserId())));
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,group", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)filter.doFilter(null))}, (String)"sequence asc,number asc,versionnumber asc");
        this.bindEntry(tmpls);
    }

    private void bindEntry(DynamicObjectCollection tmpls) {
        this.getModel().beginInit();
        LinkedHashMultimap tmplMaps = LinkedHashMultimap.create();
        for (DynamicObject doc : tmpls) {
            tmplMaps.put((Object)doc.getLong("group"), (Object)doc);
        }
        if (tmpls.size() > 0) {
            Collection docs;
            Page page = new Page();
            Area area = new Area(PANEL);
            String sign = "";
            LocaleString width = new LocaleString("90%");
            int seq = 1;
            for (Long group : tmplMaps.keySet()) {
                docs = tmplMaps.get((Object)group);
                DynamicObject tmp = (DynamicObject)docs.iterator().next();
                sign = "sign_" + tmp.getString("id");
                TextEditElement textEditElement = this.createTextEditElement(tmp.getString("number"), sign.toLowerCase(Locale.ENGLISH), width, 1);
                textEditElement.addUserObject("seq", (Object)seq);
                textEditElement.addUserObject("template_number_id", (Object)docs.stream().map(e -> String.valueOf(e.getLong("id"))).collect(Collectors.joining(",")));
                textEditElement.addUserObject("template_number", (Object)tmp.getString("number"));
                area.addElement((Element)textEditElement);
                ++seq;
            }
            page.addArea(area);
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
            page.setChangeable(true);
            this.setDraggable(page);
            for (Long group : tmplMaps.keySet()) {
                docs = tmplMaps.get((Object)group);
                DynamicObject tmpl = (DynamicObject)docs.iterator().next();
                sign = "sign_" + tmpl.getString("id");
                this.setValue(sign, tmpl.getString("number") + " | " + tmpl.getString("name"));
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setFieldStyle(1);
        textEditElement.setShowLabel(false);
        textEditElement.setHeight(new LocaleString("30px"));
        textEditElement.setLabelWidth(new LocaleString("0%"));
        textEditElement.setFieldTextAlign("left");
        textEditElement.setLock("new");
        return textEditElement;
    }

    private void updateTmplsOrder(List<Element> elementList) {
        ArrayList<DynamicObject> tmpList = new ArrayList<DynamicObject>(elementList.size());
        for (int i = 0; i < elementList.size(); ++i) {
            int sequence = i + 1;
            String templateids = elementList.get(i).getUserObject("template_number_id").toString();
            Set groupTmplIds = Arrays.stream(templateids.split(",")).map(LongUtil::toLong).collect(Collectors.toSet());
            for (Long templateId : groupTmplIds) {
                DynamicObject tmpl = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplate");
                tmpl.set("id", (Object)templateId);
                tmpl.set("sequence", (Object)sequence);
                tmpList.add(tmpl);
            }
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        op.setVariableValue("currentUserId", "false");
        SaveServiceHelper.update((DynamicObject[])tmpList.toArray(new DynamicObject[0]), (OperateOption)op);
        OperationLogUtil.writeOperationLog((String)OpItemEnum.SAVE.getName(), (String)ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6a21\u677f\u6392\u5e8f \u4fdd\u5b58\u6210\u529f", (String)"IntrTmplOrderPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId(), (String)"bcm_intrtmpl_order");
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            Page page = this.getPage(this.getView());
            boolean rebuildPageState = this.rebuildPage(page, eventArgs);
            if (rebuildPageState) {
                page.updatePage(this.getView());
                this.setPage(this.getView(), page);
                this.setDraggable(page);
            }
        }
    }

    private boolean rebuildPage(Page page, String command) {
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String dropSign = source.getSign();
        Area sourceArea = source.getArea();
        Area targetArea = ((Element)target).getArea();
        Element dropElement = source;
        int i = targetArea.getElementListList().indexOf(target);
        targetArea.removeElememt(dropSign);
        sourceArea.removeElememt(dropSign);
        dropElement.setArea(targetArea);
        targetArea.getElementListList().add(i, dropElement);
        return true;
    }

    private void setDraggable(Page page) {
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> {
            this.getView().getControl(e.getSign()).setDroppable(true);
            this.getView().getControl(e.getSign()).setDraggable(true);
        }));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("exit_save".equals(key)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                Area area = (Area)this.getPage(this.getView()).seaechSign(PANEL);
                this.updateTmplsOrder(area.getElementListList());
                this.getView().setReturnData((Object)true);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
            } else {
                this.getView().close();
            }
        }
    }

    private Long getValueId(String keyName) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(keyName);
        Long res = 0L;
        if (obj != null) {
            res = obj.getLong("id");
        }
        return res;
    }
}

