/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class IntrTmplReportRecordPlugin
extends AbstractBaseListPlugin {
    private static String ORDERBY_STR = "papertemplate.number asc,entity.number asc";
    private static final String billlistap = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(billlistap);
        billList.setBillFormId("bcm_intrreportentity");
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
                IntrTmplReportRecordPlugin.this.beforeCreateListDataProvider(arg0);
            }
        });
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key;
            switch (key = ((ColumnDesc)e.getSource()).getKey()) {
                case "papertemplate.versionnumber": {
                    BigDecimal versionnumber = e.getRowData().getBigDecimal("papertemplate.versionnumber");
                    e.setFormatValue((Object)(versionnumber == null ? "" : String.format("V%.1f", Float.valueOf(versionnumber.floatValue()))));
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qFilter = null;
        Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        qFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qFilter.and("papertemplate.id", "in", this.getView().getFormShowParameter().getCustomParam("tmplIds"));
        e.getQFilters().add(qFilter);
        e.setOrderBy(ORDERBY_STR);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "refresh": {
                this.refresh();
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)LongUtil.toLong((Object)modelId));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        this.refresh();
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(billlistap);
        billList.refresh();
    }
}

