/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IFunctionSettingPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class LyvFunctionSettingPlugin
extends AbstractBaseFormPlugin
implements IFunctionSettingPlugin {
    public static final String KEY_MODEL = "extendmodel";
    public static final String KEY_FILED = "fieldid";
    public static final String BTN_CONFIRM = "confirm";
    public static final String KEY_TEXT = "modeltext";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, KEY_TEXT);
        BasedataEdit extendModelF7 = (BasedataEdit)this.getControl(KEY_MODEL);
        extendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam("formula") != null) {
            String formula = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formula, encoder);
                ParamList paramList = ((IFormula)((List)pair.p2).get(0)).getParamList();
                String[] params = ((ParamItem)paramList.get(0)).toString().split("@");
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)params[0])});
                IntrField field = ExtDimHelper.getTmpFieldByNum((Long)modelDyn.getLong("id"), (String)params[1]);
                this.getModel().setValue(KEY_MODEL, (Object)modelDyn.getLong("id"));
                if (field != null) {
                    this.getModel().setValue(KEY_FILED, (Object)field.getId());
                    this.getModel().setValue(KEY_TEXT, (Object)(modelDyn.getString("name") + "@" + field.getName()));
                }
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_MODEL, KEY_FILED});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(BTN_CONFIRM, key) && this.validate()) {
            String modelNumber = ((DynamicObject)this.getValue(KEY_MODEL)).getString("number");
            String modelName = ((DynamicObject)this.getValue(KEY_MODEL)).getString("name");
            String fieldNumber = "";
            String fieldName = "";
            Long fieldId = (Long)this.getValue(KEY_FILED);
            IntrField field = ExtDimHelper.getTmpFieldById((Long)fieldId);
            if (field != null) {
                fieldNumber = field.getNumber();
                fieldName = field.getName();
            }
            String formula = FormulaEnum.Lyv.getCode() + "(\"" + modelNumber + "@" + fieldNumber + "\")";
            HashMap map = Maps.newHashMap();
            map.put("formula", formula);
            map.put("name", String.format("%s(%s@%s)", FormulaEnum.Lyv.getText(), modelName, fieldName));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        } else if (Objects.equals(KEY_TEXT, key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("filterModelId", this.getFormCustomParam("mergenode"));
            Long fieldId = (Long)this.getFormCustomParam("fieldId");
            Set<String> fieldDataType = this.getFieldDataType(fieldId);
            if (!CollectionUtils.isEmpty(fieldDataType)) {
                formShowParameter.setCustomParam("filterDatatype", (Object)String.join((CharSequence)",", fieldDataType));
            }
            String caption = ResManager.loadKDString((String)"\u4e0a\u5e74\u671f\u672b\u6570\u8bbe\u7f6e", (String)"LyvFunctionSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.setFormShowParameter(this.getModel(), formShowParameter, KEY_MODEL, caption, KEY_MODEL, KEY_FILED, KEY_TEXT);
            this.getView().showForm(formShowParameter);
        }
    }

    private Set<String> getFieldDataType(Long fieldId) {
        DynamicObject filed = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"id,extfield.name,extfield.id, extfield.datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fieldId)});
        if (filed != null && IntrConstant.DB_DIGITAL_DATA_TYPE.contains(filed.getString("extfield.datatype"))) {
            return IntrConstant.DB_DIGITAL_DATA_TYPE;
        }
        return IntrConstant.DB_TEXT_DATA_TYPE;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        this.setExtendValue(this.getModel(), actionId, e.getReturnData());
    }

    private boolean validate() {
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_TEXT)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u4e0a\u5e74\u671f\u672b\u6570\u201d\u3002", (String)"LyvFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

