/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IFunctionSettingPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class MfFunctionSettingPlugin
extends AbstractBaseFormPlugin
implements IFunctionSettingPlugin {
    public static final String KEY_VALUE = "dvalue";
    public static final String KEY_MODEL = "extendmodel";
    public static final String KEY_FILED = "extendfieldid";
    public static final String KEY_FMODEL = "fextendmodel";
    public static final String KEY_FFILED = "fextendfieldid";
    public static final String KEY_BYMODEL = "byextendmodel";
    public static final String KEY_BYFILED = "byextendfieldid";
    public static final String BTN_CONFIRM = "confirm";
    public static final String KEY_TEXT = "modeltext";
    public static final String KEY_FTEXT = "fmodeltext";
    public static final String KEY_BYTEXT = "bymodeltext";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, KEY_TEXT, KEY_FTEXT, KEY_BYTEXT);
        BasedataEdit extendModelF7 = (BasedataEdit)this.getControl(KEY_MODEL);
        extendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fExtendModelF7 = (BasedataEdit)this.getControl(KEY_FMODEL);
        fExtendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit byExtendModelF7 = (BasedataEdit)this.getControl(KEY_BYMODEL);
        byExtendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValue();
        if (this.getFormCustomParam("formula") != null) {
            String formulaText = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formulaText, encoder);
                ParamList paramList = ((IFormula)((List)pair.p2).get(0)).getParamList();
                String dValue = ((ParamItem)paramList.get(0)).toString();
                this.getModel().setValue(KEY_VALUE, (Object)dValue);
                String[] params = ((ParamItem)paramList.get(1)).toString().split("@");
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)params[0])});
                this.getModel().setValue(KEY_MODEL, (Object)modelDyn.getLong("id"));
                IntrField field = ExtDimHelper.getTmpFieldByNum((Long)modelDyn.getLong("id"), (String)params[1]);
                if (field != null) {
                    this.getModel().setValue(KEY_FILED, (Object)field.getId());
                    this.getModel().setValue(KEY_TEXT, (Object)(modelDyn.getString("name") + "@" + field.getName()));
                }
                String[] fParams = ((ParamItem)paramList.get(2)).toString().split("@");
                DynamicObject fModelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)fParams[0])});
                this.getModel().setValue(KEY_FMODEL, (Object)fModelDyn.getLong("id"));
                IntrField fField = ExtDimHelper.getTmpFieldByNum((Long)fModelDyn.getLong("id"), (String)fParams[1]);
                if (fField != null) {
                    this.getModel().setValue(KEY_FFILED, (Object)fField.getId());
                    this.getModel().setValue(KEY_FTEXT, (Object)(fModelDyn.getString("name") + "@" + fField.getName()));
                }
                String[] byParams = ((ParamItem)paramList.get(3)).toString().split("@");
                DynamicObject byModelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)byParams[0])});
                this.getModel().setValue(KEY_BYMODEL, (Object)byModelDyn.getLong("id"));
                IntrField byField = ExtDimHelper.getTmpFieldByNum((Long)byModelDyn.getLong("id"), (String)byParams[1]);
                if (byField != null) {
                    this.getModel().setValue(KEY_BYFILED, (Object)byField.getId());
                    this.getModel().setValue(KEY_BYTEXT, (Object)(byModelDyn.getString("name") + "@" + byField.getName()));
                }
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        } else {
            this.setDefaultValue();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_MODEL, KEY_FILED, KEY_FMODEL, KEY_FFILED, KEY_BYMODEL, KEY_BYFILED, KEY_TEXT});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(BTN_CONFIRM, key) && this.validate()) {
            try {
                String formula = "";
                String name = "";
                if (!(this.isBlank(this.getValue(KEY_VALUE)) || this.isBlank(this.getValue(KEY_FTEXT)) || this.isBlank(this.getValue(KEY_BYTEXT)))) {
                    String dValue = (String)this.getValue(KEY_VALUE);
                    String modelNumber = ((DynamicObject)this.getValue(KEY_MODEL)).getString("number");
                    String fieldNumber = "";
                    Long fieldId = (Long)this.getValue(KEY_FILED);
                    IntrField field = ExtDimHelper.getTmpFieldById((Long)fieldId);
                    if (field != null) {
                        fieldNumber = field.getNumber();
                    }
                    String fModelNumber = ((DynamicObject)this.getValue(KEY_FMODEL)).getString("number");
                    String fFieldNumber = "";
                    Long ffieldId = (Long)this.getValue(KEY_FFILED);
                    IntrField ffield = ExtDimHelper.getTmpFieldById((Long)ffieldId);
                    if (ffield != null) {
                        fFieldNumber = ffield.getNumber();
                    }
                    String byModelNumber = ((DynamicObject)this.getValue(KEY_BYMODEL)).getString("number");
                    String byFieldNumber = "";
                    Long byfieldId = (Long)this.getValue(KEY_BYFILED);
                    IntrField byfield = ExtDimHelper.getTmpFieldById((Long)byfieldId);
                    if (byfield != null) {
                        byFieldNumber = byfield.getNumber();
                    }
                    formula = FormulaEnum.Mf.getCode() + "(\"" + dValue + "\",\"" + modelNumber + "@" + fieldNumber + "\",\"" + fModelNumber + "@" + fFieldNumber + "\",\"" + byModelNumber + "@" + byFieldNumber + "\")";
                    name = String.format("%s(%s)", FormulaEnum.Mf.getText(), dValue);
                }
                HashMap map = Maps.newHashMap();
                map.put("formula", formula);
                map.put("name", name);
                this.getView().returnDataToParent((Object)map);
                this.getView().close();
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u8bbe\u7f6e\u5f02\u5e38\u3002", (String)"MfFunctionSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if (Objects.equals(KEY_TEXT, key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            Long mergenode = (Long)this.getFormCustomParam("mergenode");
            formShowParameter.setCustomParam("filterModelId", (Object)mergenode);
            this.setFormShowParameter(this.getModel(), formShowParameter, KEY_MODEL, null, KEY_MODEL, KEY_FILED, KEY_TEXT);
            this.getView().showForm(formShowParameter);
        } else if (Objects.equals(KEY_FTEXT, key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            Long seller = (Long)this.getFormCustomParam("seller");
            formShowParameter.setCustomParam("filterModelId", (Object)seller);
            formShowParameter.setCustomParam("filterDatatype", (Object)String.join((CharSequence)",", IntrConstant.DIGITAL_DATA_TYPE));
            this.setFormShowParameter(this.getModel(), formShowParameter, KEY_MODEL, null, KEY_FMODEL, KEY_FFILED, KEY_FTEXT);
            this.getView().showForm(formShowParameter);
        } else if (Objects.equals(KEY_BYTEXT, key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            Long purchaser = (Long)this.getFormCustomParam("purchaser");
            formShowParameter.setCustomParam("filterModelId", (Object)purchaser);
            formShowParameter.setCustomParam("filterDatatype", (Object)String.join((CharSequence)",", IntrConstant.DIGITAL_DATA_TYPE));
            this.setFormShowParameter(this.getModel(), formShowParameter, KEY_MODEL, null, KEY_BYMODEL, KEY_BYFILED, KEY_BYTEXT);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        this.setExtendValue(this.getModel(), actionId, e.getReturnData());
    }

    private boolean validate() {
        if (this.isBlank(this.getValue(KEY_VALUE)) && this.isBlank(this.getValue(KEY_FTEXT)) && this.isBlank(this.getValue(KEY_BYTEXT))) {
            return true;
        }
        if (this.isBlank(this.getValue(KEY_VALUE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u5dee\u989d\u9879\u4e1a\u52a1\u7c7b\u578b\u201d\u3002", (String)"MfFunctionSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isBlank(this.getValue(KEY_MODEL)) || this.isBlank(this.getValue(KEY_FILED))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u6210\u5458\u4e1a\u52a1\u6a21\u578b\u201d\u3002", (String)"MfFunctionSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isBlank(this.getValue(KEY_FMODEL)) || this.isBlank(this.getValue(KEY_FFILED)) || this.isBlank(this.getValue(KEY_FTEXT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u9500\u552e\u65b9\u5bf9\u8d26\u6210\u5458\u201d\u3002", (String)"MfFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isBlank(this.getValue(KEY_BYMODEL)) || this.isBlank(this.getValue(KEY_BYFILED)) || this.isBlank(this.getValue(KEY_BYTEXT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u91c7\u8d2d\u65b9\u5bf9\u8d26\u6210\u5458\u201d\u3002", (String)"MfFunctionSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isBlank(Object value) {
        if (value == null) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)value.toString());
    }

    private void setDefaultValue() {
        Long extendModelId = (Long)this.getFormCustomParam("purchaser");
        this.getModel().setValue(KEY_MODEL, (Object)extendModelId);
        IntrField bisField = ExtDimHelper.getTmpFieldByNum((Long)extendModelId, (String)"INTR_001");
        String fieldName = "";
        if (bisField != null) {
            this.getModel().setValue(KEY_FILED, (Object)bisField.getId());
            fieldName = bisField.getName();
        }
        String modelName = "";
        DynamicObject modelDyn = (DynamicObject)this.getValue(KEY_MODEL);
        if (Objects.nonNull(modelDyn)) {
            modelName = modelDyn.getString("name");
        }
        this.getModel().setValue(KEY_TEXT, (Object)(modelName + "@" + fieldName));
    }

    private void initValue() {
        QFilter filter = new QFilter("model", "=", this.getFormCustomParam("KEY_MODEL_ID"));
        filter.and("status", "=", (Object)"C");
        filter.and("number", "=", (Object)"INTR_001");
        DynamicObjectCollection fieldList = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name,enumitem", (QFilter[])new QFilter[]{filter});
        if (0 == fieldList.size()) {
            return;
        }
        String enumitemId = ((DynamicObject)fieldList.get(0)).getString("enumitem");
        QFilter enumFilter = new QFilter("enumitemid", "=", (Object)Long.parseLong(enumitemId));
        DynamicObjectCollection enumvalueList = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,enumvalue,name", (QFilter[])new QFilter[]{enumFilter});
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_VALUE);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(enumvalueList.size());
        for (DynamicObject obj : enumvalueList) {
            String enumvalue = obj.getString("enumvalue");
            data.add(new ComboItem(new LocaleString(enumvalue), enumvalue));
        }
        comboEdit.setComboItems(data);
    }
}

