/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IFunctionSettingPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class PnFunctionSettingPlugin
extends AbstractBaseFormPlugin
implements IFunctionSettingPlugin {
    public static final String KEY_SYMODEL = "startyearmodel";
    public static final String KEY_SYFILED = "startyearfieldid";
    public static final String KEY_SYTEXT = "startyeartext";
    public static final String KEY_SMMODEL = "startmonthmodel";
    public static final String KEY_SMFILED = "startmonthfieldid";
    public static final String KEY_SMTEXT = "startmonthtext";
    public static final String KEY_EYMODEL = "endyearmodel";
    public static final String KEY_EYFILED = "endyearfieldid";
    public static final String KEY_EYTEXT = "endyeartext";
    public static final String KEY_EMMODEL = "endmonthmodel";
    public static final String KEY_EMFILED = "endmonthfieldid";
    public static final String KEY_EMTEXT = "endmonthtext";
    public static final String BTN_CONFIRM = "confirm";
    private static Map<String, String> KEY_CLICKMAP = new HashMap<String, String>(16);

    public PnFunctionSettingPlugin() {
        KEY_CLICKMAP.put(KEY_SYTEXT, KEY_SYFILED);
        KEY_CLICKMAP.put(KEY_SMTEXT, KEY_SMFILED);
        KEY_CLICKMAP.put(KEY_EYTEXT, KEY_EYFILED);
        KEY_CLICKMAP.put(KEY_EMTEXT, KEY_EMFILED);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, KEY_SYTEXT, KEY_SMTEXT, KEY_EYTEXT, KEY_EMTEXT);
        this.addBeforeF7SelectListener(KEY_SYMODEL, KEY_SMMODEL, KEY_EYMODEL, KEY_EMMODEL);
    }

    private void addBeforeF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam("formula") != null) {
            String formulaText = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formulaText, encoder);
                ParamList paramList = ((IFormula)((List)pair.p2).get(0)).getParamList();
                Pair<DynamicObject, IntrField> syPair = this.getElInfo(((ParamItem)paramList.get(0)).toString());
                Pair<DynamicObject, IntrField> smPair = this.getElInfo(((ParamItem)paramList.get(1)).toString());
                Pair<DynamicObject, IntrField> eyPair = this.getElInfo(((ParamItem)paramList.get(2)).toString());
                Pair<DynamicObject, IntrField> emPair = this.getElInfo(((ParamItem)paramList.get(3)).toString());
                this.setModelValue(syPair, "startyear");
                this.setModelValue(smPair, "startmonth");
                this.setModelValue(eyPair, "endyear");
                this.setModelValue(emPair, "endmonth");
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SYMODEL, KEY_SYFILED, KEY_SMMODEL, KEY_SMFILED, KEY_EYMODEL, KEY_EYFILED, KEY_EMMODEL, KEY_EMFILED});
    }

    private void setModelValue(Pair<DynamicObject, IntrField> pair, String prefix) {
        if (pair != null && pair.p1 != null && pair.p2 != null) {
            this.getModel().setValue(String.format("%smodel", prefix), (Object)((DynamicObject)pair.p1).getLong("id"));
            this.getModel().setValue(String.format("%sfieldid", prefix), (Object)((IntrField)pair.p2).getId());
            this.getModel().setValue(String.format("%stext", prefix), (Object)(((DynamicObject)pair.p1).getString("name") + "@" + ((IntrField)pair.p2).getName()));
        }
    }

    private Pair<DynamicObject, IntrField> getElInfo(String funStr) {
        if ("currentYear".equals(funStr) || "currentPeriod".equals(funStr) || "startYear".equals(funStr) || "startPeriod".equals(funStr)) {
            return null;
        }
        if (funStr.contains("@")) {
            String[] params = funStr.split("@");
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)params[0])});
            IntrField field = ExtDimHelper.getTmpFieldByNum((Long)modelDyn.getLong("id"), (String)params[1]);
            return Pair.onePair((Object)modelDyn, (Object)field);
        }
        return null;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(BTN_CONFIRM, key) && this.validate()) {
            Pair<String, String> sy = this.getFormulaEl(KEY_SYMODEL, KEY_SYFILED);
            Pair<String, String> sm = this.getFormulaEl(KEY_SMMODEL, KEY_SMFILED);
            Pair<String, String> ey = this.getFormulaEl(KEY_EYMODEL, KEY_EYFILED);
            Pair<String, String> em = this.getFormulaEl(KEY_EMMODEL, KEY_EMFILED);
            String formula = String.format("%1$s(\"%2$s\",\"%3$s\",\"%4$s\",\"%5$s\")", FormulaEnum.Pn.getCode(), sy.p1, sm.p1, ey.p1, em.p1);
            String formulaName = String.format("%1$s(%2$s,%3$s\u2014%4$s,%5$s)", FormulaEnum.Pn.getText(), sy.p2, sm.p2, ey.p2, em.p2);
            HashMap map = Maps.newHashMap();
            map.put("formula", formula);
            map.put("name", formulaName);
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        } else if (KEY_CLICKMAP.containsKey(key)) {
            String fieldKey = KEY_CLICKMAP.get(key);
            String suf = fieldKey.replace("fieldid", "");
            String keyText = suf + "text";
            String keyModel = suf + "model";
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("filterModelId", this.getFormCustomParam("mergenode"));
            this.setFormShowParameter(this.getModel(), formShowParameter, "extendmodel", null, keyModel, fieldKey, keyText);
            this.getView().showForm(formShowParameter);
        }
    }

    private Pair<String, String> getFormulaEl(String model, String field) {
        Object m = this.getValue(model);
        Object f = this.getValue(field);
        if (m != null && f != null) {
            DynamicObject mDy = (DynamicObject)m;
            Long fieldId = (Long)f;
            String fieldNumber = "";
            String fieldName = "";
            IntrField intrField = ExtDimHelper.getTmpFieldById((Long)fieldId);
            if (intrField != null) {
                fieldNumber = intrField.getNumber();
                fieldName = intrField.getName();
            }
            return Pair.onePair((Object)String.format("%1$s@%2$s", mDy.getString("number"), fieldNumber), (Object)String.format("%1$s@%2$s", mDy.getString("name"), fieldName));
        }
        if (KEY_EYMODEL.equals(model)) {
            return Pair.onePair((Object)"currentYear", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74", (String)"PnFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (KEY_EMMODEL.equals(model)) {
            return Pair.onePair((Object)"currentPeriod", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4", (String)"PnFunctionSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (KEY_SYMODEL.equals(model)) {
            return Pair.onePair((Object)"startYear", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74", (String)"PnFunctionSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (KEY_SMMODEL.equals(model)) {
            return Pair.onePair((Object)"startPeriod", (Object)ResManager.loadKDString((String)"\u5e74\u521d\u671f\u95f4", (String)"PnFunctionSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Pair.onePair((Object)"", (Object)"");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        this.setExtendValue(this.getModel(), actionId, e.getReturnData());
    }

    private boolean validate() {
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_SYTEXT)))) {
            this.getModel().setValue(KEY_SYMODEL, null);
            this.getModel().setValue(KEY_SYFILED, null);
        }
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_SMTEXT)))) {
            this.getModel().setValue(KEY_SMMODEL, null);
            this.getModel().setValue(KEY_SMFILED, null);
        }
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_EYTEXT)))) {
            this.getModel().setValue(KEY_EYMODEL, null);
            this.getModel().setValue(KEY_EYFILED, null);
        }
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_EMTEXT)))) {
            this.getModel().setValue(KEY_EMMODEL, null);
            this.getModel().setValue(KEY_EMFILED, null);
        }
        return true;
    }
}

