/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class TemplateExtDataModelPlugin
extends AbstractBaseFormPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_save");
        BasedataEdit mergeNode = (BasedataEdit)this.getView().getControl("mergenode");
        BasedataEdit seller = (BasedataEdit)this.getView().getControl("seller");
        BasedataEdit purchaser = (BasedataEdit)this.getView().getControl("purchaser");
        mergeNode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        seller.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        purchaser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        if (modelId > 0L) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        }
        this.getModel().setValue("mergenode", this.getFormCustomParam("mergenode"));
        this.getModel().setValue("seller", this.getFormCustomParam("seller"));
        this.getModel().setValue("purchaser", this.getFormCustomParam("purchaser"));
        if (Objects.equals(this.getFormCustomParam("noModify"), "true")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save"});
        }
        this.getView().setVisible(Boolean.valueOf("0".equals(this.getFormCustomParam("usage"))), new String[]{"seller", "purchaser"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_save".equals(key)) {
            this.checkModelFields();
            String newAreaPointStart = this.getFormCustomParam("newAreaPointStart").toString();
            String oldAreaPointStart = this.getFormCustomParam("oldAreaPointStart").toString();
            if (!StringUtil.isEmptyString((String)oldAreaPointStart) && !newAreaPointStart.equals(oldAreaPointStart)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u5b57\u6bb5\u533a\u57df\uff0c\u662f\u5426\u91cd\u7f6e\u5f53\u524d\u5b57\u6bb5\u533a\u57df\uff1f", (String)"TemplateExtDataModelPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reset_filed_area", (IFormPlugin)this));
            } else {
                this.setDataModel();
            }
        }
    }

    private void checkModelFields() {
        DynamicObject mergeNode = (DynamicObject)this.getModel().getValue("mergenode");
        this.checkUnique(mergeNode, true);
        if ("0".equals(this.getFormCustomParam("usage"))) {
            DynamicObject seller = (DynamicObject)this.getModel().getValue("seller");
            this.checkUnique(seller, false);
            DynamicObject purchaser = (DynamicObject)this.getModel().getValue("purchaser");
            this.checkUnique(purchaser, false);
        }
    }

    private void checkUnique(DynamicObject extModel, boolean isMerge) {
        if (extModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u9009\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateExtDataModelPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List fields = null;
        fields = isMerge ? ExtDimHelper.getTmpFieldInludeBuySelll((Long)extModel.getLong("id")) : ExtDimHelper.getTmpFieldByExtModelId((Long)extModel.getLong("id"));
        HashSet numberSet = new HashSet(16);
        Set dulicates = fields.stream().filter(e -> !numberSet.add(e.getNumber())).map(IntrField::getNumber).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(dulicates)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b\u3010%1$s-%2$s\u3011\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u7f16\u7801\uff1a%3$s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"TemplateExtDataModelPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extModel.getString("number"), extModel.getString("name"), dulicates));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Map usedExtDataModels;
        super.beforeF7Select(beforeF7SelectEvent);
        long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        QFBuilder filter = new QFBuilder("model", "=", (Object)modelId);
        filter.add("enable", "=", (Object)true);
        filter.add("extendsgroup.grouptype", "=", (Object)ExtendDimGroupType.TRANSACTION.getIndex());
        BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
        if ("mergenode".equals(source.getKey()) && !(usedExtDataModels = IntrTemplateHelper.queryUsedExtDataModelIds((Long)modelId, (Long)this.getFormCustomParam("group", 0L))).isEmpty()) {
            filter.add("id", "not in", usedExtDataModels.keySet());
        }
        beforeF7SelectEvent.getCustomQFilters().addAll(filter.toList());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.setDataModel();
        }
    }

    private void setDataModel() {
        boolean isMergeUsage = "0".equals(this.getFormCustomParam("usage"));
        DynamicObject mergeNode = (DynamicObject)this.getModel().getValue("mergenode");
        DynamicObject seller = (DynamicObject)this.getModel().getValue("seller");
        DynamicObject purchaser = (DynamicObject)this.getModel().getValue("purchaser");
        if (isMergeUsage && (mergeNode == null || seller == null || purchaser == null) || !isMergeUsage && mergeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u9009\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateExtDataModelPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> dataModelInfo = new HashMap<String, Object>();
        dataModelInfo.put("mergenode", mergeNode.getLong("id"));
        if (isMergeUsage) {
            dataModelInfo.put("seller", seller.getLong("id"));
            dataModelInfo.put("purchaser", purchaser.getLong("id"));
        }
        if (isMergeUsage && !this.checkBizTypeFieldInDataModel(purchaser.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u6570\u636e\u6a21\u578b\u672a\u5305\u542b\u201cINTR_001 \u4e1a\u52a1\u7c7b\u578b\u201d\u6210\u5458\uff0c\u8bf7\u5148\u5728\u62d3\u5c55\u7ef4\u4e2d\u6dfb\u52a0\u8be5\u6210\u5458\u5230\u91c7\u8d2d\u65b9\u6570\u636e\u6a21\u578b\u6216\u91cd\u65b0\u9009\u62e9\u5305\u542b\u8be5\u6210\u5458\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"TemplateExtDataModelPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkBizTypeFieldInDataModel(mergeNode.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u65b9\u6570\u636e\u6a21\u578b\u672a\u5305\u542b\u201cINTR_001 \u4e1a\u52a1\u7c7b\u578b\u201d\u6210\u5458\uff0c\u8bf7\u5148\u5728\u62d3\u5c55\u7ef4\u4e2d\u6dfb\u52a0\u8be5\u6210\u5458\u5230\u5408\u5e76\u65b9\u6570\u636e\u6a21\u578b\u6216\u91cd\u65b0\u9009\u62e9\u5305\u542b\u8be5\u6210\u5458\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"TemplateExtDataModelPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        dataModelInfo.put("newAreaPointStart", this.getFormCustomParam("newAreaPointStart"));
        this.returnDataToParent(dataModelInfo);
        this.getView().close();
    }

    private boolean checkBizTypeFieldInDataModel(long purchaser) {
        QFilter filter = new QFilter("extmodelid", "=", (Object)purchaser).and("extfield.number", "=", (Object)"INTR_001");
        return QueryServiceHelper.exists((String)"bcm_extmodelfield", (QFilter[])filter.toArray());
    }
}

