/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade.handle;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.CommonPaperTemplateModel;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.InnerTradeTemplateModel;
import kd.fi.bcm.business.papertemplate.PaperTemplateFieldEntry;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.formplugin.papertemplate.innertrade.handle.AbstractPaperViewHandle;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class FieldPaperViewHandle
extends AbstractPaperViewHandle {
    private int row;
    private int startCol;
    private int endCol;

    @Override
    protected String getViewTabKey() {
        return "tab_field";
    }

    @Override
    protected void doHandleView() {
        this.displayStyle();
        this.controlWholeToolBarItems(true);
        this.hideWholeContextMenuItem();
        this.checkFieldArea();
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.plugin.getTemplateModel();
        if ("0".equals(templateModel.getUsage())) {
            this.showToolButton("btn_filed_area", "btn_formula_setting", "btn_check_setting", "btn_dim_scope");
        } else {
            this.showToolButton("btn_filed_area", "btn_formula_setting", "btn_dim_scope");
        }
    }

    private void checkFieldArea() {
        String areaPoint = this.plugin.getTemplateModel().getAreaPoint();
        if (StringUtil.isEmptyString((String)areaPoint)) {
            return;
        }
        this.setF7CellByArea(areaPoint);
        this.setCellColorByArea();
        this.displayDataModelFiledInfo();
        this.lockSheet();
        if (!this.plugin.checkIsExistReport()) {
            this.unlockFieldCell();
        } else {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5b58\u5728\u7f16\u5236\u8bb0\u5f55\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u62d3\u5c55\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u6216\u6210\u5458\u8303\u56f4\u8bbe\u7f6e\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u5148\u6574\u8868\u91cd\u7f6e\u6216\u8fdb\u884c\u6a21\u677f\u7248\u672c\u5316\u3002", (String)"FieldPaperViewHandle_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setF7CellByArea(String areaPoint) {
        String start = areaPoint.split(":")[0];
        String end = areaPoint.split(":")[1];
        this.row = ExcelUtils.pos2Y((String)start);
        this.startCol = ExcelUtils.pos2X((String)start);
        this.endCol = ExcelUtils.pos2X((String)end);
        this.constructF7TypeFeature();
    }

    private void constructF7TypeFeature() {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>();
        ArrayList items = new ArrayList(this.endCol - this.startCol - 1);
        for (int c = this.startCol; c <= this.endCol; ++c) {
            HashMap<String, Integer> feature = new HashMap<String, Integer>();
            feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), this.row);
            feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
            items.add(feature);
        }
        features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(0));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, features);
    }

    private void setCellColorByArea() {
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), this.row);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), this.startCol);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), this.endCol - this.startCol + 1);
        rangeList.add(rangeMap);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#66CDAA");
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.plugin.getClientViewProxy(), this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    private void displayDataModelFiledInfo() {
        boolean initFiled;
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.plugin.getTemplateModel();
        List paperTemplateField = templateModel.getPaperTemplateField();
        HashMap<String, PaperTemplateFieldEntry> fieldFormulaInfoMap = new HashMap<String, PaperTemplateFieldEntry>(16);
        for (PaperTemplateFieldEntry fieldEntry : paperTemplateField) {
            fieldFormulaInfoMap.put(fieldEntry.getExtModelFieldNumber(), fieldEntry);
        }
        SpreadManager sm = this.plugin.getSpreadModel();
        Sheet sheet = sm.getBook().getSheet(0);
        boolean bl = initFiled = this.plugin.getPageCache().get("initField") != null;
        if (initFiled) {
            sheet.clear();
            paperTemplateField.clear();
        }
        IntrTemplateHelper.repairTableRow((SpreadManager)sm);
        List fields = ExtDimHelper.getTmpFieldInludeBuySelll((Long)templateModel.getMergeNode());
        HashMap<String, IntrField> currentExtDataModelFieldMap = new HashMap<String, IntrField>(fields.size());
        HashMap<String, String> hasDeleteField = new HashMap<String, String>(16);
        for (IntrField field : fields) {
            currentExtDataModelFieldMap.put(field.getNumber(), field);
        }
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(this.endCol - this.startCol + 1);
        int seq = 1;
        for (int i = this.startCol; i <= this.endCol; ++i) {
            Cell cell = sheet.getCell(this.row, i);
            String cellShow = null;
            if (initFiled) {
                IntrField extModelField = (IntrField)fields.get(i - this.startCol);
                cellShow = extModelField.getName();
                cell.setUserObject("fieldId", (Object)extModelField.getExtFieldRefId());
                cell.setUserObject("fieldType", (Object)extModelField.getExtFieldRefType());
                cell.setUserObject("number", (Object)extModelField.getNumber());
                cell.setUserObject("name", (Object)cellShow);
                PaperTemplateFieldEntry fieldEntry = (PaperTemplateFieldEntry)fieldFormulaInfoMap.get((String)cell.getUserObject("number"));
                if (fieldEntry == null) {
                    fieldEntry = new PaperTemplateFieldEntry((CommonPaperTemplateModel)templateModel);
                    fieldEntry.setExecuteSeq(1);
                }
                fieldEntry.setExtModelId(templateModel.getMergeNode());
                fieldEntry.setFieldId((String)cell.getUserObject("fieldType"), (Long)cell.getUserObject("fieldId"));
                fieldEntry.setExtModelFieldNumber((String)cell.getUserObject("number"));
                fieldEntry.setSeq(seq);
                ++seq;
                paperTemplateField.add(fieldEntry);
            } else if (cell.getUserObject("number") != null && cell.getUserObject("name") != null) {
                cellShow = cell.getUserObject("name").toString();
                if (!currentExtDataModelFieldMap.containsKey((String)cell.getUserObject("number"))) {
                    hasDeleteField.put((String)cell.getUserObject("number"), cellShow);
                }
            }
            cell.setChangeVal(false);
            if (cellShow == null) continue;
            cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), cellShow));
        }
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.spreadKey, cellValues);
        }
        if (initFiled) {
            this.plugin.getPageCache().remove("initField");
            templateModel.setPaperTemplateField(paperTemplateField);
            this.plugin.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
            this.plugin.cacheSpreadModel();
        } else if (!hasDeleteField.isEmpty()) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u62d3\u5c55\u6570\u636e\u533a\u57df\u3002", (String)"FieldPaperViewHandle_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    protected void lockSheet() {
        Sheet sheet = this.getEffectiveSheet();
        int maxRow = sheet.getMaxRowCount();
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.C.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), maxRow);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), sheet.getMaxColumnCount());
        cells.add(cell);
        SpreadClientInvoker.invokeLockCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, cells);
    }

    protected void unlockFieldCell() {
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), this.row);
        cell.put(SpreadProperties.LockCellMethod.C.k(), this.startCol);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), 1);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), this.endCol - this.startCol + 1);
        cells.add(cell);
        SpreadClientInvoker.invokeUnLockCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, cells);
    }
}

