/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade.handle;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.formplugin.papertemplate.innertrade.InnerTradeTemplatePlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.handle.FieldPaperViewHandle;
import kd.fi.bcm.formplugin.papertemplate.innertrade.handle.IPaperViewHandle;
import kd.fi.bcm.formplugin.papertemplate.innertrade.handle.StylePaperViewHandle;

public class PaperViewSwitchers {
    public static final String TAB_CACHE_KEY = "tab_current_key";
    public static final String TAB_STYLE_VIEW = "tab_style";
    public static final String TAB_FIELD_VIEW = "tab_field";

    private String getCurrentTabKey(InnerTradeTemplatePlugin plugin) {
        return plugin.getPageCache().get(TAB_CACHE_KEY);
    }

    public void switchView(String tabKey, InnerTradeTemplatePlugin plugin, String spreadKey, boolean isForceExec) {
        if (!isForceExec && tabKey.equals(this.getCurrentTabKey(plugin))) {
            return;
        }
        PaperViewFactory.getViewInstance(tabKey).handleView(plugin, spreadKey);
        plugin.getPageCache().put(TAB_CACHE_KEY, tabKey);
    }

    static class PaperViewFactory {
        private static final Map<String, Class<? extends IPaperViewHandle>> views = new HashMap<String, Class<? extends IPaperViewHandle>>();

        PaperViewFactory() {
        }

        static IPaperViewHandle getViewInstance(String tabKey) {
            Class<? extends IPaperViewHandle> clazz = views.get(tabKey);
            if (clazz != null) {
                try {
                    return clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u89c6\u56fe%s\u5bf9\u5e94\u652f\u6301\u7684\u5904\u7406\u65b9\u5f0f\u3002", (String)"PaperViewSwitchers_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tabKey));
        }

        static {
            views.put(PaperViewSwitchers.TAB_STYLE_VIEW, StylePaperViewHandle.class);
            views.put(PaperViewSwitchers.TAB_FIELD_VIEW, FieldPaperViewHandle.class);
        }
    }
}

