/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.paramsetting;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.formplugin.param.edit.ParamSetEditOperation;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamSetCm018Plugin
extends ParamSetEditOperation
implements BeforeF7SelectListener {
    private static final String ENTITY = "entity";
    private static final String RANGE_VALUE = "rangevalue";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ParamSetCm018Plugin.class);
    public static final String SELECT_ORG_ENTITY_ID = "dentity";

    public void afterCreateNewData(EventObject e) {
        QFBuilder cm018Builder;
        DynamicObject dy;
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && this.getParamSettingModel().getModelId() != 0L && (dy = QueryServiceHelper.queryOne((String)"bcm_checkledgersetting", (String)"id", (QFilter[])(cm018Builder = new QFBuilder("number", "=", (Object)"CM018").add("dentity.isshow", "=", (Object)"1").add("model", "=", (Object)this.getParamSettingModel().getModelId())).toArray())) != null) {
            dy = BusinessDataServiceHelper.loadSingle((Object)dy.getLong("id"), (String)"bcm_checkledgersetting");
            Set oids = dy.getDynamicObjectCollection(SELECT_ORG_ENTITY_ID).stream().map(a -> a.getLong("oid")).collect(Collectors.toSet());
            List definedDynamicObjects = QueryMemberDetailsHelper.getDefinedPropertyByIds(oids);
            Map<String, String> id2PidMap = definedDynamicObjects.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("propertyid.id")));
            dy.getDynamicObjectCollection(SELECT_ORG_ENTITY_ID).stream().forEach(entry -> {
                int row = this.getModel().createNewEntryRow(SELECT_ORG_ENTITY_ID);
                this.getModel().setValue(ENTITY, entry.get(ENTITY), row);
                this.getModel().setValue("oid", entry.get("oid"), row);
                String pid = (String)id2PidMap.get(entry.getString("oid"));
                this.getModel().setValue("pid", (Object)pid, row);
                this.getModel().setValue("num", entry.get("num"), row);
                this.getModel().setValue(RANGE_VALUE, entry.get(RANGE_VALUE), row);
                this.getModel().setValue("remark", entry.get("remark"), row);
                if (StringUtils.isNotEmpty((CharSequence)entry.getString("year"))) {
                    try {
                        Set years = (Set)JSON.parseObject((String)entry.getString("year"), Set.class);
                        if (years.size() > 0) {
                            this.getModel().setValue("years", (Object)years.toArray(), row);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)entry.getString("period"))) {
                    try {
                        Set periods = (Set)JSON.parseObject((String)entry.getString("period"), Set.class);
                        if (periods.size() > 0) {
                            this.getModel().setValue("periods", (Object)periods.toArray(), row);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        ((BasedataEdit)this.getControl("years")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("periods")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "addrow": {
                this.showSelectOrgView();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String number = beforeF7SelectEvent.getProperty().getName();
        long modelId = this.getParamSettingModel().getModelId();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qf = new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)"1");
        listShowParameter.getListFilterParameter().setFilter(qf);
        if ("years".equals(number)) {
            qf.and("isleaf", "=", (Object)"1");
            qf.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentYear", "LastYear"}));
        } else if ("periods".equals(number)) {
            String cube = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)cube, (String)"MRpt");
            Set ids = new HashSet(16);
            if (IDNumberTreeNode.NotFoundTreeNode != scene) {
                ids = PeriodUtils.getPeriodByScene((long)modelId, (long)scene.getId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                qf.and(new QFilter("id", "in", ids));
            }
        }
    }

    protected boolean validateMustInput() {
        if (super.validateMustInput()) {
            DynamicObjectCollection dentity = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
            for (int i = 0; i < dentity.size(); ++i) {
                if (this.getModel().getValue("pid", i).toString().trim().isEmpty() || !this.getModel().getValue(RANGE_VALUE, i).equals("110") && !this.getModel().getValue(RANGE_VALUE, i).equals("90")) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7ec4\u7ec7\u201c%2$s\u201d\u4e3a\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6240\u6709_\u4ec5\u660e\u7ec6\u6210\u5458\u201d\u6216\u201c\u6240\u6709_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\u201d\u8303\u56f4\u3002", (String)"RptParamConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, this.getModel().getValue(ENTITY)));
                return false;
            }
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        try {
            String confirmId = messageBoxClosedEvent.getCallBackId();
            if ("treeClick_confirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().setDataChanged(false);
                DynamicObjectCollection dentity = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
                for (DynamicObject object : dentity) {
                    object.getDataEntityState().setRemovedItems(Boolean.valueOf(false));
                }
                this.getView().close();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            super.confirmCallBack(messageBoxClosedEvent);
        }
    }

    protected void afterSave() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && this.getParamSettingModel().getModelId() != 0L) {
            ParamSettingModel model = this.getParamSettingModel();
            QFilter qFilter = new QFilter("number", "=", (Object)"CM018");
            qFilter.and("model", "=", (Object)model.getModelId());
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_checkledgersetting", (String)"id", (QFilter[])qFilter.toArray());
            if (dy != null) {
                dy = BusinessDataServiceHelper.loadSingle((Object)dy.getLong("id"), (String)"bcm_checkledgersetting");
            }
            if (dy == null) {
                dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkledgersetting");
                dy.set("number", (Object)model.getNumber());
                dy.set("name", (Object)model.getName());
                dy.set("description", (Object)model.getDesc());
                dy.set("isenable", (Object)true);
                dy.set("model", (Object)model.getModelId());
                dy.set("modifytime", (Object)new Date());
                dy.set("createtime", (Object)new Date());
                dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            } else {
                dy.getDynamicObjectCollection(SELECT_ORG_ENTITY_ID).clear();
                dy.set("modifytime", (Object)new Date());
                dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            }
            DynamicObjectCollection entrys = dy.getDynamicObjectCollection(SELECT_ORG_ENTITY_ID);
            for (DynamicObject entry : this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID)) {
                DynamicObjectCollection periods;
                DynamicObject addNew = entrys.addNew();
                addNew.set("isshow", (Object)true);
                addNew.set(ENTITY, entry.get(ENTITY));
                addNew.set("oid", entry.get("oid"));
                addNew.set("num", entry.get("num"));
                addNew.set(RANGE_VALUE, entry.get(RANGE_VALUE));
                addNew.set("remark", entry.get("remark"));
                DynamicObjectCollection years = entry.getDynamicObjectCollection("years");
                if (CollectionUtils.isNotEmpty((Collection)years)) {
                    HashSet<Long> yearIds = new HashSet<Long>(16);
                    for (DynamicObject year : years) {
                        Object fbasedataid = year.getDynamicObject("fbasedataid").getPkValue();
                        yearIds.add(LongUtil.toLong((Object)fbasedataid));
                    }
                    addNew.set("year", (Object)JSON.toJSONString(yearIds));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(periods = entry.getDynamicObjectCollection("periods")))) continue;
                HashSet<Long> periodIds = new HashSet<Long>(16);
                for (DynamicObject period : periods) {
                    Object fbasedataid = period.getDynamicObject("fbasedataid").getPkValue();
                    periodIds.add(LongUtil.toLong((Object)fbasedataid));
                }
                addNew.set("period", (Object)JSON.toJSONString(periodIds));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            try {
                this.getModel().setDataChanged(false);
                DynamicObjectCollection dentity = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
                for (DynamicObject object : dentity) {
                    object.getDataEntityState().setRemovedItems(Boolean.valueOf(false));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private void showSelectOrgView() {
        long modelId = this.getParamSettingModel().getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"RptParamConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
            }
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(SELECT_ORG_ENTITY_ID);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get(4).equals(oldone.get("oid")) || !newone.get(5).equals(oldone.get(RANGE_VALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(SELECT_ORG_ENTITY_ID);
            model.setValue(ENTITY, newone.get(3), index);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            model.setValue("num", newone.get(2), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }
}

