/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.paramsetting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.model.PsResultModel;
import kd.epm.epbs.formplugin.param.edit.ParamSetEditOperation;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.PeriodUtils;
import org.apache.commons.collections.CollectionUtils;

public class ParamSetCm024Plugin
extends ParamSetEditOperation
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ORG_NAME = "orgname";
    private static final String ORG_NUMBER = "orgnumber";
    private static final String RANGE = "range";
    private static final String SCENARIO = "scenario";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ParamSetCm024Plugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        ((BasedataEdit)this.getControl(SCENARIO)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(YEAR)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(PERIOD)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "addrow": {
                this.showSelectOrgView();
                break;
            }
        }
    }

    protected void setParams() {
        super.setParams();
        ParamSettingModel model = this.getParamSettingModel();
        JSONObject params = (JSONObject)model.getParamsWithDateType();
        if (params != null) {
            JSONArray entry = params.getJSONArray(ENTRYENTITY) == null ? new JSONArray() : params.getJSONArray(ENTRYENTITY);
            for (Object row : entry) {
                JSONObject data = (JSONObject)row;
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(ORG_NUMBER, data.get((Object)ORG_NUMBER), index);
                this.getModel().setValue(ORG_NAME, data.get((Object)ORG_NAME), index);
                this.getModel().setValue("oid", data.get((Object)"oid"), index);
                this.getModel().setValue("pid", data.get((Object)"pid"), index);
                this.getModel().setValue(RANGE, data.get((Object)RANGE), index);
                this.getModel().setValue(SCENARIO, data.get((Object)SCENARIO), index);
                this.getModel().setValue(YEAR, data.get((Object)YEAR), index);
                this.getModel().setValue(PERIOD, data.get((Object)PERIOD), index);
            }
        }
    }

    protected PsResultModel getCustomParams() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return super.getCustomParams();
        }
        PsResultModel customParams = super.getCustomParams();
        Object params = customParams.getParams();
        if (params instanceof Map) {
            this.customParam((Map)params);
        }
        return customParams;
    }

    private void customParam(Map<String, Object> params) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList list = new ArrayList();
        entryEntity.forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ORG_NUMBER, dy.get(ORG_NUMBER));
            map.put(ORG_NAME, dy.get(ORG_NAME));
            map.put("oid", dy.getLong("oid"));
            map.put("pid", dy.getLong("pid"));
            map.put(RANGE, dy.get(RANGE));
            map.put(SCENARIO, dy.getLong("scenario.id"));
            map.put(YEAR, dy.getLong("year.id"));
            map.put(PERIOD, dy.getLong("period.id"));
            list.add(map);
        });
        params.put(ENTRYENTITY, list);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String number = beforeF7SelectEvent.getProperty().getName();
        long modelId = this.getParamSettingModel().getModelId();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qf = new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)"1");
        listShowParameter.getListFilterParameter().setFilter(qf);
        int rowIndex = beforeF7SelectEvent.getRow();
        if (SCENARIO.equals(number)) {
            qf.and("isleaf", "=", (Object)"1");
        } else if (YEAR.equals(number)) {
            qf.and("isleaf", "=", (Object)"1");
            qf.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentYear", "LastYear"}));
        } else if (PERIOD.equals(number)) {
            DynamicObject scene = (DynamicObject)this.getModel().getValue(SCENARIO, rowIndex);
            Set ids = new HashSet(16);
            if (scene != null) {
                ids = PeriodUtils.getPeriodByScene((long)modelId, (long)scene.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                qf.and(new QFilter("id", "in", ids));
            }
        }
        Object value = this.getModel().getValue(number, rowIndex);
        if (value != null) {
            long memberId = ((DynamicObject)value).getLong("id");
            listShowParameter.setSelectedRow((Object)memberId);
        }
    }

    protected boolean validateMustInput() {
        if (super.validateMustInput()) {
            DynamicObjectCollection dentity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < dentity.size(); ++i) {
                if (this.getModel().getValue("pid", i).toString().trim().length() <= 1 || !this.getModel().getValue(RANGE, i).equals("110") && !this.getModel().getValue(RANGE, i).equals("90")) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7ec4\u7ec7\u201c%2$s\u201d\u4e3a\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6240\u6709_\u4ec5\u660e\u7ec6\u6210\u5458\u201d\u6216\u201c\u6240\u6709_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\u201d\u8303\u56f4\u3002", (String)"RptParamConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, this.getModel().getValue(ORG_NAME)));
                return false;
            }
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        try {
            String confirmId = messageBoxClosedEvent.getCallBackId();
            if ("treeClick_confirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().setDataChanged(false);
                DynamicObjectCollection dentity = this.getModel().getEntryEntity("dentity");
                for (DynamicObject object : dentity) {
                    object.getDataEntityState().setRemovedItems(Boolean.valueOf(false));
                }
                this.getView().close();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            super.confirmCallBack(messageBoxClosedEvent);
        }
    }

    private void showSelectOrgView() {
        long modelId = this.getParamSettingModel().getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"RptParamConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("isFilterRateScheme", (Object)Boolean.TRUE);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(ENTRYENTITY);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.fillBackOrg(olddoc, newdoc);
            }
        }
    }

    private void fillBackOrg(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            boolean isExist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get(4).equals(oldone.get("oid")) || !newone.get(5).equals(oldone.get(RANGE))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            int index = model.createNewEntryRow(ENTRYENTITY);
            model.setValue(ORG_NUMBER, newone.get(2), index);
            model.setValue(ORG_NAME, newone.get(3), index);
            model.setValue(RANGE, newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }
}

