/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.paramsetting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.model.PsResultModel;
import kd.epm.epbs.formplugin.param.edit.ParamSetEditOperation;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.CM053SettingEnum;
import kd.fi.bcm.common.config.CM053TypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class ParamSetCm053Plugin
extends ParamSetEditOperation
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String SCENE = "scene";
    private static final String SETTING = "setting";
    private static final String USER = "user";
    private static final String UPDATETIME = "updatetime";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit source = (BasedataEdit)this.getControl(SCENE);
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "add": {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                if (this.isCM053()) {
                    this.getModel().setValue(TYPE, (Object)CM053TypeEnum.APPLY.getValue(), row);
                    this.getModel().setValue(SETTING, (Object)"0", row);
                    break;
                }
                this.getModel().setValue(TYPE, (Object)CM053TypeEnum.EXCEPTION.getValue(), row);
                this.getModel().setValue(SETTING, (Object)"0", row);
                break;
            }
            case "del": {
                this.deleteEntry();
            }
        }
    }

    private boolean isCM053() {
        return "CM053".equalsIgnoreCase(this.getParamSettingModel().getNumber());
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u518d\u64cd\u4f5c", (String)"ConfigCM044EditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }

    protected void setParams() {
        super.setParams();
        this.setFieldSettingHide();
        ParamSettingModel model = this.getParamSettingModel();
        JSONObject params = (JSONObject)model.getParamsWithDateType();
        if (params != null) {
            boolean isConfig = params.getBoolean("config");
            JSONArray entry = params.getJSONArray(ENTRYENTITY) == null ? new JSONArray() : params.getJSONArray(ENTRYENTITY);
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            for (Object row : entry) {
                JSONObject data = (JSONObject)row;
                IDNumberTreeNode sceneMember = MemberReader.findScenaMemberByNum((String)modelNumber, (String)data.getString("sceneNumber"));
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(TYPE, data.get((Object)TYPE), index);
                this.getModel().setValue(SCENE, (Object)sceneMember.getId(), index);
                this.getModel().setValue(SETTING, data.get((Object)SETTING), index);
                this.getModel().setValue(USER, data.get((Object)"userId"), index);
                this.getModel().setValue(UPDATETIME, (Object)data.getDate("modifyTime"), index);
            }
        }
    }

    protected PsResultModel getCustomParams() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return super.getCustomParams();
        }
        PsResultModel customParams = super.getCustomParams();
        Object params = customParams.getParams();
        if (params instanceof Map) {
            this.customParam((Map)params);
        }
        return customParams;
    }

    protected void customParam(Map<String, Object> params) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList list = new ArrayList();
        entryEntity.forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TYPE, dy.get(TYPE));
            map.put(SETTING, dy.get(SETTING));
            map.put("sceneNumber", dy.get("scene.number"));
            map.put("userId", RequestContext.get().getCurrUserId());
            map.put("modifyTime", new Date());
            list.add(map);
        });
        params.put(ENTRYENTITY, list);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        int currentRowIndex = changeData.getRowIndex();
        if ((TYPE.equals(key) || SETTING.equals(key) || SCENE.equals(key)) && null != newValue) {
            if (SCENE.equals(key)) {
                DynamicObject newScene = (DynamicObject)newValue;
                long newSceneId = newScene.getLong("id");
                List<Long> selectScenePkIds = this.getSelectScenePkIds();
                boolean isExist = false;
                int existIndex = 0;
                for (int i = 0; i < selectScenePkIds.size(); ++i) {
                    if (currentRowIndex == i || selectScenePkIds.get(i) != newSceneId) continue;
                    existIndex = i;
                    isExist = true;
                    break;
                }
                if (isExist) {
                    this.getModel().setValue(key, oldValue);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u5df2\u5b58\u5728\u65b0\u8bbe\u7684\u60c5\u666f\u3002", (String)"ConfigCM044EditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), existIndex + 1));
                    return;
                }
            }
            if (TYPE.equals(key)) {
                String newType = (String)newValue;
                boolean isEnable = true;
                if (CM053TypeEnum.EXCEPTION.getValue().equals(newType)) {
                    this.getModel().setValue(SETTING, (Object)CM053SettingEnum.ONLY_TIP.getValue(), currentRowIndex);
                    isEnable = false;
                }
                this.getView().setEnable(Boolean.valueOf(isEnable), currentRowIndex, new String[]{SETTING});
            }
            this.getModel().setValue(USER, (Object)RequestContext.getOrCreate().getCurrUserId(), currentRowIndex);
            this.getModel().setValue(UPDATETIME, (Object)TimeServiceHelper.now(), currentRowIndex);
        }
    }

    protected boolean validateMustInput() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dy : entryEntity) {
            if (!StringUtils.isBlank((CharSequence)dy.getString("scene.number"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("selectScene".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.fillBackScene(returnData);
        }
    }

    private void fillBackScene(ListSelectedRowCollection returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
        Set sceneNumberSet = currentData.stream().map(r -> r.getString("scene.number")).collect(Collectors.toSet());
        int currentRow = this.getCurrentRowIndex();
        for (ListSelectedRow sceneData : returnData) {
            if (sceneNumberSet.contains(sceneData.getNumber())) continue;
            Object currentScene = this.getModel().getValue(SCENE, currentRow);
            if (currentScene != null) {
                currentRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            }
            this.getModel().setValue(SCENE, sceneData.getPrimaryKeyValue(), currentRow);
            if (!this.isCM053()) continue;
            this.getModel().setValue(SETTING, (Object)CM053SettingEnum.NOT_CONTROL.getValue(), currentRow);
        }
    }

    private int getCurrentRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int currentRow = 0;
        if (selectRows.length > 0) {
            currentRow = selectRows[0];
        }
        return currentRow;
    }

    private void setFieldSettingHide() {
        this.getView().setVisible(Boolean.valueOf(this.isCM053()), new String[]{SETTING});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (SCENE.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
            qFilter.and("number", "!=", (Object)"Scenario");
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}), "dseq asc"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectScene"));
            showParameter.setSelectedRows(this.getSelectScenePkIds().toArray());
        }
    }

    private List<Long> getSelectScenePkIds() {
        return this.getModel().getEntryEntity(ENTRYENTITY).stream().map(r -> r.getLong("scene.id")).collect(Collectors.toList());
    }
}

