/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.paramsetting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.business.paramsetting.model.PsResultModel;
import kd.epm.epbs.formplugin.param.edit.ParamSetEditOperation;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import org.apache.commons.collections.CollectionUtils;

public class ParamSetCm056Plugin
extends ParamSetEditOperation
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        ((BasedataEdit)this.getControl("applyscenario")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("exchangeperiod")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("currentperiod")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "add": {
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
            case "del": {
                this.deleteEntry();
            }
        }
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u518d\u64cd\u4f5c", (String)"ConfigCM044EditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("entryentity", selectRows);
    }

    protected void setParams() {
        super.setParams();
        ParamSettingModel model = this.getParamSettingModel();
        JSONObject params = (JSONObject)model.getParamsWithDateType();
        JSONArray entry = params == null || params.getJSONArray("entryentity") == null ? new JSONArray() : params.getJSONArray("entryentity");
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        for (Object row : entry) {
            JSONObject data = (JSONObject)row;
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)modelNumber, (String)data.getString("sceario"));
            IDNumberTreeNode currentPeriod = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)data.getString("currentPeriod"));
            IDNumberTreeNode exchangePeriod = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)data.getString("exchangePeriod"));
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("applyscenario", (Object)scene.getId(), index);
            this.getModel().setValue("currentperiod", (Object)currentPeriod.getId(), index);
            this.getModel().setValue("exchangeperiod", (Object)exchangePeriod.getId(), index);
            this.getModel().setValue("user", data.get((Object)"userId"), index);
            this.getModel().setValue("updatetime", (Object)data.getDate("modifyTime"), index);
        }
    }

    protected PsResultModel getCustomParams() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return super.getCustomParams();
        }
        PsResultModel customParams = super.getCustomParams();
        Object params = customParams.getParams();
        if (params instanceof Map) {
            this.customParam((Map)params);
        }
        return customParams;
    }

    protected void customParam(Map<String, Object> params) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        JSONArray array = new JSONArray();
        entryEntity.forEach(dy -> {
            JSONObject obj = new JSONObject();
            obj.put("sceario", dy.get("applyscenario.number"));
            obj.put("currentPeriod", dy.get("currentperiod.number"));
            obj.put("exchangePeriod", dy.get("exchangeperiod.number"));
            obj.put("userId", (Object)RequestContext.get().getCurrUserId());
            obj.put("modifyTime", (Object)format.format(new Date()));
            array.add((Object)obj);
        });
        params.put("entryentity", array);
    }

    protected boolean validateMustInput() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String curNum;
            DynamicObject e = (DynamicObject)entryEntity.get(i);
            if (e.getDynamicObject("applyscenario") == null || e.getDynamicObject("currentperiod") == null || e.getDynamicObject("exchangeperiod") == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u60c5\u666f\u3001\u5f53\u524d\u671f\u95f4\u3001\u4e0a\u5e74\u540c\u671f\u67e5\u8be2\u671f\u95f4\u4e2d\u5b58\u5728\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"SamePeriodLastYearConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            String sceneNum = e.getDynamicObject("applyscenario").getString("number");
            String key = String.join((CharSequence)"|", sceneNum, curNum = e.getDynamicObject("currentperiod").getString("number"));
            if (map.get(key) != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %1s \u884c\u548c\u7b2c %2s \u884c\u7684\u60c5\u666f\u548c\u5f53\u524d\u671f\u95f4\u4e00\u6837\uff0c\u4e0d\u652f\u6301\u591a\u6b21\u8bbe\u7f6e\u3002", (String)"SamePeriodLastYearConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Integer)map.get(key) + 1, i + 1));
                return false;
            }
            map.put(key, i);
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId()).and("enable", "=", (Object)"1");
        listShowParameter.getListFilterParameter().setFilter(qf);
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("applyscenario".equals(key)) {
            qf.and(new QFilter("number", "!=", (Object)"Scenario"));
        } else if ("currentperiod".equals(key) || "exchangeperiod".equals(key)) {
            DynamicObject scene = (DynamicObject)this.getModel().getValue("applyscenario", beforeF7SelectEvent.getRow());
            if (scene != null) {
                Set ids = PeriodUtils.getPeriodByScene((long)this.getModelId(), (long)scene.getLong("id"));
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    qf.and(new QFilter("id", "in", (Object)ids));
                }
            } else {
                qf.and(new QFilter("1", "=", (Object)0));
            }
        }
    }
}

