/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public abstract class AbstractMemberPermEditPlugin
extends AbstractBaseFormPlugin {
    private static final String EXPORT_PAGE_MEM_PERM_CONFIRM = "export_page_mem_perm_confirm";
    protected static final String BILL_LIST_AP = "billlistap";

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_export".equals(key)) {
            if (Objects.equals(this.getView().getEntityId(), "bcm_memberperm_view") && !PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
                this.getView().showTipNotification(AbstractMemberPermEditPlugin.getNoPermTip());
                return;
            }
            FormUtils.clickCheckBillListSelect((IFormPlugin)this.getPlugin(), this.getView(), BILL_LIST_AP, ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5f15\u51fa\u3002", (String)"AbstractMemberPermEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%s\u5f20\u5355\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"AbstractMemberPermEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((BillList)this.getControl(BILL_LIST_AP)).getCurrentListAllRowCollection().size()), EXPORT_PAGE_MEM_PERM_CONFIRM, this::yesExport);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mBCE) {
        super.confirmCallBack(mBCE);
        String callBackId = mBCE.getCallBackId();
        if (Objects.isNull(callBackId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u6267\u884c\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"AbstractMemberPermEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (EXPORT_PAGE_MEM_PERM_CONFIRM.equals(callBackId) && mBCE.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            this.yesExport(billList.getCurrentListAllRowCollection());
        }
    }

    protected void yesExport(ListSelectedRowCollection rows) {
        QFBuilder filter = new QFBuilder("model", "=", (Object)this.getModelId());
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)rows.size());
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        filter.add("id", "in", (Object)ids);
        String time = DateTimeUtils.format((Date)TimeServiceHelper.now(), (String)"MMddhhmmss");
        try {
            this.exportData("bcm_memberperm", filter.toArray(), String.format(ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_\u6210\u5458\u5206\u914d\u6743\u9650\u5bfc\u51fa\u6a21\u677f_%s", (String)"AbstractMemberPermEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), time), "bcm_memberperm_IMPT_S", "bcm_memberperm_view", "1G2FW/G3YIL8");
            this.writeOperationLog(AbstractMemberPermEditPlugin.getOperationExport(), AbstractMemberPermEditPlugin.getOperationSuccess());
        }
        catch (Exception e) {
            this.writeOperationLog(AbstractMemberPermEditPlugin.getOperationExport(), AbstractMemberPermEditPlugin.getOperationFail());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a\u201c%s\u201d\u3002", (String)"AbstractMemberPermEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static OpNameMultiLangEnumBridge getOperationExport() {
        return new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "AbstractMemberPermEditPlugin_6", "fi-bcm-formplugin", "export");
    }

    protected static String getOperationSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"AbstractMemberPermEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected static String getOperationFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"AbstractMemberPermEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected static String getNoPermTip() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractMemberPermEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected static String getNoGrantTip() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u201c\u5206\u914d\u6743\u201d\u76f8\u5173\u914d\u7f6e\u3002", (String)"AbstractMemberPermEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

