/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.UserCopyPermPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class BcmCopyPermPlugin
extends UserCopyPermPlugin {
    private static final Log logger = LogFactory.getLog(BcmCopyPermPlugin.class);
    private static final String COPYROLE = "copyrole";
    private static final String COPYUSERPERM = "copyuserperm";
    private static final String COPYDISFUNPERM = "copydisfunperm";
    private static final String ORIGINUSER = "originuser";
    private static final String TARGETUSER = "targetuser";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ORG = "org";

    private String getPermUserPerm() {
        return ResManager.loadKDString((String)"\u76f4\u63a5\u6388\u6743", (String)"BcmCopyPermPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getPermRole() {
        return ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272", (String)"BcmCopyPermPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getDisFunc() {
        return ResManager.loadKDString((String)"\u7981\u7528\u6743\u9650", (String)"BcmCopyPermPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("confirmcallback_save") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            if (Objects.equals(ApplicationTypeEnum.FIDM.appnum, this.getView().getFormShowParameter().getAppId())) {
                return;
            }
            OperationLogUtil.writeOperationLog((String)this.getCopyPermOpName(), (String)this.getCopyPermDesc(), null, (String)"bcm_copyperm");
            IDataModel iDataModel = this.getModel();
            String isCopyRole = String.valueOf(iDataModel.getValue(COPYROLE));
            String isCopyUserPerm = String.valueOf(iDataModel.getValue(COPYUSERPERM));
            String isDisFunPerm = String.valueOf(iDataModel.getValue(COPYDISFUNPERM));
            DynamicObject sourceUser = (DynamicObject)iDataModel.getValue(ORIGINUSER);
            DynamicObjectCollection targetUsers = (DynamicObjectCollection)iDataModel.getValue(TARGETUSER);
            HashSet<Long> userIDs = new HashSet<Long>(1);
            Long userId = sourceUser.getLong(ID);
            userIDs.add(userId);
            String sourceUserName = sourceUser.getString(NAME);
            String sourceUserNumber = sourceUser.getString(NUMBER);
            Map<Long, String> modelDescription = this.getDescription(userIDs, isCopyUserPerm, isCopyRole, isDisFunPerm);
            String bizappId = this.getView().getFormShowParameter().getAppId();
            StringBuilder userDescription = new StringBuilder();
            for (Object targetUser : targetUsers) {
                userDescription.append(targetUser.getDynamicObject(1).getString(NAME));
                userDescription.append(";");
            }
            userDescription.deleteCharAt(userDescription.lastIndexOf(";"));
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(modelDescription.size());
            for (Map.Entry entry : modelDescription.entrySet()) {
                logs.add(FunctionPermLogHelper.newFunctionPermLog((Long)((Long)entry.getKey()), (String)sourceUserNumber, (String)sourceUserName, (String)"", (String)"", (String)"", (String)((String)entry.getValue() + userDescription), (String)bizappId));
            }
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
            }
            catch (Exception e) {
                logger.error(((Object)((Object)this)).getClass().getName() + ":\u529f\u80fd\u6743\u9650\u65e5\u5fd7\u65e5\u6dfb\u52a0\u5931\u8d25");
                return;
            }
        }
    }

    private String getCopyPermOpName() {
        return ResManager.loadKDString((String)"\u590d\u5236\u6743\u9650", (String)"BcmCopyPermPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getCopyPermDesc() {
        return ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"BcmCopyPermPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private Map<Long, String> getDescription(Collection<Long> userId, String isCopyUserPerm, String isCopyRole, String isDisFunPerm) {
        HashMap<Long, String> descriptionMap = new HashMap<Long, String>(16);
        if ("true".equals(isCopyUserPerm)) {
            this.fillDescriprion(userId, "perm_userperm", "DIM_BCM_MODEL", this.getPermUserPerm(), descriptionMap);
        }
        if ("true".equals(isCopyRole)) {
            this.fillDescriprion(userId, "perm_userrole", "bcm_model", this.getPermRole(), descriptionMap);
        }
        if ("true".equals(isDisFunPerm)) {
            this.fillDescriprion(userId, "perm_disfunperm", "bcm_model", this.getDisFunc(), descriptionMap);
        }
        return descriptionMap;
    }

    private void fillDescriprion(Collection<Long> userId, String entityName, String dimtype, String decription, Map<Long, String> descriptionMap) {
        String desc = ResManager.loadKDString((String)"\u3010\u6743\u9650\u590d\u5236\u3011", (String)"BcmCopyPermPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("user", "in", userId));
        qfBuilder.add(new QFilter("dimtype", "=", (Object)dimtype));
        DynamicObjectCollection modelList = QueryServiceHelper.query((String)entityName, (String)ORG, (QFilter[])qfBuilder.toArray());
        HashSet<Long> modelIds = new HashSet<Long>(16);
        if (modelList != null) {
            for (DynamicObject model : modelList) {
                modelIds.add(model.getLong(ORG));
            }
        }
        for (Long modelId : modelIds) {
            CharSequence descriptionBuilder;
            if (descriptionMap.get(modelId) == null) {
                descriptionBuilder = desc + "_" + decription + ":";
                descriptionMap.put(modelId, (String)descriptionBuilder);
                continue;
            }
            descriptionBuilder = new StringBuilder(descriptionMap.get(modelId));
            ((StringBuilder)descriptionBuilder).deleteCharAt(((StringBuilder)descriptionBuilder).lastIndexOf(":"));
            ((StringBuilder)descriptionBuilder).append("_");
            ((StringBuilder)descriptionBuilder).append(decription);
            ((StringBuilder)descriptionBuilder).append(":");
            descriptionMap.replace(modelId, ((StringBuilder)descriptionBuilder).toString());
        }
    }
}

