/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BcmPermRolePermImport
extends AbsCommonImport {
    private static final String CMAPPID = "11H66HLOX4IC";
    private static final String DENTITYID = "dentityid";
    private static final String ROLEID_NUMBER = "roleid.number";
    private static final String ENTITY_NUMBER = "entity.number";
    private static final String PERMITEM_NUMBER = "permitem.number";
    private static final String PERMITEM_ID = "permitem.id";
    private static final String EPMPSF = "entitytype,entitytypeid,permitem.id,permitem.number";
    private static final String RPSSF = "roleid.number,entity.number,permitem.number,permitem.id";
    private static final Integer COLLECTIONSIZE = 16;
    private static final DynamicObject[] EMPTY_DYNAMIC_OBJECT_ARRAY = new DynamicObject[0];
    private final Map<String, Pair<String, String>> roleRepeatKeysWithIdEnable = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
    private final Map<String, String> permItemRepeatKeysWithId = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
    private final Set<String> entityPermMap = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
    private final Set<String> rolePermRepeatKeys = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
    private Map<String, DynamicObject> rolePermMap;

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        String roleNum = ImportHelper.getImportBillProp(bill, ROLEID_NUMBER).toString();
        Pair<String, String> longStringPair = this.roleRepeatKeysWithIdEnable.get(roleNum);
        if (Objects.isNull(longStringPair)) {
            return Optional.of(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"BcmPermRolePermImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals(longStringPair.p2, "0")) {
            return Optional.of(ResManager.loadKDString((String)"\u89d2\u8272\u88ab\u7981\u7528\u3002", (String)"BcmPermRolePermImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List<Object> entityNums = ImportHelper.getImportBillProp(bill, "roleperm", ENTITY_NUMBER);
        List<Object> permItemNums = ImportHelper.getImportBillProp(bill, "roleperm", PERMITEM_NUMBER);
        StringBuilder errMesSB = new StringBuilder();
        int size = entityNums.size();
        for (int i = 0; i < size; ++i) {
            String permKey;
            String permItemNum = permItemNums.get(i).toString();
            String entityNum = entityNums.get(i).toString();
            StringBuilder midErrMesSB = new StringBuilder();
            boolean isCurError = Boolean.FALSE;
            int rowCur = bill.getStartIndex() + i + 1;
            String title = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a%s\u3002", (String)"BcmPermRolePermImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowCur, "\n");
            midErrMesSB.append(title);
            StringBuilder formatStr = new StringBuilder();
            formatStr.append("%");
            formatStr.append(12 + String.valueOf(rowCur).getBytes().length * 2);
            formatStr.append("s");
            if (!this.entityPermMap.contains(BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{entityNum, permItemNums.get(i).toString()})))) {
                formatStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0e\u6743\u9650\u7f16\u7801\u4e0d\u5339\u914d\u3002", (String)"BcmPermRolePermImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                formatStr.append("\n");
                midErrMesSB.append(String.format(formatStr.toString(), " "));
                isCurError = Boolean.TRUE;
            }
            if (!this.rolePermRepeatKeys.add(permKey = BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{roleNum, entityNum, permItemNum})))) {
                formatStr.append(ResManager.loadKDString((String)"\u89d2\u8272\u529f\u80fd\u6743\u9650\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u3002", (String)"BcmPermRolePermImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                formatStr.append("\n");
                midErrMesSB.append(String.format(formatStr.toString(), " "));
                if (!isCurError) {
                    isCurError = Boolean.TRUE;
                }
            }
            if (Objects.equals((Object)ImportHelper.getImportType(this.ctx), (Object)ImportOperateType.NEW) && !CollectionUtils.isEmpty(this.rolePermMap) && Objects.nonNull(this.rolePermMap.get(permKey))) {
                formatStr.append(ResManager.loadKDString((String)"\u89d2\u8272\u529f\u80fd\u6743\u9650\u5df2\u5b58\u5728\u3002", (String)"BcmPermRolePermImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                formatStr.append("\n");
                midErrMesSB.append(String.format(formatStr.toString(), " "));
                if (!isCurError) {
                    isCurError = Boolean.TRUE;
                }
            }
            if (!isCurError) continue;
            errMesSB.append((CharSequence)midErrMesSB);
        }
        if (StringUtils.isNotBlank((CharSequence)errMesSB)) {
            return Optional.of(errMesSB.toString());
        }
        return Optional.empty();
    }

    private void initData(List<ImportBillData> billdatas) {
        HashSet roleNums = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
        HashSet entityNums = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
        HashSet permItemNums = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
        for (ImportBillData bd : billdatas) {
            roleNums.add(ImportHelper.getImportBillProp(bd, ROLEID_NUMBER).toString());
            ImportHelper.getImportBillProp(bd, "roleperm", ENTITY_NUMBER).forEach(str -> entityNums.add(str.toString()));
            ImportHelper.getImportBillProp(bd, "roleperm", PERMITEM_NUMBER).forEach(str -> permItemNums.add(str.toString()));
        }
        QFBuilder roleNumQF = new QFBuilder();
        if (!CollectionUtils.isEmpty((Collection)roleNums)) {
            roleNumQF.add("number", "in", (Object)roleNums);
        }
        roleNumQF.add("bizdomain", "=", (Object)CMAPPID);
        roleNumQF.add("dimtypeid", "=", (Object)"DIM_BCM_MODEL");
        roleNumQF.add("number", "!=", (Object)"WFADMINS");
        DynamicObjectCollection rRKMid = QueryServiceHelper.query((String)"perm_role", (String)"id,number,enable", (QFilter[])roleNumQF.toArray());
        if (!CollectionUtils.isEmpty((Collection)rRKMid)) {
            this.roleRepeatKeysWithIdEnable.putAll(rRKMid.stream().collect(Collectors.toMap(r -> r.getString("number"), r -> new Pair((Object)r.getString("id"), (Object)r.getString("enable")))));
        }
        QFBuilder entityNumQF = new QFBuilder();
        if (!CollectionUtils.isEmpty((Collection)rRKMid)) {
            entityNumQF.add("id", "in", (Object)entityNums);
        }
        entityNumQF.add("bizappid", "=", (Object)CMAPPID);
        DynamicObjectCollection eRKMid = QueryServiceHelper.query((String)"bos_entityinfo", (String)DENTITYID, (QFilter[])entityNumQF.toArray());
        QFBuilder entityPermQF = new QFBuilder();
        if (!CollectionUtils.isEmpty(this.roleRepeatKeysWithIdEnable)) {
            entityPermQF.add(PERMITEM_NUMBER, "in", (Object)permItemNums);
        }
        if (!CollectionUtils.isEmpty((Collection)eRKMid)) {
            entityPermQF.add("entitytypeid", "in", eRKMid.stream().map(eT -> eT.getString(DENTITYID)).collect(Collectors.toSet()));
        }
        DynamicObjectCollection ePMPMid = QueryServiceHelper.query((String)"perm_functionperm", (String)EPMPSF, (QFilter[])entityPermQF.toArray());
        int size = ePMPMid.size();
        HashSet entityType = Sets.newHashSetWithExpectedSize((int)size);
        if (!CollectionUtils.isEmpty((Collection)ePMPMid)) {
            this.entityPermMap.addAll(ePMPMid.stream().map(eP -> {
                String entitytype = eP.getString("entitytype");
                entityType.add(entitytype);
                this.permItemRepeatKeysWithId.put(eP.getString(PERMITEM_NUMBER), eP.getString(PERMITEM_ID));
                return BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{entitytype, eP.getString(PERMITEM_NUMBER)}));
            }).collect(Collectors.toSet()));
        }
        QFBuilder rolePermQF = new QFBuilder();
        if (!CollectionUtils.isEmpty(this.roleRepeatKeysWithIdEnable)) {
            rolePermQF.add("roleid", "in", this.roleRepeatKeysWithIdEnable.values().stream().map(r -> (String)r.p1).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty((Collection)entityType)) {
            rolePermQF.add("roleperm.entity", "in", (Object)entityType);
        }
        if (!CollectionUtils.isEmpty(this.permItemRepeatKeysWithId)) {
            rolePermQF.add("roleperm.permitem.id", "in", this.permItemRepeatKeysWithId.values());
        }
        rolePermQF.add("roleperm.bizapp.number", "=", (Object)ApplicationTypeEnum.CM.getAppnum());
        Object[] rolePerms = BusinessDataServiceHelper.load((String)"bcm_perm_roleperm", (String)RPSSF, (QFilter[])rolePermQF.toArray());
        if (!ArrayUtils.isEmpty((Object[])rolePerms)) {
            this.rolePermMap = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
            Arrays.stream(rolePerms).forEach(rPI -> {
                DynamicObjectCollection roleperm = rPI.getDynamicObjectCollection("roleperm");
                if (!CollectionUtils.isEmpty((Collection)roleperm)) {
                    roleperm.forEach(rP -> this.rolePermMap.put(BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{rPI.getString(ROLEID_NUMBER), rP.getString(ENTITY_NUMBER), rP.getString(PERMITEM_NUMBER)})), (DynamicObject)rPI));
                }
            });
        } else {
            this.rolePermMap = Collections.emptyMap();
        }
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String roleNum = ImportHelper.getImportBillProp(rowData, ROLEID_NUMBER).toString();
        List<Object> entityNums = ImportHelper.getImportBillProp(rowData, "roleperm", ENTITY_NUMBER);
        List<Object> permItemNums = ImportHelper.getImportBillProp(rowData, "roleperm", PERMITEM_NUMBER);
        for (int i = 0; i < entityNums.size(); ++i) {
            String permItemNum = permItemNums.get(i).toString();
            String entityNum = entityNums.get(i).toString();
            String permKey = BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{roleNum, entityNum, permItemNum}));
            DynamicObject old = this.rolePermMap.get(permKey);
            if (CollectionUtils.isEmpty(this.rolePermMap) || !Objects.nonNull(old)) continue;
            return Optional.of(old);
        }
        return Optional.empty();
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData(billdatas);
    }

    @Override
    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        this.buildRoleEntityPermItemMapAndExec(billDataList, Collections.emptyMap());
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        this.buildRoleEntityPermItemMapAndExec(Collections.emptyList(), this.buildRoleEntityPermItemMapAndExec(billDataList, Collections.emptyMap()));
    }

    private Map<String, DynamicObject> buildRoleEntityPermItemMapAndExec(List<ImportBillData> billDataList, Map<String, DynamicObject> rolePermMapMidParam) {
        HashMap rolePermMapMidRes = Maps.newHashMap(this.rolePermMap);
        HashMap roleEntityPermItemMap = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
        boolean addOrRemove = Boolean.TRUE;
        String processInfo = "";
        if (CollectionUtils.isEmpty(billDataList) && !CollectionUtils.isEmpty(rolePermMapMidParam)) {
            addOrRemove = Boolean.FALSE;
            processInfo = "bcm_batch_bos_importupdate_del";
            rolePermMapMidParam.values().forEach(rPI -> {
                HashMap entityPermItemMap = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
                DynamicObjectCollection roleperm = rPI.getDynamicObjectCollection("roleperm");
                String roleNum = rPI.getString(ROLEID_NUMBER);
                if (!CollectionUtils.isEmpty((Collection)roleperm)) {
                    roleperm.forEach(rP -> {
                        String entityNumMid = rP.getString(ENTITY_NUMBER);
                        String permItemNumMid = rP.getString(PERMITEM_NUMBER);
                        if (Objects.nonNull(rolePermMapMidParam.get(BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{roleNum, entityNumMid, permItemNumMid}))))) {
                            this.buildEntityPermItemMap(entityPermItemMap, entityNumMid, roleperm.size(), rP.getString(PERMITEM_ID));
                        }
                    });
                }
                this.buildRoleEntityPermItemMap(roleEntityPermItemMap, roleNum, entityPermItemMap);
            });
        } else if (!CollectionUtils.isEmpty(billDataList) && CollectionUtils.isEmpty(rolePermMapMidParam)) {
            for (ImportBillData bd : billDataList) {
                String roleNum = ImportHelper.getImportBillProp(bd, ROLEID_NUMBER).toString();
                List<Object> entityNum = ImportHelper.getImportBillProp(bd, "roleperm", ENTITY_NUMBER);
                List<Object> permItemNum = ImportHelper.getImportBillProp(bd, "roleperm", PERMITEM_NUMBER);
                int size = entityNum.size();
                HashMap entityPermItemMap = Maps.newHashMapWithExpectedSize((int)size);
                for (int j = 0; j < size; ++j) {
                    String entityNumMid = entityNum.get(j).toString();
                    String permKey = BcmPermRolePermImport.getPermKey(Lists.newArrayList((Object[])new String[]{roleNum, entityNumMid, permItemNum.get(j).toString()}));
                    if (Objects.isNull(rolePermMapMidRes.get(permKey))) {
                        this.buildEntityPermItemMap(entityPermItemMap, entityNumMid, size, this.permItemRepeatKeysWithId.get(permItemNum.get(j).toString()));
                        continue;
                    }
                    rolePermMapMidRes.remove(permKey);
                }
                this.buildRoleEntityPermItemMap(roleEntityPermItemMap, roleNum, entityPermItemMap);
            }
            processInfo = CollectionUtils.isEmpty((Map)rolePermMapMidRes) ? "bcm_batch_bos_importnew" : "bcm_batch_bos_importupdate_new";
        }
        if (!CollectionUtils.isEmpty((Map)roleEntityPermItemMap)) {
            this.bcmRoleAssignFuncPerm(roleEntityPermItemMap, addOrRemove, new StringBuilder(processInfo));
        }
        return rolePermMapMidRes;
    }

    private void buildEntityPermItemMap(Map<String, List<String>> entityPermItemMap, String entityNumMid, int size, String pIId) {
        entityPermItemMap.putIfAbsent(entityNumMid, Lists.newArrayListWithExpectedSize((int)size));
        entityPermItemMap.get(entityNumMid).add(pIId);
    }

    private void buildRoleEntityPermItemMap(Map<String, Map<String, List<String>>> roleEntityPermItemMap, String roleNum, Map<String, List<String>> entityPermItemMap) {
        roleEntityPermItemMap.putIfAbsent(roleNum, entityPermItemMap);
        roleEntityPermItemMap.computeIfPresent(roleNum, (kREPIMN, vREPIMN) -> {
            vREPIMN.putAll(entityPermItemMap);
            return vREPIMN;
        });
    }

    private void bcmRoleAssignFuncPerm(Map<String, Map<String, List<String>>> roleEntityPermItemMap, boolean addOrRemove, StringBuilder processInfo) {
        roleEntityPermItemMap.entrySet().forEach(eREPIM -> {
            HashMap appEntityPermItemMap = Maps.newHashMapWithExpectedSize((int)1);
            appEntityPermItemMap.put(AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), eREPIM.getValue());
            PermissionServiceHelper.roleAssignFuncPerm((String)((String)this.roleRepeatKeysWithIdEnable.get(eREPIM.getKey()).p1), (Map)appEntityPermItemMap, (boolean)addOrRemove, (StringBuilder)processInfo);
        });
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return EMPTY_DYNAMIC_OBJECT_ARRAY;
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        return EMPTY_DYNAMIC_OBJECT_ARRAY;
    }
}

