/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.perm.UnionPermCommon;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BcmUnionPermPlugin
extends AbstractBaseFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String MODEL_FIELD = "model";
    private static final String BAR_SAVE = "bar_save";
    private static final String STATIC_CLASS_DESCRIPTION_CODE = "FormPluginConstant_0";
    private static final String TOOLBAR_AP = "toolbarap";
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SAVE_CHANGE_CONFIRM = "update_tree_confirm";
    private static final String F7_CHANGED_CONFIRM = "f7_changed_confirm";
    private static final String BAR_SAVE_CONFIRM = "bar_save_confirm";
    private static final String BAR_EXIT_CONFIRM = "bar_exit_confirm";
    public static final String FORM_SHOW_MODEL_ID = "model_id";
    private static final String ROW_SELECT_CACHE = "rowEditing";
    private static final String EDITING_FLAG = "true@";
    private static final String CM = "cm";
    private static final String BCM_UNIONPERMTREE = "bcm_unionpermtree";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"id"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object modelIdObj = formShowParameter.getCustomParam(FORM_SHOW_MODEL_ID);
        this.getModel().setValue(MODEL_FIELD, (Object)modelIdObj.toString());
        this.getPageCache().put(MODEL_FIELD, modelIdObj.toString());
        this.initPage();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBAR_AP);
        EntryGrid control = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        control.addRowClickListener((RowClickEventListener)this);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        if (this.isEditing()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\u201c%s\u201d\u3002", (String)"BcmUnionPermPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.getTip()}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SAVE_CHANGE_CONFIRM, (IFormPlugin)this));
        } else {
            this.updateTreeView();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        IPageCache pageCache = this.getPageCache();
        String rowSelectCache = pageCache.get(ROW_SELECT_CACHE);
        rowSelectCache = EDITING_FLAG + rowSelectCache;
        pageCache.put(ROW_SELECT_CACHE, rowSelectCache);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (MODEL_FIELD.equals(name)) {
            if (this.isEditing()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\u201c%s\u201d\u3002", (String)"BcmUnionPermPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.getTip()}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(F7_CHANGED_CONFIRM, (IFormPlugin)this));
            } else {
                this.initPage();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_SAVE.equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58%s", (String)"BcmUnionPermPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.getTip()}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BAR_SAVE_CONFIRM, (IFormPlugin)this));
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isEditing()) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u9000\u51fa\u3002", (String)"BcmUnionPermPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BAR_EXIT_CONFIRM, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtil.equals((String)BAR_SAVE_CONFIRM, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.saveUnionPerm();
            this.initPage();
        }
        if (StringUtil.equals((String)BAR_EXIT_CONFIRM, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put(ROW_SELECT_CACHE, "");
            this.getView().close();
        }
        if (StringUtil.equals((String)SAVE_CHANGE_CONFIRM, (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveUnionPerm();
            }
            this.updateTreeView();
        }
        if (StringUtil.equals((String)F7_CHANGED_CONFIRM, (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveUnionPerm();
            }
            this.initPage();
        }
    }

    private static String getMsgClassStatic() {
        return ResManager.loadKDString((String)"\u201c%s\u201d\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"BcmUnionPermPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void updateTreeView() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        TreeView treeview = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        if (selectRows.length == 0) {
            treeview.setMulti(false);
            this.getPageCache().put(ROW_SELECT_CACHE, "");
            return;
        }
        StringJoiner rowIndexes = new StringJoiner(",");
        for (int selectRow : selectRows) {
            rowIndexes.add(String.valueOf(selectRow));
        }
        this.getPageCache().put(ROW_SELECT_CACHE, rowIndexes.toString());
        TreeNode root = this.initTree();
        treeview.checkNode(root);
        treeview.setMulti(true);
        Set<Long> idSet = this.idCollectionByRowIndexes(entryGrid, selectRows);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_auth_info");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)entityType);
        HashMap<String, Integer> uncheckMap = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : load) {
            DynamicObjectCollection entryEntities = (DynamicObjectCollection)dynamicObject.get(ENTRY_ENTITY);
            for (DynamicObject entryEntity : entryEntities) {
                boolean check = (Boolean)entryEntity.get("ischeck");
                if (check) continue;
                String unionPermId2 = String.valueOf(entryEntity.get("unionpermid"));
                uncheckMap.putIfAbsent(unionPermId2, 0);
                uncheckMap.computeIfPresent(unionPermId2, (k, v) -> v + 1);
            }
        }
        ArrayList uncheckNodes = new ArrayList();
        uncheckMap.forEach((unionPermId, unionPermIdCount) -> {
            if (unionPermIdCount - idSet.size() == 0) {
                uncheckNodes.add(unionPermId);
            }
        });
        treeview.uncheckNodes(uncheckNodes);
    }

    private boolean isEditing() {
        String rowSelectCache = this.getPageCache().get(ROW_SELECT_CACHE);
        return rowSelectCache.contains(EDITING_FLAG);
    }

    @NotNull
    private Set<Long> idCollectionByRowIndexes(EntryGrid entryGrid, int[] selectRows) {
        HashSet<Long> idSet = new HashSet<Long>(selectRows.length);
        DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows) {
            DynamicObject dataEntity = dataEntities[selectRow];
            String id = (String)dataEntity.get("id");
            idSet.add(Long.valueOf(id));
        }
        return idSet;
    }

    private void initPage() {
        String modelId;
        Object modelValue = this.getModel().getValue(MODEL_FIELD);
        if (Objects.nonNull(modelValue)) {
            DynamicObject modelDy = (DynamicObject)modelValue;
            modelId = modelDy.getString("id");
        } else {
            modelId = this.getPageCache().get(MODEL_FIELD);
        }
        this.initEntity(modelId);
        this.initTree();
        this.getPageCache().put(ROW_SELECT_CACHE, "");
    }

    private void saveUnionPerm() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_auth_info");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = this.selectRowInCache();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u64cd\u4f5c\u5185\u5bb9\u3002", (String)"BcmUnionPermPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> idSet = this.idCollectionByRowIndexes(entryGrid, selectRows);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (DynamicObjectType)entityType);
        if (objectDynamicObjectMap.size() == 0) {
            return;
        }
        HashMap<String, List<String>> idForMap = new HashMap<String, List<String>>();
        objectDynamicObjectMap.forEach((k, v) -> {
            DynamicObjectCollection entryEntity = v.getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<String> dynamicObjects = new ArrayList<String>();
            for (DynamicObject dy : entryEntity) {
                String s = dy.toString();
                dynamicObjects.add(s);
            }
            idForMap.put(k + "", dynamicObjects);
        });
        Set<String> allLeafNode = this.getAllNode();
        HashSet<String> checkLeafNode = this.getCheckNode();
        ArrayList<DynamicObject> mainDataList = new ArrayList<DynamicObject>(objectDynamicObjectMap.size());
        objectDynamicObjectMap.forEach((k, v) -> {
            DynamicObjectCollection entryEntity = v.getDynamicObjectCollection(ENTRY_ENTITY);
            DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
            HashMap<String, DynamicObject> sub = new HashMap<String, DynamicObject>();
            for (DynamicObject dynamicObject : entryEntity) {
                sub.put(String.valueOf(dynamicObject.get("unionpermid")), dynamicObject);
            }
            allLeafNode.forEach(key -> {
                DynamicObject entryObject = (DynamicObject)sub.get(key);
                if (entryObject == null) {
                    entryObject = new DynamicObject(dynamicObjectType);
                    entryObject.set("unionpermid", key);
                    entryEntity.add((Object)entryObject);
                }
                entryObject.set("ischeck", (Object)"0");
                if (checkLeafNode.contains(key)) {
                    entryObject.set("ischeck", (Object)"1");
                }
            });
            mainDataList.add((DynamicObject)v);
        });
        try {
            SaveServiceHelper.save((DynamicObject[])mainDataList.toArray(new DynamicObject[mainDataList.size()]));
            this.writeFunPermLogs(mainDataList, idForMap);
            this.writeOpLogs(mainDataList, true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BcmUnionPermPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        catch (KDException e) {
            log.error((Throwable)e);
            this.writeOpLogs(mainDataList, false);
        }
    }

    private void writeOpLogs(List<DynamicObject> mainDataList, boolean success) {
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BcmUnionPermPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        List opDes = success ? mainDataList.stream().map(dataSelect -> {
            if ("bos_user".equals(dataSelect.getString("usertype"))) {
                return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u8054\u5408\u6743\u9650\u4fdd\u5b58\u6210\u529f\u3002", (String)"BcmUnionPermPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataSelect.getString("model.shownumber"), dataSelect.getString("model.name"), dataSelect.getDynamicObject("users").getString("name"), dataSelect.getString("authclass.number"));
            }
            return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u8054\u5408\u6743\u9650\u4fdd\u5b58\u6210\u529f\u3002", (String)"BcmUnionPermPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataSelect.getString("model.shownumber"), dataSelect.getString("model.name"), dataSelect.getDynamicObject("users").getString("name"), dataSelect.getString("authclass.number"));
        }).collect(Collectors.toList()) : mainDataList.stream().map(dataSelect -> {
            if ("bos_user".equals(dataSelect.getString("usertype"))) {
                return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u8054\u5408\u6743\u9650\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BcmUnionPermPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataSelect.getString("model.shownumber"), dataSelect.getString("name"), dataSelect.getDynamicObject("users").getString("name"), dataSelect.getString("authclass.number"));
            }
            return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u8054\u5408\u6743\u9650\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BcmUnionPermPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataSelect.getString("model.shownumber"), dataSelect.getString("name"), dataSelect.getDynamicObject("users").getString("name"), dataSelect.getString("authclass.number"));
        }).collect(Collectors.toList());
        OperationLogUtil.batchWriteOperationLog((String)opName, opDes, null, (String)"bcm_unionperm");
    }

    private void writeFunPermLogs(List<DynamicObject> mainDataList, HashMap<String, List<String>> idForMap) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        Map<String, String> allNodeMap = this.getAllNodeMap();
        String bizAppId = this.getBizAppId();
        Map<String, String> nodeEntityMap = this.getNodeItemsParentNodeMap();
        for (DynamicObject dy : mainDataList) {
            String id = dy.getString("id");
            String usernumber = dy.getString("users.number");
            String username = dy.getString("users.name");
            String authPermClassNumber = dy.getString("authclass.number");
            Map<String, DynamicObject> newMap = this.getNewMap(dy);
            List<String> list = idForMap.get(id);
            if (list.size() > 0) {
                for (String entryentity : list) {
                    DynamicObject log;
                    Map<String, String> oldMap = this.getOldMap(entryentity);
                    String permId = oldMap.get("id");
                    DynamicObject newdy = newMap.get(permId);
                    String unionPermId = newdy.getString("unionpermid");
                    String permItemName = allNodeMap.get(newdy.getString("unionpermid"));
                    String nodeEntityName = nodeEntityMap.get(unionPermId);
                    if (!this.isCheckPerm(oldMap.get("ischeck")) && newdy.getBoolean("ischeck")) {
                        log = FunctionPermLogHelper.newFunctionPermLog((Long)this.getModelId(), (String)usernumber, (String)username, (String)nodeEntityName, (String)permItemName, (String)authPermClassNumber, (String)FunctionPermLogMultiLangEnum.UnionPerm_Distribute.getOperateName(), (String)bizAppId);
                        logs.add(log);
                    }
                    if (!this.isCheckPerm(oldMap.get("ischeck")) || newdy.getBoolean("ischeck")) continue;
                    log = FunctionPermLogHelper.newFunctionPermLog((Long)this.getModelId(), (String)usernumber, (String)username, (String)nodeEntityName, (String)permItemName, (String)authPermClassNumber, (String)FunctionPermLogMultiLangEnum.UnionPerm_DelDistribute.getOperateName(), (String)bizAppId);
                    logs.add(log);
                }
                continue;
            }
            DynamicObjectCollection entryentitys = (DynamicObjectCollection)dy.get(ENTRY_ENTITY);
            for (DynamicObject entryentity : entryentitys) {
                if (!entryentity.getBoolean("ischeck")) continue;
                String unionPermId = entryentity.getString("unionpermid");
                String permItemName = allNodeMap.get(entryentity.getString("unionpermid"));
                String nodeEntityName = nodeEntityMap.get(unionPermId);
                DynamicObject log = FunctionPermLogHelper.newFunctionPermLog((Long)this.getModelId(), (String)usernumber, (String)username, (String)nodeEntityName, (String)permItemName, (String)authPermClassNumber, (String)FunctionPermLogMultiLangEnum.UnionPerm_Distribute.getOperateName(), (String)bizAppId);
                logs.add(log);
            }
        }
        if (logs.size() > 0) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
    }

    private Map<String, String> getNodeItemsParentNodeMap() {
        Map<String, String> nodeEntityMap = this.getNodeEntityMap();
        String appNumber = this.getBizAppId();
        QFilter qFilter = new QFilter("appnumber", "=", (Object)appNumber);
        HashMap<String, String> map = new HashMap<String, String>(100);
        DynamicObjectCollection query = QueryServiceHelper.query((String)BCM_UNIONPERMTREE, (String)"id,entitynumber", (QFilter[])new QFilter[]{qFilter});
        query.forEach(dy -> {
            String entitynumber = dy.getString("entitynumber");
            String id = dy.getString("id");
            String entityName = (String)nodeEntityMap.get(entitynumber);
            if (entityName != null) {
                map.put(id, entityName);
            }
        });
        return map;
    }

    private Map<String, DynamicObject> getNewMap(DynamicObject dynamicObject) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(12);
        DynamicObjectCollection dc = (DynamicObjectCollection)dynamicObject.get(ENTRY_ENTITY);
        for (DynamicObject dy : dc) {
            map.put(dy.getString("id"), dy);
        }
        return map;
    }

    private Map<String, String> getOldMap(String entryentity) {
        String[] entryentities = entryentity.split(ENTRY_ENTITY);
        String substring = entryentities[1].substring(1, entryentities[1].length() - 1);
        String[] values = substring.split(",");
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("id", values[0].trim());
        map.put("ischeck", values[2].trim());
        map.put("unionpermid", values[3].trim());
        return map;
    }

    private boolean isCheckPerm(String perm) {
        if (perm == null) {
            return false;
        }
        return !StringUtils.equals((CharSequence)"null", (CharSequence)perm);
    }

    private Map<String, String> getNodeEntityMap() {
        String appNumber = this.getBizAppId();
        QFilter qFilter = new QFilter("appnumber", "=", (Object)appNumber);
        QFilter qFilter1 = new QFilter("permitemid", "=", (Object)"0");
        HashMap<String, String> map = new HashMap<String, String>(12);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)BCM_UNIONPERMTREE, (String)"entitynumber,nodename,permitemid", (QFilter[])new QFilter[]{qFilter, qFilter1});
        dys.forEach(dy -> {
            String entitynumber = dy.getString("entitynumber");
            String nodename = dy.getString("nodename");
            map.put(entitynumber, nodename);
        });
        return map;
    }

    @NotNull
    private Map<String, String> getAllNodeMap() {
        HashMap<String, String> allNode = new HashMap<String, String>();
        TreeNode cacheNode = this.getTreeNode();
        this.getLeafKeyValue(allNode, cacheNode);
        return allNode;
    }

    private void getLeafKeyValue(Map<String, String> allNode, TreeNode treeNode) {
        Object data = treeNode.getData();
        if (data != null && !(data instanceof Boolean)) {
            allNode.put(String.valueOf(((DynamicObject)data).get("id")), String.valueOf(((DynamicObject)data).get("nodename")));
            return;
        }
        List children = treeNode.getChildren();
        for (TreeNode child : children) {
            this.getLeafKeyValue(allNode, child);
        }
    }

    @NotNull
    private HashSet<String> getCheckNode() {
        HashSet<String> checkNode = new HashSet<String>();
        TreeView treeview = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        List selectedNodes = treeview.getTreeState().getSelectedNodes();
        for (Map selectedNode : selectedNodes) {
            Object isParent = selectedNode.get("isParent");
            if (isParent == null || Boolean.parseBoolean(isParent.toString())) continue;
            String id = selectedNode.get("id").toString();
            checkNode.add(id);
        }
        return checkNode;
    }

    private int[] selectRowInCache() {
        String rowSelectCache = this.getPageCache().get(ROW_SELECT_CACHE);
        if (StringUtil.equals((String)"", (String)rowSelectCache)) {
            return new int[0];
        }
        String[] cache = rowSelectCache.split("@");
        String rows = cache[cache.length - 1];
        String[] stringRows = rows.split(",");
        int[] intRows = new int[stringRows.length];
        for (int i = 0; i < stringRows.length; ++i) {
            intRows[i] = Integer.parseInt(stringRows[i]);
        }
        return intRows;
    }

    @NotNull
    private Set<String> getAllNode() {
        HashSet<String> allNode = new HashSet<String>();
        TreeNode cacheNode = this.getTreeNode();
        this.getLeaf(allNode, cacheNode);
        return allNode;
    }

    private void getLeaf(Set<String> allNode, TreeNode treeNode) {
        Object data = treeNode.getData();
        if (data != null && !(data instanceof Boolean)) {
            allNode.add(String.valueOf(((DynamicObject)data).get("id")));
            return;
        }
        List children = treeNode.getChildren();
        for (TreeNode child : children) {
            this.getLeaf(allNode, child);
        }
    }

    private TreeNode initTree() {
        TreeNode cacheNode = this.getTreeNode();
        TreeView view = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        view.setMulti(false);
        view.deleteAllNodes();
        view.addNode(cacheNode);
        view.expand(cacheNode.getId());
        return cacheNode;
    }

    private TreeNode getTreeNode() {
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp(this.getView());
        return UnionPermCommon.getTreeNodeForCache(applicationTypeEnum);
    }

    private void initEntity(String modelIdObj) {
        if (StringUtils.isEmpty((CharSequence)modelIdObj)) {
            return;
        }
        Long modelId = Long.valueOf(modelIdObj);
        QFilter baseFilter = new QFilter(MODEL_FIELD, "=", (Object)modelId);
        StringJoiner selectFieldJoiner = new StringJoiner(",").add("id").add("users.name").add("usertype").add("authclass.id").add("authclass.number");
        ArrayList dys = Lists.newArrayList(BusinessDataServiceHelper.loadFromCache((String)"bcm_auth_info", (String)selectFieldJoiner.toString(), (QFilter[])baseFilter.toArray()).values());
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>(dys.size());
        for (DynamicObject dy2 : dys) {
            set.add(dy2.getLong("authclass.id"));
        }
        QFilter permEntityFilter = new QFilter("permclass", "in", set);
        permEntityFilter.and("entityname", "=", (Object)"bcm_entitymembertree");
        permEntityFilter.and(baseFilter);
        StringJoiner permFieldJoiner = new StringJoiner(",").add("entityid").add("permclass");
        DynamicObjectCollection permClassEntityDy = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)permFieldJoiner.toString(), (QFilter[])permEntityFilter.toArray());
        HashMap entityIdSetMap = new HashMap(permClassEntityDy.size());
        permClassEntityDy.forEach(dy -> {
            Set permClass = entityIdSetMap.getOrDefault(dy.getString("permclass"), new HashSet());
            permClass.add(dy.getLong("entityid"));
            entityIdSetMap.put(dy.getString("permclass"), permClass);
        });
        HashSet sets = new HashSet();
        entityIdSetMap.values().forEach(sets::addAll);
        QFilter orgFilter = new QFilter("id", "in", sets);
        String orgField = "id,number";
        DynamicObjectCollection orgEntityDy = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)orgField, (QFilter[])orgFilter.toArray());
        HashMap numbersMap = new HashMap(entityIdSetMap.size());
        Set entries = entityIdSetMap.entrySet();
        for (Map.Entry entry : entries) {
            Set<DynamicObject> collect = orgEntityDy.stream().filter(dy -> ((Set)entry.getValue()).contains(dy.getLong("id"))).collect(Collectors.toSet());
            StringJoiner numberJoiner = new StringJoiner(",");
            collect.forEach(dy -> numberJoiner.add(dy.getString("number")));
            numbersMap.put(entry.getKey(), numberJoiner.toString());
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dys.size());
        for (int i = 0; i < dys.size(); ++i) {
            this.getModel().setValue("id", (Object)((DynamicObject)dys.get(i)).getString("id"), i);
            this.getModel().setValue("user", (Object)((DynamicObject)dys.get(i)).getString("users.name"), i);
            this.getModel().setValue("auth_class", (Object)((DynamicObject)dys.get(i)).getString("authclass.number"), i);
            if ("bos_user".equals(((DynamicObject)dys.get(i)).get("usertype"))) {
                this.getModel().setValue("usertype", (Object)ResManager.loadKDString((String)"\u7528\u6237", (String)"DataAuthMainPagePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            } else {
                this.getModel().setValue("usertype", (Object)ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DataAuthMainPagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
            }
            this.getModel().setValue("orgnumber", numbersMap.get(((DynamicObject)dys.get(i)).getString("authclass.id")), i);
        }
    }

    private String getTip() {
        int[] selectRows = this.selectRowInCache();
        String rowTip = "";
        if (selectRows.length > 0) {
            String selectRowNums = Arrays.stream(selectRows).mapToObj(a -> String.valueOf(a + 1)).collect(Collectors.joining(",", "", ""));
            rowTip = ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"BcmUnionPermPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[]{selectRowNums});
        }
        return rowTip;
    }

    public static class BcmPermClassEntity {
        public static final String ID = "id";
        public static final String ENTITY_ID = "entityid";
        public static final String PERM_CLASS = "permclass";
        public static final String MODEL = "model";
        public static final String ENTITY_NAME = "entityname";

        private BcmPermClassEntity() {
            throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"BcmPermClassEntity"}));
        }
    }

    public static class BcmAuthEntry {
        public static final String ID = "id";
        public static final String ENTITY_ID = "entityid";
        public static final String UNION_PERM_ID = "unionpermid";
        public static final String CHECK_PERM = "ischeck";

        private BcmAuthEntry() {
            throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"BcmAuthEntry"}));
        }

        public static class CheckPerm {
            public static final String UNCHECK = "0";
            public static final String CHECK = "1";

            private CheckPerm() {
                throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"CheckPerm"}));
            }
        }
    }

    public static class BcmUnionPermTree {
        public static final String ID = "id";
        public static final String APP_NUMBER = "appnumber";
        public static final String NODE_NAME = "nodename";
        public static final String ENTITY_NUMBER = "entitynumber";
        public static final String PERM_ITEM_ID = "permitemid";

        private BcmUnionPermTree() {
            throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"BcmUnionPermTree"}));
        }

        public static String getEntityName() {
            return BcmUnionPermPlugin.BCM_UNIONPERMTREE;
        }
    }

    public static class BcmAuthInfo {
        public static final String ID = "id";
        public static final String USER_NAME = "users.name";
        public static final String USERS = "users";
        public static final String USER_TYPE = "usertype";
        public static final String MODEL = "model";
        public static final String AUTH_CLASS = "authclass";
        public static final String AUTH_CLASS_ID = "authclass.id";
        public static final String AUTH_CLASS_NUMBER = "authclass.number";
        public static final String DATA_AUTH = "data_auth";
        public static final String LEVEL1 = "level1";
        public static final String LEVEL2 = "level2";
        public static final String LEVEL3 = "level3";
        public static final String LEVEL4 = "level4";
        public static final String LEVEL5 = "level5";
        public static final String LEVEL6 = "level6";
        public static final String LEVEL7 = "level7";
        public static final String LEVEL8 = "level8";
        public static final String LEVEL9 = "level9";
        public static final String LEVEL10 = "level10";
        public static final String LEVEL11 = "level11";
        public static final String LEVEL12 = "level12";
        public static final String LEVEL13 = "level13";
        public static final String LEVEL14 = "level14";
        public static final String ENTRY_ENTITY = "entryentity";

        private BcmAuthInfo() {
            throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"BcmAuthInfo"}));
        }
    }

    static class EntryEntity {
        public static final String ID = "id";
        public static final String USER = "user";
        public static final String USERTYPE = "usertype";
        public static final String AUTH_CLASS = "auth_class";
        public static final String ORG_NUMBER = "orgnumber";

        private EntryEntity() {
            throw new IllegalStateException(ResManager.loadKDString((String)BcmUnionPermPlugin.getMsgClassStatic(), (String)BcmUnionPermPlugin.STATIC_CLASS_DESCRIPTION_CODE, (String)"fi-bcm-formplugin", (Object[])new Object[]{"EntryEntity"}));
        }
    }
}

