/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.UpgradeStatusUtil;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class BcmUnionPermRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String PERMITEMSEL = "permitemsel";
    private static final String USERS = "users";
    private static final String ID = "id";
    private static final String USERGROUPS = "usergroups";
    private static final String MODEL = "model";
    private static final String ENTITYS = "entitys";
    private static final String QUERYSELECT = "queryselect";
    private static final String BYUSER = "byuser";
    private static final String BYGROUP = "bygroup";
    private static final String BCM_MODEL = "bcm_model";
    private static final String ENTITYSINFO = "entitysinfo";
    private static final String APPNUMBER = "appnumber";
    private static final String ISBYUSER = "isbyuser";
    private static final String CSLSCHEMEENABLE = "cslschemeEnable";
    private static final String ISFILTERRATESCHEME = "isFilterRateScheme";
    private static final String DIMENSION = "dimension";
    private static final String DSEQ = "dseq";
    private static final String SIGN = "sign";
    private static final String SHOWSCOPES = "showScopes";
    private static final String NAME = "name";
    private static final String SCOPE = "scope";
    private static final String BCM_AUTH_INFO = "bcm_auth_info";
    private static final String USERTYPE = "usertype";
    private static final String BOS_USERGROUP = "bos_usergroup";
    private static final String MODEL_ID = "model.id";
    private static final String ISINCLUDEALLSUB = "isIncludeAllSub";
    private static final String BOS_USERGROUPSTAFF = "bos_usergroupstaff";
    private static final String BCM_UNIONPERMTREE = "bcm_unionpermtree";
    private static final String USERGROUP_ID = "usergroup.id";
    private static final String RPT = "rpt";
    private static final String REPORTTYPE = "ReportType";
    private static final String PID = "pid";
    private static final String BOS_USER = "bos_user";
    private static final String NUMBER = "number";
    private static final String EXPORTEXCEL = "exportexcel";
    private static final String DEFAULT_APP_ID = "cm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit permitemsel = (BasedataEdit)this.getControl(PERMITEMSEL);
        permitemsel.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit users = (BasedataEdit)this.getControl(USERS);
        users.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit usergroups = (BasedataEdit)this.getControl(USERGROUPS);
        usergroups.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener(this::beforeF7Select);
        this.addClickListeners(new String[]{ENTITYS});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{USERGROUPS});
        this.getModel().setValue(QUERYSELECT, (Object)BYUSER);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if ((StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) && (StringUtils.isEmpty((CharSequence)(modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), MODEL))) || modelId.equals("0"))) {
            return;
        }
        List<QFilter> modelFilter = this.getModelFilters();
        DynamicObjectCollection modelCollection = QueryServiceHelper.query((String)BCM_MODEL, (String)ID, (QFilter[])modelFilter.toArray(new QFilter[modelFilter.size()]));
        if (this.getIdList(modelCollection).contains(Long.parseLong(modelId))) {
            this.getModel().setValue(MODEL, (Object)Long.valueOf(modelId));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)MODEL, (CharSequence)key)) {
            String modelId;
            this.getModel().setValue(USERS, null);
            this.getModel().setValue(USERGROUPS, null);
            this.getModel().setValue(ENTITYS, null);
            this.getModel().setValue(PERMITEMSEL, null);
            if (this.getModel().getValue(MODEL) != null && StringUtils.isNotEmpty((CharSequence)(modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getString(ID)))) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), modelId);
            }
            this.getPageCache().remove(ENTITYS);
            this.getPageCache().remove("KEY_MODEL_ID");
        } else if (StringUtils.equals((CharSequence)QUERYSELECT, (CharSequence)key)) {
            String queryselect = (String)this.getModel().getValue(QUERYSELECT);
            if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USERGROUPS});
            } else if (StringUtils.equals((CharSequence)BYGROUP, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{USERGROUPS});
            }
        } else if (StringUtils.equals((CharSequence)ENTITYS, (CharSequence)key) && (changeSet = e.getChangeSet()) != null && changeSet.length > 0 && changeSet[0].getNewValue() != null && StringUtils.isEmpty((CharSequence)changeSet[0].getNewValue().toString())) {
            this.getPageCache().remove(ENTITYS);
            this.getPageCache().remove("KEY_MODEL_ID");
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String appNumber;
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        String entitys = this.getPageCache().get(ENTITYS);
        if (StringUtils.isNotEmpty((CharSequence)entitys)) {
            customParam.put(ENTITYSINFO, entitys);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appNumber = this.getView().getFormShowParameter().getAppId()))) {
            customParam.put(APPNUMBER, appNumber);
        }
        customParam.put(ISBYUSER, this.getModel().getValue(QUERYSELECT));
        queryParam.setCustomParam(customParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (this.getModel().getValue(MODEL) != null) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.QUERY.getName(), (String)(OpItemEnum.QUERY.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)EXPORTEXCEL, (CharSequence)key)) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.EXPORTEXCEL.getName(), (String)(OpItemEnum.EXPORTEXCEL.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)Long.valueOf(this.getPageCache().get(MODEL)));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (StringUtils.isEmpty((CharSequence)filterInfo.getString(MODEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId()) || StringUtils.isEmpty((CharSequence)AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"appid\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5\u3002", (String)"BcmUnionPermRptPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getPageCache().put(MODEL, ((DynamicObject)filterInfo.getValue(MODEL)).getString(ID));
        return super.verifyQuery(queryParam);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ENTITYS.equals(key)) {
            if (Objects.isNull(this.getModel().getValue(MODEL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMulTiF7(ENTITYS, "Entity");
        }
    }

    private void showMulTiF7(String key, String number) {
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumberIgnoreCase((long)modelId, (String)number);
        if (dim == null) {
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(CSLSCHEMEENABLE, false);
        params.put(ISFILTERRATESCHEME, true);
        params.put(DIMENSION, dim.getInt(DSEQ) + "");
        params.put(SIGN, key);
        if (ENTITYS.equals(key)) {
            params.put(SHOWSCOPES, ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 90, 110}));
        }
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u9009\u62e9", (String)"BcmUnionPermRptPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString(NAME) + " - "));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((BasedataEdit)event.getSource()).getKey();
        if (PERMITEMSEL.equals(key)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection permIds = QueryServiceHelper.query((String)BCM_UNIONPERMTREE, (String)"permitemid as id", (QFilter[])new QFilter[]{new QFilter(APPNUMBER, "=", (Object)appId)});
            QFilter qFilter = new QFilter(ID, "in", this.getIdStirngList(permIds));
            event.addCustomQFilter(qFilter);
        } else if (MODEL.equals(key) && this.getControl(MODEL) != null) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            List<QFilter> qFilterList = this.getModelFilters();
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if (USERS.equals(key) && this.getControl(USERS) != null) {
            if (Objects.isNull(this.getModel().getValue(MODEL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            event.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            DynamicObjectCollection userOrGroupColllection = QueryServiceHelper.query((String)BCM_AUTH_INFO, (String)"users.id as id,usertype", (QFilter[])new QFilter[]{new QFilter(MODEL_ID, "=", (Object)modelId)});
            HashSet<Long> userIds = new HashSet<Long>(userOrGroupColllection.size());
            HashSet<Long> groupIds = new HashSet<Long>(userOrGroupColllection.size());
            for (DynamicObject userOrGroup : userOrGroupColllection) {
                String usertype = userOrGroup.getString(USERTYPE);
                if (StringUtils.equals((CharSequence)usertype, (CharSequence)BOS_USER)) {
                    userIds.add(userOrGroup.getLong(ID));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)usertype, (CharSequence)BOS_USERGROUP)) continue;
                groupIds.add(userOrGroup.getLong(ID));
            }
            DynamicObjectCollection usersFromGroup = QueryServiceHelper.query((String)BOS_USERGROUPSTAFF, (String)"user.id as id", (QFilter[])new QFilter[]{new QFilter(USERGROUP_ID, "in", groupIds)});
            userIds.addAll(this.getIdList(usersFromGroup));
            QFilter qFilter3 = new QFilter(ID, "in", userIds);
            ArrayList<QFilter> qfList2 = new ArrayList<QFilter>(1);
            qfList2.add(qFilter3);
            event.setCustomQFilters(qfList2);
            event.getFormShowParameter().setCustomParam(ISINCLUDEALLSUB, (Object)true);
        } else if (USERGROUPS.equals(key) && this.getControl(USERGROUPS) != null) {
            if (Objects.isNull(this.getModel().getValue(MODEL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            QFilter authDataFilter = new QFilter(MODEL_ID, "=", (Object)modelId);
            authDataFilter.and(USERTYPE, "=", (Object)BOS_USERGROUP);
            DynamicObjectCollection authInfo = QueryServiceHelper.query((String)BCM_AUTH_INFO, (String)"users.id as id", (QFilter[])new QFilter[]{authDataFilter});
            ArrayList<QFilter> qfList3 = new ArrayList<QFilter>(1);
            qfList3.add(new QFilter(ID, "in", this.getIdList(authInfo)));
            event.setCustomQFilters(qfList3);
        }
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getLong(ID));
        }
        return idList;
    }

    private List<String> getIdStirngList(DynamicObjectCollection objList) {
        ArrayList<String> idList = new ArrayList<String>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getString(ID));
        }
        return idList;
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (cb.getReturnData() != null) {
            DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
            if (ENTITYS.equals(key)) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                Object[] ids = new Object[doc.size()];
                StringBuilder idSb = new StringBuilder();
                for (int i = 0; i < doc.size(); ++i) {
                    ids[i] = ((DynamicObject)doc.get(i)).get(4);
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put(ID, ((DynamicObject)doc.get(i)).get(4).toString());
                    map.put(SCOPE, ((DynamicObject)doc.get(i)).get(5).toString());
                    map.put(NUMBER, ((DynamicObject)doc.get(i)).get(2).toString());
                    map.put(NAME, ((DynamicObject)doc.get(i)).get(3).toString());
                    map.put(PID, ((DynamicObject)doc.get(i)).get(6).toString());
                    if (RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)) == RangeEnum.VALUE_10) {
                        sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(',');
                    } else {
                        sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"BcmUnionPermRptPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)).getName()).append(',');
                    }
                    list.add(map);
                    idSb.append(((DynamicObject)doc.get(i)).get(4).toString()).append(';').append(((DynamicObject)doc.get(i)).getInt(5)).append(',');
                }
                this.getPageCache().put(ENTITYS, SerializationUtils.toJsonString(list));
                this.getModel().setValue(ENTITYS, (Object)sb.substring(0, StringUtils.isEmpty((CharSequence)sb) ? sb.length() : sb.length() - 1));
            }
        }
    }

    private List<QFilter> getModelFilters() {
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        QFilter qf = ModelUtil.getModelQfilterByApp((IFormView)this.getView());
        if (StringUtils.equals((CharSequence)RPT, (CharSequence)this.getView().getFormShowParameter().getAppId())) {
            qf = qf.or(REPORTTYPE, "=", (Object)"1");
        }
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        QFilter upgradedid = new QFilter(ID, "in", (Object)UpgradeStatusUtil.getUpgradesModelIds());
        modelQFilters.add(upgradedid);
        QFilter superid = new QFilter(ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        modelQFilters.add(superid);
        qFilterList.addAll(modelQFilters);
        return qFilterList;
    }
}

