/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.RoleEditNewPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.perm.RoleEditPlugin;
import kd.fi.bcm.formplugin.perm.RolePermUtils;

public abstract class CommonRoleEditPlugin
extends RoleEditNewPlugin
implements IOperationLog {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(RoleEditPlugin.class);
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PERMITEMMAP_CACHE = "permItemMap";
    private static final String nodeMapTreeOldCache = "nodeMap$tree_funcpermOld";
    private static final String currentNodeMapTreeCache = "nodeMap$tree_funcperm";
    private static final String PERM_CACHE_LIST = "role_perm_cache_list";
    private static Long RoleModelId = 17299999999L;
    private static final String ID = "id";

    public void initialize() {
        super.initialize();
        if (StringUtils.isEmpty((String)this.getPageCache().get(PERMITEMMAP_CACHE))) {
            this.initPermKeys();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"baritem_org2usrgrp"});
    }

    protected void initializeDataPermCache() {
        super.initializeDataPermCache();
        this.setPermCache();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ApplicationTypeEnum app;
        super.beforeDoOperation(e);
        if (Objects.equals(e.getVarMap().get("source.operateKey"), "disable") && Objects.equals(BcmFunPermissionHelper.APP2ADMINROLEID.get(app = ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId())), this.getModel().getValue(ID))) {
            e.setCancel(Boolean.TRUE.booleanValue());
            RolePermUtils.throwAdQryProhibitDisable(app);
        }
        this.getPageCache().put(PERM_CACHE_LIST, SerializationUtils.toJsonString(this.getRolePermission()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    protected void writePermLogs() {
        String usernumber = this.getModel().getValue(NUMBER).toString();
        String username = this.getModel().getValue(NAME).toString();
        if (StringUtils.isEmpty((String)usernumber) || StringUtils.isEmpty((String)username)) {
            return;
        }
        String permItemMapString = this.getPageCache().get(PERMITEMMAP_CACHE);
        if (permItemMapString == null) {
            return;
        }
        Map permItemMap = (Map)SerializationUtils.fromJsonString((String)permItemMapString, Map.class);
        List nodeMapOld = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERM_CACHE_LIST), List.class);
        List<String> nodeMapNew = this.getRolePermission();
        ArrayList nodeMapOldTemp = Lists.newArrayListWithCapacity((int)nodeMapOld.size());
        Collections.addAll(nodeMapOldTemp, new String[nodeMapOld.size()]);
        Collections.copy(nodeMapOldTemp, nodeMapOld);
        ArrayList addMapNewTemp = Lists.newArrayListWithCapacity((int)nodeMapNew.size());
        Collections.addAll(addMapNewTemp, new String[nodeMapNew.size()]);
        Collections.copy(addMapNewTemp, nodeMapNew);
        nodeMapOld.removeAll(nodeMapNew);
        addMapNewTemp.removeAll(nodeMapOldTemp);
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (nodeMapOld.size() > 0) {
            this.setLogs(logs, usernumber, username, permItemMap, nodeMapOld, 0);
        }
        if (addMapNewTemp.size() > 0) {
            this.setLogs(logs, usernumber, username, permItemMap, addMapNewTemp, 1);
        }
        if (logs.size() > 0) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
                this.getPageCache().put(PERM_CACHE_LIST, SerializationUtils.toJsonString(nodeMapNew));
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
    }

    private List<String> getRolePermission() {
        String roleId = (String)this.getModel().getDataEntity().getPkValue();
        DynamicObject role = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_roleperm", (QFilter[])new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        if (Objects.isNull(role)) {
            return Collections.EMPTY_LIST;
        }
        String fid = role.getString(ID);
        return (List)DB.query((DBRoute)DBRoute.permission, (String)String.format("select fpermitemid,fentitytypeid from t_perm_rolepermdetial  where fid = '%s'", fid), rs -> {
            ArrayList res = Lists.newArrayListWithCapacity((int)100);
            while (rs.next()) {
                res.add(rs.getString("fentitytypeid") + "|" + rs.getString("fpermitemid"));
            }
            return res;
        });
    }

    private void setLogs(ArrayList<DynamicObject> logs, String usernumber, String username, Map<String, String> permItemMap, List<String> nodeMap, int operatType) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String permitem : nodeMap) {
            String entityNumber = this.getPermEntity(permitem);
            String permNumber = this.getPermItem(permitem);
            String entityName = "";
            try {
                entityName = MetadataServiceHelper.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue();
            }
            catch (KDException e) {
                log.error("MetadataServiceHelper.getDataEntityType is failed on SetLogs");
                continue;
            }
            String opration = FunctionPermLogMultiLangEnum.RoleEite_DelDistribute.getOperateName();
            if (operatType == 1) {
                opration = FunctionPermLogMultiLangEnum.RoleEite_Distribute.getOperateName();
            }
            DynamicObject log1 = FunctionPermLogHelper.newFunctionPermLog((Long)RoleModelId, (String)usernumber, (String)username, (String)entityName, (String)permItemMap.get(permNumber), (String)"", (String)opration, (String)appId);
            logs.add(log1);
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove(nodeMapTreeOldCache);
    }

    private void setPermCache() {
        String pageId = this.getView().getPageId();
        if (pageId != null && !pageId.contains(this.getPageNumber()) && StringUtils.isEmpty((String)this.getPageCache().get("isHavCreated")) && this.getPageCache().get(nodeMapTreeOldCache) == null) {
            this.getPageCache().put(nodeMapTreeOldCache, "{}");
            this.getPageCache().put("isHavCreated", "1");
            return;
        }
        if (this.getPageCache().get(nodeMapTreeOldCache) == null && this.getPageCache().get(currentNodeMapTreeCache) != null) {
            this.getPageCache().put(nodeMapTreeOldCache, this.getPageCache().get(currentNodeMapTreeCache));
        }
    }

    private String getPermEntity(String permItemString) {
        return permItemString.split("\\|")[0];
    }

    private String getPermItem(String permItemString) {
        String[] first = permItemString.split("\\|");
        return first[1].split("@")[0];
    }

    private void initPermKeys() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(PERMITEMMAP_CACHE))) {
            HashMap map1 = new HashMap(1500);
            BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"number,name", (QFilter[])new QFilter[0]).values().stream().forEach(k -> map1.put(k.getString(ID), k.getString(NAME)));
            this.getPageCache().put(PERMITEMMAP_CACHE, SerializationUtils.toJsonString(map1));
        }
    }

    @Override
    public String getBizEntityNumber() {
        return null;
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    protected abstract String getPageNumber();

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, null, (String)this.getBizEntityNumber());
        logInfo.setBizObjID(this.getPageNumber());
        logService.addLog(logInfo);
    }
}

