/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.UserAssignRolePlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.perm.BcmUserAssignRolePlugin;
import org.apache.commons.collections.CollectionUtils;

public abstract class CommonUserAssignRolePlugin
extends UserAssignRolePlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(BcmUserAssignRolePlugin.class);
    private static final String OldOrgMapCache = "oldOrgMapCache";
    private static final String OldRoleMapCache = "oldRoleMapCache";
    private static final String MODEL_ID = "dim_identity";
    private static final String ROLE_ID = "role_identity";
    private static final String ROLE_LIST = "list_role";
    private static final String ORG_LIST = "list_org";
    protected static final String SAVE = "baritem_save";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String isHavNotTrue = "isHavNotTrue";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{SAVE});
    }

    protected abstract String getEntityName();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        String id = AppMetadataCache.getAppInfo((String)appId).getId();
        QFilter qf = new QFilter("bizdomain", "=", (Object)id);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)this.getEntityName(), (String)"id", (QFilter[])new QFilter[]{qf});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return;
        }
        List ids = dys.stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.getPageCache().put("CustomFilter_RoleIds", JSON.toJSONString(ids));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPermCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("user".equals(e.getProperty().getName())) {
            this.clearPermCache();
            this.setPermCache();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void clearPermCache() {
        this.getPageCache().remove(OldOrgMapCache);
        this.getPageCache().remove(OldRoleMapCache);
    }

    private void setPermCache() {
        if (this.getPageCache().get(OldOrgMapCache) == null) {
            HashMap initRolesMapCache = new HashMap();
            HashMap initModelAndRoleMapCache = new HashMap();
            this.getModel().getEntryEntity(ORG_LIST).forEach(v -> {
                String modelId = v.getString(MODEL_ID);
                DynamicObjectCollection dt = (DynamicObjectCollection)v.get(ROLE_LIST);
                ArrayList<String> roleIds = new ArrayList<String>(dt.size());
                for (DynamicObject d : dt) {
                    roleIds.add(d.getString(ROLE_ID));
                    HashMap<String, String> role = new HashMap<String, String>(2);
                    role.put(NUMBER, d.getString("role_number.number"));
                    role.put(NAME, d.getString("role_number.name"));
                    initRolesMapCache.put(d.getString(ROLE_ID), role);
                }
                initModelAndRoleMapCache.put(modelId, roleIds);
            });
            this.getPageCache().put(OldOrgMapCache, SerializationUtils.toJsonString(initModelAndRoleMapCache));
            this.getPageCache().put(OldRoleMapCache, SerializationUtils.toJsonString(initRolesMapCache));
        }
    }

    private Map<String, List<String>> getCurrentMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.getModel().getEntryEntity(ORG_LIST).forEach(v -> {
            String modelId = v.getString(MODEL_ID);
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get(ROLE_LIST);
            ArrayList<String> roleIds = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                roleIds.add(d.getString(ROLE_ID));
            }
            map.put(modelId, roleIds);
        });
        return map;
    }

    protected void writePermLogs() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        String usernumber = user.getString(NUMBER);
        String username = user.getString(NAME);
        HashMap<String, DynamicObject> newUsersMap = new HashMap<String, DynamicObject>();
        HashMap mapNew = new HashMap();
        this.getModel().getEntryEntity(ORG_LIST).forEach(v -> {
            String modelId = v.getString(MODEL_ID);
            DynamicObjectCollection roleDC = (DynamicObjectCollection)v.get(ROLE_LIST);
            ArrayList<String> userIds = new ArrayList<String>(roleDC.size());
            for (DynamicObject role : roleDC) {
                userIds.add(role.getString(ROLE_ID));
                newUsersMap.put(role.getString(ROLE_ID), (DynamicObject)role.get("role_number"));
            }
            mapNew.put(modelId, userIds);
        });
        String oldOrgMapCache = this.getPageCache().get(OldOrgMapCache);
        HashMap mapOld = (HashMap)SerializationUtils.fromJsonString((String)oldOrgMapCache, Map.class);
        String oldRoleMapCache = this.getPageCache().get(OldRoleMapCache);
        HashMap mapOldRole = (HashMap)SerializationUtils.fromJsonString((String)oldRoleMapCache, Map.class);
        Set oldModelIds = mapOld.keySet();
        Set currentModelIds = mapNew.keySet();
        Set currentModleEntries = mapNew.entrySet();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (mapNew.size() > 0) {
            for (Map.Entry entry : currentModleEntries) {
                String modelId = (String)entry.getKey();
                Long modelID = Long.parseLong(modelId);
                List currentRoleIds = (List)entry.getValue();
                if (currentRoleIds.size() == 0) {
                    this.getPageCache().put(isHavNotTrue, "1");
                    break;
                }
                if (oldModelIds.contains(modelId)) {
                    List oldRoleIds = (List)mapOld.get(modelId);
                    currentRoleIds.removeAll(oldRoleIds);
                    if (currentRoleIds.size() > 0) {
                        this.setNewAddLogs(logs, modelID, currentRoleIds, newUsersMap, usernumber, username);
                    }
                    Map<String, List<String>> currentMap = this.getCurrentMap();
                    List<String> userIdsNewTemp = currentMap.get(modelId);
                    oldRoleIds.removeAll(userIdsNewTemp);
                    if (oldRoleIds.size() <= 0) continue;
                    this.setDelLogs(logs, modelID, oldRoleIds, mapOldRole, usernumber, username);
                    continue;
                }
                this.setNewAddLogs(logs, modelID, currentRoleIds, newUsersMap, usernumber, username);
            }
        }
        oldModelIds.removeAll(currentModelIds);
        if (oldModelIds.size() > 0) {
            for (String oldModel : oldModelIds) {
                List roleIds = (List)mapOld.get(oldModel);
                this.setDelLogs(logs, Long.parseLong(oldModel), roleIds, mapOldRole, usernumber, username);
            }
        }
        if (!logs.isEmpty() && this.getPageCache().get(isHavNotTrue) == null) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.getPageCache().remove(isHavNotTrue);
    }

    private void setNewAddLogs(ArrayList<DynamicObject> logs, Long modelId, List<String> currentRoleIds, HashMap<String, DynamicObject> newUsersMap, String usernumber, String username) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String roleId : currentRoleIds) {
            DynamicObject role = newUsersMap.get(roleId);
            String role_number = role.getString(NUMBER);
            String role_name = role.getString(NAME);
            String memgerInfo = this.memgerRoleInfo(role_number, role_name);
            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelId, (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
            logs.add(log1);
        }
    }

    private void setDelLogs(ArrayList<DynamicObject> logs, Long modelId, List<String> oldRoleIds, HashMap<String, Map<String, String>> mapOldRole, String usernumber, String username) {
        String appId = this.getView().getFormShowParameter().getAppId();
        for (String roleId : oldRoleIds) {
            LinkedHashMap userItems = (LinkedHashMap)mapOldRole.get(roleId);
            String role_number = (String)userItems.get(NUMBER);
            String role_name = (String)userItems.get(NAME);
            String memgerInfo = this.memgerRoleInfo(role_number, role_name);
            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)modelId, (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
            logs.add(log1);
        }
    }

    private String memgerRoleInfo(String role_number, String role_name) {
        if (role_name == null || role_number == null) {
            return "";
        }
        return "(" + role_number + "/" + role_name + ")";
    }
}

