/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.formplugin.plugin.UserGroupTreeListPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public abstract class CommonUserGroupTreeListPlugin
extends UserGroupTreeListPlugin {
    protected static final String USER_LIST = "billlistap";
    private static final String BARITEM_CLEARPERM = "btn_clearperm";
    private static final String CONFIRMCALLBACK_DELUSERGROUP = "confirmCallBack_deleteUserGroup";
    private static final String CONFIRMCALLBACK_CLEARPERM = "confirmCallBack_clearPerm";
    private static final String CONFIRM_CLEAR = "confirm_clearPerm_one";
    protected static final String BTN_CLEARCACHE = "btn_clearcache";
    private static final String TBL_SUB_DISABLE = "tblsubdisable";
    private static final String TBL_SUB_ENABLE = "tblsubenable";
    private static final String BTN_DIRECT_DIS_FUN = "btn_directdisfun";
    protected static final String BTN_COPYPERM = "btn_copyperm";
    private static final String BTN_ASSIGN_BIZROLE = "btn_assign_bizrole";
    private static final String BTN_CLEARPERM = "btn_clearperm";
    private static final String BTN_USER_MANAGE = "usermanage";
    private static final String TBLSUBDISABLE = "tblsubdisable";
    private static final String TBLSUBSCRIBERENABLE = "tblsubscriberenable";
    private static final String BTN_UNLOCK = "btn_unlock";
    private static final String BTN_RESETPWD = "btn_resetpwd";
    private static final String BTN_PWDSTRATEGY = "btn_pwdstrategy";
    protected static final String BTN_USRGRPASSIGNUSER = "btn_usrgrpassignuser";
    protected static final String BTN_USERASSIGNUSRGRP = "btn_userassignusrgrp";
    private static final Log logger = LogFactory.getLog(UserGroupTreeListPlugin.class);

    public void afterBindData(EventObject e) {
        String appId;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tblsubdisable", TBL_SUB_ENABLE, BTN_DIRECT_DIS_FUN, BTN_ASSIGN_BIZROLE, "btn_clearperm", BTN_USER_MANAGE, "tblsubdisable", TBLSUBSCRIBERENABLE, BTN_UNLOCK, BTN_RESETPWD, BTN_PWDSTRATEGY, BTN_COPYPERM});
        this.getView().setVisible(Boolean.valueOf(!ConfigServiceHelper.getGlobalBoolParam((String)"isPHideUserGroupButton")), new String[]{BTN_USERASSIGNUSRGRP, BTN_USRGRPASSIGNUSER});
        String string = appId = this.getView().getFormShowParameter().getAppId() == null ? "" : this.getView().getFormShowParameter().getAppId();
        if (ApplicationTypeEnum.DI.appnum.equalsIgnoreCase(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_USRGRPASSIGNUSER, BTN_USERASSIGNUSRGRP, BTN_ASSIGN_BIZROLE, "btn_allocprem"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!BTN_COPYPERM.equals(itemKey)) {
            super.beforeItemClick(evt);
        } else {
            BillList billList = (BillList)this.getView().getControl(USER_LIST);
            ListSelectedRowCollection listSelectRows = billList.getSelectedRows();
            if (listSelectRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"BcmUserGroupTreeListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (listSelectRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7528\u6237\u3002", (String)"BcmUserGroupTreeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(USER_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if ("btn_clearperm".equalsIgnoreCase(itemkey.toLowerCase(Locale.ENGLISH))) {
            if (rows == null || rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BcmUserGroupTreeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                return;
            }
            if (rows.size() > 1) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u6e05\u9664\u591a\u4e2a\u7528\u6237\u7684\u6570\u636e\u6743\u9650\u5417\uff1f", (String)"BcmUserGroupTreeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CLEAR));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237\u6743\u9650\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u590d\u539f\uff0c\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"BcmUserGroupTreeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CLEARPERM));
            return;
        }
        super.itemClick(evt);
    }

    protected void showForm(ListSelectedRowCollection rows, String formId, ShowType showType) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        if (rows != null && rows.size() > 0) {
            String userId = String.valueOf(rows.get(0).getPrimaryKeyValue());
            params.put("paramUserId", userId);
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            params.putAll(originalCustParams);
            if (originalCustParams.get("FormShowParam_dimension") == null) {
                params.put("FormShowParam_dimension", "DIM_ORG");
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParams(params);
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(showType);
        this.getView().showForm(fsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        switch (callBackId = event.getCallBackId()) {
            case "confirm_clearPerm_one": {
                if (event.getResult() != MessageBoxResult.Yes) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237\u6743\u9650\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u590d\u539f\uff0c\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"BcmUserGroupTreeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CLEARPERM));
                break;
            }
            case "confirmCallBack_deleteUserGroup": {
                super.confirmCallBack(event);
                break;
            }
            case "confirmCallBack_clearPerm": {
                if (event.getResult() != MessageBoxResult.Yes) break;
                BillList billList = (BillList)this.getControl(USER_LIST);
                if (billList == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BcmUserGroupTreeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BcmUserGroupTreeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> userIDs = new ArrayList<Long>(1);
                for (ListSelectedRow selectedRow : selectedRows) {
                    userIDs.add(Long.valueOf(selectedRow.toString()));
                }
                String name = selectedRows.get(0).getName();
                Long userId = Long.valueOf(selectedRows.get(0).toString());
                StringBuilder errorInfo = new StringBuilder();
                Map<Long, Set<Long>> modelIdInfo = this.getUseModelIds(userIDs, "DIM_BCM_MODEL", "bcm_model");
                boolean isSuccess = this.deleteAppUserPermission(userIDs, errorInfo);
                OperationLogUtil.writeOperationLog((String)this.getClearPermOpName(), (String)this.getClearPermDesc(isSuccess), null, (String)"bcm_usergroupuser");
                if (isSuccess) {
                    this.deleteAdminRecord(userIDs);
                    this.saveLog(modelIdInfo, selectedRows);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"BcmUserGroupTreeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    PermFormCommonUtil.addLog((String)this.getClearPermOpName(), (String)String.format(ResManager.loadKDString((String)"\u6210\u529f\u6e05\u9664\u7528\u6237\u201c%1$s\u201d(id\u4e3a\u201c%2$s\u201d)\u6240\u6709\u7684\u6743\u9650\u914d\u7f6e\u3002", (String)"BcmUserGroupTreeListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name, userId), (String)"perm_userperm");
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"BcmUserGroupTreeListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                logger.error("\u6e05\u9664\u7f13\u5b58\u6267\u884c\u5931\u8d25\uff1a" + errorInfo);
                PermFormCommonUtil.addLog((String)ResManager.loadKDString((String)"\u6e05\u9664\u6743\u9650", (String)"BcmUserGroupTreeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237%1$s(id=%2$s)\u6240\u6709\u6743\u9650\u914d\u7f6e\u5931\u8d25\u3002", (String)"BcmUserGroupTreeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name, userId), (String)"perm_userperm");
                break;
            }
        }
    }

    protected QFilter[] getDeleteAdminRecordFilter(List<Long> userIds) {
        return null;
    }

    protected void deleteAdminRecord(List<Long> userIds) {
        DynamicObject[] load;
        QFilter[] qf = this.getDeleteAdminRecordFilter(userIds);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bcm_modelperm", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_modelperm").getAllFields().keySet()), (QFilter[])qf)) {
            DynamicObjectCollection permEntrys = dynamicObject.getDynamicObjectCollection("modelpermentry");
            if (CollectionUtils.isEmpty((Collection)permEntrys)) continue;
            StringBuilder userName = new StringBuilder();
            Iterator iterator = permEntrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject e = (DynamicObject)iterator.next();
                DynamicObject user = e.getDynamicObject("eusers");
                if (userIds.contains(user.getLong("id"))) {
                    iterator.remove();
                    continue;
                }
                userName.append(user.getString("name")).append('\u3001');
            }
            if (userName.length() > 0) {
                userName.replace(userName.length() - 1, userName.length(), "");
            }
            if (userName.toString().length() > 50) {
                dynamicObject.set("username", (Object)(userName.substring(0, 45) + "..."));
                continue;
            }
            dynamicObject.set("username", (Object)userName.toString());
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    private String getClearPermOpName() {
        return ResManager.loadKDString((String)"\u6e05\u9664\u6743\u9650", (String)"BcmUserGroupTreeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getClearPermDesc(boolean success) {
        if (success) {
            return ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f", (String)"BcmUserGroupTreeListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6e05\u9664\u5931\u8d25", (String)"BcmUserGroupTreeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected void saveLog(Map<Long, Set<Long>> modelIdInfo, ListSelectedRowCollection selectedRows) {
    }

    protected void addLog(ListSelectedRowCollection selectedRows, Map<Long, Set<Long>> modelIdInfo) {
        String bizappId = this.getView().getFormShowParameter().getAppId();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            String userName = selectedRow.getName();
            String userNumber = selectedRow.getNumber();
            Long uId = Long.valueOf(selectedRow.toString());
            Set<Long> modelids = modelIdInfo.get(uId);
            if (modelids == null) continue;
            for (Long modelid : modelids) {
                logs.add(FunctionPermLogHelper.newFunctionPermLog((Long)modelid, (String)userNumber, (String)userName, (String)"", (String)"", (String)"", (String)ResManager.loadKDString((String)"\u6e05\u9664\u6743\u9650", (String)"BcmUserGroupTreeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)bizappId));
            }
        }
        try {
            FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getName() + ":\u529f\u80fd\u6743\u9650\u65e5\u5fd7\u65e5\u6dfb\u52a0\u5931\u8d25");
        }
    }

    protected abstract List<String> getDimType();

    public boolean deleteAppUserPermission(List<Long> ids, StringBuilder errorInfo) {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        if (errorInfo == null) {
            errorInfo = new StringBuilder();
        }
        logger.info("deleteUserPermission -- userID : " + ids);
        boolean result = true;
        QFilter userFilter = new QFilter("user", "in", ids);
        try (TXHandle h = TX.required();){
            try {
                QFilter dimTypeFilter = new QFilter("dimtype", "in", this.getDimType());
                DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])new QFilter[]{userFilter, dimTypeFilter});
                DeleteServiceHelper.delete((String)"perm_userrole", (QFilter[])new QFilter[]{userFilter, dimTypeFilter});
                DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{userFilter});
                DeleteServiceHelper.delete((String)"perm_disfunperm", (QFilter[])new QFilter[]{userFilter, dimTypeFilter});
                DeleteServiceHelper.delete((String)"perm_userfieldperm", (QFilter[])new QFilter[]{userFilter, dimTypeFilter});
                DeleteServiceHelper.delete((String)"perm_userdataperm", (QFilter[])new QFilter[]{userFilter, dimTypeFilter});
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u5220\u9664\u6307\u5b9a\u7528\u6237\u6743\u9650\u5f02\u5e38", (Throwable)e);
                result = false;
                errorInfo.append(e.getMessage());
            }
        }
        this.clearAllPermissionCache();
        return result;
    }

    private void clearAllPermissionCache() {
        try {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            CacheMrg.clearAllLocalCache();
        }
        catch (Exception e) {
            logger.error("PermissionServiceImpl-clearAllCache-\u6e05\u7406\u6743\u9650\u7f13\u5b58\u51fa\u9519: " + e.getMessage());
        }
    }

    protected Map<Long, Set<Long>> getUseModelIds(Collection<Long> userIds, String dimType, String entityName) {
        DynamicObjectCollection permDisfunPerm;
        DynamicObjectCollection permUserRole;
        HashMap<Long, Set<Long>> modelInfo = new HashMap<Long, Set<Long>>(16);
        String selectField = "org,user";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("user", "in", userIds));
        qfBuilder.add(new QFilter("dimtype", "=", (Object)dimType));
        QFBuilder qfBuilderForRole = new QFBuilder();
        qfBuilderForRole.add(new QFilter("user", "in", userIds));
        qfBuilderForRole.add(new QFilter("dimtype", "=", (Object)entityName));
        DynamicObjectCollection modelIds = new DynamicObjectCollection();
        DynamicObjectCollection permUserPerm = QueryServiceHelper.query((String)"perm_userperm", (String)selectField, (QFilter[])qfBuilder.toArray());
        if (permUserPerm != null) {
            modelIds.addAll((Collection)permUserPerm);
        }
        if ((permUserRole = QueryServiceHelper.query((String)"perm_userrole", (String)selectField, (QFilter[])qfBuilderForRole.toArray())) != null) {
            modelIds.addAll((Collection)permUserRole);
        }
        if ((permDisfunPerm = QueryServiceHelper.query((String)"perm_disfunperm", (String)selectField, (QFilter[])qfBuilderForRole.toArray())) != null) {
            modelIds.addAll((Collection)QueryServiceHelper.query((String)"perm_disfunperm", (String)selectField, (QFilter[])qfBuilderForRole.toArray()));
        }
        for (DynamicObject model : modelIds) {
            Set<Long> modelList;
            Long userId = model.getLong("user");
            Long modelId = model.getLong("org");
            if (userId == null || userId == 0L || modelId == null || modelId == 0L) continue;
            if (modelInfo.get(userId) == null) {
                modelList = new HashSet(16);
                modelList.add(modelId);
                modelInfo.put(userId, modelList);
                continue;
            }
            modelList = (Set)modelInfo.get(userId);
            modelList.add(modelId);
        }
        return modelInfo;
    }
}

