/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;

public class MemberPermDetailPlugin
extends AbstractFormPlugin {
    private Set<Long> allMemIds = new HashSet<Long>();
    private Map<Long, String> allUserMap = new HashMap<Long, String>();
    private Map<Long, String> allMemMap = new HashMap<Long, String>();
    private List<Long> userOrder = new ArrayList<Long>();
    private List<Long> memberOrder = new ArrayList<Long>();
    private Map<Long, String> allNumberMap = new HashMap<Long, String>();
    private Map<Long, Map<Long, Integer>> userMemMap = new HashMap<Long, Map<Long, Integer>>();
    private Map<Long, Map<Long, Integer>> memUserMap = new HashMap<Long, Map<Long, Integer>>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object[] disPks = (Object[])SerializationUtils.fromJsonString((String)((String)params.get("ids")), Object[].class);
        String modelid = (String)params.get("modelid");
        String memberType = (String)params.get("membertype");
        this.buildAllDictionary(memberType, disPks, modelid);
        this.buildMemberDictionary(memberType);
        this.setUserOrderBys();
        this.setData2MemberEntry(this.userOrder, this.memberOrder, this.userMemMap, this.allUserMap, this.allMemMap, this.allNumberMap, "userentry", "user1", "member1", "permission1", "number1");
        this.setData2MemberEntry(this.memberOrder, this.userOrder, this.memUserMap, this.allMemMap, this.allUserMap, this.allNumberMap, "memberentry", "member2", "user2", "permission2", "number2");
        this.setEntityVisibleByCombo();
    }

    private List<Long> setUserOrderBys() {
        String selectFields = "id";
        QFilter filter = new QFilter("id", "in", this.allUserMap.keySet());
        String orderBys = "number";
        ArrayList<Long> ids = new ArrayList<Long>();
        QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBys).forEach(p -> this.userOrder.add(p.getLong("id")));
        return ids;
    }

    private void buildAllDictionary(String memberType, Object[] pks, String modelid) {
        Set memIds = new HashSet();
        for (DynamicObject perm : this.querCollectionByParams("bcm_memberperm", pks)) {
            long memberId = perm.getLong("member");
            int range = perm.getInt("range");
            Integer permValue = perm.getInt("permission");
            boolean iscustomprop = perm.getBoolean("iscustomprop");
            memIds = !iscustomprop ? ("bcm_structofextend".equals(this.getView().getFormShowParameter().getCustomParam("membertype")) ? QueryMemberDetailsHelper.queryMemberIdsByRangeOfExt((String)memberType, (Long)memberId, (int)range, (String)modelid, (DetailTypeEnum)DetailTypeEnum.MEMBERPERM) : QueryMemberDetailsHelper.queryMemberIdsByRange((String)memberType, (Long)memberId, (int)range, (String)modelid, (DetailTypeEnum)DetailTypeEnum.MEMBERPERM)) : QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)memberType, (Long)memberId, (int)range, (String)modelid, (DetailTypeEnum)DetailTypeEnum.MEMBERPERM);
            memIds = MemberReader.change2BaseMember((String)((String)this.getView().getFormShowParameter().getCustomParam("membertype")), memIds);
            this.allMemIds.addAll(memIds);
            if ("bos_usergroup".equals(perm.getString("usertype"))) {
                DynamicObjectCollection userDoc = UserDistributeServiceHelper.queryAllUsersByGroupId((Object)perm.getLong("users"));
                for (DynamicObject user : userDoc) {
                    this.setMember2Map(user.getLong("user"), user.getString("name"), user.getString("number"), permValue, memIds);
                }
            } else {
                this.setMember2Map(perm.getLong("users"), perm.getString("username"), perm.getString("users.number"), permValue, memIds);
            }
            memIds.clear();
        }
    }

    private void buildMemberDictionary(String entityName) {
        String selectFields = "id,name,storagetype";
        QFilter filter = new QFilter("id", "in", this.allMemIds);
        String orderBys = "level,dseq";
        QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBys).forEach(p -> {
            if ("3".equals(p.getString("storagetype"))) {
                long baseId = QueryMemberDetailsHelper.getBaseMemberId((Long)p.getLong("id"), (String)entityName);
                if (this.allMemMap.put(baseId, p.getString("name")) == null) {
                    this.memberOrder.add(baseId);
                }
            } else if (this.allMemMap.put(p.getLong("id"), p.getString("name")) == null) {
                this.memberOrder.add(p.getLong("id"));
            }
        });
    }

    private void setData2MemberEntry(List<Long> headOrder, List<Long> bodyOrder, Map<Long, Map<Long, Integer>> entryData, Map<Long, String> Dictionary1, Map<Long, String> Dictionary2, Map<Long, String> Dictionary3, String entryKey, String param1, String param2, String param3, String param4) {
        ArrayList dataList = new ArrayList();
        for (Long id1 : headOrder) {
            Map<Long, Integer> bodyMap = entryData.getOrDefault(id1, Collections.EMPTY_MAP);
            for (Long id2 : bodyOrder) {
                if (bodyMap.get(id2) == null) continue;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put(param1, Dictionary1.get(id1));
                dataMap.put(param2, Dictionary2.get(id2));
                dataMap.put(param3, bodyMap.get(id2));
                dataMap.put(param4, Dictionary3.get("userentry".equalsIgnoreCase(entryKey) ? id1 : id2));
                dataList.add(dataMap);
            }
        }
        if (dataList.size() < 1) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(entryKey, dataList.size());
        int index = 0;
        for (Map map : dataList) {
            this.getModel().setValue(param1, map.get(param1), rows[index]);
            this.getModel().setValue(param2, map.get(param2), rows[index]);
            this.getModel().setValue(param3, map.get(param3), rows[index]);
            this.getModel().setValue(param4, map.get(param4), rows[index++]);
        }
    }

    private void setMember2Map(long userId, String userName, String userNumber, Integer permValue, Set<Long> memIds) {
        HashMap<Long, Integer> memMap = new HashMap<Long, Integer>(16);
        for (Long mid : memIds) {
            memMap.put(mid, permValue);
            Map<Long, Integer> resultUserMap = this.memUserMap.get(mid);
            if (resultUserMap != null) {
                Integer oldPermValue = resultUserMap.get(userId);
                resultUserMap.put(userId, oldPermValue == null ? permValue : (oldPermValue > permValue ? oldPermValue : permValue));
                this.memUserMap.put(mid, resultUserMap);
                continue;
            }
            HashMap<Long, Integer> userMap = new HashMap<Long, Integer>();
            userMap.put(userId, permValue);
            this.memUserMap.put(mid, userMap);
        }
        Map resultMemMap = this.userMemMap.put(userId, memMap);
        if (resultMemMap != null) {
            for (Map.Entry entry : memMap.entrySet()) {
                Long mid = (Long)entry.getKey();
                Integer oldPermValue = (Integer)resultMemMap.get(mid);
                if (oldPermValue == null) continue;
                Integer newPermValue = (Integer)entry.getValue();
                memMap.put(mid, newPermValue > oldPermValue ? newPermValue : oldPermValue);
            }
            resultMemMap.putAll(memMap);
            this.userMemMap.put(userId, resultMemMap);
        }
        this.allUserMap.put(userId, userName);
        this.allNumberMap.put(userId, userNumber);
    }

    private DynamicObjectCollection querCollectionByParams(String entityName, Object[] ids) {
        String selectFields = "usertype,users,users.number,users.name as username,membername,member,iscustomprop,range,permission";
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.setEntityVisibleByCombo();
            }
        }
    }

    private void setEntityVisibleByCombo() {
        String value = String.valueOf(this.getModel().getValue("viewcombo"));
        if ("1".equals(value)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"memberentry"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"userentry"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"userentry"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"memberentry"});
        }
    }
}

