/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.perm.AbstractMemberPermEditPlugin;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.formplugin.util.GrantPermUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.BooleanUtils;

public class MemberPermEditPlugin
extends AbstractMemberPermEditPlugin
implements BeforeF7SelectListener {
    public static final String USERENTRY_ID = "userentry";
    public static final String MEMBERENTRY_ID = "memberentry";
    public static final String DIMENSIONCOMBO_ID = "dimensioncombo";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String DIMENSION = "dimension";
    private static final String MEMBER_TYPE = "membertype";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String EUSERS = "eusers";

    @Override
    public void initialize() {
        super.initialize();
        this.billListSort();
    }

    private void billListSort() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)MemberPermEditPlugin.this.getModel().getValue("viewcombo");
                if (viewid != null && !viewid.startsWith(((IListColumn)listCol.get(0)).getListFieldKey().substring(0, 3))) {
                    Collections.swap(listCol, 0, 2);
                    Collections.swap(listCol, 1, 3);
                }
            }
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"report"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    private void addListener() {
        this.addClickListeners("selectmember", "deldistribute", "details", "delmember");
        this.addItemClickListeners("advcontoolbarap", "toolbarap");
        BasedataEdit user = (BasedataEdit)this.getControl("baseuser");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl("baseusergroup");
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid usereg = (EntryGrid)this.getControl(USERENTRY_ID);
        usereg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                MemberPermEditPlugin.this.refreshBillList();
            }
        });
        EntryGrid memeg = (EntryGrid)this.getControl(MEMBERENTRY_ID);
        memeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                MemberPermEditPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)MemberPermEditPlugin.this.getModel().getValue("viewcombo");
                if (viewid != null && !viewid.startsWith(((IListColumn)listCol.get(0)).getListFieldKey().substring(0, 3))) {
                    Collections.swap(listCol, 0, 2);
                    Collections.swap(listCol, 1, 3);
                }
            }
        });
        billList.addSetFilterListener(event -> this.addFilters(event));
    }

    private void addFilters(SetFilterEvent event) {
        List<DynamicObject> memberList;
        Set memberIds;
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        List<DynamicObject> userList = this.getEntrySelectedAndResultList(USERENTRY_ID);
        Set ids = userList.stream().filter(x -> Objects.nonNull(x.getDynamicObject(EUSERS)) && !Objects.equals(x.getDynamicObject(EUSERS).getPkValue(), 0L)).map(x -> (Long)x.getDynamicObject(EUSERS).getPkValue()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(ids)) {
            qf.and(new QFilter("users", "in", ids));
        }
        if (!CollectionUtils.isEmpty(memberIds = (memberList = this.getEntrySelectedAndResultList(MEMBERENTRY_ID)).stream().map(x -> x.getLong("mid")).collect(Collectors.toSet()))) {
            qf.and(new QFilter("member", "in", memberIds));
        }
        event.addCustomQFilter(qf);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Set set = MemberPermHelper.getLimitedCompleteIsolationModelListByUser((ApplicationTypeEnum)this.getApplicationType());
        HashSet<Long> setCopy = new HashSet<Long>(set.size());
        for (Long modelid : set) {
            setCopy.add(modelid);
        }
        if ((modelId == null || modelId.equals("0")) && set.size() > 0) {
            Set funcAuthModel;
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
            if (Objects.isNull(modelId)) {
                modelId = "0";
            }
            Long modelID = Long.parseLong(modelId);
            Boolean isGrant = BooleanUtils.toBoolean((Boolean)ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm"));
            Set set2 = funcAuthModel = isGrant != false ? BcmFunPermissionHelper.getFuncAuthModel((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(this.getView()), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)Boolean.FALSE, (boolean)Boolean.TRUE) : Collections.EMPTY_SET;
            if (!(isGrant.booleanValue() && !StringUtils.isEmpty((CharSequence)modelId) && !CollectionUtils.isEmpty((Collection)funcAuthModel) && funcAuthModel.contains(LongUtil.toLong((Object)modelId)) || setCopy.contains(modelID))) {
                modelId = String.valueOf(setCopy.iterator().next());
            }
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        this.getModel().setValue("model", (Object)modelId);
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            this.getPageCache().put("ischange", "true");
            this.setDimensionCombo();
            this.setDimMemberFilter();
        } else {
            BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
            FilterParameter filterParameter = new FilterParameter();
            QFilter filter1 = new QFilter("1", "!=", (Object)1);
            filterParameter.setFilter(filter1);
            billlist.setFilterParameter(filterParameter);
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "MemberPermEditPlugin_0", FI_BCM_FORMPLUGIN, "view"), new OPDescMultiLangEnumBridge("\u67e5\u770b\u6210\u529f", "MemberPermEditPlugin_1", FI_BCM_FORMPLUGIN, null));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if (!"baseuser".equals(evt.getProperty().getName()) && !"baseusergroup".equals(evt.getProperty().getName())) {
            super.beforeF7Select(evt);
        }
        if ("baseuser".equals(evt.getProperty().getName()) || "baseusergroup".equals(evt.getProperty().getName())) {
            CloseCallBack aa = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
            evt.getFormShowParameter().setCloseCallBack(aa);
            evt.getFormShowParameter().setHasRight(true);
            evt.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (this.getModel().getValue("model") != null) {
            switch (key) {
                case "selectmember": {
                    this.showMulMemberF7View();
                    break;
                }
                case "delmember": {
                    this.deleteEntryRow(MEMBERENTRY_ID);
                    break;
                }
                case "deldistribute": {
                    BillList billList = (BillList)this.getControl(BILL_LIST_AP);
                    Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
                    if (ids.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MemberPermEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        break;
                    }
                    Collection dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bcm_memberperm", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}).values();
                    ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(dynamicObjects.size());
                    if (!this.checkGrantPerm(ids)) {
                        this.getView().showTipNotification(MemberPermEditPlugin.getNoGrantTip());
                        return;
                    }
                    String bizAppId = this.getBizAppId();
                    try {
                        HashSet deleteCacheKeys = Sets.newHashSetWithExpectedSize((int)16);
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            DynamicObject permLog = DataPermLogHelper.newMemberPermLog((DynamicObject)dynamicObject, (String)DataPermLogMultiLangEnum.MemberPerm_DelDistribute.getOperateName(), (String)bizAppId);
                            deleteCacheKeys.add("bcm_memberperm_" + dynamicObject.getString("dimension.id"));
                            logs.add(permLog);
                        }
                        BusinessDataServiceHelper.delete((IDataEntityType)billList.getEntityType(), (Object[])ids);
                        MemberPermHelper.clearPermCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (Set)deleteCacheKeys);
                        if (logs.size() > 0) {
                            DataPermLogHelper.batchInsertDataPermLog(logs);
                        }
                        this.delDistributeLog(ids.length);
                    }
                    catch (KDException e) {
                        log.error((Throwable)e);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"MemberPermEditPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    this.refreshBillList();
                    break;
                }
                case "details": {
                    this.showDetailsView();
                    break;
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"MemberPermEditPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private boolean checkGrantPerm(Object[] ids) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_memberperm", (String)"member,range,membertype,iscustomprop,dimension", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        for (DynamicObject dy : dys) {
            if (GrantPermUtil.hasGrantPerm(modelId, dy.getLong(DIMENSION), dy.getLong("member"), RangeEnum.getRangeByVal((int)dy.getInt("range")), dy.getBoolean("iscustomprop"))) continue;
            return false;
        }
        return true;
    }

    private void delDistributeLog(int delRowsNums) {
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "anti distribution"), new OPDescMultiLangEnumBridge("%s\u6761\u8bb0\u5f55\u53cd\u5206\u914d\u6210\u529f\u3002", "MemberPermEditPlugin_14", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.valueOf(delRowsNums)})));
    }

    private void showDetailsView() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_memberpermdetail_view");
        param.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u5206\u914d\u8be6\u60c5", (String)"MemberPermEditPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        Object[] ids = billlist.getSelectedRows().getPrimaryKeyValues();
        if (ids.length < 1) {
            ids = billlist.getCurrentListAllRowCollection().getPrimaryKeyValues();
        }
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam(MEMBER_TYPE, (Object)this.getPageCache().get(MEMBER_TYPE));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_user");
                break;
            }
            case "baseusergroup": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_usergroup");
                break;
            }
            case "selectmember": {
                this.setData2MemberEntry(evt.getReturnData());
                break;
            }
            case "importdataback": {
                this.refreshBillList();
            }
        }
    }

    private void delRepeatDataAndWrite(DynamicObjectCollection newdoc, DynamicObjectCollection olddoc, int param1, String param2) {
        EntryGrid eg = (EntryGrid)this.getControl(MEMBERENTRY_ID);
        int[] rows = eg.getSelectRows();
        HashSet<Integer> listRows = new HashSet<Integer>();
        String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
        String[] dimData = this.getDimDataByValue(dimValue);
        if (dimData != null && dimData.length >= 5) {
            String dimId = dimData[4];
            int dvalue = MemberPermHelper.getDefaultPermValue((long)Long.parseLong(dimId));
            int permValue = dvalue == PermEnum.NOPERM.getValue() ? PermEnum.READWRITE.getValue() : PermEnum.NOPERM.getValue();
            for (DynamicObject newd : newdoc) {
                boolean flag = true;
                for (DynamicObject oldd : olddoc) {
                    if (!newd.getString(param1).equals(oldd.getString(param2)) || newd.getInt(5) != oldd.getInt("range")) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                int rowIndex = this.getModel().createNewEntryRow(MEMBERENTRY_ID);
                this.getModel().setValue("number", newd.get(2), rowIndex);
                this.getModel().setValue("member", newd.get(3), rowIndex);
                this.getModel().setValue("range", newd.get(5), rowIndex);
                this.getModel().setValue("mid", newd.get(4), rowIndex);
                this.getModel().setValue("proid", newd.get(6), rowIndex);
                this.getModel().setValue("permission", (Object)permValue, rowIndex);
                listRows.add(rowIndex);
            }
            this.setDefaultSelectRows(eg, listRows, rows);
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_memberperm";
    }

    private void distributeMember() {
        List<DynamicObject> dlist;
        block15: {
            List<DynamicObject> userList = this.getEntrySelectedAndResultList(USERENTRY_ID);
            List<DynamicObject> memberList = this.getEntrySelectedAndResultList(MEMBERENTRY_ID);
            if (userList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7528\u6237\u7ec4/\u7528\u6237\u3002", (String)"MemberPermEditPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (memberList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6210\u5458\u3002", (String)"MemberPermEditPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!this.checkGrantPerm(memberList)) {
                this.getView().showTipNotification(MemberPermEditPlugin.getNoGrantTip());
                return;
            }
            dlist = this.getMergeData(userList, memberList);
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            String selectFields = "member,users,range,permission";
            QFilter filter = new QFilter(MEMBER_TYPE, "=", (Object)this.getPageCache().get(MEMBER_TYPE));
            DynamicObjectCollection oldoc = QueryServiceHelper.query((String)billList.getEntityId(), (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<DynamicObject> repeatList = new ArrayList<DynamicObject>();
            block2: for (DynamicObject newd : dlist) {
                for (Object oldd : oldoc) {
                    if (!oldd.getString("member").equals(newd.getString("member")) || !oldd.getString("users").equals(newd.getString("users")) || !oldd.getString("range").equals(newd.getString("range")) || !oldd.getString("permission").equals(newd.getString("permission"))) continue;
                    repeatList.add(newd);
                    continue block2;
                }
            }
            dlist.removeAll(repeatList);
            if (dlist.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u6743\u9650\u5df2\u5206\u914d\u5b8c\u6210\u3002", (String)"MemberPermEditPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            try {
                DynamicObjectCollection query;
                SaveServiceHelper.save((DynamicObject[])dlist.toArray(new DynamicObject[dlist.size()]));
                Long dimid = dlist.get(0).getLong(DIMENSION);
                MemberPermHelper.clearPermCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (Set)Sets.newHashSet((Object[])new String[]{"bcm_memberperm_" + dimid}));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\u3002", (String)"MemberPermEditPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                HashMap<Long, String> users = new HashMap<Long, String>(userList.size());
                HashMap<Long, DynamicObject> members = new HashMap<Long, DynamicObject>(memberList.size());
                for (DynamicObject user : userList) {
                    users.put(user.getLong("eusers.id"), user.getString("eusers.number"));
                }
                for (DynamicObject member : memberList) {
                    members.put(member.getLong("mid"), member);
                }
                ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(dlist.size());
                if (dlist.size() <= 0) break block15;
                if (!"bcm_structofextend".equals(dlist.get(0).get(MEMBER_TYPE))) {
                    query = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimid)});
                    String number = ((DynamicObject)query.get(0)).getString("number");
                    String bizAppId = this.getBizAppId();
                    for (DynamicObject d : dlist) {
                        DynamicObject appenddy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datapermlog");
                        appenddy.set("dimensionnumber", (Object)number);
                        appenddy.set("membernumber", (Object)((DynamicObject)members.get(d.getLong("member"))).getString("number"));
                        appenddy.set("membername", (Object)((DynamicObject)members.get(d.getLong("member"))).getString("member"));
                        appenddy.set("usernumber", users.get(d.getLong("users")));
                        appenddy.set("username", (Object)d.getLocaleString("username"));
                        DynamicObject log = DataPermLogHelper.newMemberPermLog((DynamicObject)d, (DynamicObject)appenddy, (String)DataPermLogMultiLangEnum.MemberPerm_Distribute.getOperateName(), (String)bizAppId);
                        logs.add(log);
                    }
                } else {
                    query = QueryServiceHelper.query((String)"bcm_dimension_ext", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimid)});
                    String number = ((DynamicObject)query.get(0)).getString("number");
                    String bizAppId = this.getBizAppId();
                    for (DynamicObject d : dlist) {
                        DynamicObject appenddy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datapermlog");
                        appenddy.set("dimensionnumber", (Object)number);
                        appenddy.set("membernumber", (Object)((DynamicObject)members.get(d.getLong("member"))).getString("number"));
                        appenddy.set("membername", (Object)((DynamicObject)members.get(d.getLong("member"))).getString("member"));
                        appenddy.set("usernumber", users.get(dlist.get(0).getLong("users")));
                        appenddy.set("username", (Object)d.getLocaleString("username"));
                        DynamicObject log = DataPermLogHelper.newMemberPermLog((DynamicObject)d, (DynamicObject)appenddy, (String)DataPermLogMultiLangEnum.MemberPerm_Distribute.getOperateName(), (String)bizAppId);
                        logs.add(log);
                    }
                }
                if (logs.size() > 0) {
                    DataPermLogHelper.batchInsertDataPermLog(logs);
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53cd\u5206\u914d", "DistributionPlugin_20", FI_BCM_FORMPLUGIN, "anti distribution"), new OPDescMultiLangEnumBridge("%s\u6761\u8bb0\u5f55\u5206\u914d\u6210\u529f\u3002", "OpItemEnum_184", "fi-bcm-common", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.valueOf(dlist.size())})));
        this.refreshBillList();
    }

    private boolean checkGrantPerm(List<DynamicObject> memberList) {
        String dimValue = this.getPageCache().get("dimvalue");
        String[] dimData = this.getDimDataByValue(dimValue);
        if (Objects.isNull(dimData) || dimData.length < 5) {
            return Boolean.FALSE;
        }
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        Long dimId = LongUtil.toLong((Object)dimData[4]);
        for (DynamicObject dy : memberList) {
            if (GrantPermUtil.hasGrantPerm(modelId, dimId, dy.getLong("mid"), RangeEnum.getRangeByVal((int)dy.getInt("range")), StringUtils.isNotBlank((CharSequence)dy.getString("proid")))) continue;
            return false;
        }
        return true;
    }

    private List<DynamicObject> getMergeData(List<DynamicObject> userList, List<DynamicObject> memberList) {
        String dimValue = this.getPageCache().get("dimvalue");
        String[] dimData = this.getDimDataByValue(dimValue);
        ArrayList<DynamicObject> dlist = new ArrayList<DynamicObject>();
        if (dimData != null && dimData.length >= 5) {
            String baseType = dimData[2];
            String modelid = this.getPageCache().get("KEY_MODEL_ID");
            String dimId = dimData[4];
            for (DynamicObject user : userList) {
                for (DynamicObject member : memberList) {
                    DynamicObject menPerm = BusinessDataServiceHelper.newDynamicObject((String)"bcm_memberperm");
                    menPerm.set("usertype", (Object)user.getString("etype"));
                    menPerm.set("username", (Object)user.getDynamicObject(EUSERS).getLocaleString("name"));
                    menPerm.set("users", user.getDynamicObject(EUSERS).getPkValue());
                    menPerm.set("membername", (Object)member.getString("member"));
                    menPerm.set("range", (Object)member.getString("range"));
                    menPerm.set("permission", (Object)member.getString("permission"));
                    menPerm.set("model", (Object)modelid);
                    menPerm.set(MEMBER_TYPE, (Object)baseType);
                    menPerm.set("member", (Object)member.getString("mid"));
                    menPerm.set(DIMENSION, (Object)dimId);
                    if (StringUtils.isNotEmpty((CharSequence)member.getString("proid").trim())) {
                        menPerm.set("iscustomprop", (Object)1);
                    } else {
                        menPerm.set("iscustomprop", (Object)0);
                    }
                    dlist.add(menPerm);
                }
            }
            MemberPermHelper.clearPermCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (Set)Sets.newHashSet((Object[])new String[]{"bcm_memberperm_" + dimId}));
        }
        return dlist;
    }

    private List<DynamicObject> getEntrySelectedAndResultList(String entityid) {
        int[] rows = this.getEnterySelectRows(entityid);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (dd == null) continue;
            if (Objects.equals(USERENTRY_ID, entityid)) {
                DynamicObject user = dd.getDynamicObject(EUSERS);
                if (!Objects.nonNull(user) || Objects.equals(user.getPkValue(), 0L)) continue;
                list.add(dd);
                continue;
            }
            list.add(dd);
        }
        return list;
    }

    private int[] getEnterySelectRows(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        return eg.getSelectRows();
    }

    private void setDefaultSelectRows(EntryGrid eg, Set<Integer> listRows, int[] rows) {
        for (int row : rows) {
            listRows.add(row);
        }
        if (listRows.size() == 0) {
            return;
        }
        rows = new int[listRows.size()];
        int index = 0;
        for (Integer row : listRows) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void setData2MemberEntry(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        DynamicObjectCollection newdoc = (DynamicObjectCollection)returnData;
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(MEMBERENTRY_ID);
        if (StringUtils.isEmpty((CharSequence)((DynamicObject)newdoc.get(0)).getString(6).trim())) {
            this.replaceOrgidToBaseId(newdoc);
        }
        this.delRepeatDataAndWrite(newdoc, olddoc, 4, "mid");
        this.refreshBillList();
    }

    private void replaceOrgidToBaseId(DynamicObjectCollection doc) {
        ArrayList<String> numbers = new ArrayList<String>();
        for (DynamicObject obj : doc) {
            numbers.add(obj.getString(2));
        }
        String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
        String[] dimData = this.getDimDataByValue(dimValue);
        if (dimData == null) {
            return;
        }
        String dimId = dimData[4];
        QFilter qf = new QFilter(DIMENSION, "=", (Object)Long.valueOf(dimId));
        qf.and(new QFilter("number", "in", numbers));
        qf.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)dimData[2], (String)"id,number", (QFilter[])new QFilter[]{qf});
        HashMap<String, Long> number2id = new HashMap<String, Long>(10);
        for (DynamicObject obj : orgs.values()) {
            number2id.put(obj.getString("number"), obj.getLong("id"));
        }
        for (DynamicObject obj : doc) {
            String number = obj.getString(2);
            if (!number2id.containsKey(number)) continue;
            obj.set(4, number2id.get(number));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl("baseusergroup");
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl("baseuser");
                user.click();
                break;
            }
            case "btn_distribute": {
                this.distributeMember();
                break;
            }
            case "deluser": {
                this.deleteEntryRow(USERENTRY_ID);
                break;
            }
            case "report": {
                this.openReportForm();
                break;
            }
            case "btn_import": {
                if (!LongUtil.isvalidLong((Object)this.getModelId())) {
                    this.getView().showTipNotification(MemberPermEditPlugin.getNoModelTip());
                    break;
                }
                if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
                    this.getView().showTipNotification(MemberPermEditPlugin.getNoPermTip());
                    break;
                }
                this.importMemPerm();
                break;
            }
        }
    }

    private void openReportForm() {
        ReportShowParameter form = new ReportShowParameter();
        form.setFormId("bcm_memberperm_report");
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setParentPageId(this.getView().getPageId());
        form.setCustomParam("model", (Object)this.getModelId());
        this.getView().showForm((FormShowParameter)form);
    }

    private void deleteEntryRow(String entryId) {
        int[] rows = this.getEnterySelectRows(entryId);
        if (rows.length > 0) {
            this.getModel().deleteEntryRows(entryId, rows);
            this.refreshBillList();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MemberPermEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "dimensioncombo": {
                DynamicObjectCollection mems = this.getModel().getEntryEntity(MEMBERENTRY_ID);
                if (mems.size() == 0) {
                    String dimValue = (String)e.getChangeSet()[0].getNewValue();
                    this.getPageCache().put("dimvalue", dimValue);
                    this.setDimMemberFilter();
                    return;
                }
                boolean isChange = Boolean.parseBoolean(this.getPageCache().get("ischange"));
                if (isChange) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ef4\u5ea6\u5c06\u6e05\u7a7a\u5df2\u9009\u6210\u5458\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"MemberPermEditPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("dimchange_comfirm", (IFormPlugin)this));
                }
                this.getPageCache().put("ischange", "true");
                break;
            }
            case "viewcombo": {
                this.refreshBillList();
                break;
            }
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
                if (modelId == null) {
                    this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.modelChange(modelId);
            }
        }
    }

    private void setDimMemberFilter() {
        String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
        this.setBillFilter4DimChange(dimValue);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        billlist.addSetFilterListener(evt -> {
            List filters = evt.getQFilters();
            filters.clear();
            if (LongUtil.isvalidLong((Object)this.getModelId())) {
                QFilter userFilter = this.getUserFilter();
                QFilter memFilter = this.getMemberFilter();
                if (userFilter != null && memFilter != null) {
                    filters.add(userFilter.and(memFilter));
                } else if (userFilter != null) {
                    filters.add(userFilter);
                } else if (memFilter != null) {
                    filters.add(memFilter);
                } else {
                    filters.add(new QFilter("1", "!=", (Object)1));
                }
                String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
                if (dimValue == null) {
                    return;
                }
                String[] dimData = this.getDimDataByValue(dimValue);
                if (dimData != null && dimData.length >= 5) {
                    String dimType = dimData[2];
                    String dimId = dimData[4];
                    this.getPageCache().put(MEMBER_TYPE, dimType);
                    QFilter filter1 = new QFilter(MEMBER_TYPE, "=", (Object)dimType);
                    QFilter filter2 = new QFilter(DIMENSION, "=", (Object)Long.valueOf(dimId));
                    filters.add(filter1.and(filter2));
                }
            } else {
                filters.add(new QFilter("1", "!=", (Object)1));
            }
        });
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getMemberFilter() {
        ArrayList<Object> memberIds = new ArrayList<Object>();
        this.getEntrySelectedAndResultList(MEMBERENTRY_ID).forEach(p -> memberIds.add(p.getString("mid")));
        if (memberIds.size() > 0) {
            List<Long> memberIdsL = this.turnString2Long(memberIds);
            if (memberIdsL.size() > 0) {
                return new QFilter("member", "in", (Object)memberIdsL.toArray());
            }
            return null;
        }
        return null;
    }

    private List<Long> turnString2Long(List<Object> memberIds) {
        ArrayList<Long> memberIdsL = new ArrayList<Long>(0);
        for (Object id : memberIds) {
            if (StringUtil.isEmptyString((String)((String)id))) continue;
            memberIdsL.add(Long.valueOf((String)id));
        }
        return memberIdsL;
    }

    private QFilter getUserFilter() {
        ArrayList userIds = new ArrayList();
        this.getEntrySelectedAndResultList(USERENTRY_ID).forEach(p -> {
            DynamicObject eusers = p.getDynamicObject(EUSERS);
            if (Objects.nonNull(eusers) && !Objects.equals(eusers.getPkValue(), 0L)) {
                userIds.add(eusers.getPkValue());
            }
        });
        QFilter filter = null;
        if (userIds.size() > 0) {
            filter = new QFilter("users", "in", (Object)userIds.toArray());
        }
        return filter;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("dimchange_comfirm".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
                this.getPageCache().put("dimvalue", dimValue);
                this.getModel().deleteEntryData(MEMBERENTRY_ID);
                this.setBillFilter4DimChange(dimValue);
            } else {
                this.getPageCache().get("dimvalue");
                this.getPageCache().put("ischange", "false");
                this.getModel().setValue(DIMENSIONCOMBO_ID, (Object)this.getPageCache().get("dimvalue"));
            }
        }
    }

    private void setBillFilter4DimChange(String dimValue) {
        BillList billlist = (BillList)this.getControl(BILL_LIST_AP);
        FilterParameter filterParameter = new FilterParameter();
        String[] dimData = this.getDimDataByValue(dimValue);
        if (dimData != null && dimData.length >= 5) {
            String dimType = dimData[2];
            String dimId = dimData[4];
            this.getPageCache().put(MEMBER_TYPE, dimType);
            QFilter filter1 = new QFilter(MEMBER_TYPE, "=", (Object)dimType);
            QFilter filter2 = new QFilter(DIMENSION, "=", (Object)ConvertUtil.convertStrToLong((String)dimId));
            filterParameter.setFilter(filter1.and(filter2));
            billlist.setFilterParameter(filterParameter);
            this.refreshBillList();
        }
    }

    private void setData2UserEntry(ListSelectedRowCollection returnData, String baseType) {
        if (returnData == null) {
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl(USERENTRY_ID);
        int[] rowsIndex = eg.getSelectRows();
        HashSet<Integer> listRows = new HashSet<Integer>();
        ArrayList<Object> oids = this.getOldDisIds();
        returnData.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(USERENTRY_ID);
                this.getModel().setValue("etype", (Object)baseType, rowIndex);
                this.getModel().setValue(EUSERS, p.getPrimaryKeyValue(), rowIndex);
                this.getModel().setValue("eusersnumber", p.getPrimaryKeyValue(), rowIndex);
                listRows.add(rowIndex);
            }
        });
        this.setDefaultSelectRows(eg, listRows, rowsIndex);
        this.refreshBillList();
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        this.getModel().getEntryEntity(USERENTRY_ID).forEach(p -> {
            if (p.getDynamicObject(EUSERS) != null) {
                ids.add(p.getDynamicObject(EUSERS).getPkValue());
            }
        });
        return ids;
    }

    private void setDimensionCombo() {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(DIMENSIONCOMBO_ID);
        List<Object> dimensionlist = this.getDimensionComData();
        dimensionlist = dimensionlist.stream().filter(str -> !Objects.equals("bcm_mycompanymembertree", str[2])).collect(Collectors.toList());
        this.getPageCache().put("listDimension", SerializationUtils.serializeToBase64(dimensionlist));
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        String dimId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        if (dimId == null) {
            dimId = QueryDimensionServiceHelper.getDimIdByNumber((String)DimTypesEnum.ENTITY.getNumber(), (String)this.getPageCache().get("KEY_MODEL_ID"));
        }
        if (dimId != null) {
            String dimSeq = this.getDimSeqById(dimensionlist, dimId);
            this.getPageCache().put("dimvalue", dimSeq);
            this.getModel().setValue(DIMENSIONCOMBO_ID, (Object)dimSeq);
        }
    }

    private String getDimSeqById(List<String[]> dimensionlist, String dimId) {
        if (dimensionlist.size() < 1) {
            return "";
        }
        for (String[] ss : dimensionlist) {
            if (!dimId.equals(ss[4])) continue;
            return ss[1];
        }
        return dimensionlist.get(0)[1];
    }

    private String[] getDimDataByValue(String dimValue) {
        List dimensionlist = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("listDimension"));
        for (String[] ss : dimensionlist) {
            if (!ss[1].equals(dimValue)) continue;
            return ss;
        }
        return null;
    }

    private void showMulMemberF7View() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_tem");
        String dimValue = (String)this.getModel().getValue(DIMENSIONCOMBO_ID);
        String[] dimData = this.getDimDataByValue(dimValue);
        if (dimData != null && dimData.length > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String dimName = dimData[0];
            params.put(DIMENSION, dimValue);
            params.put("isUpDownBtn", true);
            params.put("isExchangeRate", "1");
            params.put("isfromDimDesigner", "true");
            params.put("f7modelId", this.getModelId());
            params.put("sign", dimData[2]);
            params.put("source", "memberPerm");
            params.put("isNotPermFilterF7", "true");
            params.put("isPEnableGrantPerm", true);
            params.put("isFilterRateScheme", Boolean.TRUE);
            formShowParameter.setCustomParams(params);
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u9009\u62e9", (String)"MemberPermEditPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimName + " - "));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    private List<String[]> getDimensionComData() {
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "id,name,dseq,membermodel,membertable";
        QFilter fmodelid = new QFilter("model", "=", (Object)Long.valueOf(modelID));
        if (!this.isInterMem(modelID)) {
            QFilter filter1 = new QFilter("number", "!=", (Object)DimTypesEnum.INTERCOMPANY.getNumber());
            fmodelid.and(filter1);
        }
        if (ModelUtil.queryApp(this.getView()) == ApplicationTypeEnum.EB) {
            fmodelid.and("number", "!=", (Object)DimTypesEnum.SCENARIO.getNumber());
        }
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "dseq";
        ArrayList<String[]> dimList = new ArrayList<String[]>();
        QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)orderBys).forEach(p -> {
            String[] dimensionArray = new String[]{p.getString("name"), p.getString("dseq"), p.getString("membermodel"), p.getString("membertable"), p.getString("id")};
            dimList.add(dimensionArray);
        });
        return dimList;
    }

    private boolean isInterMem(String modelid) {
        QFilter filter1 = new QFilter("model", "=", (Object)Long.valueOf(modelid));
        QFilter filter3 = new QFilter("issysmember", "!=", (Object)1);
        QFilter[] filters = new QFilter[]{filter1, filter3};
        return QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])filters);
    }

    private void modelChange(String modelId) {
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.setDimensionCombo();
        this.getModel().deleteEntryData(USERENTRY_ID);
        this.getModel().deleteEntryData(MEMBERENTRY_ID);
        this.refreshBillList();
    }

    private void importMemPerm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        String listName = ResManager.loadKDString((String)"\u6210\u5458\u6743\u9650\u5206\u914d\u8bb0\u5f55", (String)"MemberPermEditPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        AbsCommonImport.invokeOperation("bcm_memberperm", "kd.fi.bcm.formplugin.perm.MemberPermImport", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    private static String getNoModelTip() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"MemberPermEditPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }
}

