/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import org.apache.commons.lang3.StringUtils;

public class MemberPermImport
extends AbsCommonImport {
    private static final String PMSF = "users.number,usertype,username,model.number,member.number,membertype,dimension.number,permission,range";
    private static final Integer COLLECTIONSIZE = 16;
    private static final List<String> PERMKEYS = Lists.newArrayList((Object[])new String[]{"model.shownumber", "dimension.number", "membertype", "member.number", "usertype", "users.number", "range", "permission"});
    private DynamicObject model;
    private Map<String, DynamicObject> memberPermMap;
    private final Set<String> memPermRepeatKeys = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
    private final Map<String, Tuple<Long, String, String>> userTypeRepeatKeysWithIdNameEnable = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
    private final Map<String, Long> dimRepeatKeysWithId = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);
    private final Map<String, Pair<Long, String>> memTypeRepeatKeysWithIdName = Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE);

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Optional<DynamicObject> dbOld;
        if (!Objects.equals(this.model.getString("shownumber"), ImportHelper.getImportBillProp(bill, "model.shownumber").toString())) {
            return Optional.of(ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u5165\u5176\u4ed6\u4f53\u7cfb\u3002", (String)"MemberPermImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String dimNum = ImportHelper.getImportBillProp(bill, "dimension.number").toString();
        if (Objects.isNull(this.dimRepeatKeysWithId.get(dimNum))) {
            return Optional.of(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"MemberPermImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String membertype = ImportHelper.getImportBillProp(bill, "membertype").toString();
        if (Objects.equals(membertype, "bcm_mycompanymembertree")) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u76f4\u63a5\u5bf9\u6211\u65b9\u7ec4\u7ec7\u5206\u914d\u6210\u5458\u6743\u9650\u3002", (String)"MemberPermImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals(membertype, "bcm_definedpropertyvalue")) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u76f4\u63a5\u5bf9\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u5206\u914d\u6210\u5458\u6743\u9650\u3002", (String)"MemberPermImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(this.memTypeRepeatKeysWithIdName.get(MemberPermImport.getPermKey(Lists.newArrayList((Object[])new String[]{dimNum, membertype, ImportHelper.getImportBillProp(bill, "member.number").toString()}))))) {
            return Optional.of(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"MemberPermImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Tuple<Long, String, String> uIdNameIsUse = this.userTypeRepeatKeysWithIdNameEnable.get(MemberPermImport.getPermKey(bill, Boolean.FALSE, Lists.newArrayList((Object[])new String[]{"usertype", "users.number"})));
        if (Objects.isNull(uIdNameIsUse)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u6216\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"MemberPermImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals(uIdNameIsUse.p3, "0")) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u6216\u7528\u6237\u7ec4\u88ab\u7981\u7528\u3002", (String)"MemberPermImport_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.memPermRepeatKeys.add(MemberPermImport.getPermKey(bill, Boolean.FALSE, PERMKEYS))) {
            return Optional.of(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u6210\u5458\u6743\u9650\u6a21\u677f\u5185\u91cd\u590d\u3002", (String)"MemberPermImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals((Object)ImportHelper.getImportType(this.ctx), (Object)ImportOperateType.NEW) && (dbOld = this.getDbOld(bill)).isPresent()) {
            return Optional.of(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u6210\u5458\u6743\u9650\u5df2\u5b58\u5728\u3002", (String)"MemberPermImport_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void initData(List<ImportBillData> billdatas) {
        Object[] permMembers;
        Long modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        if (Objects.isNull(this.model)) {
            this.model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        }
        HashMap typeUserParmMap = Maps.newHashMapWithExpectedSize((int)4);
        HashSet dimNumsSet = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
        HashSet memNumsSet = Sets.newHashSetWithExpectedSize((int)COLLECTIONSIZE);
        for (ImportBillData bd : billdatas) {
            String userNum = ImportHelper.getImportBillProp(bd, "users.number").toString();
            String userType = ImportHelper.getImportBillProp(bd, "usertype").toString();
            typeUserParmMap.putIfAbsent(userType, Sets.newHashSet((Object[])new String[]{userNum}));
            typeUserParmMap.computeIfPresent(userType, (uTK, uNs) -> {
                uNs.add(userNum);
                return uNs;
            });
            dimNumsSet.add(ImportHelper.getImportBillProp(bd, "dimension.number").toString());
            memNumsSet.add(ImportHelper.getImportBillProp(bd, "member.number").toString());
        }
        typeUserParmMap.entrySet().forEach(tUP -> {
            Map<String, Tuple> uTRKWNMid;
            String uT;
            QFBuilder userQFBuilder = new QFBuilder("enable", "=", (Object)"1");
            Set users = (Set)tUP.getValue();
            if (!CollectionUtils.isEmpty((Collection)users)) {
                userQFBuilder.add("number", "in", (Object)users);
            }
            if (Objects.equals(uT = (String)tUP.getKey(), "bos_user")) {
                QFBuilder usertypeQFBuilder = new QFBuilder("category", "=", (Object)"1");
                usertypeQFBuilder.add("isvisible", "=", (Object)"1");
                DynamicObjectCollection bos_usertype = QueryServiceHelper.query((String)"bos_usertype", (String)"id", (QFilter[])usertypeQFBuilder.toArray());
                QFBuilder userParaQFBuilder = new QFBuilder();
                if (!CollectionUtils.isEmpty((Collection)bos_usertype)) {
                    for (DynamicObject but : bos_usertype) {
                        String id = but.getString("id");
                        CharSequence[] spliter = new String[]{"%,", ",%"};
                        userParaQFBuilder.or("usertype", "=", (Object)id);
                        userParaQFBuilder.or(QFilter.ftlike((String[])new String[]{spliter[0] + id, id + spliter[1], String.join((CharSequence)id, spliter)}, (String[])new String[]{"usertype"}));
                    }
                }
                userQFBuilder.add(userParaQFBuilder.toList());
            }
            if (!CollectionUtils.isEmpty(uTRKWNMid = QueryServiceHelper.query((String)uT, (String)"id,name,number,enable", (QFilter[])userQFBuilder.toArray()).stream().collect(Collectors.toMap(us -> MemberPermImport.getPermKey(Lists.newArrayList((Object[])new String[]{uT, us.getString("number")})), us -> new Tuple((Object)us.getLong("id"), (Object)us.getString("name"), (Object)us.getString("enable")))))) {
                this.userTypeRepeatKeysWithIdNameEnable.putAll(uTRKWNMid);
            }
        });
        dimNumsSet.forEach(dn -> {
            Long dimensionIdByNum = MemberReader.getDimensionIdByNum((long)this.model.getLong("id"), (String)dn);
            if (Objects.nonNull(dimensionIdByNum)) {
                this.dimRepeatKeysWithId.put((String)dn, dimensionIdByNum);
            }
            for (IDNumberTreeNode idntn : MemberReader.getAllNodeByDimNum((String)dn, (String)MemberReader.findModelNumberById((Object)modelId))) {
                String num = idntn.getNumber();
                if (!memNumsSet.contains(num) || Objects.equals(idntn.getStorageType(), StorageTypeEnum.SHARE)) continue;
                String dimNum = idntn.getDimNumber();
                this.memTypeRepeatKeysWithIdName.put(MemberPermImport.getPermKey(Lists.newArrayList((Object[])new String[]{dimNum, DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), num})), (Pair<Long, String>)new Pair((Object)idntn.getId(), (Object)idntn.getName()));
            }
        });
        QFBuilder pMQFBuilder = new QFBuilder("model.id", "=", (Object)modelId);
        if (!CollectionUtils.isEmpty(this.userTypeRepeatKeysWithIdNameEnable)) {
            pMQFBuilder.add("users.id", "in", this.userTypeRepeatKeysWithIdNameEnable.values().stream().map(uTRKWINE -> (Long)uTRKWINE.p1).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(this.memTypeRepeatKeysWithIdName)) {
            pMQFBuilder.add("member.id", "in", this.memTypeRepeatKeysWithIdName.values().stream().map(mTRKWIN -> (Long)mTRKWIN.p1).collect(Collectors.toSet()));
        }
        if (!ArrayUtils.isEmpty((Object[])(permMembers = BusinessDataServiceHelper.load((String)"bcm_memberperm", (String)PMSF, (QFilter[])pMQFBuilder.toArray())))) {
            this.memberPermMap = Arrays.stream(permMembers).filter(mP -> StringUtils.isNotBlank((CharSequence)mP.getString("users.number"))).collect(Collectors.toMap(mP -> MemberPermImport.getPermKey(mP, Boolean.TRUE, PERMKEYS), Function.identity(), (mP1, mp2) -> mp2));
        }
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject old;
            JSONObject data = billDataList.get(i).getData();
            dys[i] = old = (DynamicObject)data.get((Object)"existingRecordDy");
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            dynamicObject.set("id", ImportHelper.getImportBillProp(billDataList.get(i), "id"));
            String userType = ImportHelper.getImportBillProp(billDataList.get(i), "usertype").toString();
            dynamicObject.set("usertype", (Object)userType);
            Tuple<Long, String, String> uIdNameIsUse = this.userTypeRepeatKeysWithIdNameEnable.get(MemberPermImport.getPermKey(Lists.newArrayList((Object[])new String[]{userType, ImportHelper.getImportBillProp(billDataList.get(i), "users.number").toString()})));
            dynamicObject.set("users", uIdNameIsUse.p1);
            dynamicObject.set("username", uIdNameIsUse.p2);
            String dimNum = ImportHelper.getImportBillProp(billDataList.get(i), "dimension.number").toString();
            dynamicObject.set("dimension", (Object)this.dimRepeatKeysWithId.get(dimNum));
            String membertype = ImportHelper.getImportBillProp(billDataList.get(i), "membertype").toString();
            dynamicObject.set("membertype", (Object)membertype);
            Pair<Long, String> memIdNameProp = this.memTypeRepeatKeysWithIdName.get(MemberPermImport.getPermKey(Lists.newArrayList((Object[])new String[]{dimNum, membertype, ImportHelper.getImportBillProp(billDataList.get(i), "member.number").toString()})));
            dynamicObject.set("member", memIdNameProp.p1);
            dynamicObject.set("membername", memIdNameProp.p2);
            dynamicObject.set("iscustomprop", (Object)0);
            dynamicObject.set("range", (Object)ImportHelper.getImportBillProp(billDataList.get(i), "range").toString());
            dynamicObject.set("permission", (Object)ImportHelper.getImportBillProp(billDataList.get(i), "permission").toString());
            dynamicObject.set("model", (Object)this.model.getLong("id"));
            dys[i] = dynamicObject;
        }
        return dys;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData(billdatas);
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String permKey = MemberPermImport.getPermKey(rowData, Boolean.FALSE, PERMKEYS);
        DynamicObject old = null;
        if (!CollectionUtils.isEmpty(this.memberPermMap)) {
            old = this.memberPermMap.get(permKey);
        }
        return Optional.ofNullable(old);
    }

    @Override
    protected void afterSaveBatch(List<ImportBillData> validatedBillData, List<BillResult> resultEntries) {
        ArrayList logs = Lists.newArrayListWithCapacity((int)resultEntries.size());
        resultEntries.forEach(t -> {
            Object record = t.getData().get("existingRecordDy");
            if (t.isSucess() && Objects.isNull(record)) {
                Map<String, Object> data = t.getData();
                String memNum = (String)((Map)data.get("member")).get("number");
                String dimNum = (String)((Map)data.get("dimension")).get("number");
                String userNum = (String)((Map)data.get("users")).get("number");
                logs.add(DataPermLogHelper.newMemberPermLog((Long)this.model.getLong("id"), (String)dimNum, (String)memNum, (String)((String)this.memTypeRepeatKeysWithIdName.get((Object)MemberPermImport.getPermKey((List<String>)Lists.newArrayList((Object[])new String[]{dimNum, data.get((Object)"membertype").toString(), memNum}))).p2), (String)data.get("permission").toString(), null, (String)DataPermLogMultiLangEnum.MemberPermImport_Distribute.getOperateName(), (String)data.get("range").toString(), (String)userNum, (String)((String)this.userTypeRepeatKeysWithIdNameEnable.get((Object)MemberPermImport.getPermKey((List<String>)Lists.newArrayList((Object[])new String[]{data.get((Object)"usertype").toString(), userNum}))).p2), (String)RequestContext.get().getClient(), (String)RequestContext.get().getLoginIP(), (String)this.ctx.getAppId()));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)logs)) {
            DataPermLogHelper.batchInsertDataPermLog((List)logs);
        }
    }
}

