/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ModelServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.AppUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ModelDistributeEditPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    private static final String DISENTRY_ID = "modelpermentry";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String FIMD_MODEL = "fidmmodel";
    private static final String ETYPE = "etype";
    private static final String EUSERS = "eusers";
    private static final String BASEUSER = "baseuser";
    private static final String BOS_USER = "bos_user";
    private static final String BASE_USER_GROUP = "baseusergroup";
    private static final String PARENTFORMID = "parentFormId";
    private static final String OLD = "old";
    private static final String DIMTYPE = "dimtype";
    private static final String USRGRPID = "usrgrpid";
    private static final String ROLE = "role";
    private static final String DIMID = "dimid";
    private static final String PERM_USRGRPROLE = "perm_usrgrprole";

    @Override
    public void initialize() {
        super.initialize();
        this.addListener();
    }

    private void addListener() {
        this.addItemClickListeners("advcontoolbarap");
        BasedataEdit user = (BasedataEdit)this.getControl(BASEUSER);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl(BASE_USER_GROUP);
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        this.getModel().setValue(MODEL, (Object)modelid);
    }

    @Override
    public void afterBindData(EventObject e) {
        Map lockInfo;
        super.afterBindData(e);
        Pair<Set<Long>, Set<Long>> omids = this.getAllUserId();
        this.getPageCache().put(OLD, SerializationUtils.toJsonString(omids));
        String billId = String.valueOf(this.getModel().getValue("id"));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_modelperm", (String)"model.name", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(billId)).toArray());
        String modelName = dy.getString("model.name");
        if (!MutexServiceHelper.request((String)billId, (String)"bcm_modelperm", (String)OpItemEnum.BTN_EDIT.getName()) && (lockInfo = MutexServiceHelper.getLockInfo((String)billId, (String)"bcm_modelperm", (String)OpItemEnum.BTN_EDIT.getName())) != null && !RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u88ab%2$s\u9501\u5b9a\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"ModelDistributeEditPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelName, UserServiceHelper.getUsernameByUserid(lockInfo.get("userid"))), Integer.valueOf(3000));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl(BASE_USER_GROUP);
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl(BASEUSER);
                user.click();
                break;
            }
            case "delentry": {
                this.deleteEntryRow(DISENTRY_ID);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            int entryRowCount = this.getModel().getEntryRowCount(DISENTRY_ID);
            if (entryRowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u79fb\u9664\u6240\u6709\u6743\u9650\u3002", (String)"ModelDistributeEditPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                this.getModel().setDataChanged(false);
                return;
            }
            ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
            if (Objects.equals(ApplicationTypeEnum.FIDM, application) || Objects.equals(ApplicationTypeEnum.FAR, application)) {
                DynamicObject moelobj = (DynamicObject)this.getModel().getValue(FIMD_MODEL);
                Long modelId = moelobj.getLong("id");
                if (!MemberPermHelper.isDiscModelAdmin((Long)modelId, (String)this.getBizAppId()) && !MemberPermHelper.isDiscModelSuperAdmin((String)application.appnum)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u201c%s\u201d\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u4e0d\u53ef\u6307\u5b9a\u8be5\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"ModelDistributeEditPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), moelobj.getString("name")));
                    args.setCancel(true);
                }
            } else {
                Set modelIds;
                DynamicObject moelobj = (DynamicObject)this.getModel().getValue(MODEL);
                Long modelId = moelobj.getLong("id");
                String billFormId = "";
                if (this.getView() != null && this.getView().getFormShowParameter().getCustomParams().containsKey(PARENTFORMID)) {
                    billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTFORMID);
                }
                if (!(modelIds = MemberPermHelper.getLimitedModelListByUser((String)billFormId, (ApplicationTypeEnum)application)).contains(modelId)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u201c%s\u201d\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u4e0d\u53ef\u6307\u5b9a\u8be5\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"ModelDistributeEditPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), moelobj.getString("name")));
                    args.setCancel(true);
                }
            }
        }
    }

    private void deleteEntryRow(String entryId) {
        EntryGrid eg = (EntryGrid)this.getControl(entryId);
        int[] rows = eg.getSelectRows();
        if (rows.length > 0) {
            this.getModel().deleteEntryRows(entryId, rows);
            eg.clearEntryState();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ModelDistributeEditPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null) {
            return;
        }
        ArrayList<Object> oids = this.getOldDisIds();
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2Entry(rows, oids, BOS_USER);
                break;
            }
            case "baseusergroup": {
                this.setData2Entry(rows, oids, "bos_usergroup");
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billId = String.valueOf(this.getModel().getValue("id"));
        Map lockInfo = MutexServiceHelper.getLockInfo((String)billId, (String)"bcm_modelperm", (String)OpItemEnum.BTN_EDIT.getName());
        if (lockInfo != null && RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            MutexServiceHelper.release((String)billId, (String)"bcm_modelperm", (String)OpItemEnum.BTN_EDIT.getName());
        }
    }

    private void setData2Entry(ListSelectedRowCollection rows, ArrayList<Object> oids, String baseType) {
        rows.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(DISENTRY_ID);
                this.getModel().setValue(ETYPE, (Object)baseType, rowIndex);
                this.getModel().setValue(EUSERS, p.getPrimaryKeyValue(), rowIndex);
            }
        });
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        this.getModel().getEntryEntity(DISENTRY_ID).forEach(p -> ids.add(p.getDynamicObject(EUSERS).getPkValue()));
        return ids;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        CloseCallBack aa = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
        evt.getFormShowParameter().setCloseCallBack(aa);
        evt.getFormShowParameter().setHasRight(true);
        String name = evt.getProperty().getName();
        if (Objects.equals(BASEUSER, name) || Objects.equals(BASE_USER_GROUP, name)) {
            evt.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if ("deleteentry".equals(e.getOperateKey())) {
            return;
        }
        if ("save".equals(e.getOperateKey()) && issuccess && this.getPageCache().get(OLD) != null) {
            String permType;
            String modelId;
            ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
            if (Objects.equals(app, ApplicationTypeEnum.FIDM) || Objects.equals(app, ApplicationTypeEnum.FAR)) {
                modelId = ((DynamicObject)this.getModel().getValue(FIMD_MODEL)).getString("id");
                permType = "fidm_model";
            } else {
                modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getString("id");
                app = ModelServiceHelper.getModelApp((long)Long.parseLong(modelId));
                permType = "DIM_BCM_MODEL";
            }
            long modelIdL = ConvertUtil.convertStrToLong((String)modelId);
            ArrayList modelIdLong = Lists.newArrayList((Object[])new Long[]{modelIdL});
            Pair<Set<Long>, Set<Long>> newids = this.getAllUserId();
            ObjectMapper mapper = new ObjectMapper();
            TypeFactory typeFactory = mapper.getTypeFactory();
            JavaType javaType = typeFactory.constructParametricType(Pair.class, new JavaType[]{typeFactory.constructParametricType(List.class, new Class[]{Long.class}), typeFactory.constructParametricType(List.class, new Class[]{Long.class})});
            Pair omids = null;
            try {
                omids = (Pair)mapper.readValue(this.getPageCache().get(OLD), javaType);
            }
            catch (JsonProcessingException ex) {
                log.error(ex.getMessage());
            }
            HashSet usrOdCp = null;
            if (CollectionUtils.isNotEmpty((Collection)((Collection)omids.p1))) {
                usrOdCp = Sets.newHashSet((Iterable)((Iterable)omids.p1));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)newids.p1))) {
                    ((List)omids.p1).removeAll((Collection)newids.p1);
                }
                PermissionServiceHelper.roleAssignUserOrg((String)((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(app)), ((List)omids.p1).stream().collect(Collectors.toMap(Function.identity(), t -> modelIdLong)), null, (boolean)Boolean.FALSE);
                if (Objects.equals(ApplicationTypeEnum.CM, app)) {
                    PermissionServiceHelper.roleAssignUserOrg((String)((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(ApplicationTypeEnum.RPT)), ((List)omids.p1).stream().collect(Collectors.toMap(Function.identity(), t -> modelIdLong)), null, (boolean)Boolean.FALSE);
                }
            }
            HashSet usrGrpOdCp = Sets.newHashSet((Iterable)((Iterable)omids.p2));
            String roleId = (String)BcmFunPermissionHelper.APP2ADMINROLEID.get(app);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)omids.p2))) {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)newids.p2))) {
                    ((List)omids.p2).removeAll((Collection)newids.p2);
                }
                QFBuilder del = new QFBuilder(DIMID, "=", (Object)modelIdL);
                del.and(ROLE, "=", (Object)roleId);
                if (Objects.equals(ApplicationTypeEnum.CM, app)) {
                    del.or(ROLE, "=", BcmFunPermissionHelper.APP2ADMINROLEID.get(ApplicationTypeEnum.RPT));
                }
                del.and(USRGRPID, "in", omids.p2);
                del.and(DIMTYPE, "=", (Object)permType);
                DeleteServiceHelper.delete((String)PERM_USRGRPROLE, (QFilter[])del.toArray());
            }
            if (AppUtil.isEpmAppId((String)this.getBizAppId())) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"addEPMPermByUsers", (Object[])new Object[]{modelId, newids});
            } else {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)newids.p1))) {
                    if (CollectionUtils.isNotEmpty((Collection)usrOdCp)) {
                        ((Set)newids.p1).removeAll(usrOdCp);
                    }
                    PermissionServiceHelper.roleAssignUserOrg((String)((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(app)), (String)permType, ((Set)newids.p1).stream().collect(Collectors.toMap(Function.identity(), t -> modelIdLong)), null, (boolean)Boolean.TRUE);
                    if (Objects.equals(ApplicationTypeEnum.CM, app)) {
                        PermissionServiceHelper.roleAssignUserOrg((String)((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(ApplicationTypeEnum.RPT)), (String)permType, ((Set)newids.p1).stream().collect(Collectors.toMap(Function.identity(), t -> modelIdLong)), null, (boolean)Boolean.TRUE);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)newids.p2))) {
                    Set uGIdDb;
                    if (CollectionUtils.isNotEmpty((Collection)usrGrpOdCp)) {
                        ((Set)newids.p2).removeAll(usrGrpOdCp);
                    }
                    if (CollectionUtils.isNotEmpty(uGIdDb = QueryServiceHelper.query((String)PERM_USRGRPROLE, (String)USRGRPID, (QFilter[])new QFBuilder(DIMID, "=", (Object)modelIdL).and(USRGRPID, "in", newids.p2).and(DIMTYPE, "=", (Object)permType).toArray()).stream().map(t -> t.getLong(USRGRPID)).collect(Collectors.toSet()))) {
                        ((Set)newids.p2).removeAll(uGIdDb);
                    }
                    ArrayList usrGrpSaveList = Lists.newArrayListWithExpectedSize((int)(Objects.equals(app, ApplicationTypeEnum.CM) ? ((Set)newids.p2).size() * 2 : ((Set)newids.p2).size()));
                    for (Long id : (Set)newids.p2) {
                        usrGrpSaveList.add(this.buildUsrGrpDyObj(permType, modelIdL, id, app));
                        if (!Objects.equals(app, ApplicationTypeEnum.CM)) continue;
                        usrGrpSaveList.add(this.buildUsrGrpDyObj(permType, modelIdL, id, ApplicationTypeEnum.RPT));
                    }
                    SaveServiceHelper.save((DynamicObject[])usrGrpSaveList.toArray(new DynamicObject[0]));
                }
            }
            RequestContext tx = RequestContext.get();
            long userId = Long.parseLong(tx.getUserId());
            ThreadCache.remove((Object)("limit_model_" + userId + null));
            CacheMrg.clearAllCache();
        }
        if (issuccess && e.getSource() instanceof Save) {
            this.getView().returnDataToParent((Object)new LocaleString(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\u3002", (String)"ModelDistributeEditPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            this.getView().close();
        }
    }

    private Pair<Set<Long>, Set<Long>> getAllUserId() {
        HashSet uIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet uGrIds = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObjectCollection oldmember = (DynamicObjectCollection)this.getModel().getValue(DISENTRY_ID);
        for (DynamicObject mem : oldmember) {
            String type = mem.getString(ETYPE);
            long usid = mem.getLong("eusers.id");
            if (BOS_USER.equals(type)) {
                uIds.add(usid);
                continue;
            }
            uGrIds.add(usid);
        }
        return Pair.onePair((Object)uIds, (Object)uGrIds);
    }

    private DynamicObject buildUsrGrpDyObj(String permType, long dimId, long usrGrpId, ApplicationTypeEnum midApp) {
        DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)PERM_USRGRPROLE);
        saveObj.set(DIMTYPE, (Object)permType);
        saveObj.set(DIMID, (Object)dimId);
        saveObj.set("includesub", (Object)0);
        saveObj.set(USRGRPID, (Object)usrGrpId);
        saveObj.set(ROLE, BcmFunPermissionHelper.APP2ADMINROLEID.get(midApp));
        return saveObj;
    }
}

