/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.Collection;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;

public class ModelPermCommon {
    public static final String FORMSHOW_DIMENSIONOBJIDS = "FormShowParam_dimensionObjIds";
    public static final String PERTIP = "formShowParm_show_unableInfo";

    public static boolean isSysAdmin() {
        Set models = MemberPermHelper.getLimitedModelListByUser();
        return models != null && models.size() > 0;
    }

    public static boolean isFidmAdmin() {
        return !CollectionUtils.isEmpty((Collection)MemberPermHelper.getFidmModelAdmin());
    }

    public static boolean isFarAdmin() {
        return !CollectionUtils.isEmpty((Collection)MemberPermHelper.getDisModelAdmin((String)ApplicationTypeEnum.FAR.getAppnum()));
    }

    public static boolean isSysAdmin(ApplicationTypeEnum application) {
        if (application != null && MemberPermHelper.isManager((ApplicationTypeEnum)application)) {
            return true;
        }
        return ModelPermCommon.isSysAdmin();
    }

    public static String getModelScop(String appId, String entity) {
        Set manageModelids;
        ApplicationTypeEnum application = ApplicationTypeEnum.getEnumByNumber((String)appId);
        Set ids = BcmFunPermissionHelper.getEffectiveByPermModel((String)entity, (ApplicationTypeEnum)application);
        String entityName = "bcm_model";
        if (ApplicationTypeEnum.isFIDM((ApplicationTypeEnum)application) || ApplicationTypeEnum.isFAR((ApplicationTypeEnum)application)) {
            entityName = "fidm_model";
            manageModelids = MemberPermHelper.getDisModelAdmin((String)application.getAppnum());
        } else {
            manageModelids = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)ApplicationTypeEnum.getEnumByNumber((String)appId));
        }
        Set perRoleids = BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)entityName, (ApplicationTypeEnum)application);
        ids.addAll(manageModelids);
        ids.addAll(perRoleids);
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(',');
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(","));
        }
        return "0";
    }
}

