/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.perm.RoleOrgUserPlugin;

public class RoleStatusChangeHandler {
    private static Long RoleModelId = 17299999999L;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(RoleOrgUserPlugin.class);

    public static void logHandler(Set<Object> roleIds, boolean isEnable, String appId) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        DynamicObjectCollection roles = QueryServiceHelper.query((String)"perm_role", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return;
        }
        ArrayList logs = Lists.newArrayListWithCapacity((int)roles.size());
        String operateName = isEnable ? FunctionPermLogMultiLangEnum.ROLE_ENABLE.getOperateName() : FunctionPermLogMultiLangEnum.ROLE_DISABLE.getOperateName();
        for (DynamicObject dy : roles) {
            DynamicObject log = FunctionPermLogHelper.newRolePermLog((Long)RoleModelId, (String)dy.getString("number"), (String)dy.getString("name"), (String)operateName, (String)appId);
            logs.add(log);
        }
        try {
            FunctionPermLogHelper.batchInsertFunctionPermLog((List)logs);
        }
        catch (KDException e) {
            log.error((Throwable)e);
        }
    }
}

