/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.perm.RolePermUtils;
import org.apache.commons.collections.CollectionUtils;

public class RoleUserOrgPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(RoleUserOrgPlugin.class);
    private final String OldUserAndModelCache = "oldUserAndModelMapCache";
    private final String OldUserMapCache = "oldUserMapCache";
    private final String HavOldUserAndOrgSetCache = "havOldOrgAndUserSetCache";
    private final String MODEL_ID = "org_id_temp";
    private final String USER_LIST = "userlist";
    private final String ORG_LIST = "orglist";
    private final String SAVE = "bar_save";
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String USER_ID = "user.id";
    private final String isHavNotTrue = "isHavNotTrue";
    private final String isLatesVersion = "isLatesVersion";
    private final String ORG = "orglist_visiable";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"bar_save"});
        EntryGrid eg = (EntryGrid)this.getControl("userlist");
        eg.addRowClickListener((RowClickEventListener)this);
        this.itemClickListeners();
    }

    private void itemClickListeners() {
        Toolbar userToolBar = (Toolbar)this.getControl("toolbar_user");
        userToolBar.addItemClickListener((ItemClickListener)this);
        Toolbar orgToolBar = (Toolbar)this.getControl("toolbar_org");
        orgToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Object user;
        int[] selectRows;
        EntryGrid eg;
        String itemKey = evt.getItemKey();
        if (Objects.equals("org_del", itemKey)) {
            eg = (EntryGrid)this.getControl("orglist_visiable");
            selectRows = eg.getSelectRows();
            if (Objects.isNull(selectRows)) {
                return;
            }
            Set models = MemberPermHelper.getLimitedModelListByUser();
            for (int selectRow : selectRows) {
                DynamicObject model;
                long modelId;
                DynamicObject org = this.getModel().getEntryRowEntity("orglist_visiable", selectRow);
                if (Objects.isNull(org) || models.contains(modelId = org.getLong("org_id_temp_visiable")) || Objects.isNull(model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)}))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u3010%1$s\u3011\u3010%2$s\u3011\u4f53\u7cfb\u7ba1\u7406\u6743\u9650\u3002", (String)"RoleOrgUserPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getString("shownumber"), model.getString("name")));
                evt.setCancel(true);
                return;
            }
        }
        if (!Objects.equals("user_del", itemKey)) {
            return;
        }
        eg = (EntryGrid)this.getControl("userlist");
        selectRows = eg.getSelectRows();
        if (Objects.isNull(selectRows)) {
            return;
        }
        HashMap userMaps = Maps.newHashMapWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            user = this.getModel().getEntryRowEntity("userlist", selectRow);
            if (Objects.isNull(user)) continue;
            long userId = user.getLong("user_id_temp");
            userMaps.put(userId, user.getLocaleString("user.name").getLocaleValue());
        }
        String roleId = ((DynamicObject)this.getModel().getValue("role_number")).getString("id");
        QFilter[] qFilters = new QFBuilder("role", "=", (Object)roleId).and("user", "in", userMaps.keySet()).and("dimtype", "=", (Object)"bcm_model").toArray();
        DynamicObjectCollection permUserRole = QueryServiceHelper.query((String)"perm_userrole", (String)"user,org", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)permUserRole)) {
            return;
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)permUserRole.get(0)).getDataEntityType().getProperties().get((Object)"org");
        user = permUserRole.stream().collect(Collectors.groupingBy(e -> e.getLong("user")));
        Set models = MemberPermHelper.getLimitedModelListByUser();
        for (Map.Entry userMap : user.entrySet()) {
            List value = (List)userMap.getValue();
            for (DynamicObject dy : value) {
                DynamicObject model;
                long org = dy.getLong(dataEntityProperty);
                if (models.contains(org) || Objects.isNull(model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)org)}))) continue;
                String userName = (String)userMaps.get(userMap.getKey());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u65e0\u4f53\u7cfb\u7ba1\u7406\u6743\u9650\u3002", (String)"RoleOrgUserPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), userName, model.getString("shownumber"), model.getString("name")));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        this.getPageCache().put("CustomQFilter_DimObjIds", superid.toSerializedString());
        this.getPageCache().put("FormShowParam_CtrlType_Name", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"DataCollectedNewPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPermCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("role_number".equals(e.getProperty().getName())) {
            this.clearPermCache();
            this.setPermCache();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            this.writePermLogs();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int[] selectedRows = ((EntryGrid)this.getView().getControl("userlist")).getEntryState().getSelectedRows();
        EntryGrid source = (EntryGrid)evt.getSource();
        String entryKey = source.getEntryKey();
        if ("userlist".equals(entryKey)) {
            for (int selectedRow : selectedRows) {
                RolePermUtils.isInitHavOrgOrUserFlag(selectedRow, this.getView(), "userlist", "user.id", "oldUserMapCache", "havOldOrgAndUserSetCache");
            }
        }
    }

    private void clearPermCache() {
        this.getPageCache().remove("oldUserAndModelMapCache");
        this.getPageCache().remove("oldUserMapCache");
        this.getPageCache().remove("havOldOrgAndUserSetCache");
        this.getPageCache().put("isLatesVersion", "0");
    }

    private void setPermCache() {
        this.getPageCache().put("isLatesVersion", "0");
        if (this.getPageCache().get("oldUserAndModelMapCache") == null) {
            HashMap initUsersMapCache = new HashMap(12);
            HashMap initModelAndUserMapCache = new HashMap(12);
            HashSet havLoadOrgsSet = new HashSet(12);
            this.getModel().getEntryEntity("userlist").stream().forEach(v -> {
                String userId = v.getString("user.id");
                HashMap<String, String> user = new HashMap<String, String>(2);
                user.put("number", v.getString("user.number"));
                user.put("name", v.getString("user.name"));
                initUsersMapCache.put(userId, user);
                DynamicObjectCollection dt = (DynamicObjectCollection)v.get("orglist");
                ArrayList<String> models = new ArrayList<String>(dt.size());
                for (DynamicObject d : dt) {
                    models.add(d.getString("org_id_temp"));
                }
                initModelAndUserMapCache.put(userId, models);
                if (models.size() == 0) {
                    this.getPageCache().put("isLatesVersion", "1");
                } else {
                    havLoadOrgsSet.add(userId);
                }
            });
            this.getPageCache().put("oldUserAndModelMapCache", SerializationUtils.toJsonString(initModelAndUserMapCache));
            this.getPageCache().put("oldUserMapCache", SerializationUtils.toJsonString(initUsersMapCache));
            this.getPageCache().put("havOldOrgAndUserSetCache", SerializationUtils.toJsonString(havLoadOrgsSet));
        }
    }

    private void getSelectRowOrgUsers(Set<String> userIds, final Map<String, List<String>> userOrgMapCache) {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role_number");
        String roleId = (String)role.getPkValue();
        String sql1 = "SELECT t1.fuserid,t1.forgid from t_perm_userrole t1 where t1.froleid = ? and t1.fuserid in (" + RolePermUtils.getPlaceholder(userIds) + ")";
        Object[] params = new Object[]{roleId};
        DB.query((DBRoute)DBRoute.base, (String)sql1, (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String forgid = rs.getString("forgid");
                    String fuserid = rs.getString("fuserid");
                    List orgList = (List)userOrgMapCache.get(fuserid);
                    orgList.add(forgid);
                    userOrgMapCache.put(fuserid, orgList);
                }
                return null;
            }
        });
    }

    private Map<String, List<String>> getCurrentMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.getModel().getEntryEntity("userlist").stream().forEach(v -> {
            String userId = v.getString("user.id");
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get("orglist");
            ArrayList<String> models = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                models.add(d.getString("org_id_temp"));
            }
            map.put(userId, models);
        });
        return map;
    }

    private void writePermLogs() {
        DynamicObject role_number1 = (DynamicObject)this.getModel().getValue("role_number");
        String role_number = role_number1.getString("number");
        String role_name = role_number1.getString("name");
        String memgerInfo = "(" + role_number + "/" + role_name + ")";
        String appId = this.getView().getFormShowParameter().getAppId();
        HashMap newUsersMap = new HashMap();
        HashMap mapNew = new HashMap();
        this.getModel().getEntryEntity("userlist").stream().forEach(v -> {
            String userId = v.getString("user.id");
            HashMap<String, String> user = new HashMap<String, String>(2);
            user.put("number", v.getString("user.number"));
            user.put("name", v.getString("user.name"));
            newUsersMap.put(userId, user);
            DynamicObjectCollection dt = (DynamicObjectCollection)v.get("orglist");
            ArrayList<String> models = new ArrayList<String>(dt.size());
            for (DynamicObject d : dt) {
                models.add(d.getString("org_id_temp"));
            }
            mapNew.put(userId, models);
        });
        String oldOrgLists = this.getPageCache().get("oldUserAndModelMapCache");
        HashMap mapOld = (HashMap)SerializationUtils.fromJsonString((String)oldOrgLists, Map.class);
        boolean latesVersion = RolePermUtils.isLatesVersion(this.getView(), "isLatesVersion");
        HashSet<String> oldHavOrgSet = new HashSet(12);
        if (latesVersion) {
            String havOldOrg = this.getPageCache().get("havOldOrgAndUserSetCache");
            oldHavOrgSet = (Set)SerializationUtils.fromJsonString((String)havOldOrg, Set.class);
            this.getSelectRowOrgUsers(oldHavOrgSet, mapOld);
        }
        String oldUserLists = this.getPageCache().get("oldUserMapCache");
        HashMap mapOldUser = (HashMap)SerializationUtils.fromJsonString((String)oldUserLists, Map.class);
        Set oldUserIds = mapOld.keySet();
        Set newUserIds = mapNew.keySet();
        Set entrySet = mapNew.entrySet();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        if (mapNew.size() > 0) {
            for (Map.Entry entry : entrySet) {
                String userId = (String)entry.getKey();
                if (latesVersion && oldUserIds.contains(userId) && !oldHavOrgSet.contains(userId)) continue;
                List modelIdsNew = (List)entry.getValue();
                if (modelIdsNew.size() == 0) {
                    this.getPageCache().put("isHavNotTrue", "1");
                    break;
                }
                Map user = (Map)newUsersMap.get(userId);
                String usernumber = (String)user.get("number");
                String username = (String)user.get("name");
                if (oldUserIds.contains(userId)) {
                    List modelIdsOld = (List)mapOld.get(userId);
                    modelIdsNew.removeAll(modelIdsOld);
                    if (modelIdsNew.size() > 0) {
                        for (String modelId : modelIdsNew) {
                            DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                            logs.add(log1);
                        }
                    }
                    Map<String, List<String>> currentMap = this.getCurrentMap();
                    List<String> userIdsNewTemp = currentMap.get(userId);
                    modelIdsOld.removeAll(userIdsNewTemp);
                    if (modelIdsOld.size() <= 0) continue;
                    Iterator iterator = modelIdsOld.iterator();
                    while (iterator.hasNext()) {
                        String modelId = (String)iterator.next();
                        DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                        logs.add(log1);
                    }
                    continue;
                }
                for (String modelId : modelIdsNew) {
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_Distribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        oldUserIds.removeAll(newUserIds);
        if (oldUserIds.size() > 0) {
            for (String oldUserId : oldUserIds) {
                Map user = (Map)mapOldUser.get(oldUserId);
                String usernumber = (String)user.get("number");
                String username = (String)user.get("name");
                List oldModels = (List)mapOld.get(oldUserId);
                for (String modelId : oldModels) {
                    DynamicObject log1 = FunctionPermLogHelper.newRolePermLog((Long)Long.parseLong(modelId), (String)usernumber, (String)username, (String)(FunctionPermLogMultiLangEnum.Role_DelDistribute.getOperateName() + memgerInfo), (String)appId);
                    logs.add(log1);
                }
            }
        }
        if (logs.size() > 0 && this.getPageCache().get("isHavNotTrue") == null) {
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
                this.clearPermCache();
                this.setPermCache();
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        this.getPageCache().remove("isHavNotTrue");
    }
}

