/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.perm.GroupConcat;
import org.apache.commons.lang3.StringUtils;

public class SystemPermRptData
extends AbstractReportListDataPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(SystemPermRptData.class);
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final String ID = "id";
    private static final String ISBYUSER = "isbyuser";
    private static final String MODEL = "model";
    private static final String USERS = "users";
    private static final String APPID = "appid";
    private static final String USERNUMBER = "usernumber";
    private static final String USERID = "userid";
    private static final String USERNAME = "username";
    private static final String ENTITYNAME = "entityname";
    private static final String PERMITEMID = "permitemid";
    private static final String PERMITEMNAME = "permitemname";
    private static final String SOURCEROLE = "sourcerole";
    private static final String TEMPID = "tempid";
    private static final String SOURCEUSERNAME = "sourceusername";
    private static final String ROLEREMARK = "roleremark";
    private static final String ROLENUMBER = "rolenumber";
    private static final String ROLENAME = "rolename";
    private static final String ROLEID = "roleid";
    private static final String DIMTYPE = "dimtype";
    private static final String BCM_MODEL = "bcm_model";
    private static final String BIZAPP = "bizapp";
    private static final String ORG = "org";
    private static final String USER_ID = "user.id";
    private static final String PERMITEM_ID = "permitem.id";
    private static final String PERM_DISFUNPERM = "perm_disfunperm";
    private static final String ISDISABLED = "isdisabled";
    private static final String SOURCEUSERNUMBER = "sourceusernumber";
    private static final String MODELNUMBER = "modelnumber";
    private static final String ROLE_ID = "role.id";
    private static final String ROLEPERM_BIZAPP = "roleperm.bizapp";
    private static final String ROLE_BIZDOMAIN = "role.bizdomain";
    private static final String PERM_USERROLE = "perm_userrole";
    private static final String PERM_ROLEPERM = "perm_roleperm";
    private static final String DIM_BCM_MODEL = "DIM_BCM_MODEL";
    private static final String SHOWNUMBER = "shownumber";
    private static final String PERMITEMSEL = "permitemsel";
    private static final String ROLES = "roles";
    private static final String PERM_USERPERM = "perm_userperm";
    private static final String ENTRYENTITY_BIZAPP = "entryentity.bizapp";
    private static final String SEPARATOR = ";\n";
    private static final String BYUSER = "byuser";
    private static final String PERMITEMIDEXPRESSION = "entitynumber+' '+'('+permitemid+')' as permitemid";
    private static final String TEMPIDEXPRESSION = "cast(userid as String)+'_'+entitynumber+'_'+permitemid as tempid";
    private static final String START_TIME_EXPRESSION = "case when starttime is null then '' else rolenumber+':' +cast(starttime as String) end as rolestarttime";
    private static final String END_TIME_EXPRESSION = "case when endtime is null then '' else rolenumber+':' + cast(endtime as String) end as roleendtime";
    private static final String ROLE_START_TIME = "rolestarttime";
    private static final String ROLE_END_TIME = "roleendtime";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private int maxCount = Integer.parseInt(ConfigEnum.P_SYSTEM_PERM_REPORT_LIMIT.getTextConfig());
    private int resCount = 0;

    private boolean getSystemParam(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(100000L));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap != null && Boolean.parseBoolean(paramMap.get(key).toString());
    }

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        long modelId = filterInfo.getDynamicObject(MODEL).getLong(ID);
        if (modelId == 0L) {
            return this.returnEmptyDataSet();
        }
        DynamicObjectCollection users = filterInfo.getDynamicObjectCollection(USERS);
        List<Long> userIds = null;
        if (users != null && users.size() > 0) {
            userIds = this.getIdList(users);
        }
        DynamicObjectCollection roles = filterInfo.getDynamicObjectCollection(ROLES);
        List<String> roleIds = null;
        if (roles != null && roles.size() > 0) {
            roleIds = this.getIdStirngList(roles);
        }
        DynamicObjectCollection permitemsels = filterInfo.getDynamicObjectCollection(PERMITEMSEL);
        List<String> permIds = null;
        if (permitemsels != null && permitemsels.size() > 0) {
            permIds = this.getIdStirngList(permitemsels);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BCM_MODEL, (String)SHOWNUMBER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)modelId)});
        String modelShowNumber = "";
        if (dynamicObject != null) {
            modelShowNumber = dynamicObject.getString(SHOWNUMBER);
        }
        String isbyuser = (String)queryParam.getCustomParam().get(ISBYUSER);
        if (filterInfo.getDynamicObject(MODEL) == null) {
            return null;
        }
        String appid = (String)queryParam.getCustomParam().get(APPID);
        if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)isbyuser)) {
            return this.querySysPermByUser(modelId, userIds, permIds, appid, modelShowNumber);
        }
        return this.querySysPermByRole(modelId, roleIds, permIds, appid, modelShowNumber);
    }

    private DataSet querySysPermByUser(Long modelId, List<Long> userIds, List<String> permIds, String appId, String modelShowNumber) {
        int mCount;
        DataSet userRoleDetail;
        DataSet result;
        block62: {
            result = null;
            QFilter directPermFilter = new QFilter(DIMTYPE, "=", (Object)DIM_BCM_MODEL);
            directPermFilter.and(ENTRYENTITY_BIZAPP, "=", (Object)appId);
            directPermFilter.and("org.id", "=", (Object)modelId);
            if (userIds != null && userIds.size() > 0) {
                directPermFilter.and(USER_ID, "in", userIds);
            }
            if (permIds != null && permIds.size() > 0) {
                directPermFilter.and("entryentity.permitem.id", "in", permIds);
            }
            String field = ResManager.loadKDString((String)"'\u76f4\u63a5\u6388\u6743'", (String)"SystemPermRptData_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            log.info("direct permission field:" + field);
            if (!field.startsWith("'")) {
                field = "'" + field + "'";
            }
            String userPermSelectFields = "id,org.id as sysid,user.id as userid,user.name as username,user.number as usernumber,entryentity.entitytype.name as entityname,entryentity.permitem.name as permitemname,entryentity.entitytype.number as entitynumber,entryentity.permitem.id as permitemid";
            try (DataSet userPermDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERPERM, (String)userPermSelectFields, (QFilter[])new QFilter[]{directPermFilter}, (String)"").distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION});){
                this.checkCount(userPermDataSet, (boolean)Boolean.TRUE);
                result = userPermDataSet.addField(field, SOURCEROLE);
                result = result.select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID});
            }
            QFilter userRoleFilter = new QFilter(DIMTYPE, "=", (Object)BCM_MODEL);
            userRoleFilter.and(ROLE_BIZDOMAIN, "=", (Object)appId);
            userRoleFilter.and("role.enable", "=", (Object)"1");
            userRoleFilter.and(ORG, "=", (Object)modelId);
            if (userIds != null) {
                userRoleFilter.and(USER_ID, "in", userIds);
            }
            userRoleDetail = null;
            String userRoleSelectFields = "id,role.id as roleid,role.name as rolename,role.number as rolenumber,user.id as userid,user.name as username,user.number as usernumber,starttime,endtime";
            try (DataSet userRole = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERROLE, (String)userRoleSelectFields, (QFilter[])new QFilter[]{userRoleFilter}, null).select(new String[]{ID, ROLEID, ROLENUMBER, USERID, USERNAME, USERNUMBER, START_TIME, END_TIME});){
                HashSet<String> rolesIdSet = new HashSet<String>();
                for (Row row : userRole.copy()) {
                    rolesIdSet.add(row.getString(ROLEID));
                }
                if (rolesIdSet.size() <= 0) break block62;
                this.checkCount(rolesIdSet.size(), (boolean)Boolean.FALSE);
                QFilter roleDetailFilter = new QFilter(ROLEID, "in", rolesIdSet);
                roleDetailFilter.and(ROLEPERM_BIZAPP, "=", (Object)appId);
                if (permIds != null) {
                    roleDetailFilter.and("roleperm.permitem.id", "in", permIds);
                }
                String rolePermSelectFields = "id,roleperm.entity.name as entityname,roleperm.permitem.name as permitemname,roleperm.permitem.id as permitemid,roleperm.entity.number as entitynumber,roleid";
                try (DataSet rolePermDetail = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_ROLEPERM, (String)rolePermSelectFields, (QFilter[])new QFilter[]{roleDetailFilter}, null);){
                    userRoleDetail = userRole.select(new String[]{USERID, USERNAME, USERNUMBER, ROLENUMBER, ROLEID, START_TIME, END_TIME}).join(rolePermDetail, JoinType.INNER).on(ROLEID, ROLEID).select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, "rolenumber as sourcerole", PERMITEMIDEXPRESSION, START_TIME_EXPRESSION, END_TIME_EXPRESSION}).finish().distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, ROLE_START_TIME, ROLE_END_TIME});
                }
            }
        }
        if (userRoleDetail != null && (mCount = userRoleDetail.copy().count(USERID, Boolean.FALSE.booleanValue())) > 0) {
            this.checkCount(mCount, (boolean)Boolean.TRUE);
            result = result.addField("\"\"", ROLE_START_TIME);
            result = result.addField("\"\"", ROLE_END_TIME);
            result = result.union(userRoleDetail).groupBy(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMID}).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEROLE, SOURCEROLE).agg((CustomAggFunction)new GroupConcat(SEPARATOR), ROLE_START_TIME, ROLE_START_TIME).agg((CustomAggFunction)new GroupConcat(SEPARATOR), ROLE_END_TIME, ROLE_END_TIME).finish().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, ROLE_START_TIME, ROLE_END_TIME});
        }
        QFilter disfunFilter = new QFilter(DIMTYPE, "=", (Object)BCM_MODEL);
        disfunFilter.and(BIZAPP, "=", (Object)appId);
        disfunFilter.and(ORG, "=", (Object)modelId);
        if (userIds != null) {
            disfunFilter.and(USER_ID, "in", userIds);
        }
        if (permIds != null) {
            disfunFilter.and(PERMITEM_ID, "in", permIds);
        }
        String disfunPermSelectFields = "id,user.id as userid,user.name as username,user.number as usernumber,entitytype.name as entityname,permitem.name as permitemname,entitytype.number as entitynumber,permitem.id as permitemid";
        DataSet disfunPerm = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_DISFUNPERM, (String)disfunPermSelectFields, (QFilter[])new QFilter[]{disfunFilter}, (String)"").distinct().select(new String[]{ID, USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, "cast(userid as String)+'_'+entitynumber+' '+'('+permitemid+')' as tempid"}).addField("1", ISDISABLED);
        Object object = null;
        try {
            int mCount2 = disfunPerm.copy().count(ID, Boolean.FALSE.booleanValue());
            if (mCount2 > 0) {
                this.checkCount(mCount2, (boolean)Boolean.TRUE);
                result = result.select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, "cast(userid as String)+'_'+permitemid as tempid", ROLE_START_TIME, ROLE_END_TIME});
                result = result.leftJoin(disfunPerm).on(TEMPID, TEMPID).select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, SOURCEROLE, PERMITEMID, TEMPID, ISDISABLED, ROLE_START_TIME, ROLE_END_TIME}).finish().filter("isdisabled<>1");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (disfunPerm != null) {
                if (object != null) {
                    try {
                        disfunPerm.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    disfunPerm.close();
                }
            }
        }
        result = result.addField("\"" + modelShowNumber + "\"", MODELNUMBER);
        if (!this.getSystemParam("enablepermvalidatetime")) {
            ArrayList fields = Lists.newArrayList((Object[])result.getRowMeta().getFieldNames());
            if (fields.contains(ROLE_START_TIME)) {
                result = result.removeFields(new String[]{ROLE_START_TIME});
            }
            if (fields.contains(ROLE_END_TIME)) {
                result = result.removeFields(new String[]{ROLE_END_TIME});
            }
        }
        return result;
    }

    private DataSet querySysPermByRole(Long modelId, List<String> roleIds, List<String> permIds, String appId, String modelShowNumber) {
        Throwable throwable;
        QFilter userRoleFilter = new QFilter(DIMTYPE, "=", (Object)BCM_MODEL);
        userRoleFilter.and(ROLE_BIZDOMAIN, "=", (Object)appId).and("role.enable", "=", (Object)"1");
        userRoleFilter.and(ORG, "=", (Object)modelId);
        if (roleIds != null) {
            userRoleFilter.and(ROLE_ID, "in", roleIds);
        }
        QFilter roleDetailFilter = new QFilter(ROLEPERM_BIZAPP, "=", (Object)appId);
        if (roleIds != null) {
            roleDetailFilter.and(ROLEID, "in", roleIds);
        }
        if (permIds != null) {
            roleDetailFilter.and("roleperm.permitem.id", "in", permIds);
        }
        DataSet result = null;
        HashSet<Long> userIds = new HashSet<Long>();
        String userRoleSelectFields = "id,role.id as roleid,role.name as rolename,role.number as rolenumber,role.remark as roleremark,user.id as userid,user.name as username,user.number as usernumber";
        try (DataSet userRole = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_USERROLE, (String)userRoleSelectFields, (QFilter[])new QFilter[]{userRoleFilter}, (String)"").select(new String[]{USERID, "username as sourceusername", "usernumber as sourceusernumber", ROLENAME, ROLENUMBER, ROLEID, ROLEREMARK});){
            throwable = null;
            try (DataSet rolePermDetail = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_ROLEPERM, (String)"id,roleperm.entity.name as entityname,roleperm.permitem.name as permitemname,roleperm.permitem.id as permitemid,roleperm.entity.number as entitynumber,roleid", (QFilter[])new QFilter[]{roleDetailFilter}, (String)"");){
                for (Row row : userRole.copy()) {
                    userIds.add(row.getLong(USERID));
                }
                this.checkCount(userIds.size(), (boolean)Boolean.FALSE);
                DataSet userRoleDetail = userRole.join(rolePermDetail, JoinType.INNER).on(ROLEID, ROLEID).select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLEID, ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, TEMPIDEXPRESSION}).finish().distinct();
                this.checkCount(userRoleDetail, (boolean)Boolean.TRUE);
                result = userRoleDetail;
            }
            catch (Throwable userRoleDetail) {
                throwable = userRoleDetail;
                throw userRoleDetail;
            }
        }
        QFilter disfunFilter = new QFilter(DIMTYPE, "=", (Object)BCM_MODEL);
        disfunFilter.and(BIZAPP, "=", (Object)appId);
        if (modelId != 0L) {
            disfunFilter.and(ORG, "=", (Object)modelId);
        }
        if (userIds.size() > 0) {
            disfunFilter.and(USER_ID, "in", userIds);
        }
        if (permIds != null) {
            disfunFilter.and(PERMITEM_ID, "in", permIds);
        }
        String disFunPermSelectFields = "id,user.id as userid,user.name as username,user.number as usernumber,entitytype.name as entityname,permitem.name as permitemname,entitytype.number as entitynumber,permitem.id as permitemid";
        throwable = null;
        try (DataSet disfunPerm = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)PERM_DISFUNPERM, (String)disFunPermSelectFields, (QFilter[])new QFilter[]{disfunFilter}, (String)"").distinct().select(new String[]{USERID, USERNAME, USERNUMBER, ENTITYNAME, PERMITEMNAME, PERMITEMIDEXPRESSION, TEMPIDEXPRESSION}).addField("1", ISDISABLED);){
            int mCount = disfunPerm.copy().count(USERID, Boolean.TRUE.booleanValue());
            if (mCount > 0) {
                this.checkCount(mCount, (boolean)Boolean.TRUE);
                result = result.select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLENAME, ROLEID, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID, TEMPID});
                result = result.leftJoin(disfunPerm).on(TEMPID, TEMPID).select(new String[]{USERID, SOURCEUSERNAME, SOURCEUSERNUMBER, ROLEID, ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID, TEMPID, "roleid+'_'+permitemid as newtempid", ISDISABLED}).finish().filter("isdisabled<>1");
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        result = result.distinct().groupBy(new String[]{ROLENAME, ROLENUMBER, ROLEREMARK, ENTITYNAME, PERMITEMNAME, PERMITEMID}).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEUSERNAME, SOURCEUSERNAME).agg((CustomAggFunction)new GroupConcat(SEPARATOR), SOURCEUSERNUMBER, SOURCEUSERNUMBER).finish().addField("\"" + modelShowNumber + "\"", MODELNUMBER);
        return result;
    }

    private DataSet returnEmptyDataSet() {
        ArrayList coll = new ArrayList();
        String[] columns = new String[]{};
        DataType[] dataTypes = new DataType[]{};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columns, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet result = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        return result;
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getLong(ID));
        }
        return idList;
    }

    private List<String> getIdStirngList(DynamicObjectCollection objList) {
        ArrayList<String> idList = new ArrayList<String>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getString(ID));
        }
        return idList;
    }

    private void checkCount(DataSet ds, boolean isAdd) {
        RowMeta rowMeta = ds.getRowMeta();
        if (rowMeta.getFields().length > 0) {
            int count = ds.copy().count(ds.getRowMeta().getField(0).getName(), Boolean.FALSE.booleanValue());
            this.checkCount(count, isAdd);
        }
    }

    private void checkCount(int count, boolean isAdd) {
        this.maxCountHandler();
        if (count > this.maxCount) {
            this.throwCountOutErr(count, this.maxCount);
        }
        if (isAdd) {
            this.resCount += count;
        }
        if (this.resCount > this.maxCount) {
            this.throwCountOutErr(this.resCount, this.maxCount);
        }
    }

    private void maxCountHandler() {
        String textCfg;
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(textCfg = ConfigServiceHelper.getStringParamNoModel((String)"PSystemPermReportLimit"));
        if (isNum.matches()) {
            try {
                this.maxCount = Integer.parseInt(textCfg);
            }
            catch (Exception e) {
                log.error("\u5b57\u7b26\u4e32\u53c2\u6570\u5f3a\u8f6cInteger\u6570\u5b57\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5185\u5bb9\uff1a" + e.getMessage());
            }
        } else {
            log.error("\u53c2\u6570\u5185\u5bb9\u5305\u542b\u975e\u6570\u5b57");
        }
    }

    private void throwCountOutErr(int resCount, int maxCount) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u8bb0\u5f55\u8fc7\u591a\uff0c\u8bf7\u6dfb\u52a0\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u3002(\u5f53\u524d:%1$s,\u9650\u5236:%2$s)", (String)"SystemPermRptData_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), resCount, maxCount));
    }
}

