/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.UpgradeStatusUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class SystemPermRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String PERMITEMSEL = "permitemsel";
    private static final String USERS = "users";
    private static final String ID = "id";
    private static final String MODEL = "model";
    private static final String QUERYSELECT = "queryselect";
    private static final String BYUSER = "byuser";
    private static final String ISBYUSER = "isbyuser";
    private static final String ROLES = "roles";
    private static final String USER_ID = "user.id";
    private static final String BCM_MODEL = "bcm_model";
    private static final String ORG_ID = "org.id";
    private static final String ROLE_ENABLE = "role.enable";
    private static final String APPID = "appid";
    private static final String BYROLE = "byrole";
    private static final String REPORTLISTAP = "reportlistap";
    private static final String PERM_USERPERM = "perm_userperm";
    private static final String PERM_USERROLE = "perm_userrole";
    private static final String ROLE_ID = "role.id";
    private static final String TOOLBARAP = "toolbarap";
    private static final String DIMTYPEID = "dimtypeid";
    private static final String DIM_BCM_MODEL = "DIM_BCM_MODEL";
    private static final String UNIONREPORT = "unionreport";
    private static final String FUNCTIONPERMLOG = "functionpermlog";
    private static final String BCM_UNIONPERMREPORT = "bcm_unionperm_report";
    private static final String BCM_FUNCTIONPERM_LOG = "bcm_functionperm_log";
    private static final String ISINCLUDEALLSUB = "isIncludeAllSub";
    private static final String BIZDOMAIN = "bizdomain";
    private static final String FORMSHOWPARAM_DIMENSION = "FormShowParam_dimension";
    private static final String RPT = "rpt";
    private static final String REPORTTYPE = "ReportType";
    private static final String EXPORTEXCEL = "exportexcel";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ROLES});
        this.getModel().setValue(QUERYSELECT, (Object)BYUSER);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            return;
        }
        List<QFilter> modelFilter = this.getModelFilters();
        DynamicObjectCollection modelCollection = QueryServiceHelper.query((String)BCM_MODEL, (String)ID, (QFilter[])modelFilter.toArray(new QFilter[modelFilter.size()]));
        if (this.getIdList(modelCollection).contains(Long.parseLong(modelId))) {
            this.getModel().setValue(MODEL, (Object)Long.valueOf(modelId));
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        String queryselect = (String)this.getModel().getValue(QUERYSELECT);
        if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)queryselect)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{USERS});
            this.getView().setVisible(Boolean.FALSE, new String[]{ROLES});
        } else if (StringUtils.equals((CharSequence)BYROLE, (CharSequence)queryselect)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{USERS});
            this.getView().setVisible(Boolean.TRUE, new String[]{ROLES});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit permitemsel = (BasedataEdit)this.getControl(PERMITEMSEL);
        permitemsel.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit users = (BasedataEdit)this.getControl(USERS);
        users.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit roles = (BasedataEdit)this.getControl(ROLES);
        roles.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener(this::beforeF7Select);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)UNIONREPORT, (CharSequence)key)) {
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + BCM_UNIONPERMREPORT;
            if (mainPageView.getView(pageId) == null) {
                ReportShowParameter form = new ReportShowParameter();
                form.setFormId(BCM_UNIONPERMREPORT);
                form.setPageId(pageId);
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.getOpenStyle().setTargetKey("_submaintab_");
                form.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
                parentView.showForm((FormShowParameter)form);
                this.getView().sendFormAction(parentView);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        } else if (StringUtils.equals((CharSequence)FUNCTIONPERMLOG, (CharSequence)key)) {
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + BCM_FUNCTIONPERM_LOG;
            if (mainPageView.getView(pageId) == null) {
                FormShowParameter form = new FormShowParameter();
                form.setFormId(BCM_FUNCTIONPERM_LOG);
                form.setPageId(pageId);
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.getOpenStyle().setTargetKey("_submaintab_");
                parentView.showForm(form);
                this.getView().sendFormAction(parentView);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String appId;
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && StringUtils.isNotEmpty((CharSequence)(appId = AppMetadataCache.getAppInfo((String)appNumber).getId()))) {
            customParam.put(APPID, appId);
        }
        customParam.put(ISBYUSER, this.getModel().getValue(QUERYSELECT));
        queryParam.setCustomParam(customParam);
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>(objList.size());
        for (DynamicObject object : objList) {
            idList.add(object.getLong(ID));
        }
        return idList;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        if (StringUtils.isEmpty((CharSequence)filterInfo.getString(MODEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId()) || StringUtils.isEmpty((CharSequence)AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"appid\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5\u3002", (String)"SystemPermRptPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getPageCache().put(MODEL, ((DynamicObject)filterInfo.getValue(MODEL)).getString(ID));
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            String modelId;
            this.getModel().setValue(USERS, null);
            this.getModel().setValue(ROLES, null);
            this.getModel().setValue(PERMITEMSEL, null);
            if (this.getModel().getValue(MODEL) != null && StringUtils.isNotEmpty((CharSequence)(modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getString(ID)))) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), modelId);
            }
        }
        if (StringUtils.equals((CharSequence)QUERYSELECT, (CharSequence)key)) {
            String queryselect = (String)this.getModel().getValue(QUERYSELECT);
            if (StringUtils.equals((CharSequence)BYUSER, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ROLES});
            } else if (StringUtils.equals((CharSequence)BYROLE, (CharSequence)queryselect)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USERS});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ROLES});
            }
            ItemClickEvent itemClickEvent = new ItemClickEvent((Object)((Toolbar)this.getView().getControl(TOOLBARAP)), "refresh", "refresh");
            this.itemClick(itemClickEvent);
            this.getControl(REPORTLISTAP).getView().updateView();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((BasedataEdit)event.getSource()).getKey();
        if (PERMITEMSEL.equals(key)) {
            Map permitem = BcmPermSingleModel.getInstance().getPermitem();
            HashSet<String> bcmItemId = new HashSet<String>(permitem.size());
            for (Map permItems : permitem.values()) {
                for (String permItem : permItems.values()) {
                    if (permItem.split("@").length <= 1) continue;
                    bcmItemId.add(permItem.split("@")[1]);
                }
            }
            QFilter qFilter = new QFilter(ID, "in", bcmItemId);
            event.addCustomQFilter(qFilter);
        } else if (MODEL.equals(key)) {
            if (StringUtils.isNotEmpty((CharSequence)MODEL) && this.getControl(MODEL) != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                List<QFilter> qFilterList = this.getModelFilters();
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else if (USERS.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            event.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            DynamicObjectCollection permUserperm = QueryServiceHelper.query((String)PERM_USERPERM, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(ORG_ID, "=", (Object)modelId)});
            HashSet<Long> userIds = new HashSet<Long>(16);
            for (Object dy : permUserperm) {
                userIds.add(dy.getLong(USER_ID));
            }
            DynamicObjectCollection permUserrole = QueryServiceHelper.query((String)PERM_USERROLE, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(ORG_ID, "=", (Object)modelId)});
            for (DynamicObject dy2 : permUserrole) {
                userIds.add(dy2.getLong(USER_ID));
            }
            QFilter qFilter3 = new QFilter(ID, "in", userIds);
            ArrayList<QFilter> qfList2 = new ArrayList<QFilter>(1);
            qfList2.add(qFilter3);
            event.setCustomQFilters(qfList2);
            event.getFormShowParameter().setCustomParam(ISINCLUDEALLSUB, (Object)true);
        } else if (ROLES.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SystemPermRptPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            ArrayList<QFilter> qfList4 = new ArrayList<QFilter>(1);
            qfList4.add(new QFilter(BIZDOMAIN, "=", (Object)AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId()));
            qfList4.add(new QFilter(DIMTYPEID, "in", (Object)DIM_BCM_MODEL));
            event.setCustomQFilters(qfList4);
            event.getFormShowParameter().setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            event.getFormShowParameter().setCustomParam(FORMSHOWPARAM_DIMENSION, (Object)BCM_MODEL);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (this.getModel().getValue(MODEL) != null) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.QUERY.getName(), (String)(OpItemEnum.QUERY.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)EXPORTEXCEL, (CharSequence)key)) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.EXPORTEXCEL.getName(), (String)(OpItemEnum.EXPORTEXCEL.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)Long.valueOf(this.getPageCache().get(MODEL)));
        }
    }

    private List<QFilter> getModelFilters() {
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        QFilter qf = kd.fi.bcm.business.dimension.util.ModelUtil.getModelQfilterByApp((IFormView)this.getView());
        if (StringUtils.equals((CharSequence)RPT, (CharSequence)this.getView().getFormShowParameter().getAppId())) {
            qf = qf.or(REPORTTYPE, "=", (Object)"1");
        }
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        QFilter upgradedid = new QFilter(ID, "in", (Object)UpgradeStatusUtil.getUpgradesModelIds());
        modelQFilters.add(upgradedid);
        QFilter superid = new QFilter(ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        modelQFilters.add(superid);
        qFilterList.addAll(modelQFilters);
        return qFilterList;
    }
}

