/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.perm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.perm.BcmUnionPermPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class UnionPermCommon {
    private UnionPermCommon() {
        throw new IllegalStateException(ResManager.loadKDString((String)"%s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"FormPluginConstant_0", (String)"fi-bcm-formplugin", (Object[])new Object[]{"UnionPermCommon"}));
    }

    public static Long getUnionPermId(String[] perm, ApplicationTypeEnum applicationTypeEnum) {
        TreeNode tree = UnionPermCommon.getTreeNodeForCache(applicationTypeEnum);
        return UnionPermCommon.bcmUnionPermId(tree, perm);
    }

    private static Long bcmUnionPermId(TreeNode treeNode, String[] perm) {
        Object data = treeNode.getData();
        if (data instanceof DynamicObject) {
            DynamicObject dyData = (DynamicObject)data;
            if (StringUtil.equals((String)perm[0], (String)((String)dyData.get("entitynumber"))) && StringUtil.equals((String)perm[1], (String)((String)dyData.get("permitemid")))) {
                return (Long)dyData.get("id");
            }
        } else {
            List children = treeNode.getChildren();
            for (TreeNode child : children) {
                Long unionPermId = UnionPermCommon.bcmUnionPermId(child, perm);
                if (unionPermId == null) continue;
                return unionPermId;
            }
        }
        return null;
    }

    public static DynamicObjectCollection getPermClassId(String entityName, Long modelId, Set<Long> entityIds, String bizAppId) {
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("entityid", "in", entityIds).and("entityname", "=", (Object)entityName);
        String permClassEntity = "bcm_permclass_entity";
        return QueryServiceHelper.query((String)permClassEntity, (String)"permclass.id", (QFilter[])range.toArray());
    }

    public static DynamicObject[] getUserAllPermission(Long permClassId, Long modelId, Long userId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(modelId));
        if (adminUserBol) {
            return new DynamicObject[0];
        }
        HashSet<String> users = new HashSet<String>();
        QFilter qf = new QFilter("user", "=", (Object)userId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
        Set groupIds = dys.stream().map(dy -> dy.getString("usergroup.id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(groupIds)) {
            users.addAll(PermClassEntityHelper.getRelGroupIds(groupIds));
        }
        users.add(String.valueOf(userId));
        Long[] allUser = new Long[users.size()];
        int i = 0;
        for (String user : users) {
            allUser[i++] = Long.valueOf(user);
        }
        StringJoiner selectFieldsJoiner = new StringJoiner(",").add("id").add("users").add(new StringJoiner(".").add("entryentity").add("unionpermid").toString()).add(new StringJoiner(".").add("entryentity").add("ischeck").toString());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("users", "in", (Object)allUser));
        filter.and(new QFilter(new StringJoiner(".").add("authclass").add("id").toString(), "=", (Object)permClassId));
        return BusinessDataServiceHelper.load((String)"bcm_auth_info", (String)selectFieldsJoiner.toString(), (QFilter[])filter.toArray());
    }

    public static TreeNode getTreeNodeForCache(ApplicationTypeEnum applicationTypeEnum) {
        return (TreeNode)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(BcmUnionPermPlugin.BcmUnionPermTree.getEntityName() + applicationTypeEnum.getAppnum()), () -> {
            TreeNode root = UnionPermCommon.createRoot();
            DynamicObject[] permTrees = UnionPermCommon.getPermTrees(applicationTypeEnum);
            if (permTrees == null || permTrees.length == 0) {
                return root;
            }
            List<CloudNode> rows = UnionPermCommon.getCloudNodes(applicationTypeEnum);
            Map<String, String> allAppIdNameMap = UnionPermCommon.getAllAppIdNameMap();
            for (CloudNode row : rows) {
                TreeNode cloudNode = new TreeNode("root#tree", row.getCloudId(), row.getCloudName(), true);
                cloudNode.setIsOpened(true);
                root.addChild(cloudNode);
                String appName = allAppIdNameMap.get(row.getAppId());
                TreeNode appNode = new TreeNode(row.getCloudId(), row.getAppId(), appName, true);
                appNode.setIsOpened(true);
                cloudNode.addChild(appNode);
                HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
                for (DynamicObject perm : permTrees) {
                    String parentNodeId2 = perm.getString("entitynumber");
                    ILocaleString localeString = perm.getLocaleString("nodename");
                    String nodeName = (String)localeString.get((Object)RequestContext.get().getLang().name());
                    if ("0".equals(perm.getString("permitemid"))) {
                        TreeNode treeNode = UnionPermCommon.getTreeNodeById(nodeMap, parentNodeId2);
                        treeNode.setText(nodeName);
                        treeNode.setIsOpened(true);
                        continue;
                    }
                    TreeNode newNode = new TreeNode(parentNodeId2, perm.getString("id"), nodeName, (Object)perm);
                    TreeNode parentNode2 = UnionPermCommon.getTreeNodeById(nodeMap, parentNodeId2);
                    parentNode2.addChild(newNode);
                }
                nodeMap.forEach((parentNodeId, parentNode) -> {
                    if (parentNode.getChildren() != null && parentNode.getIsOpened()) {
                        parentNode.setParentid(appNode.getId());
                        appNode.addChild(parentNode);
                    }
                });
            }
            return root;
        });
    }

    @NotNull
    private static TreeNode getTreeNodeById(Map<String, TreeNode> nodeMap, String id) {
        return nodeMap.computeIfAbsent(id, key -> new TreeNode(null, id, null, true));
    }

    public static DynamicObject[] getPermTrees(ApplicationTypeEnum applicationTypeEnum) {
        StringJoiner selectFieldJoiner = new StringJoiner(",").add("id").add("permitemid").add("entitynumber").add("nodename");
        QFBuilder qfBuilder = new QFBuilder().add(new QFilter("appnumber", "=", (Object)applicationTypeEnum.getAppnum()));
        return BusinessDataServiceHelper.load((String)BcmUnionPermPlugin.BcmUnionPermTree.getEntityName(), (String)selectFieldJoiner.toString(), (QFilter[])qfBuilder.toArray());
    }

    private static List<CloudNode> getCloudNodes(ApplicationTypeEnum applicationTypeEnum) {
        DataSet appDataSet = UnionPermCommon.getAppName(applicationTypeEnum.getAppnum());
        ArrayList<CloudNode> rows = new ArrayList<CloudNode>(8);
        while (appDataSet.hasNext()) {
            Row row = appDataSet.next();
            CloudNode cloudNode = new CloudNode(row.getString("cloud_id"), row.getString("cloud_name"), row.getInteger("cloud_seq"), row.getString("app_id"), row.getString("app_number"));
            rows.add(cloudNode);
        }
        Collections.sort(rows);
        return rows;
    }

    private static TreeNode createRoot() {
        String roleName = ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650", (String)"UnionPermCommon_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        return new TreeNode("", "root#tree", roleName, true);
    }

    private static DataSet getAppName(String app) {
        String langStr = RequestContext.get().getLang().name();
        StringBuilder sb = new StringBuilder(1400).append("select cloudl.fid cloud_id, cloudl.fname cloud_name, cloud.fseq cloud_seq, ").append(" app.FID app_id, app.fnumber app_number ").append(" from t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" WHERE NOT EXISTS (SELECT 1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) AND appr.falluserapp = '1')").append(" AND app.fdeploystatus = '2' ").append(" and app.fnumber = '").append(app).append("' ");
        return DB.queryDataSet((String)"kd.fi.bcm.common.cache.business.UnionPermTree.getAppName", (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr});
    }

    private static Map<String, String> getAllAppIdNameMap() {
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        if (null == allBizApps || allBizApps.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        List allParentIds = allBizApps.stream().map(dobj -> dobj.getString("parentid")).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>(allBizApps.size());
        allBizApps.stream().filter(x -> !allParentIds.contains(x.getString("id"))).forEach(dobj -> {
            String id = dobj.getString("id");
            String name = dobj.getString("name");
            String masterId = dobj.getString("masterid");
            if (StringUtils.isEmpty((String)masterId)) {
                map.put(id, name);
            } else {
                map.put(masterId, name);
            }
        });
        return map;
    }

    static class CloudNode
    implements Comparable<CloudNode> {
        private String cloudId;
        private String cloudName;
        private Integer cloudSeq;
        private String appId;
        private String appNumber;

        CloudNode(String cloudId, String cloudName, Integer cloudSeq, String appId, String appNumber) {
            this.cloudId = cloudId;
            this.cloudName = cloudName;
            this.cloudSeq = cloudSeq;
            this.appId = appId;
            this.appNumber = appNumber;
        }

        @Override
        public int compareTo(CloudNode o) {
            return this.cloudSeq - o.getCloudSeq();
        }

        public String getCloudId() {
            return this.cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public Integer getCloudSeq() {
            return this.cloudSeq;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppNumber() {
            return this.appNumber;
        }
    }
}

