/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.BcmDMLServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.SystemSeparatorChar;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.GrantPermUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataAuthAddPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    public static final String USERENTRY = "userentry";
    public static final String AUTHENTRY = "authentry";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String SHOWNUMBER = "shownumber";
    public static final String BTN_OK = "btn_ok";
    public static final String MODEL = "model";
    public static final String FIDMMODEL = "fidmmodel";
    public static final String MODELTYPE = "fidmmodeltype";
    public static final String APP = "app";
    private static final String MID = "mid";
    private static final String USERS = "users";
    private static final String USERS_ID = "users.id";
    private static final String USERTYPE = "usertype";
    private static final String EUSERS = "eusers";
    private static final String ETYPE = "etype";
    private static final String DATA_AUTH = "data_auth";
    private static final String AUTHCLASS = "authclass";
    private static final String AUTHCLASS_ID = "authclass.id";
    private static final String NUMBER = "number";
    private static final String REMARK = "remark";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap", "advcontoolbarap1", "addusergroup", "adduser", "deluser", "selectauth", "delauth");
        this.addClickListeners(BTN_OK);
        BasedataEdit user = (BasedataEdit)this.getControl("baseuser");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl("baseusergroup");
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit auth = (BasedataEdit)this.getControl("baseauth");
        auth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        String parFormId = parameter.getParentFormId();
        long modelId = parFormId.startsWith("bcm") ? LongUtil.toLong((Object)parameter.getCustomParam(MODEL)) : LongUtil.toLong((Object)parameter.getCustomParam(FIDMMODEL));
        if (modelId == 0L) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseauth"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MID});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseuser"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseusergroup"});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_ok": {
                this.saveData();
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl("baseusergroup");
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl("baseuser");
                user.click();
                break;
            }
            case "deluser": {
                EntryGrid userentry = (EntryGrid)this.getView().getControl(USERENTRY);
                int[] selectRows = userentry.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DataAuthAddPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().deleteEntryRows(USERENTRY, selectRows);
                break;
            }
            case "selectauth": {
                MulBasedataEdit auth = (MulBasedataEdit)this.getControl("baseauth");
                auth.click();
                break;
            }
            case "delauth": {
                EntryGrid authentry = (EntryGrid)this.getView().getControl(AUTHENTRY);
                int[] select = authentry.getSelectRows();
                if (select.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DataAuthAddPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().deleteEntryRows(AUTHENTRY, select);
                break;
            }
        }
    }

    private void saveData() {
        block12: {
            DynamicObject model;
            Long modelId;
            List<DynamicObject> userList = this.getEntrySelectedAndResultList(USERENTRY);
            List<DynamicObject> authList = this.getEntrySelectedAndResultList(AUTHENTRY);
            if (userList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7528\u6237\u7ec4/\u7528\u6237\u3002", (String)"DataAuthAddPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (authList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6743\u9650\u7c7b\u3002", (String)"DataAuthAddPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String selectFields = "users,authclass,usertype,authclass.number";
            QFBuilder authInfoFilter = new QFBuilder();
            if (this.isFIDMorFAR()) {
                modelId = (Long)this.getView().getFormShowParameter().getCustomParam(FIDMMODEL);
                model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"fidm_model");
                authInfoFilter.add(new QFilter(FIDMMODEL, "=", (Object)modelId));
                authInfoFilter.add(new QFilter("authclass.app", "=", (Object)this.getView().getFormShowParameter().getAppId()));
            } else {
                modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODEL);
                model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
                authInfoFilter.add(new QFilter(MODEL, "=", (Object)modelId));
            }
            authInfoFilter.and(USERS_ID, "in", userList.stream().filter(u -> Objects.nonNull(u.getDynamicObject(EUSERS)) && !Objects.equals(u.getDynamicObject(EUSERS).getLong(ID), 0L)).map(u -> u.getDynamicObject(EUSERS).getLong(ID)).collect(Collectors.toSet()));
            authInfoFilter.and(AUTHCLASS_ID, "in", authList.stream().map(a -> a.getLong(MID)).collect(Collectors.toSet()));
            DynamicObjectCollection authorizedFromDB = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])authInfoFilter.toArray());
            Set<String> dataAuthRepeatKey = authorizedFromDB.stream().map(d -> String.join((CharSequence)SystemSeparatorChar.S_SPLIT.toString(), d.getString(USERS), d.getString(AUTHCLASS), d.getString(USERTYPE))).collect(Collectors.toSet());
            List<DynamicObject> authorityList = this.buildApprovalAuthority(userList, authList, dataAuthRepeatKey);
            String authComb = authList.stream().map(auth -> auth.getString(NUMBER)).collect(Collectors.joining(" "));
            String opName = ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"DataAuthAddPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            try {
                BcmDMLServiceHelper.batchSave(authorityList);
                if (Objects.nonNull(model)) {
                    String modelNumber = this.isFIDMorFAR() ? model.getString(NUMBER) : model.getString(SHOWNUMBER);
                    List opDes = userList.stream().map(user -> {
                        if ("bos_user".equals(user.getString(ETYPE))) {
                            return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthAddPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelNumber, model.getString(NAME), user.getDynamicObject(EUSERS).getString(NAME), authComb);
                        }
                        return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthAddPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelNumber, model.getString(NAME), user.getDynamicObject(EUSERS).getString(NAME), authComb);
                    }).collect(Collectors.toList());
                    OperationLogUtil.batchWriteOperationLog((String)opName, opDes, null, (String)"bcm_data_auth_new");
                }
                HashMap<Long, String> users = new HashMap<Long, String>(userList.size());
                HashMap<Long, String> auths = new HashMap<Long, String>(authList.size());
                for (DynamicObject user2 : userList) {
                    users.put(user2.getLong("eusers.id"), user2.getString("eusers.number"));
                }
                for (DynamicObject member : authList) {
                    auths.put(member.getLong(MID), member.getString(NUMBER));
                }
                if (!this.isFIDMorFAR()) {
                    String bizAppId = this.getBizAppId();
                    ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(authList.size());
                    for (DynamicObject dynamicObject : authorityList) {
                        String permClassNumber = (String)auths.get(dynamicObject.getLong(AUTHCLASS));
                        DynamicObject log = DataPermLogHelper.newDataPermControlLog((Long)dynamicObject.getLong(MODEL), (String)"3", (String)permClassNumber, (String)DataPermLogMultiLangEnum.DataPerm_AddNew.getOperateName(), (String)((String)users.get(dynamicObject.getLong(USERS))), (String)dynamicObject.getString("username"), (String)bizAppId);
                        logs.add(log);
                    }
                    if (logs.size() > 0) {
                        DataPermLogHelper.batchInsertDataPermLog(logs);
                    }
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
                if (!Objects.nonNull(model)) break block12;
                String modelNumber = this.isFIDMorFAR() ? model.getString(NUMBER) : model.getString(SHOWNUMBER);
                List opDes = userList.stream().map(user -> {
                    if ("bos_user".equals(user.getString(ETYPE))) {
                        return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DataAuthAddPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelNumber, model.getString(NAME), user.getDynamicObject(EUSERS).getString(NAME), authComb);
                    }
                    return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DataAuthAddPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelNumber, model.getString(NAME), user.getDynamicObject(EUSERS).getString(NAME), authComb);
                }).collect(Collectors.toList());
                OperationLogUtil.batchWriteOperationLog((String)opName, opDes, null, (String)"bcm_analysishelper");
            }
        }
        this.getView().close();
    }

    private List<DynamicObject> buildApprovalAuthority(List<DynamicObject> userList, List<DynamicObject> authList, Set<String> dataAuthRepeatKey) {
        ArrayList authorityList = Lists.newArrayListWithCapacity((int)userList.size());
        for (DynamicObject user : userList) {
            DynamicObject userEt = user.getDynamicObject(EUSERS);
            if (!Objects.nonNull(userEt) || Objects.equals(userEt.getPkValue(), 0L)) continue;
            for (DynamicObject auth : authList) {
                Long modelId;
                if (dataAuthRepeatKey.contains(String.join((CharSequence)SystemSeparatorChar.S_SPLIT.toString(), user.getDynamicObject(EUSERS).getPkValue().toString(), auth.getString(MID), user.getString(ETYPE)))) continue;
                DynamicObject approvalauthority = BusinessDataServiceHelper.newDynamicObject((String)"bcm_auth_info");
                approvalauthority.set(USERS, user.getDynamicObject(EUSERS).getPkValue());
                approvalauthority.set(USERTYPE, (Object)user.getString(ETYPE));
                approvalauthority.set("username", (Object)user.getDynamicObject(EUSERS).getString(NAME));
                approvalauthority.set(AUTHCLASS, (Object)auth.getLong(MID));
                if (this.isFIDMorFAR()) {
                    modelId = (Long)this.getView().getFormShowParameter().getCustomParam(FIDMMODEL);
                    approvalauthority.set(FIDMMODEL, (Object)modelId);
                } else {
                    modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODEL);
                    approvalauthority.set(MODEL, (Object)modelId);
                }
                approvalauthority.set(DATA_AUTH, (Object)auth.getInt(DATA_AUTH));
                authorityList.add(approvalauthority);
            }
        }
        return authorityList;
    }

    private List<DynamicObject> getEntrySelectedAndResultList(String entityid) {
        return this.getModel().getEntryEntity(entityid);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (!"baseuser".equals(name) && !"baseusergroup".equals(name)) {
            super.beforeF7Select(evt);
        }
        if ("baseuser".equals(name) || "baseusergroup".equals(name)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, name);
            evt.getFormShowParameter().setCloseCallBack(closeCallBack);
            evt.getFormShowParameter().setHasRight(true);
            evt.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
        if ("baseauth".equals(name)) {
            QFilter qFilter;
            ArrayList afList = Lists.newArrayListWithExpectedSize((int)10);
            if (this.isFIDMorFAR()) {
                qFilter = new QFilter(FIDMMODEL, "=", (Object)Long.valueOf(this.getView().getFormShowParameter().getCustomParam(FIDMMODEL).toString()));
                QFilter appFilter = new QFilter(APP, "=", (Object)this.getView().getFormShowParameter().getAppId());
                afList.add(qFilter);
                afList.add(appFilter);
            } else {
                qFilter = new QFilter(MODEL, "=", (Object)Long.valueOf(this.getView().getFormShowParameter().getCustomParam(MODEL).toString()));
                if (ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm") && !PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL).toString())).isAdmin()) {
                    Set<Long> permClass = GrantPermUtil.getPermClass(Long.valueOf(this.getView().getFormShowParameter().getCustomParam(MODEL).toString()));
                    if (CollectionUtils.isNotEmpty(permClass)) {
                        afList.add(new QFilter(ID, "in", permClass));
                    } else {
                        afList.add(new QFilter("1", "!=", (Object)1));
                    }
                }
                afList.add(qFilter);
            }
            evt.setCustomQFilters((List)afList);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, name);
            evt.getFormShowParameter().setCloseCallBack(closeCallBack);
            evt.getFormShowParameter().setHasRight(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setDataEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_user", USERENTRY);
                break;
            }
            case "baseusergroup": {
                this.setDataEntry((ListSelectedRowCollection)evt.getReturnData(), "bos_usergroup", USERENTRY);
                break;
            }
            case "baseauth": {
                this.setDataEntry((ListSelectedRowCollection)evt.getReturnData(), "bcm_permissionclass", AUTHENTRY);
            }
        }
    }

    private void setDataEntry(ListSelectedRowCollection returnData, String baseType, String dataType) {
        if (returnData == null) {
            return;
        }
        IDataModel model = this.getModel();
        EntryGrid userentry = (EntryGrid)this.getControl(dataType);
        int[] selectRows = userentry.getSelectRows();
        ArrayList<Object> oids = this.getOldDisNumbers(dataType);
        HashSet<Integer> listRows = new HashSet<Integer>(returnData.size());
        boolean isUserEntry = Objects.equals(dataType, USERENTRY);
        HashMap permClassIdWithNumberName = isUserEntry ? new HashMap(1) : QueryServiceHelper.query((String)"bcm_permissionclass", (String)"id,number,remark", (QFilter[])new QFBuilder(ID, "in", returnData.stream().map(p -> ConvertUtil.convertObjToLong((Object)p.getPrimaryKeyValue())).collect(Collectors.toList())).toArray()).stream().collect(Collectors.toMap(p -> p.getLong(ID), p -> Pair.onePair((Object)p.getString(NUMBER), (Object)p.getString(REMARK))));
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(dataType);
        for (ListSelectedRow row : returnData) {
            if (oids.contains(row.getPrimaryKeyValue())) continue;
            DynamicObject dynamicObject = entryEntity.addNew();
            if (isUserEntry) {
                dynamicObject.set(ETYPE, (Object)baseType);
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)baseType);
                user.set(ID, row.getPrimaryKeyValue());
                user.set(NAME, (Object)row.getName());
                dynamicObject.set(EUSERS, (Object)user);
            } else {
                Pair permClassNumberName = (Pair)permClassIdWithNumberName.get(ConvertUtil.convertObjToLong((Object)row.getPrimaryKeyValue()));
                dynamicObject.set(NUMBER, permClassNumberName.p1);
                dynamicObject.set(REMARK, permClassNumberName.p2);
                dynamicObject.set(DATA_AUTH, (Object)1);
                dynamicObject.set(MID, row.getPrimaryKeyValue());
            }
            listRows.add(entryEntity.size() - 1);
        }
        this.getView().updateView(dataType);
        this.setDefaultSelectRows(userentry, listRows, selectRows);
    }

    private ArrayList<Object> getOldDisNumbers(String dataType) {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
        this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(dataType).forEach(p -> {
            if (USERENTRY.equals(dataType)) {
                DynamicObject eusers = p.getDynamicObject(EUSERS);
                if (Objects.nonNull(eusers) && !Objects.equals(eusers.getPkValue(), 0L)) {
                    ids.add(eusers.getPkValue());
                }
            } else {
                ids.add(p.getLong(MID));
            }
        });
        return ids;
    }

    private void setDefaultSelectRows(EntryGrid entryGrid, Set<Integer> listRows, int[] selectRows) {
        for (int selectRow : selectRows) {
            listRows.add(selectRow);
        }
        if (listRows.size() == 0) {
            return;
        }
        int[] rows = new int[listRows.size()];
        int index = 0;
        for (Integer row : listRows) {
            rows[index++] = row;
        }
        entryGrid.selectRows(rows, rows[0]);
    }

    private String getModelEntity() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        if ("2".equals(modeltype)) {
            return "epm_model";
        }
        return "bcm_model";
    }

    private boolean isFIDMorFAR() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FIDM.appnum, appId) || Objects.equals(ApplicationTypeEnum.FAR.appnum, appId);
    }
}

