/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.DataAuthUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.GrantPermUtil;

public class DataAuthAssignPlugin
extends AbstractBaseListPlugin {
    public static final String BTN_CONFIRM = "confirm";
    private static final String RADIOGROUP = "radiogroup";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String USERS_NAME = "users.name";
    private static final String DATA_AUTH = "data_auth";
    private static final String selectFields = "id,users.number,users.name,usertype,data_auth,authclass.number,authclass.id,level1,level2,level3,level4,level5,level6,level7,level8,level9,level10,level11,level12";
    private static final DynamicObject[] nullDyobjAry = new DynamicObject[0];
    private static final Map<String, String> dataAuthVO2LogMap = ImmutableMap.of((Object)"1", (Object)"3", (Object)"2", (Object)"2", (Object)"3", (Object)"1");

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (Objects.equals(appId, ApplicationTypeEnum.RPT.getAppnum())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        } else {
            Object[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)((Long)this.getFormCustomParam("model")));
            if (approvalInfo.length >= 2 && approvalInfo.length <= 12) {
                for (int i = approvalInfo.length - 2; i < 10; ++i) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"level" + (i + 1)});
                }
            }
            this.getPageCache().put("data", Arrays.toString(approvalInfo));
            this.buildPage((DynamicObject[])approvalInfo);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "confirm": {
                this.actionSave();
                break;
            }
        }
    }

    private void buildPage(DynamicObject[] approvalInfo) {
        for (int i = 1; i <= approvalInfo.length - 2; ++i) {
            Label label = (Label)this.getView().getControl("label" + i);
            label.setText(approvalInfo[i - 1].getString(NAME));
        }
        Label commit = (Label)this.getView().getControl("label11");
        commit.setText(approvalInfo[approvalInfo.length - 2].getString(NAME));
        Label repulse = (Label)this.getView().getControl("label12");
        repulse.setText(approvalInfo[approvalInfo.length - 1].getString(NAME));
    }

    private void actionSave() {
        boolean optRes;
        List ids = (List)this.getFormCustomParam("ids");
        long modelId = (Long)this.getFormCustomParam(this.getModelSign());
        DynamicObject[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)modelId);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(10);
        QFBuilder qfb = new QFBuilder(this.getModelSign(), "=", (Object)modelId);
        qfb.and(ID, "in", (Object)ids);
        DynamicObject[] authInfos = BusinessDataServiceHelper.load((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfb.toArray());
        ArrayList dALogs = Lists.newArrayListWithExpectedSize((int)ids.size());
        ArrayList dAOptLogs = Lists.newArrayListWithExpectedSize((int)ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            int j;
            StringBuilder logs = new StringBuilder();
            DynamicObject updateObject = authInfos[i];
            Object usertype = updateObject.get("usertype");
            if ("bos_user".equals(usertype)) {
                logs.append(OpItemEnum.USER.getName());
            } else {
                logs.append(OpItemEnum.USERGROUP.getName());
            }
            logs.append(" ");
            logs.append(updateObject.getString(USERS_NAME));
            logs.append(" ");
            logs.append(OpItemEnum.PERMCLASS.getName());
            logs.append(" ");
            DynamicObject authclass = (DynamicObject)updateObject.get("authclass");
            String authClassNumber = authclass.getString(NUMBER);
            logs.append(authClassNumber);
            logs.append(" ");
            logs.append(OpItemEnum.DATAPERM.getName());
            String dataAuth = (String)this.getValue(RADIOGROUP);
            if (!Objects.equals(dataAuth, updateObject.getString(DATA_AUTH))) {
                dALogs.add(DataPermLogHelper.newDataPermControlLog((Long)modelId, (String)dataAuthVO2LogMap.get(dataAuth), (String)updateObject.getString("authclass.number"), (String)DataPermLogMultiLangEnum.DataPerm_MODIFY.getOperateName(), (String)updateObject.getString("users.number"), (String)updateObject.getString(USERS_NAME), (String)this.getBizAppId()));
                updateObject.set(DATA_AUTH, (Object)dataAuth);
            }
            if ("2".equals(dataAuth)) {
                logs.append(OpItemEnum.READ.getName());
            } else if ("1".equals(dataAuth)) {
                logs.append(OpItemEnum.WRITE.getName());
            } else if ("3".equals(dataAuth)) {
                logs.append(OpItemEnum.NOPERM.getName());
            }
            for (j = 0; j < approvalInfo.length; ++j) {
                String value;
                logs.append(" ");
                logs.append(approvalInfo[j].getString(NAME));
                if (j == approvalInfo.length - 2) {
                    value = (String)this.getValue("radiogroup11");
                    if (2 == Integer.parseInt(value)) {
                        updateObject.set("level11", (Object)approvalInfo[j].getLong(ID));
                        logs.append(OpItemEnum.SELECT.getName());
                        continue;
                    }
                    if (1 == Integer.parseInt(value)) {
                        logs.append(OpItemEnum.IGNORE.getName());
                        continue;
                    }
                    updateObject.set("level11", null);
                    logs.append(OpItemEnum.NOSELECT.getName());
                    continue;
                }
                if (j == approvalInfo.length - 1) {
                    value = (String)this.getValue("radiogroup12");
                    if (2 == Integer.parseInt(value)) {
                        updateObject.set("level12", (Object)approvalInfo[j].getLong(ID));
                        logs.append(OpItemEnum.SELECT.getName());
                        continue;
                    }
                    if (1 == Integer.parseInt(value)) {
                        logs.append(OpItemEnum.IGNORE.getName());
                        continue;
                    }
                    updateObject.set("level12", null);
                    logs.append(OpItemEnum.NOSELECT.getName());
                    continue;
                }
                value = (String)this.getValue(RADIOGROUP + (j + 1));
                if (2 == Integer.parseInt(value)) {
                    updateObject.set("level" + (j + 1), (Object)approvalInfo[j].getLong(ID));
                    logs.append(OpItemEnum.SELECT.getName());
                    continue;
                }
                if (1 == Integer.parseInt(value)) {
                    logs.append(OpItemEnum.IGNORE.getName());
                    continue;
                }
                updateObject.set("level" + (j + 1), null);
                logs.append(OpItemEnum.NOSELECT.getName());
            }
            for (j = approvalInfo.length - 2; j < 10; ++j) {
                updateObject.set("level" + (j + 1), null);
            }
            dataList.add(updateObject);
            logs.append(",");
            logs.append(OpItemEnum.BATCH.getName());
            dAOptLogs.add(logs);
        }
        try {
            this.checkGrantPerm(modelId, dataList);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        try {
            SaveServiceHelper.update((DynamicObject[])dataList.toArray(nullDyobjAry));
            if (!CollectionUtils.isEmpty((Collection)dALogs)) {
                DataPermLogHelper.batchInsertDataPermLog((List)dALogs);
            }
            optRes = Boolean.TRUE;
        }
        catch (Exception e) {
            log.error("batch_update_submit_with_auth rollback, error:" + e.getMessage(), (Throwable)e);
            optRes = Boolean.FALSE;
        }
        ArrayList opDescriptions = Lists.newArrayListWithExpectedSize((int)ids.size());
        for (StringBuilder log : dAOptLogs) {
            log.append(optRes ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName());
            opDescriptions.add(log.toString());
        }
        OperationLogUtil.batchWriteOperationLog((String)OpItemEnum.BATCHPERM.getName(), (List)opDescriptions, (Long)modelId, (String)this.getBizEntityNumber());
        this.getView().getParentView().setReturnData((Object)optRes);
        this.getView().close();
    }

    private void checkGrantPerm(Long modelId, List<DynamicObject> dataList) {
        if (PermissionServiceImpl.getInstance((Long)modelId).isAdmin()) {
            return;
        }
        Set<Long> permClass = GrantPermUtil.getPermClass(modelId);
        Optional<DynamicObject> noPerm = dataList.stream().filter(t -> !permClass.contains(t.getLong("authclass.id"))).findFirst();
        if (noPerm.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u201c\u5206\u914d\u6743\u201d\u76f8\u5173\u914d\u7f6e\u3002", (String)"DataAuthAssignPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

