/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.util.DataAuthUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;

public class DataAuthMainImport
extends AbsCommonImport {
    private Map<String, DynamicObject> recordMap;
    private Map<String, Long> permClassMap;
    private DynamicObject model;
    private List<DynamicObject> approvalInfo;
    private Map<String, Pair<Long, String>> userMap;
    private Map<String, Pair<Long, String>> userGroupMap;
    private final Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private static final String USERS_NUMBER = "users.number";
    private static final String USERTYPE = "usertype";
    private static final String AUTH = "auth";
    private static final String NUMBER = "number";
    private Long modelId;
    private final List<String> userTypeList = Lists.newArrayList((Object[])new String[]{"bos_user", "bos_usergroup"});

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_auth_info";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.initData(billDatas);
    }

    private void initData(List<ImportBillData> billDatas) {
        this.modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        if (Objects.isNull(this.model)) {
            this.model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,showNumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.modelId)});
        }
        HashSet userNumbers = Sets.newHashSetWithExpectedSize((int)billDatas.size());
        HashSet userGroupNumbers = Sets.newHashSetWithExpectedSize((int)billDatas.size());
        HashSet permClassNumbers = Sets.newHashSetWithExpectedSize((int)billDatas.size());
        billDatas.forEach(b -> {
            String usersNumberString = ImportHelper.getImportBillProp(b, USERS_NUMBER).toString();
            if (Objects.equals(ImportHelper.getImportBillProp(b, USERTYPE).toString(), "bos_user")) {
                userNumbers.add(usersNumberString);
            } else {
                userGroupNumbers.add(usersNumberString);
            }
            permClassNumbers.add(ImportHelper.getImportBillProp(b, AUTH).toString());
        });
        HashSet permClassIds = Sets.newHashSetWithExpectedSize((int)permClassNumbers.size());
        if (!CollectionUtils.isEmpty((Collection)permClassNumbers)) {
            Map permissionClass = PermClassEntityHelper.getPermissionClassByNum((Long)this.modelId, (String)"model.id", (Set)permClassNumbers);
            if (Objects.isNull(this.permClassMap)) {
                this.permClassMap = Maps.newHashMapWithExpectedSize((int)permissionClass.size());
            } else {
                this.permClassMap.putAll(this.permClassMap);
            }
            permissionClass.values().forEach(p -> {
                long permClassId = p.getLong("id");
                this.permClassMap.putIfAbsent(p.getString(NUMBER), permClassId);
                permClassIds.add(permClassId);
            });
        }
        HashSet userIds = Sets.newHashSetWithExpectedSize((int)(userNumbers.size() + userGroupNumbers.size()));
        if (!CollectionUtils.isEmpty((Collection)userNumbers)) {
            this.userMap = this.getUserFromDb(Sets.newHashSet((Iterable)userNumbers), userIds, "bos_user");
        }
        if (!CollectionUtils.isEmpty((Collection)userGroupNumbers)) {
            this.userGroupMap = this.getUserFromDb(Sets.newHashSet((Iterable)userGroupNumbers), userIds, "bos_usergroup");
        }
        this.recordMap = this.getDataAuthFromDb(this.modelId, userIds, permClassIds);
        if (Objects.isNull(this.approvalInfo)) {
            DynamicObject[] results = DataAuthUtil.getApprovalInfo((Long)this.modelId);
            this.approvalInfo = Objects.isNull(results) ? Lists.newArrayListWithExpectedSize((int)16) : Arrays.asList(results);
        }
    }

    private Map<String, Pair<Long, String>> getUserFromDb(Set<String> numbers, Set<Long> uIds, String userType) {
        DynamicObjectCollection dys;
        if (CollectionUtils.isEmpty(numbers)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        QFBuilder qfBuilder = new QFBuilder(NUMBER, "in", numbers);
        if (Objects.equals(this.entityName, UserTypeEnum.USER.getName())) {
            qfBuilder.and("enable", "=", (Object)"1");
        }
        if (CollectionUtils.isEmpty((Collection)(dys = QueryServiceHelper.query((String)userType, (String)"id,number,name", (QFilter[])qfBuilder.toArray())))) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        HashMap users = Maps.newHashMapWithExpectedSize((int)numbers.size());
        dys.forEach(u -> {
            long userId = u.getLong("id");
            users.put(u.getString(NUMBER), Pair.onePair((Object)userId, (Object)u.getString("name")));
            uIds.add(userId);
        });
        return users;
    }

    private Map<String, DynamicObject> getDataAuthFromDb(Long modelId, Set<Long> uIds, Set<Long> pCIds) {
        DynamicObject[] load;
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (!CollectionUtils.isEmpty(uIds)) {
            filter.and("users.id", "in", uIds);
        }
        if (!CollectionUtils.isEmpty(pCIds)) {
            filter.and("authClass.id", "in", pCIds);
        }
        if (Objects.isNull(load = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)this.entityName).getAllFields().keySet()), (QFilter[])new QFilter[]{filter})) || load.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(load).collect(Collectors.toMap(this::getRepeatKey, Function.identity(), (value1, value2) -> value1));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        String audit11;
        Optional<DynamicObject> dbOld;
        Pair<Long, String> userGroup;
        Pair<Long, String> user;
        String number = ImportHelper.getImportBillProp(bill, "model_number").toString();
        if (!Objects.equals(this.model.getString("showNumber"), number)) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u5176\u4ed6\u4f53\u7cfb\u3002", (String)"DataAuthMainImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String usersNumber = ImportHelper.getImportBillProp(bill, USERS_NUMBER).toString();
        if (StringUtils.isEmpty((Object)usersNumber)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u6216\u7528\u6237\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (usersNumber.length() > 36) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc736\u4e2a\u5b57\u7b26\u3002", (String)"DataAuthMainImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String username = ImportHelper.getImportBillProp(bill, "username").toString();
        if (StringUtils.isEmpty((Object)username)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String usertype = ImportHelper.getImportBillProp(bill, USERTYPE).toString();
        if (StringUtils.isEmpty((Object)usertype)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.userTypeList.contains(usertype)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b\u53ea\u5141\u8bb8\u586b\u5165bos_user\u6216bos_usergroup\uff01", (String)"DataAuthMainImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals("bos_user", usertype) && (Objects.isNull(user = this.userMap.get(usersNumber)) || !Objects.equals(user.p2, username))) {
            String message = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7528\u6237\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e14\u7528\u6237\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7528\u6237\u3002", (String)"DataAuthMainImport_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), usersNumber, username);
            return Optional.of(message);
        }
        if (Objects.equals("bos_usergroup", usertype) && (Objects.isNull(userGroup = this.userGroupMap.get(usersNumber)) || !Objects.equals(userGroup.p2, username))) {
            String message = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7528\u6237\u7ec4\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e14\u7528\u6237\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7528\u6237\u3002", (String)"DataAuthMainImport_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), usersNumber, username);
            return Optional.of(message);
        }
        String auth = ImportHelper.getImportBillProp(bill, AUTH).toString();
        if (StringUtils.isEmpty((Object)auth)) {
            return Optional.of(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(this.permClassMap.get(auth))) {
            return Optional.of(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u6743\u9650\u7c7b\u3002", (String)"DataAuthMainImport_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String dataAuth = ImportHelper.getImportBillProp(bill, "data_auth").toString();
        if (StringUtils.isEmpty((Object)dataAuth)) {
            return Optional.of(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String repeatKey = this.getRepeatKey(bill);
        if (!this.repeatKeys.add(repeatKey)) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && (dbOld = this.getDbOld(bill)).isPresent()) {
            return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataAuthMainImport_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(this.approvalInfo)) {
            for (int i = 0; i < this.approvalInfo.size() - 2; ++i) {
                String key = "level" + (i + 1) + "step";
                String audit = ImportHelper.getImportBillProp(bill, key).toString();
                if (!StringUtils.isEmpty((Object)audit)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5ba1\u6279\u73af\u8282\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), key);
                return Optional.of(msg);
            }
        }
        if (StringUtils.isEmpty((Object)(audit11 = ImportHelper.getImportBillProp(bill, "level11step").toString()))) {
            return Optional.of(ResManager.loadKDString((String)"\u63d0\u4ea4\u73af\u8282\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String audit12 = ImportHelper.getImportBillProp(bill, "level12step").toString();
        if (StringUtils.isEmpty((Object)audit12)) {
            return Optional.of(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u6253\u56de\u73af\u8282\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            JSONObject data = billDataList.get(i).getData();
            DynamicObject old = (DynamicObject)data.get((Object)"existingRecordDy");
            old.set("data_auth", (Object)data.getString("data_auth"));
            this.buildAudit(old, data);
            dys[i] = old;
        }
        return dys;
    }

    private void setAuditValue(DynamicObject dy, String value, String key, Integer index) {
        if (Objects.equals(value, "true")) {
            dy.set(key, (Object)this.approvalInfo.get(index).getLong("id"));
        } else {
            dy.set(key, null);
        }
    }

    private void buildAudit(DynamicObject dy, JSONObject data) {
        if (CollectionUtils.isEmpty(this.approvalInfo)) {
            return;
        }
        String level11step = data.get((Object)"level11step").toString();
        this.setAuditValue(dy, level11step, "level11", this.approvalInfo.size() - 2);
        String level12step = data.get((Object)"level12step").toString();
        this.setAuditValue(dy, level12step, "level12", this.approvalInfo.size() - 1);
        for (int i = 0; i < this.approvalInfo.size() - 2; ++i) {
            String key = "level" + (i + 1) + "step";
            String auditValue = data.get((Object)key).toString();
            this.setAuditValue(dy, auditValue, "level" + (i + 1), i);
        }
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            long usersId;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            ImportBillData billData = billDataList.get(i);
            dynamicObject.set("id", (Object)LongUtil.toLong((Object)ImportHelper.getImportBillProp(billData, "id")));
            String usertype = ImportHelper.getImportBillProp(billData, USERTYPE).toString();
            if (usertype.equals("bos_user")) {
                Pair<Long, String> user = this.userMap.get(ImportHelper.getImportBillProp(billData, USERS_NUMBER).toString());
                usersId = (Long)user.p1;
            } else {
                Pair<Long, String> userGroup = this.userGroupMap.get(ImportHelper.getImportBillProp(billData, USERS_NUMBER).toString());
                usersId = (Long)userGroup.p1;
            }
            dynamicObject.set("users", (Object)usersId);
            dynamicObject.set(USERTYPE, (Object)usertype);
            dynamicObject.set("username", (Object)ImportHelper.getImportBillProp(billData, "username").toString());
            dynamicObject.set("authclass", (Object)this.permClassMap.get(ImportHelper.getImportBillProp(billData, AUTH).toString()));
            dynamicObject.set("model", (Object)this.model.getLong("id"));
            dynamicObject.set("data_auth", (Object)ImportHelper.getImportBillProp(billData, "data_auth").toString());
            this.buildAudit(dynamicObject, billData.getData());
            dys[i] = dynamicObject;
        }
        return dys;
    }

    private String changeToDataPermLogPermEnum(String permission) {
        if (Objects.equals("3", permission)) {
            return "1";
        }
        if (Objects.equals("1", permission)) {
            return "3";
        }
        return permission;
    }

    @Override
    protected void afterSaveBatch(List<ImportBillData> validatedBillData, List<BillResult> resultEntries) {
        ArrayList logs = Lists.newArrayListWithCapacity((int)resultEntries.size());
        resultEntries.forEach(t -> {
            if (t.isSucess()) {
                String permission = this.changeToDataPermLogPermEnum(t.getData().get("data_auth").toString());
                String description = this.getImportType((BillResult)t);
                DynamicObject dy = this.buildDataPermLog(t.getData().get(AUTH).toString(), description, permission, ((Map)t.getData().get("users")).get(NUMBER).toString(), t.getData().get("username").toString());
                logs.add(dy);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)logs)) {
            DataPermLogHelper.batchInsertDataPermLog((List)logs);
        }
    }

    private DynamicObject buildDataPermLog(String permClassNumber, String description, String permission, String usernumber, String username) {
        StringBuilder operateName = new StringBuilder().append("\u3010").append(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165", (String)"DataAuthMainImport_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\u3011").append(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650", (String)"DataAuthMainImport_19", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("-").append(description);
        return DataPermLogHelper.newDataPermControlLog((Long)this.modelId, (String)permission, (String)permClassNumber, (String)operateName.toString(), (String)usernumber, (String)username, (String)this.ctx.getAppId());
    }

    private String getImportType(BillResult t) {
        Object record = t.getData().get("existingRecordDy");
        if (Objects.isNull(record)) {
            return ResManager.loadKDString((String)"\u65b0\u589e", (String)"DataAuthMainImport_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"DataAuthMainImport_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        DynamicObject dynamicObject = this.recordMap.get(this.getRepeatKey(rowData));
        return Optional.ofNullable(dynamicObject);
    }

    private String getRepeatKey(ImportBillData data) {
        String usersNumber = ImportHelper.getImportBillProp(data, USERS_NUMBER).toString();
        String userType = ImportHelper.getImportBillProp(data, USERTYPE).toString();
        String auth = ImportHelper.getImportBillProp(data, AUTH).toString();
        return new StringJoiner("|").add(usersNumber).add(userType).add(auth).toString();
    }

    private String getRepeatKey(DynamicObject dy) {
        return new StringJoiner("|").add(dy.getString(USERS_NUMBER)).add(dy.getString(USERTYPE)).add(dy.getString("authclass.number")).toString();
    }
}

