/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.export.strategy.AuthExportStrategy;
import kd.fi.bcm.business.export.strategy.ExportExecuteStrategyContext;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepInitHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.DataAuthUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.GrantPermUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class DataAuthMainPagePlugin
extends AbstractBaseListPlugin {
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_NEW = "bar_new";
    private static final String BAR_BATCH = "bar_batch";
    private static final String BAR_QUERY = "bar_query";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_UNION = "bar_union";
    private static final String ENTRYENTITY = "entryentity";
    private static final String AUTH_NEW = "47156aff000000ac";
    private static final String AUTH_SAVE = "0=KX5+QVF5+R";
    private static final String BAR_IMPORT = "bar_import";
    private static final String BAR_EXPORT = "bar_export";
    private static final String ROW_SELECT_CACHE = "rowEditing";
    private static final String BAR_EXIT_CONFIRM = "bar_exit_confirm";
    private static final String EXIT_FLAG = "exit_flag";
    private static final String SAVE = "save";
    private static final String Exit = "exit";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String MODEL_NUMBER = "model.number";
    private static final String MODEL_NAME = "model.name";
    private static final String LEVEL = "level";
    private static final String cLvl11Id = "level11";
    private static final String cLvl12Id = "level12";
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String USERTYPE = "usertype";
    private static final String USERS_NAME = "users.name";
    private static final String USERS_NUMBER = "users.number";
    private static final String USERNUMBER = "usernumber";
    private static final String USERNAME = "username";
    private static final String DATA_AUTH = "data_auth";
    private static final String AUTH_CLASS = "auth_class";
    private static final String AUTHCLASS_NUMBER = "authclass.number";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String FIELDCAPTION = "fieldCaption";
    private static final String RESETCURRENTPAGEINDEX = "resetCurrentPageIndex";
    private static final String ISUSEQFILTER = "isUseQFilter";
    private static final String CHANGESET = "changeSet";
    private static final Integer COLLECTIONSIZE = 16;
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DataAuthMainPagePlugin.class);

    @Override
    public void initialize() {
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.addFilterGridF7ClickEvents(filterGridF7ClickEvent -> {
            filterGridF7ClickEvent.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u624b\u52a8\u8f93\u5165\u7b5b\u9009\u5185\u5bb9\u3002", (String)"DataAuthMainPagePlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        });
        this.addItemClickListeners("toolbarap1");
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm")) {
            return;
        }
        if (Objects.equals(beforeF7SelectEvent.getProperty().getName(), "model")) {
            List qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (Objects.isNull(qFilterList)) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)16);
            }
            qFilterList.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
            qFilterList.add(new QFilter(ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser()));
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.setEntityNumber("bcm_auth_info");
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)4);
        keys.add(USERNAME);
        keys.add(USERTYPE);
        keys.add(AUTHCLASS_NUMBER);
        keys.add(DATA_AUTH);
        keys.add(MODEL_NUMBER);
        keys.add(MODEL_NAME);
        filterGrid.setFilterFieldKeys((List)keys);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        List filterColumns = filterGrid.getFilterColumns();
        for (Map col : filterColumns) {
            col.compute("fieldName", (kFN, vFN) -> {
                switch (String.valueOf(vFN)) {
                    case "username": {
                        this.setColName(col, ResManager.loadKDString((String)"\u7528\u6237/\u7528\u6237\u7ec4", (String)"DataAuthMainPagePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "usertype": {
                        this.setColName(col, ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b", (String)"DataAuthMainPagePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "model.number": {
                        this.setColName(col, ResManager.loadKDString((String)"\u7528\u6237\u7f16\u7801", (String)"DataAuthMainPagePlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "model.name": {
                        this.setColName(col, ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u7f16\u7801", (String)"DataAuthMainPagePlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "authclass.number": {
                        this.setColName(col, ResManager.loadKDString((String)"\u6743\u9650\u7c7b", (String)"DataAuthMainPagePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                return vFN;
            });
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)ENTRYENTITY)) {
            EntryGrid entryGrid = new EntryGrid(){

                public void setPageRows(int rows) {
                    AbstractGrid.GridState entryState = this.getEntryState();
                    this.getView().getPageCache().put(DataAuthMainPagePlugin.RESETCURRENTPAGEINDEX, Boolean.TRUE.toString());
                    if (this.onFetchPageData(entryState.getCurrentPageIndex(), rows)) {
                        super.setPageRows(rows);
                    }
                }

                protected boolean onFetchPageData(int pageIndex, int pageRows) {
                    String reset = this.getView().getPageCache().get(DataAuthMainPagePlugin.RESETCURRENTPAGEINDEX);
                    if (Objects.equals(Boolean.TRUE.toString(), reset)) {
                        pageIndex = 1;
                        this.getView().getPageCache().remove(DataAuthMainPagePlugin.RESETCURRENTPAGEINDEX);
                    }
                    if (Objects.equals(this.getEntryState().getCurrentPageIndex(), pageIndex) && Objects.equals(this.getRowCount(), pageRows)) {
                        return Boolean.FALSE;
                    }
                    DataAuthMainPagePlugin.this.refreshBillList(pageIndex, pageRows, DataAuthMainPagePlugin.this.isUseQFilter() ? DataAuthMainPagePlugin.this.getQFilter() : null, Boolean.FALSE);
                    return Boolean.TRUE;
                }
            };
            entryGrid.setView(this.getView());
            entryGrid.setKey(ENTRYENTITY);
            entryGrid.setEntryKey(ENTRYENTITY);
            entryGrid.setSplitPage(Boolean.TRUE.booleanValue());
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                oldGrid = this.findControl(ENTRYENTITY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Set funcAuthModel;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{ID});
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        Set ids = MemberPermHelper.getLimitedModelListByUser();
        Boolean isGrant = BooleanUtils.toBoolean((Boolean)ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm"));
        Set set = funcAuthModel = isGrant != false ? BcmFunPermissionHelper.getFuncAuthModel((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (ApplicationTypeEnum)kd.fi.bcm.formplugin.dimension.util.ModelUtil.queryApp(this.getView()), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)Boolean.FALSE, (boolean)Boolean.TRUE) : Collections.EMPTY_SET;
        if (!(!StringUtils.isEmpty((CharSequence)modelId) && !CollectionUtils.isEmpty((Collection)ids) && ids.contains(LongUtil.toLong((Object)modelId)) && !Objects.equals(modelId, "0") || isGrant.booleanValue() && !CollectionUtils.isEmpty((Collection)funcAuthModel) && funcAuthModel.contains(LongUtil.toLong((Object)modelId)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DataAuthMainPagePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(this.getModelSign(), (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        try {
            this.refreshBillList(1, null, Boolean.FALSE);
        }
        catch (KDBizException kdBizE) {
            this.getView().showErrorNotification(kdBizE.getMessage());
            return;
        }
        this.getView().getPageCache().put(ISUSEQFILTER, Boolean.TRUE.toString());
        this.getPageCache().put(ROW_SELECT_CACHE, "");
        this.getPageCache().put(EXIT_FLAG, "");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        EntryGrid entryentity;
        if (closedCallBackEvent.getActionId().equals("batch")) {
            Object returnData = this.getView().getReturnData();
            if (null != returnData) {
                if (Boolean.parseBoolean(returnData.toString())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DataAuthMainPagePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            this.refreshBillList(this.getQFilter());
        } else if (closedCallBackEvent.getActionId().equals("close")) {
            entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            this.refreshBillList(entryentity.getEntryState().getCurrentPageIndex(), this.getQFilter(), Boolean.TRUE);
        }
        if (closedCallBackEvent.getActionId().equals("IMPORT_CLOSE")) {
            entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            this.refreshBillList(entryentity.getEntryState().getCurrentPageIndex(), this.getQFilter(), Boolean.TRUE);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("model".equals(propName)) {
            ArrayList<String> list = new ArrayList<String>(16);
            list.add("model");
            this.propertyChangedModelUse(list);
            if (null != this.getValue("model")) {
                try {
                    this.refreshBillList(null);
                }
                catch (KDBizException kdBizE) {
                    this.getView().showErrorNotification(kdBizE.getMessage());
                    return;
                }
                this.getView().getPageCache().put(ISUSEQFILTER, Boolean.FALSE.toString());
            }
        } else if (Objects.equals(propName, DATA_AUTH) || StringUtils.startsWith((CharSequence)propName, (CharSequence)LEVEL)) {
            String id;
            ChangeData changeData = e.getChangeSet()[0];
            Map<String, Object> dataMap = this.getOrNewMap(this.getPageCache().get(CHANGESET));
            Object propVals = dataMap.get(id = changeData.getDataEntity().getString(ID));
            Map<String, Object> authMap = this.getOrNewMap(Objects.isNull(propVals) ? null : propVals.toString());
            authMap.put(propName, changeData.getNewValue());
            dataMap.put(id, SerializationUtils.toJsonString(authMap));
            this.getPageCache().put(CHANGESET, SerializationUtils.toJsonString(dataMap));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DataAuthMainPagePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "bar_refresh": 
            case "bar_query": {
                this.getView().getPageCache().put(ISUSEQFILTER, Boolean.TRUE.toString());
                this.refreshBillList(this.getQFilter());
                break;
            }
            case "bar_new": {
                this.openNewPage();
                break;
            }
            case "bar_save": {
                try {
                    this.actionSaveOrExit(SAVE);
                    break;
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(e.getMessage());
                    return;
                }
            }
            case "bar_batch": {
                this.openBatchPage();
                break;
            }
            case "bar_export": {
                if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
                    this.getView().showTipNotification(DataAuthMainPagePlugin.getNoPermTip());
                    break;
                }
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
                if (entryentity.getEntryData().getDataEntitys().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"DataAuthMainPagePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportDatas();
                break;
            }
            case "bar_import": {
                if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
                    this.getView().showTipNotification(DataAuthMainPagePlugin.getNoPermTip());
                    break;
                }
                this.importDatas();
                break;
            }
            case "bar_del": {
                this.del();
                break;
            }
            case "bar_union": {
                this.openUnionPage();
                break;
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isClosedFlag()) {
            try {
                this.actionSaveOrExit(Exit);
            }
            catch (KDBizException ex) {
                this.getView().showTipNotification(ex.getMessage());
                return;
            }
            if (this.isEditing()) {
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"DataAuthMainPagePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BAR_EXIT_CONFIRM, (IFormPlugin)this));
            }
        }
    }

    public boolean isClosedFlag() {
        return this.isFinishedOperation(EXIT_FLAG);
    }

    private boolean isEditing() {
        return this.isFinishedOperation(ROW_SELECT_CACHE);
    }

    private boolean isFinishedOperation(String opertaionName) {
        String isFlag = this.getPageCache().get(opertaionName);
        return !StringUtils.isEmpty((CharSequence)isFlag);
    }

    private void openUnionPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_unionperm");
        showParameter.setPageId(this.getView().getPageId() + "_" + BAR_UNION);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return;
        }
        showParameter.setCustomParam("model_id", (Object)model.getString(ID));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void exportDatas() {
        String preEntityNameImp = "bcm_auth_import_IMPT";
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)preEntityNameImp);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528-\u5f15\u5165\u5f15\u51fa\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"DataAuthMainPagePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            long modelId = this.getModelId();
            FormView view = (FormView)this.getView();
            String entityName = "bcm_auth_import";
            String appId = view.getFormShowParameter().getServiceAppId();
            HashMap<String, Serializable> exportDataParms = new HashMap<String, Serializable>(16);
            exportDataParms.put("modelId", Long.valueOf(modelId));
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectIndexs = entryGrid.getSelectRows();
            if (selectIndexs != null && selectIndexs.length > 0) {
                int pageRow = entryGrid.getPageRow();
                DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
                for (int row : selectIndexs) {
                    int cur = row % pageRow;
                    ids.add(dataEntities[cur].getLong(ID));
                }
                exportDataParms.put("idList", ids);
            }
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new AuthExportStrategy());
            String url = exportExecuteStrategyContext.export(appId, ((Long)pkIds.get(0)).longValue(), entityName, entityName, exportDataParms);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_auth", "1G2FW/G3YIL8");
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "OpItemEnum_1", "fi-bcm-common", "export"), new OPDescMultiLangEnumBridge("\u5168\u90e8\u6570\u636e\u6743\u9650\u5bfc\u51fa", "OpItemEnum_35", "fi-bcm-common", null));
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private void importDatas() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        String listName = ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u5217\u8868", (String)"DataAuthMainPagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AbsCommonImport.invokeOperation("bcm_auth_import", "kd.fi.bcm.formplugin.permissionclass.DataAuthMainImport", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    private void setColName(Map<String, Object> col, String name) {
        col.compute(FIELDCAPTION, (kFC, vFC) -> new LocaleString(name).getLocaleValue());
    }

    private QFilter getQFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)"bcm_auth_info"), filterGrid.getFilterGridState().getFilterCondition());
        filterBuilder.buildFilter();
        QFilter head = filterBuilder.getQFilter();
        QFilter cur = null;
        List nests = Collections.EMPTY_LIST;
        while (!(!Objects.isNull(cur) && CollectionUtils.isEmpty((Collection)nests) || Objects.isNull(head))) {
            cur = Objects.isNull(cur) ? head : ((QFilter.QFilterNest)nests.get(0)).getFilter();
            nests = cur.getNests(false);
            String userType = "";
            if (Objects.equals(cur.getProperty(), MODEL_NUMBER)) {
                userType = "bos_user";
            } else if (Objects.equals(cur.getProperty(), MODEL_NAME)) {
                userType = "bos_usergroup";
            }
            if (!StringUtils.isNotBlank((CharSequence)userType)) continue;
            QFilter qFilter1 = new QFilter(NUMBER, cur.getCP(), cur.getValue());
            Set collect = QueryServiceHelper.query((String)userType, (String)ID, (QFilter[])qFilter1.toArray()).stream().map(t -> t.getLong(ID)).collect(Collectors.toSet());
            cur.__setProperty("users.id");
            cur.__setCP("in");
            cur.__setValue(collect);
        }
        return head;
    }

    private boolean isUseQFilter() {
        return Boolean.parseBoolean(this.getView().getPageCache().get(ISUSEQFILTER));
    }

    private Map<String, Object> getOrNewMap(String json) {
        Map authMap = Objects.isNull(json) ? Maps.newHashMapWithExpectedSize((int)COLLECTIONSIZE) : (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        return authMap;
    }

    private void refreshBillList() {
        for (int i = 1; i < 11; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LEVEL + i});
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        grid.setColumnProperty(cLvl11Id, "header", (Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u73af\u8282", (String)"DataAuthMainPagePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        grid.setColumnProperty(cLvl12Id, "header", (Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u6253\u56de", (String)"DataAuthMainPagePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        entryEntities.clear();
        this.getView().updateView(ENTRYENTITY);
    }

    private void refreshBillList(QFilter qFilter) {
        this.refreshBillList(Integer.MIN_VALUE, Integer.MIN_VALUE, qFilter, Boolean.FALSE);
    }

    private void refreshBillList(int pageIndex, QFilter qFilter, boolean isDataAdd) {
        this.refreshBillList(pageIndex, Integer.MIN_VALUE, qFilter, isDataAdd);
    }

    private void refreshBillList(int pageIndex, int pageRows, QFilter qFilter, boolean isDataAdd) {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.clearEntryState();
        FlowStepInitHelper.initFlowStep((String)String.valueOf(this.getModelId()));
        DynamicObject[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)this.getModelId());
        this.buildPage(approvalInfo);
        if (Objects.equals(pageIndex, Integer.MIN_VALUE)) {
            pageIndex = entryentity.getEntryState().getCurrentPageIndex();
        }
        this.buildEntry(pageIndex, pageRows, qFilter, approvalInfo, isDataAdd);
    }

    private void del() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DataAuthMainPagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.noHasGrantPerm(this.getSelectRowsId())) {
            this.getView().showTipNotification(DataAuthMainPagePlugin.getNoGrantTip());
            return;
        }
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u884c\u5417\uff1f", (String)"DataAuthMainPagePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("del_confirm", (IFormPlugin)this));
    }

    private boolean noHasGrantPerm(List<Long> ids) {
        if (PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
            return false;
        }
        String selectFields = "authclass.id";
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add(ID, "in", ids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfBuilder.toArray());
        List classIds = query.stream().map(dy -> dy.getLong("authclass.id")).collect(Collectors.toList());
        Set<Long> permClass = GrantPermUtil.getPermClass(this.getModelId());
        return !permClass.containsAll(classIds);
    }

    private void buildPage(DynamicObject[] approvalInfo) {
        int i;
        if (approvalInfo.length < 2) {
            this.refreshBillList();
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5ba1\u6279\u73af\u8282\u65b0\u589e\u6570\u636e", (String)"DataAuthMainPagePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (approvalInfo.length > 12) {
            this.refreshBillList();
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u73af\u8282\u4e2a\u6570\u8d85\u8fc7\u8303\u56f4\u3002", (String)"DataAuthMainPagePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        for (i = 0; i < approvalInfo.length - 2; ++i) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{LEVEL + (i + 1)});
        }
        this.getView().setVisible(Boolean.valueOf(this.isCMModel()), new String[]{cLvl11Id});
        this.getView().setVisible(Boolean.valueOf(this.isCMModel()), new String[]{cLvl12Id});
        for (i = approvalInfo.length - 2; i < 10; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LEVEL + (i + 1)});
        }
    }

    private void buildEntry(int pageIndex, int pageRows, QFilter qFilter, DynamicObject[] approvalInfo, Boolean isDataAdd) {
        StringBuilder sFSB = new StringBuilder();
        sFSB.append("id,users,usertype,data_auth,authclass.number");
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        for (int i = 0; i < approvalInfo.length - 2; ++i) {
            String cLvlId = LEVEL + (i + 1);
            grid.setColumnProperty(cLvlId, "header", (Object)new LocaleString(approvalInfo[i].getString(NAME)));
            sFSB.append(",");
            sFSB.append(cLvlId);
        }
        grid.setColumnProperty(cLvl11Id, "header", (Object)new LocaleString(approvalInfo[approvalInfo.length - 2].getString(NAME)));
        sFSB.append(",");
        sFSB.append(cLvl11Id);
        grid.setColumnProperty(cLvl12Id, "header", (Object)new LocaleString(approvalInfo[approvalInfo.length - 1].getString(NAME)));
        sFSB.append(",");
        sFSB.append(cLvl12Id);
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        entryEntities.clear();
        DynamicObject model = (DynamicObject)this.getValue("model");
        QFBuilder filter = new QFBuilder("model", "=", (Object)model.getLong(ID));
        if (Objects.nonNull(qFilter)) {
            filter.and(qFilter);
        }
        int realCount = ORM.create().count(this.getClass().getName(), "bcm_auth_info", filter.toArray());
        int phyxPageIndex = pageIndex - 1;
        boolean isPageNotChange = Boolean.FALSE;
        if (Objects.equals(pageRows, Integer.MIN_VALUE)) {
            pageRows = grid.getPageRow();
            isPageNotChange = Boolean.TRUE;
            this.getPageCache().remove(CHANGESET);
        } else if (!Objects.equals(pageRows, grid.getPageRow())) {
            this.getPageCache().remove(CHANGESET);
        }
        int realPages = realCount / pageRows;
        if (realCount % pageRows > 0) {
            ++realPages;
        }
        int realPhyxPages = realPages - 1;
        if (isDataAdd.booleanValue() || phyxPageIndex > realPhyxPages) {
            phyxPageIndex = realPhyxPages;
            if (!Objects.equals(pageIndex, realPages)) {
                AbstractGrid.GridState entryState = grid.getEntryState();
                entryState.setCurrentPageIndex(Integer.valueOf(realPages));
            }
        }
        DynamicObject[] authInfo = BusinessDataServiceHelper.load((String)"bcm_auth_info", (String)sFSB.toString(), (QFilter[])filter.toArray(), null, (int)phyxPageIndex, (int)pageRows);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        if (authInfo.length == 0) {
            dataEntityState.setEntryRowCount(ENTRYENTITY, 0);
            dataEntityState.setEntryPageSize(ENTRYENTITY, pageRows);
            dataEntityState.setEntryStartRowIndex(ENTRYENTITY, 0);
            this.getView().updateView(ENTRYENTITY);
            return;
        }
        String authMapJson = this.getPageCache().get(CHANGESET);
        Map authMap = authMapJson != null ? (Map)SerializationUtils.fromJsonString((String)authMapJson, Map.class) : null;
        for (DynamicObject aI : authInfo) {
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set(ID, aI.get(ID));
            entryEntity.set(USER, Objects.nonNull(aI.get(USERS_NAME)) ? aI.get(USERS_NAME) : "");
            String dataMapJson = authMap != null ? (String)authMap.get(aI.get(ID).toString()) : null;
            Map dataMap = dataMapJson != null ? (Map)SerializationUtils.fromJsonString((String)dataMapJson, Map.class) : null;
            entryEntity.set(AUTH_CLASS, aI.get(AUTHCLASS_NUMBER));
            entryEntity.set(USERNUMBER, aI.get(USERS_NUMBER));
            entryEntity.set(DATA_AUTH, dataMap != null && dataMap.containsKey(DATA_AUTH) ? dataMap.get(DATA_AUTH) : aI.get(DATA_AUTH));
            if ("bos_user".equals(aI.get(USERTYPE))) {
                entryEntity.set(USERTYPE, (Object)ResManager.loadKDString((String)"\u7528\u6237", (String)"DataAuthMainPagePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                entryEntity.set(USERTYPE, (Object)ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DataAuthMainPagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            for (int j = 0; j < approvalInfo.length; ++j) {
                if (j == approvalInfo.length - 2) {
                    if (dataMap != null && dataMap.containsKey(cLvl11Id)) {
                        entryEntity.set(cLvl11Id, dataMap.get(cLvl11Id));
                        continue;
                    }
                    if (null == aI.get(cLvl11Id) || !aI.get(cLvl11Id).equals(approvalInfo[approvalInfo.length - 2].getString(ID))) continue;
                    entryEntity.set(cLvl11Id, (Object)Boolean.TRUE);
                    continue;
                }
                if (j == approvalInfo.length - 1) {
                    if (dataMap != null && dataMap.containsKey(cLvl12Id)) {
                        entryEntity.set(cLvl12Id, dataMap.get(cLvl12Id));
                        continue;
                    }
                    if (null == aI.get(cLvl12Id) || !aI.get(cLvl12Id).equals(approvalInfo[approvalInfo.length - 1].getString(ID))) continue;
                    entryEntity.set(cLvl12Id, (Object)Boolean.TRUE);
                    continue;
                }
                String eGFId = LEVEL + (j + 1);
                if (dataMap != null && dataMap.containsKey(eGFId)) {
                    entryEntity.set(eGFId, dataMap.get(eGFId));
                    continue;
                }
                if (null == aI.get(eGFId) || !aI.get(eGFId).equals(approvalInfo[j].getString(ID))) continue;
                entryEntity.set(eGFId, (Object)Boolean.TRUE);
            }
        }
        dataEntityState.setEntryRowCount(ENTRYENTITY, realCount);
        dataEntityState.setEntryPageSize(ENTRYENTITY, pageRows);
        dataEntityState.setEntryStartRowIndex(ENTRYENTITY, phyxPageIndex * pageRows);
        if (isPageNotChange) {
            entryEntities.setStartRowIndex(phyxPageIndex * pageRows);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    void openNewPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_data_auth_new");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(showParameter);
    }

    void openBatchPage() {
        List<Long> selectRowsId = this.getSelectRowsId();
        if (selectRowsId.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"DataAuthMainPagePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)this.getModelId());
        if (approvalInfo.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5ba1\u6279\u73af\u8282\u7684\u7684\u6570\u636e\u3002", (String)"DataAuthMainPagePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.noHasGrantPerm(this.getSelectRowsId())) {
            this.getView().showTipNotification(DataAuthMainPagePlugin.getNoGrantTip());
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_datapermissionassig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("ids", selectRowsId);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batch"));
        this.getView().showForm(showParameter);
    }

    private void actionSaveOrExit(String operationType) {
        boolean isSave;
        boolean bl = isSave = !StringUtils.equals((CharSequence)Exit, (CharSequence)operationType);
        if (Objects.isNull(this.getPageCache().get(CHANGESET))) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHANGESET), Map.class);
        DynamicObject[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)this.getModelId());
        ArrayList logs = new ArrayList(10);
        String bizAppId = this.getBizAppId();
        String selectFields = "id,users,usertype,data_auth,authclass.number,authclass.id,level1,level2,level3,level4,level5,level6,level7,level8,level9,level10,level11,level12";
        Set ids = data.keySet().stream().map(ConvertUtil::convertObjToLong).collect(Collectors.toSet());
        if (this.noHasGrantPerm(Lists.newArrayList(ids))) {
            this.getView().showTipNotification(DataAuthMainPagePlugin.getNoGrantTip());
            return;
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add(ID, "in", ids);
        DynamicObject[] dataList = BusinessDataServiceHelper.load((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfBuilder.toArray());
        HashMap approvalInfoMap = Maps.newHashMapWithExpectedSize((int)approvalInfo.length);
        for (int i = 0; i < approvalInfo.length - 2; ++i) {
            approvalInfoMap.put(LEVEL + (i + 1), approvalInfo[i].getLong(ID));
        }
        approvalInfoMap.put(cLvl11Id, approvalInfo[approvalInfo.length - 2].getLong(ID));
        approvalInfoMap.put(cLvl12Id, approvalInfo[approvalInfo.length - 1].getLong(ID));
        for (DynamicObject authData : dataList) {
            Map authDataMap = (Map)SerializationUtils.fromJsonString((String)((String)data.get(authData.getString(ID))), Map.class);
            if (!Objects.nonNull(authDataMap)) continue;
            authDataMap.entrySet().forEach(k -> {
                String propName = (String)k.getKey();
                if (Objects.equals(propName, DATA_AUTH)) {
                    authData.set(DATA_AUTH, k.getValue());
                    int permIndex = 1;
                    if (authData.getInt(DATA_AUTH) == 1) {
                        permIndex = authData.getInt(DATA_AUTH) + 2;
                    } else if (authData.getInt(DATA_AUTH) == 2) {
                        permIndex = authData.getInt(DATA_AUTH);
                    } else if (authData.getInt(DATA_AUTH) == 3) {
                        permIndex = authData.getInt(DATA_AUTH) - 2;
                    }
                    String perm = permIndex + "";
                    DynamicObject log = DataPermLogHelper.newDataPermControlLog((Long)this.getModelId(), (String)perm, (String)authData.getString(AUTHCLASS_NUMBER), (String)DataPermLogMultiLangEnum.DataPerm_MODIFY.getOperateName(), (String)authData.getString(USERS_NUMBER), (String)authData.getString(USERS_NAME), (String)bizAppId);
                    logs.add(log);
                } else if (StringUtils.startsWith((CharSequence)propName, (CharSequence)LEVEL)) {
                    Object value = null;
                    if (Boolean.parseBoolean(k.getValue().toString())) {
                        value = approvalInfoMap.get(propName);
                    }
                    authData.set(propName, value);
                    for (int j = approvalInfo.length - 2; j < 10; ++j) {
                        authData.set(LEVEL + (j + 1), null);
                    }
                }
            });
        }
        if (logs.size() > 0) {
            this.getPageCache().put(ROW_SELECT_CACHE, "1");
        } else {
            this.getPageCache().put(ROW_SELECT_CACHE, "");
        }
        String opName = ResManager.loadKDString((String)"\u7f16\u8f91\u4fdd\u5b58", (String)"DataAuthAddPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model");
        if (isSave) {
            try {
                this.getPageCache().put(ROW_SELECT_CACHE, "");
                this.checkGrantPerm(this.getModelId(), Arrays.asList(dataList));
                SaveServiceHelper.update((DynamicObject[])dataList);
                if (logs.size() > 0) {
                    DataPermLogHelper.batchInsertDataPermLog(logs);
                }
                List opDes = Arrays.stream(dataList).map(dataSelect -> {
                    if ("bos_user".equals(dataSelect.getDynamicObject("users").getDataEntityType().getName())) {
                        return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthAddPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getString("shownumber"), model.getString(NAME), dataSelect.getDynamicObject("users").getString(NAME), dataSelect.getString(AUTHCLASS_NUMBER));
                    }
                    return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthAddPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getString("shownumber"), model.getString(NAME), dataSelect.getDynamicObject("users").getString(NAME), dataSelect.getString(AUTHCLASS_NUMBER));
                }).collect(Collectors.toList());
                OperationLogUtil.batchWriteOperationLog((String)opName, opDes, null, (String)"bcm_auth");
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (KDException e) {
                log.error((Throwable)e);
                List opDes = Arrays.stream(dataList).map(dataSelect -> {
                    if ("bos_user".equals(dataSelect.getDynamicObject("users").getDataEntityType().getName())) {
                        return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DataAuthAddPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getString("shownumber"), model.getString(NAME), dataSelect.getDynamicObject("users").getString(NAME), dataSelect.getString(AUTHCLASS_NUMBER));
                    }
                    return String.format(ResManager.loadKDString((String)"%1$s %2$s \u7528\u6237\u7ec4 %3$s \u6743\u9650\u7c7b %4$s \u6570\u636e\u6743\u9650\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DataAuthAddPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.getString("shownumber"), model.getString(NAME), dataSelect.getDynamicObject("users").getString(NAME), dataSelect.getString(AUTHCLASS_NUMBER));
                }).collect(Collectors.toList());
                OperationLogUtil.batchWriteOperationLog((String)opName, opDes, null, (String)"bcm_analysishelper");
            }
            this.refreshBillList(this.getQFilter());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkGrantPerm(Long modelId, List<DynamicObject> dataList) {
        if (PermissionServiceImpl.getInstance((Long)modelId).isAdmin()) {
            return;
        }
        Set<Long> permClass = GrantPermUtil.getPermClass(modelId);
        Optional<DynamicObject> noPerm = dataList.stream().filter(t -> !permClass.contains(t.getLong("authclass.id"))).findFirst();
        if (noPerm.isPresent()) {
            throw new KDBizException(DataAuthMainPagePlugin.getNoGrantTip());
        }
    }

    List<Long> getSelectRowsId() {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObjectCollection data = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(ENTRYENTITY);
        for (int selectRow : selectRows) {
            long id = ((DynamicObject)data.get(selectRow % data.getPageSize())).getLong(ID);
            ids.add(id);
        }
        return ids;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callId = messageBoxClosedEvent.getCallBackId();
        String name = messageBoxClosedEvent.getResultValue();
        if ("del_confirm".equals(callId) && MessageBoxResult.Yes.name().equals(name)) {
            List<Long> selectRowsId = this.getSelectRowsId();
            if (null == selectRowsId || selectRowsId.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DataAuthMainPagePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter(ID, "in", selectRowsId);
            DynamicObjectCollection delObjs = QueryServiceHelper.query((String)"bcm_auth_info", (String)"username,usertype,authclass.number,data_auth,users", (QFilter[])new QFilter[]{qFilter});
            try {
                Collection delDy = BusinessDataServiceHelper.loadFromCache((String)"bcm_auth_info", (QFilter[])new QFilter[]{qFilter}).values();
                DeleteServiceHelper.delete((String)"bcm_auth_info", (QFilter[])new QFilter[]{qFilter});
                String bizAppId = this.getBizAppId();
                ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(delDy.size());
                for (DynamicObject delObj : delDy) {
                    int permIndex = 1;
                    if (delObj.getInt(DATA_AUTH) == 1) {
                        permIndex = delObj.getInt(DATA_AUTH) + 2;
                    } else if (delObj.getInt(DATA_AUTH) == 2) {
                        permIndex = delObj.getInt(DATA_AUTH);
                    } else if (delObj.getInt(DATA_AUTH) == 3) {
                        permIndex = delObj.getInt(DATA_AUTH) - 2;
                    }
                    String perm = permIndex + "";
                    DynamicObject log = DataPermLogHelper.newDataPermControlLog((Long)this.getModelId(), (String)perm, (String)delObj.getString(AUTHCLASS_NUMBER), (String)DataPermLogMultiLangEnum.DataPerm_DELETE.getOperateName(), (String)delObj.getString(USERS_NUMBER), (String)delObj.getString(USERS_NAME), (String)bizAppId);
                    logs.add(log);
                }
                if (logs.size() > 0) {
                    DataPermLogHelper.batchInsertDataPermLog(logs);
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
            String usertype = "";
            String username = "";
            String authnumber = "";
            if (delObjs != null && delObjs.size() > 0) {
                for (DynamicObject dy : delObjs) {
                    usertype = dy.getString(USERTYPE);
                    username = dy.getString(USERNAME);
                    authnumber = dy.getString(AUTHCLASS_NUMBER);
                    if (StringUtils.equals((CharSequence)usertype, (CharSequence)"bos_user")) {
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "OpItemEnum_2", "fi-bcm-common", "delete"), new OPDescMultiLangEnumBridge("%1$s %2$s \u6570\u636e\u6743\u9650\u5220\u9664\u6210\u529f\u3002", "OpItemEnum_200", "fi-bcm-common", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{OpItemEnum.USER.getName() + username, OpItemEnum.PERMCLASS.getName() + authnumber})));
                    }
                    if (!StringUtils.equals((CharSequence)usertype, (CharSequence)"bos_usergroup")) continue;
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "OpItemEnum_2", "fi-bcm-common", "delete"), new OPDescMultiLangEnumBridge("%1$s %2$s \u6570\u636e\u6743\u9650\u5220\u9664\u6210\u529f\u3002", "OpItemEnum_200", "fi-bcm-common", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{OpItemEnum.USERGROUP.getName() + username, OpItemEnum.PERMCLASS.getName() + authnumber})));
                }
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            this.refreshBillList(entryGrid.getEntryState().getCurrentPageIndex(), this.getQFilter(), Boolean.FALSE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (StringUtil.equals((String)BAR_EXIT_CONFIRM, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put(ROW_SELECT_CACHE, "");
            this.getPageCache().put(EXIT_FLAG, "1");
            this.getView().close();
        }
    }

    private static String getNoGrantTip() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u201c\u5206\u914d\u6743\u201d\u76f8\u5173\u914d\u7f6e\u3002", (String)"DataAuthMainPagePlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getNoPermTip() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataAuthMainPagePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

