/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.FormUtils;
import kd.fi.bcm.formplugin.util.GrantPermUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class GrantFormPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
TabSelectListener {
    private static final String USER_ENTRY_ID = "userentry";
    private static final String MEMBER_ENTRY_ID = "memberentry";
    private static final String DIMENSION_COMBO_ID = "dimensioncombo";
    private static final String MEMBER_TYPE = "membertype";
    private static final String DIMENSION = "dimension";
    private static final String E_USERS = "eusers";
    private static final String BASE_USER_GROUP = "baseusergroup";
    private static final String BASE_USER = "baseuser";
    private static final String IS_CHANGE = "ischange";
    private static final String ID = "id";
    private static final String MID = "mid";
    private static final String PROID = "proid";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String SELECT_MEMBER = "selectmember";
    private static final String E_TYPE = "etype";
    private static final String LIST_DIMENSION = "listDimension";
    private static final String INCLUDE_SUB = "includesub";
    private static final String MEMBER = "member";
    private static final String MEMBER_ID = "member.id";
    private static final String IS_CUSTOM_PROP = "iscustomprop";
    private static final String BASE_AUTH = "baseauth";
    private static final String DIM_VALUE = "dimvalue";
    private static final String DIM_CHANGE_COMFIRM = "dimchange_comfirm";
    private static final String DEL_MEMBER = "delmember";
    private static final String DEL_PERM_CLZ = "del_perm_clz";
    private static final String SELECT_PERM_CLZ = "select_perm_clz";
    private static final String PERM_CLASS = "perm_class";
    private static final String DIM_MEM = "dim_mem";
    private static final String TAB_AP = "tabap";
    private static final String USERS = "users";
    private static final String USER_TYPE = "usertype";
    private static final String CREATER = "creater";
    private static final String PERMCLASS_ID = "permclass.id";
    private static final String PERMCLASS = "permclass";
    private static final String ORDERBYS = "dseq";
    private static final String BCM_GRANT_REPORT = "bcm_grant_report";
    private static final String USER_CHANGE_COMFIRM = "user_change_comfirm";
    private static final String USER_SELECT = "user_select";
    private static final String CHANGE_TIP = "changeTip";
    private static final Map<String, Map<String, String>> typeMap = ImmutableMap.of((Object)"dim_mem", (Object)ImmutableMap.of((Object)"changeTip", (Object)ResManager.loadKDString((String)"\u5207\u6362\u7528\u6237\u5c06\u6e05\u7a7a\u672a\u4fdd\u5b58\u6210\u5458\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"GrantFormPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), (Object)"perm_class", (Object)ImmutableMap.of((Object)"changeTip", (Object)ResManager.loadKDString((String)"\u5207\u6362\u7528\u6237\u5c06\u6e05\u7a7a\u672a\u4fdd\u5b58\u6743\u9650\u7c7b\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"GrantFormPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])));

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.changeTab(Boolean.TRUE);
        long modelTrdCh = this.getModelId();
        long modelId = 0L;
        Set set = MemberPermHelper.getLimitedCompleteIsolationModelListByUser((ApplicationTypeEnum)this.getApplicationType());
        Set funcAuthModel = BcmFunPermissionHelper.getFuncAuthModel((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(this.getView()), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
        if (!Objects.equals(modelTrdCh, 0L) && (set.contains(modelTrdCh) || funcAuthModel.contains(modelTrdCh))) {
            modelId = modelTrdCh;
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), String.valueOf(modelId));
        } else {
            String modelRmb = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
            Long modelRmbLong = LongUtil.toLong((Object)modelRmb);
            if (StringUtils.isNotBlank((CharSequence)modelRmb) && !Objects.equals(modelRmb, "0") && (set.contains(modelRmbLong) || funcAuthModel.contains(modelRmbLong))) {
                modelId = LongUtil.toLong((Object)modelRmb);
            }
        }
        if (Objects.equals(modelId, 0L)) {
            this.getView().showTipNotification(this.getBlankModelTip());
        } else {
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            this.setDimensionCombo();
            this.setDimMemberFilter();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{BASE_USER, BASE_USER_GROUP})) {
            beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, beforeF7SelectEvent.getProperty().getName()));
            beforeF7SelectEvent.getFormShowParameter().setHasRight(Boolean.TRUE.booleanValue());
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
        if (Objects.equals(BASE_AUTH, name)) {
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
            ArrayList filters = Lists.newArrayList();
            filters.add(modelFilter);
            if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
                filters.add(new QFilter(ID, "in", GrantPermUtil.getPermClass(this.getModelId())));
            }
            beforeF7SelectEvent.setCustomQFilters((List)filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, name);
            beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(closeCallBack);
            beforeF7SelectEvent.getFormShowParameter().setHasRight(Boolean.TRUE.booleanValue());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.save();
                break;
            }
            case "btn_query": {
                this.query();
                break;
            }
            case "bar_refresh": {
                this.refreshMemEntry();
                break;
            }
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl(BASE_USER_GROUP);
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl(BASE_USER);
                user.click();
                break;
            }
            case "deluser": {
                this.deleteEntryRow(USER_ENTRY_ID);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "dimensioncombo": {
                boolean isChange = BooleanUtils.toBoolean((String)this.getPageCache().get(IS_CHANGE));
                if (isChange) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ef4\u5ea6\u5c06\u6e05\u7a7a\u5df2\u9009\u6210\u5458\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"GrantFormPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DIM_CHANGE_COMFIRM, (IFormPlugin)this));
                    break;
                }
                String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
                this.getPageCache().put(DIM_VALUE, dimValue);
                this.setBillFilter4DimChange(dimValue);
                this.refreshMemEntry();
                break;
            }
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
                if (Objects.isNull(modelId)) {
                    this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (Objects.equals(modelId, this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.modelChange(modelId);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), UserTypeEnum.USER.getName());
                break;
            }
            case "baseusergroup": {
                this.setData2UserEntry((ListSelectedRowCollection)evt.getReturnData(), UserTypeEnum.USERGROUP.getName());
                break;
            }
            case "selectmember": {
                this.setData2MemberEntry(evt.getReturnData());
                break;
            }
            case "baseauth": {
                this.setData2ClassEntry(evt.getReturnData());
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        boolean admin = PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin();
        if (!admin && !ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u5206\u914d\u6743\u7ba1\u7406\u529f\u80fd,\u4ec5\u4f53\u7cfb\u7ba1\u7406\u5458\u53ef\u5206\u914d\u7ba1\u7406\u6743\u9650\u3002", (String)"GrantFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "selectmember": {
                this.showMulMemberF7View();
                break;
            }
            case "delmember": 
            case "del_perm_clz": {
                this.deleteEntryRow(MEMBER_ENTRY_ID);
                break;
            }
            case "select_perm_clz": {
                if (!this.checkIsMemOptLegality(Boolean.TRUE, "model", USER_ENTRY_ID)) break;
                MulBasedataEdit auth = (MulBasedataEdit)this.getControl(BASE_AUTH);
                auth.click();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (Objects.equals(DIM_CHANGE_COMFIRM, callBackId)) {
            if (Objects.equals(messageBoxClosedEvent.getResult(), MessageBoxResult.Yes)) {
                String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
                this.getPageCache().put(DIM_VALUE, dimValue);
                this.setBillFilter4DimChange(dimValue);
                this.refreshMemEntry();
            } else {
                this.getPageCache().remove(IS_CHANGE);
                this.getModel().setValue(DIMENSION_COMBO_ID, (Object)this.getPageCache().get(DIM_VALUE));
                this.getPageCache().put(IS_CHANGE, Boolean.TRUE.toString());
            }
        } else if (Objects.equals(USER_CHANGE_COMFIRM, callBackId)) {
            if (Objects.equals(messageBoxClosedEvent.getResult(), MessageBoxResult.Yes)) {
                this.refreshMemEntry();
                int[] userSelect = this.getEnterySelectRows(USER_ENTRY_ID);
                if (ArrayUtils.isNotEmpty((int[])userSelect)) {
                    this.getPageCache().put(USER_SELECT, String.valueOf(userSelect[0]));
                }
            } else {
                EntryGrid grid = (EntryGrid)this.getControl(USER_ENTRY_ID);
                String s = this.getPageCache().get(USER_SELECT);
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    grid.selectRows(Integer.parseInt(s));
                }
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        EntryGrid grid = (EntryGrid)this.getControl(MEMBER_ENTRY_ID);
        if (Objects.equals(tabKey, DIM_MEM)) {
            this.changeTab(Boolean.TRUE);
            grid.setColumnProperty(NAME, "header", (Object)ResManager.loadKDString((String)"\u540d\u79f0", (String)"GrantFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (Objects.equals(tabKey, PERM_CLASS)) {
            this.changeTab(Boolean.FALSE);
            grid.setColumnProperty(NAME, "header", (Object)ResManager.loadKDString((String)"\u5907\u6ce8", (String)"GrantFormPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.refreshMemEntry();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid src = (EntryGrid)evt.getSource();
        if (Objects.equals(src.getEntryKey(), USER_ENTRY_ID)) {
            String userSelectStr = this.getPageCache().get(USER_SELECT);
            int[] userSelect = this.getEnterySelectRows(USER_ENTRY_ID);
            if (ArrayUtils.isNotEmpty((int[])userSelect)) {
                String row = String.valueOf(userSelect[0]);
                if (StringUtils.isBlank((CharSequence)userSelectStr)) {
                    this.refreshMemEntry();
                    if (ArrayUtils.isNotEmpty((int[])userSelect)) {
                        this.getPageCache().put(USER_SELECT, row);
                    }
                } else if (BooleanUtils.toBoolean((String)this.getPageCache().get(IS_CHANGE))) {
                    this.getView().showConfirm(typeMap.get(this.getTabKey()).get(CHANGE_TIP), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(USER_CHANGE_COMFIRM, (IFormPlugin)this));
                } else {
                    this.refreshMemEntry();
                }
            } else {
                this.getPageCache().remove(USER_SELECT);
                this.getPageCache().remove(IS_CHANGE);
                this.getModel().deleteEntryData(MEMBER_ENTRY_ID);
            }
        }
    }

    private void addListener() {
        this.addClickListeners(SELECT_MEMBER, DEL_MEMBER, SELECT_PERM_CLZ, DEL_PERM_CLZ);
        this.addItemClickListeners("advcontoolbarap", "toolbarap");
        BasedataEdit user = (BasedataEdit)this.getControl(BASE_USER);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userGroup = (BasedataEdit)this.getControl(BASE_USER_GROUP);
        userGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit auth = (BasedataEdit)this.getControl(BASE_AUTH);
        auth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid userEntryGrid = (EntryGrid)this.getControl(USER_ENTRY_ID);
        userEntryGrid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private String getBlankModelTip() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"GrantFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void changeTab(boolean isDimMem) {
        this.getView().setVisible(Boolean.valueOf(isDimMem), new String[]{"flexpanelap611", SELECT_MEMBER, DEL_MEMBER, "mem_includesub", INCLUDE_SUB});
        this.getView().setVisible(Boolean.valueOf(!isDimMem), new String[]{SELECT_PERM_CLZ, DEL_PERM_CLZ});
    }

    private boolean checkIsMemOptLegality(boolean isShowTip, String ... strings) {
        for (String s : strings) {
            boolean isEntry = Boolean.FALSE;
            String err = "";
            String key = "";
            switch (s) {
                case "model": {
                    key = "model";
                    err = this.getBlankModelTip();
                    break;
                }
                case "userentry": {
                    key = USER_ENTRY_ID;
                    err = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"GrantFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    isEntry = Boolean.TRUE;
                    break;
                }
                case "dimensioncombo": {
                    key = DIMENSION_COMBO_ID;
                    err = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"GrantFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            if (isEntry && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, err})) {
                if (!ArrayUtils.isEmpty((int[])this.getEnterySelectRows(USER_ENTRY_ID))) continue;
                if (isShowTip) {
                    this.getView().showTipNotification(err);
                }
                return Boolean.FALSE;
            }
            if (!Objects.isNull(this.getModel().getValue(DIMENSION_COMBO_ID))) continue;
            if (isShowTip) {
                this.getView().showTipNotification(err);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setBillFilter4DimChange(String dimValue) {
        Object[] dimData = this.getDimDataByValue(dimValue);
        if (ArrayUtils.isNotEmpty((Object[])dimData) && dimData.length >= 5) {
            this.getPageCache().put(MEMBER_TYPE, (String)dimData[2]);
        }
    }

    private void setDimensionCombo() {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(DIMENSION_COMBO_ID);
        List<Object> dimensionlist = this.getDimensionComData();
        dimensionlist = dimensionlist.stream().filter(str -> !Objects.equals("bcm_mycompanymembertree", str[2])).collect(Collectors.toList());
        this.getPageCache().put(LIST_DIMENSION, SerializationUtils.serializeToBase64(dimensionlist));
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        String dimId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        if (Objects.isNull(dimId)) {
            dimId = QueryDimensionServiceHelper.getDimIdByNumber((String)DimTypesEnum.ENTITY.getNumber(), (String)this.getPageCache().get("KEY_MODEL_ID"));
        }
        if (Objects.nonNull(dimId)) {
            String dimSeq = this.getDimSeqById(dimensionlist, dimId);
            this.getPageCache().put(DIM_VALUE, dimSeq);
            this.getModel().setValue(DIMENSION_COMBO_ID, (Object)dimSeq);
        }
    }

    private void setDimMemberFilter() {
        String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
        this.setBillFilter4DimChange(dimValue);
    }

    private List<String[]> getDimensionComData() {
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        String selectFields = "id,name,dseq,membermodel,membertable";
        QFBuilder fmodelid = new QFBuilder("model", "=", (Object)Long.valueOf(modelID));
        if (!this.isInterMem(modelID)) {
            fmodelid.and(NUMBER, "!=", (Object)DimTypesEnum.INTERCOMPANY.getNumber());
        }
        if (Objects.equals(ModelUtil.queryApp(this.getView()), ApplicationTypeEnum.EB)) {
            fmodelid.and(NUMBER, "!=", (Object)DimTypesEnum.SCENARIO.getNumber());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])fmodelid.toArray(), (String)ORDERBYS);
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)query.size());
        query.forEach(p -> {
            String[] dimensionArray = new String[]{p.getString(NAME), p.getString(ORDERBYS), p.getString("membermodel"), p.getString("membertable"), p.getString(ID)};
            dimList.add(dimensionArray);
        });
        return dimList;
    }

    private boolean isInterMem(String modelid) {
        QFBuilder qfb = new QFBuilder("model", "=", (Object)Long.valueOf(modelid));
        qfb.and("issysmember", "!=", (Object)1);
        return QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])qfb.toArray());
    }

    private String getDimSeqById(List<String[]> dimensionlist, String dimId) {
        if (CollectionUtils.isEmpty(dimensionlist)) {
            return "";
        }
        for (String[] ss : dimensionlist) {
            if (!Objects.equals(dimId, ss[4])) continue;
            return ss[1];
        }
        return dimensionlist.get(0)[1];
    }

    private void deleteEntryRow(String entryId) {
        int[] rows = this.getEnterySelectRows(entryId);
        if (ArrayUtils.isNotEmpty((int[])rows)) {
            this.getPageCache().put(IS_CHANGE, Boolean.TRUE.toString());
            if (Objects.equals(entryId, USER_ENTRY_ID)) {
                EntryGrid eg = (EntryGrid)this.getControl(entryId);
                eg.clearEntryState();
                this.getModel().deleteEntryData(MEMBER_ENTRY_ID);
                this.getPageCache().remove(IS_CHANGE);
                this.getPageCache().remove(USER_SELECT);
            }
            this.getModel().deleteEntryRows(entryId, rows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"GrantFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private int[] getEnterySelectRows(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        return eg.getSelectRows();
    }

    private int[] getEnteryRows(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        int n = eg.getEntryData().getEndIndex();
        int[] res = new int[n];
        for (int i = 0; i < n; ++i) {
            res[i] = i;
        }
        return res;
    }

    private void refreshMemEntry() {
        if (this.checkIsMemOptLegality(Boolean.FALSE, "model", DIMENSION_COMBO_ID, USER_ENTRY_ID)) {
            Pair<String, QFBuilder> tabAndFilters = this.getTabAndFilters();
            DynamicObjectCollection memEntry = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(MEMBER_ENTRY_ID);
            memEntry.clear();
            QFBuilder qfb = (QFBuilder)tabAndFilters.p2;
            long modelId = this.getModelId();
            if (Objects.equals(tabAndFilters.p1, DIM_MEM)) {
                qfb.and(MEMBER_TYPE, "=", (Object)this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[2]);
                qfb.and("dimension.id", "=", (Object)LongUtil.toLong((Object)this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[4]));
                for (DynamicObject dy : QueryServiceHelper.query((String)"bcm_member_grant", (String)"member,membertype,includesub,iscustomprop", (QFilter[])qfb.toArray())) {
                    IDNumberTreeNode memeber = dy.getBoolean(IS_CUSTOM_PROP) ? MemberReader.findMemberById((long)modelId, (String)"bcm_definedpropertyvalue", (Long)dy.getLong(MEMBER)) : MemberReader.findMemberById((long)modelId, (String)dy.getString(MEMBER_TYPE), (Long)dy.getLong(MEMBER));
                    if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, memeber)) continue;
                    DynamicObject row = memEntry.addNew();
                    row.set(NUMBER, (Object)memeber.getNumber());
                    row.set(NAME, (Object)memeber.getName());
                    row.set(INCLUDE_SUB, (Object)dy.getBoolean(INCLUDE_SUB));
                    row.set(MID, (Object)memeber.getId());
                }
                this.getView().updateView(MEMBER_ENTRY_ID);
            } else if (Objects.equals(tabAndFilters.p1, PERM_CLASS)) {
                for (DynamicObject dy : QueryServiceHelper.query((String)"bcm_class_grant", (String)"permclass.id,permclass.number,permclass.remark", (QFilter[])qfb.toArray())) {
                    DynamicObject row = memEntry.addNew();
                    row.set(NUMBER, (Object)dy.getString("permclass.number"));
                    row.set(NAME, (Object)dy.getString("permclass.remark"));
                    row.set(MID, (Object)dy.getLong(PERMCLASS_ID));
                }
                this.getView().updateView(MEMBER_ENTRY_ID);
            }
        } else {
            this.getModel().deleteEntryData(MEMBER_ENTRY_ID);
            this.getPageCache().remove(IS_CHANGE);
        }
    }

    private Pair<String, QFBuilder> getTabAndFilters() {
        Tab tab = (Tab)this.getControl(TAB_AP);
        String currentTab = tab.getCurrentTab();
        QFBuilder qfb = new QFBuilder("model", "=", (Object)this.getModelId());
        qfb.and(USERS, "in", (Object)this.getEntrySelectedAndResultList(USER_ENTRY_ID, Boolean.FALSE).get(0).getLong("eusers.id"));
        return Pair.onePair((Object)currentTab, (Object)qfb);
    }

    private void save() {
        if (!this.checkIsMemOptLegality(Boolean.TRUE, "model", DIMENSION_COMBO_ID, USER_ENTRY_ID)) {
            return;
        }
        List<DynamicObject> userList = this.getEntrySelectedAndResultList(USER_ENTRY_ID, Boolean.FALSE);
        List<DynamicObject> memberList = this.getEntrySelectedAndResultList(MEMBER_ENTRY_ID, Boolean.TRUE);
        Pair<String, QFBuilder> tabAndFilters = this.getTabAndFilters();
        QFBuilder qfb = (QFBuilder)tabAndFilters.p2;
        if (Objects.equals(tabAndFilters.p1, DIM_MEM)) {
            qfb.and(MEMBER_TYPE, "=", (Object)this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[2]);
            qfb.and("dimension.id", "=", (Object)LongUtil.toLong((Object)this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[4]));
            DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bcm_member_grant", (String)"member.id,includesub,iscustomprop", (QFilter[])qfb.toArray());
            Map dId = Arrays.stream(doc).collect(Collectors.toMap(t -> t.getLong("member_id"), Function.identity()));
            ArrayList dto = Lists.newArrayListWithExpectedSize((int)memberList.size());
            memberList.forEach(t -> {
                long id = t.getLong(MID);
                if (Objects.isNull(dId.get(id))) {
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_member_grant");
                    dy.set(INCLUDE_SUB, (Object)t.getBoolean(INCLUDE_SUB));
                    dy.set(USERS, ((DynamicObject)userList.get(0)).getDynamicObject(E_USERS).getPkValue());
                    dy.set(USER_TYPE, (Object)((DynamicObject)userList.get(0)).getString(E_TYPE));
                    dy.set("model", (Object)this.getModelId());
                    String dimValue = this.getPageCache().get(DIM_VALUE);
                    dy.set(MEMBER_TYPE, (Object)this.getDimDataByValue(dimValue)[2]);
                    dy.set(DIMENSION, (Object)LongUtil.toLong((Object)this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[4]));
                    dy.set(MEMBER, (Object)t.getLong(MID));
                    dy.set(INCLUDE_SUB, (Object)t.getBoolean(INCLUDE_SUB));
                    dy.set(CREATER, (Object)RequestContext.get().getCurrUserId());
                    if (StringUtils.isBlank((CharSequence)t.getString(PROID))) {
                        dy.set(IS_CUSTOM_PROP, (Object)0);
                    } else {
                        dy.set(IS_CUSTOM_PROP, (Object)1);
                    }
                    dto.add(dy);
                } else {
                    DynamicObject dy = (DynamicObject)dId.get(id);
                    if (!Objects.equals(dy.getBoolean(INCLUDE_SUB), t.getBoolean(INCLUDE_SUB))) {
                        dy.set(INCLUDE_SUB, (Object)t.getBoolean(INCLUDE_SUB));
                        dto.add(dy);
                    }
                    dId.remove(id);
                }
            });
            try {
                this.checkMemberGrantPerm(this.getModelId(), Long.valueOf(this.getDimDataByValue(this.getPageCache().get(DIM_VALUE))[4]), dto, dId.values());
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            this.saveService(dto, dId.keySet(), "bcm_member_grant", MEMBER_ID, qfb);
        } else if (Objects.equals(tabAndFilters.p1, PERM_CLASS)) {
            DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bcm_class_grant", (String)PERMCLASS_ID, (QFilter[])qfb.toArray());
            Set<Long> dId = Arrays.stream(doc).map(t -> t.getLong(PERMCLASS_ID)).collect(Collectors.toSet());
            ArrayList dto = Lists.newArrayListWithExpectedSize((int)memberList.size());
            memberList.forEach(t -> {
                long id = t.getLong(MID);
                if (!dId.remove(id)) {
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_class_grant");
                    dy.set(USERS, ((DynamicObject)userList.get(0)).getDynamicObject(E_USERS).getPkValue());
                    dy.set(USER_TYPE, (Object)((DynamicObject)userList.get(0)).getString(E_TYPE));
                    dy.set("model", (Object)this.getModelId());
                    dy.set(PERMCLASS, (Object)t.getLong(MID));
                    dy.set(CREATER, (Object)RequestContext.get().getCurrUserId());
                    dto.add(dy);
                }
            });
            try {
                this.checkClassGrantPerm(this.getModelId(), dto, dId);
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            this.saveService(dto, dId, "bcm_class_grant", PERMCLASS_ID, qfb);
        }
        this.getPageCache().remove(IS_CHANGE);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GrantFormPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void query() {
        String pageId;
        IFormView mainPageView = this.getView().getMainView();
        IFormView childFormView = mainPageView.getView(pageId = this.getView().getPageId() + BCM_GRANT_REPORT);
        if (Objects.isNull(childFormView)) {
            IFormView parentView = this.getView().getParentView();
            ReportShowParameter form = new ReportShowParameter();
            form.setFormId(BCM_GRANT_REPORT);
            form.setPageId(pageId);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setCustomParam("model", (Object)this.getModelId());
            parentView.showForm((FormShowParameter)form);
            this.getView().sendFormAction(parentView);
        } else {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void checkClassGrantPerm(Long modelId, List<DynamicObject> dto, Set<Long> dId) {
        if (PermissionServiceImpl.getInstance((Long)modelId).isAdmin()) {
            return;
        }
        Set<Long> permClass = GrantPermUtil.getPermClass(modelId);
        if (!permClass.containsAll(dId)) {
            throw new KDBizException(GrantFormPlugin.getNoPermTip());
        }
        Optional<DynamicObject> permclass = dto.stream().filter(dy -> !permClass.contains(dy.getLong(PERMCLASS))).findFirst();
        if (permclass.isPresent()) {
            throw new KDBizException(GrantFormPlugin.getNoPermTip());
        }
    }

    private static String getNoPermTip() {
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u201c\u5206\u914d\u6743\u201d\u76f8\u5173\u914d\u7f6e\u3002", (String)"GrantFormPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void saveService(List<DynamicObject> dto, Set<Long> dId, String entity, String delField, QFBuilder qfb) {
        try (TXHandle tx = TX.required((String)"GrantAuthFormPluginSaveData");){
            try {
                if (CollectionUtils.isNotEmpty(dto)) {
                    SaveServiceHelper.save((DynamicObject[])dto.toArray(new DynamicObject[0]));
                }
                if (CollectionUtils.isNotEmpty(dId)) {
                    qfb.and(delField, "in", dId);
                    DeleteServiceHelper.delete((String)entity, (QFilter[])qfb.toArray());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(e.getMessage(), (Throwable)e);
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5206\u914d", "OpItemEnum_7", "fi-bcm-common", "distribution"), new OPDescMultiLangEnumBridge("\u6210\u5458\u6743\u9650%s\u6761\u8bb0\u5f55\u5206\u914d\u6210\u529f\u3002", "OpItemEnum_183", "fi-bcm-common", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.valueOf(dto.size() + dId.size())})));
    }

    private void checkMemberGrantPerm(Long modelId, Long dimId, List<DynamicObject> dto, Collection<DynamicObject> values) {
        RangeEnum rangeEnum;
        if (PermissionServiceImpl.getInstance((Long)modelId).isAdmin()) {
            return;
        }
        for (DynamicObject dy : dto) {
            RangeEnum rangeEnum2 = rangeEnum = dy.getBoolean(INCLUDE_SUB) ? RangeEnum.VALUE_50 : RangeEnum.VALUE_10;
            if (GrantPermUtil.hasGrantPerm(modelId, dimId, this.convert2MemLong(dy), rangeEnum, dy.getBoolean(IS_CUSTOM_PROP))) continue;
            throw new KDBizException(GrantFormPlugin.getNoPermTip());
        }
        for (DynamicObject dy : values) {
            RangeEnum rangeEnum3 = rangeEnum = dy.getBoolean(INCLUDE_SUB) ? RangeEnum.VALUE_50 : RangeEnum.VALUE_10;
            if (GrantPermUtil.hasGrantPerm(modelId, dimId, this.convert2MemLong(dy), rangeEnum, dy.getBoolean(IS_CUSTOM_PROP))) continue;
            throw new KDBizException(GrantFormPlugin.getNoPermTip());
        }
    }

    private long convert2MemLong(DynamicObject dy) {
        Object mem = dy.get(MEMBER);
        long memId = 0L;
        if (mem instanceof Long) {
            memId = dy.getLong(MEMBER);
        } else if (mem instanceof DynamicObject) {
            memId = dy.getLong(MEMBER_ID);
        }
        return memId;
    }

    private String[] getDimDataByValue(String dimValue) {
        List dimensionlist = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(LIST_DIMENSION));
        for (String[] ss : dimensionlist) {
            if (!ss[1].equals(dimValue)) continue;
            return ss;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private List<DynamicObject> getEntrySelectedAndResultList(String entityid, boolean isALl) {
        int[] rows = isALl ? this.getEnteryRows(entityid) : this.getEnterySelectRows(entityid);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)rows.length);
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityid, row);
            if (!Objects.nonNull(dd)) continue;
            if (Objects.equals(USER_ENTRY_ID, entityid)) {
                DynamicObject user = dd.getDynamicObject(E_USERS);
                if (!Objects.nonNull(user) || Objects.equals(user.getPkValue(), 0L)) continue;
                list.add(dd);
                continue;
            }
            list.add(dd);
        }
        return list;
    }

    private void setData2UserEntry(ListSelectedRowCollection returnData, String baseType) {
        if (Objects.isNull(returnData)) {
            return;
        }
        List<Object> oids = this.getOldDisIds();
        returnData.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(USER_ENTRY_ID);
                this.getModel().setValue(E_TYPE, (Object)baseType, rowIndex);
                this.getModel().setValue(E_USERS, p.getPrimaryKeyValue(), rowIndex);
            }
        });
    }

    private List<Object> getOldDisIds() {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        this.getModel().getEntryEntity(USER_ENTRY_ID).forEach(p -> {
            if (Objects.nonNull(p.getDynamicObject(E_USERS))) {
                ids.add(p.getDynamicObject(E_USERS).getPkValue());
            }
        });
        return ids;
    }

    private void setDefaultSelectRows(EntryGrid eg, Set<Integer> listRows, int[] rows) {
        for (int row : rows) {
            listRows.add(row);
        }
        if (CollectionUtils.isEmpty(listRows)) {
            return;
        }
        rows = new int[listRows.size()];
        int index = 0;
        for (Integer row : listRows) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void setData2MemberEntry(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        this.getPageCache().put(IS_CHANGE, Boolean.TRUE.toString());
        DynamicObjectCollection newdoc = (DynamicObjectCollection)returnData;
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(MEMBER_ENTRY_ID);
        if (StringUtils.isBlank((CharSequence)((DynamicObject)newdoc.get(0)).getString(6))) {
            this.replaceOrgidToBaseId(newdoc);
        }
        this.delRepeatDataAndWrite(newdoc, olddoc);
    }

    private void setData2ClassEntry(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        this.getPageCache().put(IS_CHANGE, Boolean.TRUE.toString());
        ListSelectedRowCollection newdoc = (ListSelectedRowCollection)returnData;
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(MEMBER_ENTRY_ID);
        EntryGrid eg = (EntryGrid)this.getControl(MEMBER_ENTRY_ID);
        HashSet listRows = Sets.newHashSetWithExpectedSize((int)olddoc.size());
        Map<Long, Pair> collect = QueryServiceHelper.query((String)"bcm_permissionclass", (String)"id,number,remark", (QFilter[])new QFBuilder(ID, "in", newdoc.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet())).toArray()).stream().collect(Collectors.toMap(t -> t.getLong(ID), t -> Pair.onePair((Object)t.getString(NUMBER), (Object)t.getString("remark"))));
        for (ListSelectedRow newd : newdoc) {
            Object primaryKey;
            boolean flag = Boolean.TRUE;
            for (DynamicObject oldd : olddoc) {
                if (!Objects.equals(newd.getPrimaryKeyValue(), oldd.getLong(MID))) continue;
                flag = Boolean.FALSE;
                break;
            }
            if (!flag || !((primaryKey = newd.getPrimaryKeyValue()) instanceof Long)) continue;
            int rowIndex = this.getModel().createNewEntryRow(MEMBER_ENTRY_ID);
            this.getModel().setValue(NUMBER, collect.get((Object)primaryKey).p1, rowIndex);
            this.getModel().setValue(NAME, collect.get((Object)primaryKey).p2, rowIndex);
            this.getModel().setValue(MID, newd.getPrimaryKeyValue(), rowIndex);
            listRows.add(rowIndex);
        }
        this.setDefaultSelectRows(eg, listRows, eg.getSelectRows());
    }

    private void replaceOrgidToBaseId(DynamicObjectCollection doc) {
        ArrayList numbers = Lists.newArrayListWithExpectedSize((int)doc.size());
        for (DynamicObject obj : doc) {
            numbers.add(obj.getString(2));
        }
        String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
        String[] dimData = this.getDimDataByValue(dimValue);
        if (Objects.isNull(dimData)) {
            return;
        }
        String dimId = dimData[4];
        QFBuilder qf = new QFBuilder(DIMENSION, "=", (Object)Long.valueOf(dimId));
        qf.and(NUMBER, "in", (Object)numbers);
        qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)dimData[2], (String)"id,number", (QFilter[])qf.toArray());
        HashMap number2id = Maps.newHashMapWithExpectedSize((int)orgs.size());
        for (DynamicObject obj : orgs.values()) {
            number2id.put(obj.getString(NUMBER), obj.getLong(ID));
        }
        for (DynamicObject obj : doc) {
            String number = obj.getString(2);
            if (!number2id.containsKey(number)) continue;
            obj.set(4, number2id.get(number));
        }
    }

    private void modelChange(String modelId) {
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.setDimensionCombo();
        this.getModel().deleteEntryData(USER_ENTRY_ID);
        this.getModel().deleteEntryData(MEMBER_ENTRY_ID);
        this.getPageCache().remove(IS_CHANGE);
        this.getPageCache().remove(USER_SELECT);
    }

    private void showMulMemberF7View() {
        if (this.checkIsMemOptLegality(Boolean.TRUE, "model", DIMENSION_COMBO_ID, USER_ENTRY_ID)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_mulmemberf7base_tem");
            String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
            Object[] dimData = this.getDimDataByValue(dimValue);
            if (ArrayUtils.isNotEmpty((Object[])dimData)) {
                HashMap params = Maps.newHashMapWithExpectedSize((int)16);
                params.put(DIMENSION, dimValue);
                params.put("isUpDownBtn", Boolean.TRUE);
                params.put("isExchangeRate", "1");
                params.put("isfromDimDesigner", Boolean.TRUE.toString());
                params.put("f7modelId", this.getModelId());
                params.put("sign", dimData[2]);
                params.put("source", "memberPerm");
                params.put("isNotPermFilterF7", Boolean.TRUE);
                params.put("isPEnableGrantPerm", Boolean.TRUE);
                params.put("IS_VISIBLE_RANGE", Boolean.TRUE);
                params.put("IS_VISIBLE_CUSTOM_PROPERTY", Boolean.TRUE);
                formShowParameter.setCustomParams((Map)params);
                formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"GrantFormPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimData[0]));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_MEMBER);
                formShowParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private void delRepeatDataAndWrite(DynamicObjectCollection newdoc, DynamicObjectCollection olddoc) {
        EntryGrid eg = (EntryGrid)this.getControl(MEMBER_ENTRY_ID);
        int[] rows = eg.getSelectRows();
        HashSet listRows = Sets.newHashSetWithExpectedSize((int)newdoc.size());
        String dimValue = (String)this.getModel().getValue(DIMENSION_COMBO_ID);
        String[] dimData = this.getDimDataByValue(dimValue);
        if (Objects.nonNull(dimData) && dimData.length >= 5) {
            for (DynamicObject newd : newdoc) {
                boolean flag = Boolean.TRUE;
                for (DynamicObject oldd : olddoc) {
                    if (!newd.getString(4).equals(oldd.getString(MID))) continue;
                    flag = Boolean.FALSE;
                    break;
                }
                if (!flag) continue;
                int rowIndex = this.getModel().createNewEntryRow(MEMBER_ENTRY_ID);
                this.getModel().setValue(NUMBER, newd.get(2), rowIndex);
                this.getModel().setValue(NAME, newd.get(3), rowIndex);
                this.getModel().setValue(MID, newd.get(4), rowIndex);
                this.getModel().setValue(PROID, newd.get(6), rowIndex);
                listRows.add(rowIndex);
            }
            this.setDefaultSelectRows(eg, listRows, rows);
        }
    }

    private String getTabKey() {
        Tab tab = (Tab)this.getControl(TAB_AP);
        return tab.getCurrentTab();
    }
}

