/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class MemberPermFormRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParam("model") != null) {
            this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
            this.getPageCache().put(this.getModelSign(), "true");
            this.setComboItems();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit userF7 = (BasedataEdit)this.getControl("users");
        userF7.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getFormShowParameter().setCustomParam("externalUserType", (Object)"all"));
        ItemClassEdit members = (ItemClassEdit)this.getControl("members");
        members.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.getModel().getValue(this.getModelSign()) != null) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter(this.getModelSign(), "=", (Object)((DynamicObject)this.getModel().getValue(this.getModelSign())).getLong("id")));
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)10);
            }
            qFilterList.addAll(ModelUtil.getModelFilters((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public String getModelSign() {
        return "model";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (this.getModelSign().equals(name)) {
            if (this.getModel().getValue(this.getModelSign()) == null) {
                return;
            }
            this.setComboItems();
            this.getPageCache().put(this.getModelSign(), "true");
        }
    }

    private void setComboItems() {
        ComboEdit membertype = (ComboEdit)this.getControl("membertype");
        List items = ((ItemClassTypeProp)membertype.getProperty()).getComboItems();
        if (Objects.nonNull(items)) {
            ArrayList comboItems = Lists.newArrayListWithCapacity((int)items.size());
            items.forEach(item -> {
                if ("bcm_audittrialmembertree".equals(item.getValue())) {
                    if (MemberReader.isExistAuditTrailDimension((long)((DynamicObject)this.getModel().getValue(this.getModelSign())).getLong("id"))) {
                        comboItems.add(new ComboItem(item.getName(), item.getValue()));
                    }
                } else if ("bcm_changetypemembertree".equals(item.getValue())) {
                    if (MemberReader.isExistChangeTypeDimension((long)((DynamicObject)this.getModel().getValue(this.getModelSign())).getLong("id"))) {
                        comboItems.add(new ComboItem(item.getName(), item.getValue()));
                    }
                } else {
                    comboItems.add(new ComboItem(item.getName(), item.getValue()));
                }
            });
            membertype.setComboItems((List)comboItems);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (this.getPageCache().get(this.getModelSign()) == null || this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MemberPermFormRpt_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

