/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class MemberPermListDataRpt
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        long modelId = filterInfo.getDynamicObject("model").getLong("id");
        List<Long> userIds = null;
        List<Long> memberIds = null;
        DynamicObjectCollection users = filterInfo.getDynamicObjectCollection("users");
        DynamicObject member = filterInfo.getDynamicObject("members");
        String dimStr = filterInfo.getString("membertype");
        if (StringUtils.isEmpty((CharSequence)dimStr)) {
            return this.getEmptyDataSet();
        }
        String status = filterInfo.getString("selectpermstatus");
        Long dimId = this.getDimId(dimStr, modelId);
        if (users != null) {
            userIds = this.getIdList(users);
        }
        if (member != null) {
            memberIds = Collections.singletonList(member.getLong("id"));
        }
        QFilter nFilters = new QFilter("model", "=", (Object)modelId);
        nFilters.and("dimension", "=", (Object)dimId);
        if (userIds != null) {
            nFilters = nFilters.and("users", "in", userIds);
        }
        if (member != null) {
            nFilters = nFilters.and("member.id", "in", memberIds);
        }
        if (!status.equals("0")) {
            nFilters = nFilters.and(new QFilter("permission", "=", (Object)status));
        }
        String selectFileds = String.format("model.shownumber as modelnum,users.name as user,users.number as worknumber,member,case when permission='1' then '%s' when permission='2' then '%s' else '%s' end as permstatus", ResManager.loadKDString((String)"\u8bfb\u5199", (String)"MemberPermListDataRpt_01", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ea\u8bfb", (String)"MemberPermListDataRpt_02", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e0\u6743", (String)"MemberPermListDataRpt_03", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        DataSet userPermDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bcm_memberperm", (String)selectFileds, (QFilter[])new QFilter[]{nFilters}, (String)null);
        DataSet data = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)dimStr, (String)"id,number as membernum ,name as membername", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, null);
        userPermDataSet = userPermDataSet.join(data).on("member", "id").select(new String[]{"modelnum", "user", "worknumber", "membernum", "membername", "permstatus"}).finish();
        return userPermDataSet;
    }

    private List<Long> getIdList(DynamicObjectCollection objList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject object : objList) {
            idList.add(object.getLong("id"));
        }
        return idList;
    }

    private List<String> getObjectTypeList(DynamicObjectCollection objList) {
        ArrayList<String> idList = new ArrayList<String>();
        for (DynamicObject object : objList) {
            idList.add(String.valueOf(object.getString("id")));
        }
        return idList;
    }

    private Long getDimId(String type, Long modelId) {
        QFBuilder range = new QFBuilder("membermodel", "=", (Object)type);
        range.add("model", "=", (Object)modelId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])range.toArray());
        return dyn == null ? 0L : dyn.getLong("id");
    }

    private DataSet getEmptyDataSet() {
        ArrayList coll = Lists.newArrayListWithExpectedSize((int)10);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[0], (DataType[])new DataType[0]);
        CollectionInput inputs = new CollectionInput(rowMeta, (Collection)coll);
        DataSet result = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        return result;
    }
}

