/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermSpreadLogic;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.PermSourceEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.StringUtils;

public class MemerPermReportListPlugin
extends AbstractReportListDataPlugin {
    private static final String MODEL = "model";
    public static final String ORG = "org";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final String MEMBERTYPE = "membertype";
    private static final String PERMSOURCE = "permsource";
    private static final String PERMSTATE = "permstate";
    private static final String MEMBER = "member";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ENTITYID = "entityid";
    private static final String ID = "id";
    private static final String QUERY_BY_GROUP = "2";
    private static final String QUERYELECT = "queryselect";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String SEPARATOR = ";";
    private static final String PLACEHOLDER = "#";
    private static final String USER_ID = "user.id";
    private static final String MEMBER_NUM = "member_num";
    private static final String[] ALL_FILEDS = new String[]{"list_model", "list_username", "list_worknumber", "list_group", "list_groupname", "list_membertype", "list_membernumber", "list_membername", "list_permsource", "list_permstate", "list_permsourcegroup", "list_permsourceuser", "list_permsourcenumber", "permsource", "permstate"};
    private static final DataType[] ALL_FILEDS_TYPE = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.IntegerType};
    private static final Map<String, String> formMap = new ImmutableMap.Builder().put((Object)DimEntityNumEnum.ENTITY.getNumber(), (Object)"bcm_entitymembertree").put((Object)DimEntityNumEnum.ACCOUNT.getNumber(), (Object)"bcm_accountmembertree").put((Object)DimEntityNumEnum.SCENARIO.getNumber(), (Object)"bcm_scenemembertree").put((Object)DimEntityNumEnum.YEAR.getNumber(), (Object)"bcm_fymembertree").put((Object)DimEntityNumEnum.PERIOD.getNumber(), (Object)"bcm_periodmembertree").put((Object)DimEntityNumEnum.PROCESS.getNumber(), (Object)"bcm_processmembertree").put((Object)DimEntityNumEnum.CURRENCY.getNumber(), (Object)"bcm_currencymembertree").put((Object)DimEntityNumEnum.AUDITTRIAL.getNumber(), (Object)"bcm_audittrialmembertree").put((Object)DimEntityNumEnum.CHANGETYPE.getNumber(), (Object)"bcm_changetypemembertree").put((Object)DimEntityNumEnum.DATASORT.getNumber(), (Object)"bcm_datasortmembertree").put((Object)DimEntityNumEnum.MULTIGAAP.getNumber(), (Object)"bcm_rulemembertree").put((Object)DimEntityNumEnum.MYCOMPANY.getNumber(), (Object)"bcm_mycompanymembertree").put((Object)DimEntityNumEnum.INTERCOMPANY.getNumber(), (Object)"bcm_icmembertree").put((Object)DimEntityNumEnum.EXTENDS.getNumber(), (Object)"bcm_structofextend").build();
    private static final Map<Integer, PermSourceEnum> sourceMap = new ImmutableMap.Builder().put((Object)1, (Object)PermSourceEnum.USER_MEMBER).put((Object)2, (Object)PermSourceEnum.USER_PERMCLASS).put((Object)3, (Object)PermSourceEnum.GROUP_MEMBER).put((Object)4, (Object)PermSourceEnum.GROUP_PERMCLASS).build();
    private static final Map<Integer, PermEnum> permClassToPermMap = new ImmutableMap.Builder().put((Object)1, (Object)PermEnum.NOPERM).put((Object)2, (Object)PermEnum.READONLY).put((Object)3, (Object)PermEnum.READWRITE).build();
    private Long modelId = null;
    private DynamicObject model = null;
    private String memberType = null;
    private PermSourceEnum permSource = null;
    private Integer permState = null;
    private boolean queryByUser = true;
    private final Set<Long> memberIds = Sets.newHashSetWithExpectedSize((int)16);
    private boolean selectUser = false;
    private final Map<Long, Pair<String, String>> groupMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Pair<String, String>> userMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Map<Long, Integer>> userPermClass = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Map<Long, Integer>> userGroupPermClass = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Map<Long, Integer>> userMemberPerm = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Map<Long, Integer>> userGroupMemberPerm = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, Pair<String, String>> memberMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<Long, String> permClassNumberMap = Maps.newHashMapWithExpectedSize((int)16);

    private String getMemberDesc() {
        return ResManager.loadKDString((String)"\u6210\u5458\u6743\u9650\u5206\u914d", (String)"MemerPermReportListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getDisFunDesc() {
        return ResManager.loadKDString((String)"\u76f4\u63a5\u6388\u6743", (String)"MemerPermReportListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getMaxSelectCountDesc(Integer curCount, Integer maxCount) {
        return String.format(ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u8bb0\u5f55\u8fc7\u591a\uff0c\u8bf7\u6dfb\u52a0\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u3002(\u5f53\u524d\uff1a%1$s\uff0c\u9650\u5236\uff1a%2$s)", (String)"MemerPermReportListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), curCount, maxCount);
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        this.paramHandler(reportQueryParam.getFilter().getFilterItems(), reportQueryParam.getCustomParam());
        this.initAllPermUser();
        this.permClassHandler();
        this.memberPermHandler();
        Collection<Object[]> value = this.buildDataSetValue();
        DataSet result = this.initDataSet(value);
        String filter = this.buildFilter();
        if (StringUtils.isNotEmpty((String)filter)) {
            return result.filter(filter);
        }
        return result;
    }

    private Collection<Object[]> buildDataSetValue() {
        ArrayList<Object[]> value = new ArrayList<Object[]>(16);
        if (this.queryByUser) {
            this.buildDataSetByUser(value);
        } else {
            this.buildDataSetByUserGroup(value);
        }
        return value;
    }

    private void paramHandler(List<FilterItemInfo> filterItems, Map<String, Object> customParam) {
        block20: for (FilterItemInfo filterItem : filterItems) {
            Object value = filterItem.getValue();
            switch (filterItem.getPropName()) {
                case "model": {
                    this.model = (DynamicObject)value;
                    this.modelId = this.model.getLong(ID);
                    break;
                }
                case "membertype": {
                    this.memberType = String.valueOf(value);
                    break;
                }
                case "permsource": {
                    Integer val = Integer.valueOf(String.valueOf(value));
                    this.permSource = sourceMap.get(val);
                    break;
                }
                case "permstate": {
                    Integer state = Integer.valueOf(String.valueOf(value));
                    PermEnum permEnum = permClassToPermMap.get(state);
                    this.permState = Objects.nonNull(permEnum) ? Integer.valueOf(permEnum.getValue()) : null;
                    break;
                }
                case "queryselect": {
                    if (!Objects.equals(String.valueOf(value), QUERY_BY_GROUP)) break;
                    this.queryByUser = false;
                    break;
                }
                case "user": {
                    if (Objects.isNull(value)) break;
                    this.selectUser = true;
                    DynamicObjectCollection users = (DynamicObjectCollection)value;
                    this.userMap.putAll(users.stream().collect(Collectors.toMap(k -> k.getLong(ID), v -> new Pair((Object)v.getString(NUMBER), (Object)v.getString(NAME)))));
                    break;
                }
                case "group": {
                    if (Objects.isNull(value)) break;
                    DynamicObjectCollection groups = (DynamicObjectCollection)value;
                    this.groupMap.putAll(groups.stream().collect(Collectors.toMap(k -> k.getLong(ID), v -> new Pair((Object)v.getString(NUMBER), (Object)v.getString(NAME)))));
                    break;
                }
                case "member": {
                    Object memNumsObj = customParam.get(MEMBER_NUM);
                    if (!Objects.nonNull(memNumsObj)) break;
                    String memNumsStr = memNumsObj.toString();
                    if (!StringUtils.isNotBlank((String)memNumsStr)) continue block20;
                    List memNums = SerializationUtils.fromJsonStringToList((String)memNumsStr, String.class);
                    memNums.forEach(t -> {
                        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)this.memberType, (String)t.toString());
                        if (Objects.nonNull(node) && !Objects.equals(IDNumberTreeNode.NotFoundTreeNode, node)) {
                            this.memberIds.add(node.getId());
                            this.memberMap.put(node.getId(), (Pair<String, String>)new Pair((Object)t.toString(), (Object)node.getName()));
                        }
                    });
                    break;
                }
            }
        }
    }

    private void permClassHandler() {
        Map<Long, Set<Long>> allPermClassIds = this.getAllPermClassIds();
        if (CollectionUtils.isEmpty(allPermClassIds)) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId);
        qfBuilder.and(new QFilter("authclass", "in", allPermClassIds.keySet()));
        this.addFilter(qfBuilder);
        String selectFields = "users,usertype,authclass,data_auth";
        DynamicObjectCollection permClassAuth = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfBuilder.toArray());
        if (CollectionUtils.isEmpty((Collection)permClassAuth)) {
            return;
        }
        int count = this.setPDataPermReportLimit(ConfigServiceHelper.getStringParamNoModel((String)"PDataPermReportLimit"));
        if (permClassAuth.size() > count) {
            throw new KDBizException(this.getMaxSelectCountDesc(permClassAuth.size(), count));
        }
        permClassAuth.forEach(auth -> {
            long users = auth.getLong("users");
            long permClassId = auth.getLong("authclass");
            int perm = auth.getInt("data_auth");
            String userType = auth.getString("usertype");
            perm = permClassToPermMap.get(perm).getValue();
            if (Objects.equals(UserTypeEnum.USER.getName(), userType)) {
                if (this.userMap.containsKey(users)) {
                    this.permClassHandler(this.userPermClass, users, permClassId, perm, allPermClassIds);
                }
            } else {
                this.permClassHandler(this.userGroupPermClass, users, permClassId, perm, allPermClassIds);
            }
        });
    }

    private void memberPermHandler() {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId);
        qfBuilder.and(new QFilter(MEMBERTYPE, "=", (Object)formMap.getOrDefault(this.memberType, "bcm_userdefinedmembertree")));
        this.addFilter(qfBuilder);
        MemberPermSpreadLogic mpsl = new MemberPermSpreadLogic();
        DynamicObjectCollection allMemberPerms = mpsl.getAllMemberPerms(formMap.getOrDefault(this.memberType, "bcm_userdefinedmembertree"), qfBuilder.toArray());
        int count = this.setPDataPermReportLimit(ConfigServiceHelper.getStringParamNoModel((String)"PDataPermReportLimit"));
        if (allMemberPerms.size() > count) {
            throw new KDBizException(this.getMaxSelectCountDesc(allMemberPerms.size(), count));
        }
        Map<String, List<DynamicObject>> map = allMemberPerms.stream().collect(Collectors.groupingBy(memberPerm -> new StringJoiner(SEPARATOR).add(memberPerm.getString("usertype")).add(memberPerm.getString("users")).toString()));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String[] split = entry.getKey().split(SEPARATOR);
            if (split.length < 2) continue;
            Map permMap = mpsl.buildMemberPerm(entry.getValue(), formMap.getOrDefault(this.memberType, "bcm_userdefinedmembertree"), (Object)this.modelId);
            Long userId = LongUtil.toLong((Object)split[1]);
            if (Objects.equals(UserTypeEnum.USERGROUP.getName(), split[0])) {
                this.userGroupMemberPerm.put(userId, permMap);
                continue;
            }
            if (!this.userMap.containsKey(userId)) continue;
            this.userMemberPerm.put(userId, permMap);
        }
    }

    private void addFilter(QFBuilder qfBuilder) {
        if (this.queryByUser) {
            if (this.selectUser && !CollectionUtils.isEmpty(this.userMap)) {
                Set<Long> userIds = this.userMap.keySet();
                HashSet selectIds = Sets.newHashSetWithExpectedSize((int)16);
                for (Long userId : userIds) {
                    selectIds.add(userId);
                    selectIds.addAll(UserDistributeServiceHelper.queryAllGroupByUserId((long)userId));
                }
                qfBuilder.and(new QFilter("users", "in", (Object)selectIds));
            }
        } else {
            qfBuilder.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
        }
        if (!CollectionUtils.isEmpty(this.groupMap)) {
            qfBuilder.and(new QFilter("users", "in", this.groupMap.keySet()));
        }
    }

    private void buildDataSetByUser(Collection<Object[]> value) {
        Map<Long, Set<Long>> userGroupMap = this.getUserGroupMap(this.userMap.keySet());
        HashMap res = Maps.newHashMap();
        for (Long userId : this.userMap.keySet()) {
            Map userMember = this.userMemberPerm.getOrDefault(userId, Collections.emptyMap());
            Map userClass = this.userPermClass.getOrDefault(userId, Collections.emptyMap());
            HashSet allMemberIds = Sets.newHashSet();
            if (CollectionUtils.isEmpty(this.memberIds)) {
                allMemberIds.addAll(userMember.keySet());
                allMemberIds.addAll(userClass.keySet());
                Set<Long> groupIds = userGroupMap.getOrDefault(userId, Collections.emptySet());
                groupIds.forEach(groupId -> {
                    allMemberIds.addAll(this.userGroupMemberPerm.getOrDefault(groupId, Collections.emptyMap()).keySet());
                    allMemberIds.addAll(this.userGroupPermClass.getOrDefault(groupId, Collections.emptyMap()).keySet());
                });
            } else {
                allMemberIds.addAll(this.memberIds);
            }
            for (Long memberId : allMemberIds) {
                String permClassNumber;
                String key = new StringJoiner(PLACEHOLDER).add(userId.toString()).add(memberId.toString()).toString();
                ReportColumn reportColumn = (ReportColumn)res.get(key);
                Integer userMemberPerm = (Integer)userMember.get(memberId);
                reportColumn = this.buildReportColumnByUser(userId, memberId, userMemberPerm, reportColumn, this.getMemberDesc(), PermSourceEnum.USER_MEMBER.getValue(), null);
                boolean hasDataAuth = false;
                Integer userClassPerm = (Integer)userClass.get(memberId);
                if (userClassPerm != null) {
                    hasDataAuth = true;
                }
                reportColumn = this.buildReportColumnByUser(userId, memberId, userClassPerm, reportColumn, this.permClassNumberMap.get(memberId), PermSourceEnum.USER_PERMCLASS.getValue(), null);
                Set groupIds = userGroupMap.getOrDefault(userId, Collections.emptySet());
                for (Long groupId2 : groupIds) {
                    Map groupMember = this.userGroupMemberPerm.getOrDefault(groupId2, Collections.emptyMap());
                    userMemberPerm = (Integer)groupMember.get(memberId);
                    reportColumn = this.buildReportColumnByUser(userId, memberId, userMemberPerm, reportColumn, this.getMemberDesc(), PermSourceEnum.GROUP_MEMBER.getValue(), groupId2);
                    Map groupClass = this.userGroupPermClass.getOrDefault(groupId2, Collections.emptyMap());
                    userClassPerm = (Integer)groupClass.get(memberId);
                    if (userClassPerm != null) {
                        hasDataAuth = true;
                    }
                    reportColumn = this.buildReportColumnByUser(userId, memberId, userClassPerm, reportColumn, this.permClassNumberMap.get(memberId), PermSourceEnum.GROUP_PERMCLASS.getValue(), groupId2);
                }
                if (!hasDataAuth && StringUtils.isNotEmpty((String)(permClassNumber = this.permClassNumberMap.get(memberId)))) {
                    if (reportColumn == null) {
                        reportColumn = this.buildReportColumnByUser(userId, memberId, PermEnum.NOPERM.getValue(), reportColumn, permClassNumber, PermSourceEnum.USER_PERMCLASS.getValue(), null);
                    } else {
                        reportColumn.setPermSource(PermSourceEnum.USER_PERMCLASS.getValue(), permClassNumber);
                        reportColumn.setPermState(PermEnum.NOPERM.getValue());
                    }
                }
                if (reportColumn == null) continue;
                res.put(key, reportColumn);
            }
        }
        res.values().forEach(rc -> value.add(this.buildObjArray((ReportColumn)rc)));
    }

    private void buildDataSetByUserGroup(Collection<Object[]> value) {
        if (CollectionUtils.isEmpty(this.userGroupPermClass) && CollectionUtils.isEmpty(this.userGroupMemberPerm)) {
            return;
        }
        HashSet groupIds = Sets.newHashSet();
        groupIds.addAll(this.userGroupMemberPerm.keySet());
        groupIds.addAll(this.userGroupPermClass.keySet());
        Map<Long, List<Pair<String, String>>> userGroupUser = this.buildUserGroupUserMap(groupIds);
        HashMap res = Maps.newHashMap();
        for (Long groupId : groupIds) {
            Map member = this.userGroupMemberPerm.getOrDefault(groupId, Collections.emptyMap());
            Map permClass = this.userGroupPermClass.getOrDefault(groupId, Collections.emptyMap());
            HashSet allMemberIds = Sets.newHashSet();
            if (CollectionUtils.isEmpty(this.memberIds)) {
                allMemberIds.addAll(member.keySet());
                allMemberIds.addAll(permClass.keySet());
            } else {
                allMemberIds.addAll(this.memberIds);
            }
            for (Long memberId : allMemberIds) {
                String permClassNumber;
                String key = new StringJoiner(PLACEHOLDER).add(groupId.toString()).add(memberId.toString()).toString();
                ReportColumn reportColumn = (ReportColumn)res.get(key);
                Integer memberPerm = (Integer)member.get(memberId);
                reportColumn = this.buildReportColumnByGroup(userGroupUser, groupId, memberId, memberPerm, reportColumn, this.getMemberDesc(), PermSourceEnum.GROUP_MEMBER.getValue());
                Integer classPerm = (Integer)permClass.get(memberId);
                reportColumn = this.buildReportColumnByGroup(userGroupUser, groupId, memberId, classPerm, reportColumn, this.permClassNumberMap.get(memberId), PermSourceEnum.GROUP_PERMCLASS.getValue());
                if (classPerm == null && StringUtils.isNotEmpty((String)(permClassNumber = this.permClassNumberMap.get(memberId)))) {
                    if (reportColumn == null) {
                        reportColumn = this.buildReportColumnByUser(groupId, memberId, PermEnum.NOPERM.getValue(), reportColumn, permClassNumber, PermSourceEnum.GROUP_PERMCLASS.getValue(), null);
                    } else {
                        reportColumn.setPermSource(PermSourceEnum.USER_PERMCLASS.getValue(), permClassNumber);
                        reportColumn.setPermState(PermEnum.NOPERM.getValue());
                    }
                }
                if (reportColumn == null) continue;
                res.put(key, reportColumn);
            }
        }
        res.values().forEach(rc -> value.add(this.buildObjArray((ReportColumn)rc)));
    }

    private DataSet initDataSet(Collection<Object[]> coll) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])ALL_FILEDS, (DataType[])ALL_FILEDS_TYPE);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private String buildFilter() {
        StringBuilder filterStr = new StringBuilder();
        boolean first = true;
        if (this.permSource != null) {
            List permSource = PermSourceEnum.allPermSource((PermSourceEnum)this.permSource);
            filterStr.append("permsource in (").append(permSource.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
            first = false;
        }
        if (this.permState != null) {
            if (!first) {
                filterStr.append("and ");
            }
            filterStr.append("permstate = ").append(this.permState);
        }
        return filterStr.toString();
    }

    private void initAllPermUser() {
        if (!CollectionUtils.isEmpty(this.userMap)) {
            return;
        }
        QFBuilder qb = new QFBuilder(ORG, "=", (Object)this.modelId);
        qb.add(new QFilter("dimtype", "=", (Object)"DIM_BCM_MODEL"));
        String selectField = "user.id,user.number,user.name";
        DynamicObjectCollection records = QueryServiceHelper.query((String)"perm_userperm", (String)selectField, (QFilter[])qb.toArray());
        QFBuilder qfBuilder = new QFBuilder(ORG, "=", (Object)this.modelId);
        DynamicObjectCollection roleUser = QueryServiceHelper.query((String)"perm_userrole", (String)selectField, (QFilter[])qfBuilder.toArray());
        Set uIds = records.stream().map(t -> t.getLong(USER_ID)).collect(Collectors.toSet());
        uIds.addAll(roleUser.stream().map(t -> t.getLong(USER_ID)).collect(Collectors.toSet()));
        Set adminUIds = MemberPermHelper.checkUsersIsAdmin(uIds, (long)this.modelId);
        this.userMap.putAll(records.stream().filter(t -> !adminUIds.contains(t.getLong(USER_ID))).collect(Collectors.toMap(dy -> dy.getLong(USER_ID), dy -> new Pair((Object)dy.getString("user.number"), (Object)dy.getString("user.name")), (v1, v2) -> v1)));
        this.userMap.putAll(roleUser.stream().filter(t -> !adminUIds.contains(t.getLong(USER_ID))).collect(Collectors.toMap(dy -> dy.getLong(USER_ID), dy -> new Pair((Object)dy.getString("user.number"), (Object)dy.getString("user.name")), (v1, v2) -> v1)));
    }

    private Map<Long, List<Pair<String, String>>> buildUserGroupUserMap(Set<Long> groupIds) {
        DynamicObjectCollection userAndGroupRelation = this.getUserAndGroupRelationFromDb(groupIds);
        Set results = userAndGroupRelation.stream().map(dy -> dy.getLong("usergroup.id")).collect(Collectors.toSet());
        if (groupIds.size() != results.size()) {
            this.buildUserGroup(groupIds);
        }
        HashMap map = Maps.newHashMap();
        for (DynamicObject dy2 : userAndGroupRelation) {
            long userId = dy2.getLong(USER_ID);
            long groupId = dy2.getLong("usergroup.id");
            String groupName = dy2.getString("usergroup.name");
            String groupNumber = dy2.getString("usergroup.number");
            this.groupMap.put(groupId, (Pair<String, String>)new Pair((Object)groupNumber, (Object)groupName));
            if (!this.userMap.containsKey(userId)) continue;
            Pair userPair = new Pair((Object)dy2.getString("user.number"), (Object)dy2.getString("user.name"));
            if (map.containsKey(groupId)) {
                ((List)map.get(groupId)).add(userPair);
                continue;
            }
            map.put(groupId, Lists.newArrayList((Object[])new Pair[]{userPair}));
        }
        return map;
    }

    private void buildUserGroup(Set<Long> groupIds) {
        DynamicObjectCollection userGroupFromDb = this.getUserGroupFromDb(groupIds);
        for (DynamicObject dy : userGroupFromDb) {
            this.groupMap.put(dy.getLong(ID), (Pair<String, String>)new Pair((Object)dy.getString(NUMBER), (Object)dy.getString(NAME)));
        }
    }

    private ReportColumn buildReportColumnByGroup(Map<Long, List<Pair<String, String>>> userGroupUser, Long groupId, Long memberId, Integer perm, ReportColumn reportColumn, String permSourceStr, Integer permSource) {
        if (perm == null) {
            return reportColumn;
        }
        Pair<String, String> memberPair = this.getMember(memberId);
        if (memberPair == null) {
            return reportColumn;
        }
        if (Objects.isNull(this.groupMap.get(groupId))) {
            return reportColumn;
        }
        if (reportColumn == null) {
            reportColumn = new ReportColumn();
        }
        List<Pair<String, String>> userList = userGroupUser.get(groupId);
        return reportColumn.setModelId(this.model.getLong(ID)).setGroupNumber((String)this.groupMap.get((Object)groupId).p1).setGroupName((String)this.groupMap.get((Object)groupId).p2).setMemberType(DimEntityNumEnum.getNameByNumber((String)this.memberType)).setMemberNumber((String)memberPair.p1).setMemberName((String)memberPair.p2).setPermSource(permSource, permSourceStr).setPermState(perm).setPermSourceUser(CollectionUtils.isEmpty(userList) ? "" : userList.stream().map(l -> (String)l.p2).collect(Collectors.joining(SEPARATOR))).setPermSourceNumber(CollectionUtils.isEmpty(userList) ? "" : userList.stream().map(l -> (String)l.p1).collect(Collectors.joining(SEPARATOR)));
    }

    private Object[] buildObjArray(ReportColumn rc) {
        Object[] objects = new Object[]{rc.getModelId(), rc.getUserName(), rc.getWorkNumber(), rc.getGroupNumber(), rc.getGroupName(), rc.getMemberType(), rc.getMemberNumber(), rc.getMemberName(), rc.getPermSourceStr(), 4 - rc.getPermState(), rc.getPermSourceGroup(), rc.getPermSourceUser(), rc.getPermSourceNumber(), rc.getPermSource(), rc.getPermState()};
        return objects;
    }

    private DynamicObjectCollection getUserAndGroupRelationFromDb(Set<Long> groupIds) {
        String selectFields = "user.id,user.number,user.name,usergroup.id,usergroup.name,usergroup.number";
        return QueryServiceHelper.query((String)"bos_usergroupstaff", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("usergroup", "in", groupIds)});
    }

    private DynamicObjectCollection getUserGroupFromDb(Set<Long> groupIds) {
        String selectFields = "id,number,name";
        return QueryServiceHelper.query((String)"bos_usergroup", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(ID, "in", groupIds)});
    }

    private Pair<String, String> getMember(Long memberId) {
        if (this.memberMap.containsKey(memberId)) {
            return this.memberMap.get(memberId);
        }
        IDNumberTreeNode node = MemberReader.findMemberById((String)MemberReader.findModelNumberById((Object)this.modelId), (String)DimEntityNumEnum.getEntieyNumByNumber((String)this.memberType), (Long)memberId);
        if (node == null || IDNumberTreeNode.NotFoundTreeNode.equals(node)) {
            return null;
        }
        Pair pair = new Pair((Object)node.getNumber(), (Object)node.getName());
        this.memberMap.put(memberId, (Pair<String, String>)pair);
        return pair;
    }

    private ReportColumn buildReportColumnByUser(Long userId, Long memberId, Integer perm, ReportColumn reportColumn, String permSourceStr, Integer permSource, Long groupId) {
        if (perm == null) {
            return reportColumn;
        }
        Pair<String, String> memberPair = this.getMember(memberId);
        if (memberPair == null) {
            return reportColumn;
        }
        if (Objects.isNull(this.userMap.get(userId))) {
            return reportColumn;
        }
        if (reportColumn == null) {
            reportColumn = new ReportColumn();
        }
        String permSourceGroup = groupId == null ? this.getDisFunDesc() : (String)this.groupMap.get((Object)groupId).p1;
        return reportColumn.setModelId(this.model.getLong(ID)).setWorkNumber((String)this.userMap.get((Object)userId).p1).setUserName((String)this.userMap.get((Object)userId).p2).setMemberType(DimEntityNumEnum.getNameByNumber((String)this.memberType)).setMemberNumber((String)memberPair.p1).setMemberName((String)memberPair.p2).setPermSource(permSource, permSourceStr).setPermState(perm).setPermSourceGroup(permSourceGroup);
    }

    private Map<Long, Set<Long>> getUserGroupMap(Set<Long> userIds) {
        HashMap map = Maps.newHashMap();
        HashSet groupIds = Sets.newHashSet();
        groupIds.addAll(this.userGroupMemberPerm.keySet());
        groupIds.addAll(this.userGroupPermClass.keySet());
        if (groupIds.isEmpty()) {
            return map;
        }
        DynamicObjectCollection userAndGroupRelation = this.getUserAndGroupRelationFromDb(groupIds);
        Set results = userAndGroupRelation.stream().map(dy -> dy.getLong("usergroup.id")).collect(Collectors.toSet());
        if (groupIds.size() != results.size()) {
            this.buildUserGroup(groupIds);
        }
        for (DynamicObject dy2 : userAndGroupRelation) {
            long userId = dy2.getLong(USER_ID);
            if (!userIds.contains(userId)) continue;
            long groupId = dy2.getLong("usergroup.id");
            String groupName = dy2.getString("usergroup.name");
            String groupNumber = dy2.getString("usergroup.number");
            this.groupMap.put(groupId, (Pair<String, String>)new Pair((Object)groupNumber, (Object)groupName));
            if (map.containsKey(userId)) {
                ((Set)map.get(userId)).add(groupId);
                continue;
            }
            map.put(userId, Sets.newHashSet((Object[])new Long[]{groupId}));
        }
        return map;
    }

    private void permClassHandler(Map<Long, Map<Long, Integer>> permClass, long users, long permClassId, int perm, Map<Long, Set<Long>> allPermClassIds) {
        if (permClass.containsKey(users)) {
            permClass.computeIfPresent(users, (k, v) -> {
                for (Long id : (Set)allPermClassIds.get(permClassId)) {
                    v.put(id, perm);
                }
                return v;
            });
        } else {
            HashMap permMap = Maps.newHashMap();
            for (Long id : allPermClassIds.get(permClassId)) {
                permMap.put(id, perm);
            }
            permClass.put(users, permMap);
        }
    }

    private Map<Long, Set<Long>> getAllPermClassIds() {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId);
        qfBuilder.and(new QFilter("entityname", "=", (Object)formMap.getOrDefault(this.memberType, "bcm_userdefinedmembertree")));
        if (!CollectionUtils.isEmpty(this.memberIds)) {
            qfBuilder.and(new QFilter(ENTITYID, "in", this.memberIds));
        }
        DynamicObjectCollection dys = PermClassEntityHelper.getPermClassListFromDb((QFilter[])qfBuilder.toArray(), (String)"permclass.id,permclass.number,entityid");
        this.permClassNumberMap.putAll(dys.stream().collect(Collectors.toMap(dy -> dy.getLong(ENTITYID), dy -> dy.getString("permclass.number"), (v1, v2) -> v1)));
        return dys.stream().collect(Collectors.groupingBy(k -> k.getLong("permclass.id"), Collectors.mapping(v -> v.getLong(ENTITYID), Collectors.toSet())));
    }

    private int setPDataPermReportLimit(String pDataPermReportLimit) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(pDataPermReportLimit);
        if (!isNum.matches()) {
            pDataPermReportLimit = "20000";
        }
        return Integer.parseInt(pDataPermReportLimit);
    }

    public static class ReportColumn {
        private Long modelId;
        private String userName;
        private String workNumber;
        private String groupNumber;
        private String groupName;
        private String memberType;
        private String memberNumber;
        private String memberName;
        private Integer permSource;
        private String permSourceStr;
        private Integer permState;
        private String permSourceGroup;
        private String permSourceUser;
        private String permSourceNumber;

        public Long getModelId() {
            return this.modelId;
        }

        public ReportColumn setModelId(Long modelId) {
            this.modelId = modelId;
            return this;
        }

        public String getUserName() {
            return this.userName;
        }

        public ReportColumn setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public String getWorkNumber() {
            return this.workNumber;
        }

        public ReportColumn setWorkNumber(String workNumber) {
            this.workNumber = workNumber;
            return this;
        }

        public String getGroupNumber() {
            return this.groupNumber;
        }

        public ReportColumn setGroupNumber(String groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public ReportColumn setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public String getMemberType() {
            return this.memberType;
        }

        public ReportColumn setMemberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        public String getMemberNumber() {
            return this.memberNumber;
        }

        public ReportColumn setMemberNumber(String memberNumber) {
            this.memberNumber = memberNumber;
            return this;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public ReportColumn setMemberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public Integer getPermSource() {
            return this.permSource;
        }

        public ReportColumn setPermSource(Integer permSource, String permSourceStr) {
            if (this.permSource == null) {
                this.permSourceStr = permSourceStr;
                this.permSource = permSource;
            } else {
                this.permSource = PermSourceEnum.addPermSource((Integer)this.permSource, (PermSourceEnum)PermSourceEnum.getByValue((Integer)permSource));
                Object[] split = this.permSourceStr.split(MemerPermReportListPlugin.SEPARATOR);
                if (!Lists.newArrayList((Object[])split).contains(permSourceStr)) {
                    this.permSourceStr = new StringJoiner(MemerPermReportListPlugin.SEPARATOR).add(this.permSourceStr).add(permSourceStr).toString();
                }
            }
            return this;
        }

        public String getPermSourceStr() {
            return this.permSourceStr;
        }

        public Integer getPermState() {
            return this.permState;
        }

        public ReportColumn setPermState(Integer permState) {
            this.permState = this.permState == null ? permState : Integer.valueOf(Math.max(permState, this.permState));
            return this;
        }

        public String getPermSourceGroup() {
            return this.permSourceGroup;
        }

        public ReportColumn setPermSourceGroup(String permSourceGroup) {
            if (this.permSourceGroup == null) {
                this.permSourceGroup = permSourceGroup;
                return this;
            }
            Object[] split = this.permSourceGroup.split(MemerPermReportListPlugin.SEPARATOR);
            if (!Lists.newArrayList((Object[])split).contains(permSourceGroup)) {
                this.permSourceGroup = new StringJoiner(MemerPermReportListPlugin.SEPARATOR).add(this.permSourceGroup).add(permSourceGroup).toString();
            }
            return this;
        }

        public String getPermSourceUser() {
            return this.permSourceUser;
        }

        public ReportColumn setPermSourceUser(String permSourceUser) {
            this.permSourceUser = permSourceUser;
            return this;
        }

        public String getPermSourceNumber() {
            return this.permSourceNumber;
        }

        public ReportColumn setPermSourceNumber(String permSourceNumber) {
            this.permSourceNumber = permSourceNumber;
            return this;
        }
    }
}

