/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.Permission.EntitySelectEnum;
import kd.fi.bcm.common.enums.Permission.UserSelectEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PermGrantAuthReportListPlugin
extends AbstractReportListDataPlugin {
    private static final String ID = "id";
    private static final String MEMBER = "member";
    private static final String USERS = "users";
    private static final String MEMBER_NUM = "member_num";
    private long modelId = 0L;
    private String memberType = null;
    private boolean isClass = Boolean.TRUE;
    private boolean isUser = Boolean.TRUE;
    private static final String MEMBER_TYPE = "membertype";
    private static final String USER_TYPE = "usertype";
    private static final String INCLUDE_SUB = "includesub";
    private static final Map<String, String> formMap = new ImmutableMap.Builder().put((Object)DimEntityNumEnum.ENTITY.getNumber(), (Object)"bcm_entitymembertree").put((Object)DimEntityNumEnum.ACCOUNT.getNumber(), (Object)"bcm_accountmembertree").put((Object)DimEntityNumEnum.SCENARIO.getNumber(), (Object)"bcm_scenemembertree").put((Object)DimEntityNumEnum.YEAR.getNumber(), (Object)"bcm_fymembertree").put((Object)DimEntityNumEnum.PERIOD.getNumber(), (Object)"bcm_periodmembertree").put((Object)DimEntityNumEnum.PROCESS.getNumber(), (Object)"bcm_processmembertree").put((Object)DimEntityNumEnum.CURRENCY.getNumber(), (Object)"bcm_currencymembertree").put((Object)DimEntityNumEnum.AUDITTRIAL.getNumber(), (Object)"bcm_audittrialmembertree").put((Object)DimEntityNumEnum.CHANGETYPE.getNumber(), (Object)"bcm_changetypemembertree").put((Object)DimEntityNumEnum.DATASORT.getNumber(), (Object)"bcm_datasortmembertree").put((Object)DimEntityNumEnum.MULTIGAAP.getNumber(), (Object)"bcm_rulemembertree").put((Object)DimEntityNumEnum.MYCOMPANY.getNumber(), (Object)"bcm_mycompanymembertree").put((Object)DimEntityNumEnum.INTERCOMPANY.getNumber(), (Object)"bcm_icmembertree").put((Object)DimEntityNumEnum.EXTENDS.getNumber(), (Object)"bcm_structofextend").build();
    private static final String[] ALL_FILEDS = new String[]{"list_username", "list_worknumber", "list_group", "list_group_num", "list_membernumber", "list_membername", "includesub", "class_num", "class_name"};
    private static final DataType[] ALL_FILEDS_TYPE = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BooleanType, DataType.StringType, DataType.StringType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        QFBuilder qfb = new QFBuilder();
        String entity = "";
        block19: for (FilterItemInfo filterItem : reportQueryParam.getFilter().getFilterItems()) {
            Object value = filterItem.getValue();
            if (Objects.isNull(value)) continue;
            switch (filterItem.getPropName()) {
                case "model": {
                    DynamicObject model = (DynamicObject)value;
                    this.modelId = model.getLong(ID);
                    qfb.and("model", "=", (Object)this.modelId);
                    break;
                }
                case "queryselect": {
                    if (Objects.equals(String.valueOf(value), UserSelectEnum.USER.getValue())) {
                        qfb.and(USER_TYPE, "=", (Object)UserTypeEnum.USER.getName());
                        this.isUser = Boolean.TRUE;
                        break;
                    }
                    if (!Objects.equals(String.valueOf(value), UserSelectEnum.GROUP.getValue())) break;
                    qfb.and(USER_TYPE, "=", (Object)UserTypeEnum.USERGROUP.getName());
                    this.isUser = Boolean.FALSE;
                    break;
                }
                case "user": 
                case "group": {
                    DynamicObjectCollection groups = (DynamicObjectCollection)value;
                    qfb.and("users.id", "in", groups.stream().map(t -> t.getLong(ID)).collect(Collectors.toSet()));
                    break;
                }
                case "entity_query_select": {
                    String type = value.toString();
                    if (Objects.equals(type, EntitySelectEnum.CLASS.getValue())) {
                        entity = "bcm_class_grant";
                        this.isClass = Boolean.TRUE;
                        break;
                    }
                    if (!Objects.equals(type, EntitySelectEnum.MEMBER.getValue())) break;
                    entity = "bcm_member_grant";
                    this.isClass = Boolean.FALSE;
                    break;
                }
                case "membertype": {
                    this.memberType = String.valueOf(value);
                    qfb.and(MEMBER_TYPE, "=", (Object)formMap.getOrDefault(this.memberType, "bcm_userdefinedmembertree"));
                    break;
                }
                case "member": {
                    Object memNumsObj = reportQueryParam.getCustomParam().get(MEMBER_NUM);
                    if (!Objects.nonNull(memNumsObj)) break;
                    String memNumsStr = memNumsObj.toString();
                    if (!StringUtils.isNotBlank((CharSequence)memNumsStr)) continue block19;
                    List memNums = SerializationUtils.fromJsonStringToList((String)memNumsStr, String.class);
                    qfb.and("member.id", "in", memNums.stream().map(t -> MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)this.memberType, (String)t.toString()).getId()).collect(Collectors.toSet()));
                    break;
                }
                case "perm_class": {
                    DynamicObjectCollection permClass = (DynamicObjectCollection)value;
                    qfb.and("permclass.id", "in", permClass.stream().map(t -> t.getLong(ID)).collect(Collectors.toSet()));
                    break;
                }
            }
        }
        String field = this.isClass ? "usertype,users,users.name,users.number,permclass.number,permclass.remark" : "usertype,users,users.name,users.number,membertype,member,includesub";
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)field, (QFilter[])qfb.toArray());
        Map<Long, Pair> group = null;
        if (!this.isUser) {
            Set groups = query.stream().map(t -> t.getLong(USERS)).collect(Collectors.toSet());
            group = QueryServiceHelper.query((String)"bos_usergroup", (String)"id,number,name", (QFilter[])new QFBuilder(ID, "in", groups).toArray()).stream().collect(Collectors.toMap(t -> t.getLong(ID), t -> Pair.onePair((Object)t.getString("number"), (Object)t.getString("name"))));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])ALL_FILEDS, (DataType[])ALL_FILEDS_TYPE);
        ArrayList coll = Lists.newArrayListWithExpectedSize((int)query.size());
        CollectionInput inputs = new CollectionInput(rowMeta, (Collection)coll);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        for (DynamicObject midObj : query) {
            Object[] objects = new Object[9];
            if (Objects.equals(midObj.getString(USER_TYPE), UserTypeEnum.USER.getName())) {
                objects[0] = midObj.getString("users.name");
                objects[1] = midObj.getString("users.number");
            } else {
                if (MapUtils.isEmpty(group)) continue;
                Pair pair = group.get(midObj.getLong(USERS));
                objects[2] = pair.p2;
                objects[3] = pair.p1;
            }
            if (Objects.equals(entity, "bcm_class_grant")) {
                objects[8] = midObj.getString("permclass.remark");
                objects[7] = midObj.getString("permclass.number");
            } else if (Objects.equals(entity, "bcm_member_grant")) {
                IDNumberTreeNode memeber = MemberReader.findMemberById((long)this.modelId, (String)midObj.getString(MEMBER_TYPE), (Long)midObj.getLong(MEMBER));
                objects[4] = memeber.getNumber();
                objects[5] = memeber.getName();
                objects[6] = midObj.getBoolean(INCLUDE_SUB);
            }
            coll.add(objects);
        }
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }
}

