/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;

public class PermissionClassEdit
extends AbstractBasePlugIn {
    protected static WatchLogger watchLogger = BcmLogFactory.getWatchLogInstance((boolean)true, PermissionClassEdit.class);
    private static final String BTN_CONFIRM = "confirm";
    private static final String MODEL = "model";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String MODELTYPE = "modeltype";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_TIME = "modifytime";
    private static final String SUCCESS = "success";
    private static final String APP = "app";

    private String getOperationCreateNew() {
        return ResManager.loadKDString((String)"\u65b0\u589e", (String)"PermissionClassEdit_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"PermissionClassEdit_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusUpdate() {
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"PermissionClassEdit_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key)) {
            String errorMsg;
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && !StringUtil.isEmptyString((String)(errorMsg = this.checkNumber()))) {
                return;
            }
            Object parentModelId = this.getView().getFormShowParameter().getCustomParam(MODEL);
            if (!LongUtil.isvalidLong((Object)parentModelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u4f53\u7cfb\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"AnalysisDesignListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = LongUtil.toLong((Object)parentModelId);
            if (this.isFIDM() || this.isFar()) {
                Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam(FIDMMODEL);
                this.getModel().setValue(FIDMMODEL, (Object)dmModelId);
                String appId = this.getView().getFormShowParameter().getAppId();
                this.getModel().setValue(APP, (Object)appId);
            } else {
                this.getModel().setValue(MODEL, (Object)modelId);
            }
            this.getModel().setValue(MODIFIER, (Object)RequestContext.get().getUserId());
            this.getModel().setValue(MODIFY_TIME, (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            String number = (String)this.getModel().getValue("number");
            String log = String.format("%s,%s%s", number, this.getOperationCreateNew(), this.getOperationStatusSuccess());
            String edit = (String)this.getView().getFormShowParameter().getCustomParam("edit");
            if (!this.isFIDM() && !this.isFar()) {
                if ("edit".equals(edit)) {
                    String updatelog = String.format("%s,%s%s", number, this.getOperationStatusUpdate(), this.getOperationStatusSuccess());
                    OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationStatusUpdate(), (String)updatelog, (Long)modelId);
                } else {
                    OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationCreateNew(), (String)log, (Long)modelId);
                }
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                boolean isAddNew = true;
                if (status == OperationStatus.EDIT) {
                    isAddNew = false;
                }
                String appId = this.getView().getFormShowParameter().getAppId();
                ArrayList permlogs = Lists.newArrayListWithExpectedSize((int)1);
                DynamicObject logs = null;
                try {
                    logs = "edit".equals(edit) ? DataPermLogHelper.newPermClassControlLog((Long)modelId, (String)number, (String)DataPermLogMultiLangEnum.PermCLASS_MODIFY.getOperateName(), (String)appId) : DataPermLogHelper.newPermClassControlLog((Long)modelId, (String)number, (String)DataPermLogMultiLangEnum.PermCLASS_AddNew.getOperateName(), (String)appId);
                    permlogs.add(logs);
                    if (isAddNew && permlogs.size() > 0) {
                        DataPermLogHelper.batchInsertDataPermLog((List)permlogs);
                    }
                }
                catch (Exception e) {
                    watchLogger.error((Throwable)e);
                }
            }
            this.getView().returnDataToParent((Object)SUCCESS);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ((Long)this.getModel().getDataEntity().getPkValue() != 0L) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().updateView("number");
        }
    }

    private String checkNumber() {
        if ("".equals(this.getModel().getValue("number").toString().trim())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PermissionClassEdit_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return "error";
        }
        QFilter numberFilter = new QFilter("number", "=", this.getModel().getValue("number"));
        QFBuilder range = new QFBuilder();
        range.add(MODEL, "=", this.getView().getFormShowParameter().getCustomParam(MODEL));
        range.and(numberFilter);
        boolean exists = QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (QFilter[])range.toArray());
        if (exists) {
            if (!this.isFIDM() && !this.isFar()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e0e\u5408\u5e76\u62a5\u8868\u540c\u4f53\u7cfb\u4e2d\u5176\u4ed6\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return "error";
        }
        QFBuilder fidmRange = new QFBuilder();
        fidmRange.add(new QFilter(FIDMMODEL, "=", this.getView().getFormShowParameter().getCustomParam(FIDMMODEL)));
        fidmRange.add(numberFilter);
        fidmRange.add(new QFilter(APP, "=", (Object)ApplicationTypeEnum.FIDM.getAppnum()));
        boolean fidmExists = QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (QFilter[])fidmRange.toArray());
        if (fidmExists) {
            if (this.isFIDM()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e0e\u62ab\u9732\u7ba1\u7406\u76f8\u540c\u4f53\u7cfb\u4e2d\u5176\u4ed6\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return "error";
        }
        QFBuilder farRange = new QFBuilder();
        farRange.add(new QFilter(FIDMMODEL, "=", this.getView().getFormShowParameter().getCustomParam(FIDMMODEL)));
        farRange.add(numberFilter);
        farRange.add(new QFilter(APP, "=", (Object)ApplicationTypeEnum.FAR.getAppnum()));
        boolean farExists = QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (QFilter[])farRange.toArray());
        if (farExists) {
            if (this.isFar()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e0e\u7ee9\u6548\u5206\u6790\u76f8\u540c\u4f53\u7cfb\u4e2d\u5176\u4ed6\u6743\u9650\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"PermissionClassEdit_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return "error";
        }
        return "";
    }

    private boolean isFIDM() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FIDM.appnum, appId);
    }

    private boolean isFar() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FAR.appnum, appId);
    }

    private boolean isCmModel() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        return "1".equals(modeltype);
    }

    private boolean isEpmModel() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        return "2".equals(modeltype);
    }
}

