/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class PermissionClassFormPlugin
extends AbstractBaseListPlugin {
    private static final String TOOL_BARAP = "toolbarap";
    private static final String BUTTON_ADD = "btn_add";
    private static final String BUTTON_UPDATE = "btn_edit";
    private static final String BUTTON_DELETE = "btn_delete";
    private static final String BUTTON_REFRESH = "btn_refresh";
    private static final String ENTITY_NAME = "bcm_permissionclass";
    private static final String BILLLISTAP = "billlistap";
    private static final String FORCE_DELETE = "forceDelete";
    private static final String SUCCESS = "success";
    private static final String BUTTON_EXPORT = "btn_export";
    private static final String BUTTON_IMPORT = "btn_import";
    private static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    private static final String Model = "model";
    private static final String MODELTYPE = "modeltype";
    private static final String FIDMMODEL = "fidmmodel";

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"PermissionClassFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"PermissionClassFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"PermissionClassFormPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"PermissionClassFormPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = e.getFormShowParameter().getFormId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.hasViewPermission((long)currUserId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)formId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), Model);
        this.getView().getPageCache().put(KEY_MODEL_ID, modelId);
        this.getModel().setValue(this.getModelSign(), (Object)modelId);
        this.checkDefaultPermissionClass();
        this.refreshBillList();
    }

    private void checkDefaultPermissionClass() {
        QFBuilder range = new QFBuilder(Model, "=", (Object)this.getModelId());
        range.add("number", "=", (Object)"Default");
        if (!QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])range.toArray())) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dyn.set(Model, (Object)this.getModelId());
            dyn.set("number", (Object)"Default");
            dyn.set("remark", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u6743\u9650\u7c7b", (String)"PermissionClassFormPlugin_3", (String)"fi-bcm-formplugin"));
            dyn.set("modifier", (Object)this.getUserId());
            dyn.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        BaseShowParameter bs = this.getBaseShowParameter();
        switch (key) {
            case "btn_add": {
                bs.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm((FormShowParameter)bs);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u64cd\u4f5c\u884c\u3002", (String)"PermissionClassFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectedRows.size() <= 0) break;
                ConfirmCallBackListener confirm = new ConfirmCallBackListener(FORCE_DELETE, (IFormPlugin)this);
                String tip = "";
                tip = selectedRows.size() == 1 ? ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u8be5\u6743\u9650\u7c7b\u5417\uff1f", (String)"PermissionClassFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u591a\u4e2a\u6743\u9650\u7c7b\u5417\uff1f", (String)"PermissionClassFormPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tip, MessageBoxOptions.YesNo, confirm);
                break;
            }
            case "btn_import": {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
                ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
                String listName = ResManager.loadKDString((String)"\u6743\u9650\u7c7b", (String)"PermissionClassFormPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                AbsCommonImport.invokeOperation(ENTITY_NAME, "kd.fi.bcm.formplugin.permissionclass.PermissionClassImport", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
                break;
            }
            case "btn_export": {
                try {
                    QFBuilder filter = new QFBuilder(Model, "=", (Object)this.getModelId());
                    BillList list = (BillList)this.getControl(BILLLISTAP);
                    if (list.getSelectedRows().size() != 0) {
                        ListSelectedRowCollection rows = list.getSelectedRows();
                        ArrayList<Object> ids = new ArrayList<Object>();
                        for (ListSelectedRow row : rows) {
                            ids.add(row.getPrimaryKeyValue());
                        }
                        filter.add("id", "in", ids);
                    }
                    this.exportData(ENTITY_NAME, filter.toArray(), ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u5217\u8868\u5bfc\u51fa", (String)"PermissionClassFormPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_permissionclass_IMPT_S", "bcm_permissionclass_list", "47150e89000000ac");
                    this.writeOperationLog(this.getOperationExport(), this.getOperationStstusSuccess());
                }
                catch (Exception e) {
                    this.writeOperationLog(this.getOperationExport(), this.getOperationStstusFail());
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s\u3002", (String)"PermissionClassFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
                break;
            }
        }
    }

    private BaseShowParameter getBaseShowParameter() {
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId(ENTITY_NAME);
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCustomParam(this.getModelSign(), (Object)this.getModelId());
        QFilter modelFilter = new QFilter(Model, "=", (Object)this.getModelId());
        DynamicObject fidmModel = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_model", (QFilter[])new QFilter[]{modelFilter});
        if (fidmModel != null) {
            bs.setCustomParam(FIDMMODEL, (Object)fidmModel.getLong("id"));
        }
        bs.setCustomParam(MODELTYPE, (Object)"1");
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUTTON_REFRESH));
        return bs;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(this.getModelSign())) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(Model);
            if (model == null) {
                this.getModel().setValue(Model, (Object)this.getView().getPageCache().get(KEY_MODEL_ID));
            } else {
                this.getView().getPageCache().put(KEY_MODEL_ID, model.getString("id"));
            }
            this.checkDefaultPermissionClass();
            this.refreshBillList();
            this.savetUserSelectWhenOtherChange(this.getModelSign(), new UserSelectModel());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        if (FORCE_DELETE.equals(mbce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            int size = Objects.nonNull(selectedRows) ? selectedRows.size() : 0;
            ArrayList list = Lists.newArrayListWithCapacity((int)size);
            for (ListSelectedRow selectedRow : selectedRows) {
                if (selectedRow.getNumber().equalsIgnoreCase("Default")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6743\u9650\u7c7b\u4e0d\u80fd\u5220\u9664\u3002", (String)"PermissionClassFormPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                list.add((Long)selectedRow.getPrimaryKeyValue());
            }
            if (PermClassEntityHelper.checkDistribute((List)list, (Long)this.getModelId()) || PermClassEntityHelper.checkIsItReferenced((List)list, (Long)this.getModelId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u5df2\u88ab\u5f15\u7528\u4e0d\u80fd\u5220\u9664\u3002", (String)"PermissionClassFormPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)list);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            try {
                DeleteServiceHelper.delete((IDataEntityType)billList.getEntityType(), (Object[])list.toArray());
                String bizAppId = this.getBizAppId();
                ArrayList<DynamicObject> permlogs = new ArrayList<DynamicObject>(1);
                for (DynamicObject dynamicObject : dys) {
                    DynamicObject logs = DataPermLogHelper.newPermClassControlLog((Long)this.getModelId(), (String)dynamicObject.getString("number"), (String)DataPermLogMultiLangEnum.PermCLASS_DELETE.getOperateName(), (String)bizAppId);
                    permlogs.add(logs);
                }
                if (permlogs.size() > 0) {
                    DataPermLogHelper.batchInsertDataPermLog(permlogs);
                }
                this.writeDelLog((List<DynamicObject>)dys);
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PermissionClassFormPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    private void writeDelLog(List<DynamicObject> delDoc) {
        for (DynamicObject dy : delDoc) {
            String number = dy.getString("number");
            String log = String.format("%s,%s%s", number, this.getOperationStstusDelete(), this.getOperationStstusSuccess());
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationStstusDelete(), (String)log, (Long)this.getModelId());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object data = closedCallBackEvent.getReturnData();
        if (data instanceof String) {
            String status = (String)data;
            if (BUTTON_REFRESH.equals(closedCallBackEvent.getActionId()) && SUCCESS.equals(status)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PermissionClassFormPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        int is;
        args.setCancel(true);
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId())) && (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "4715a0df000000ac")) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"PermissionClassFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        BillList list = (BillList)this.getControl(BILLLISTAP);
        BaseShowParameter bs = this.getBaseShowParameter();
        bs.setPkId(list.getFocusRowPkId());
        bs.setStatus(OperationStatus.EDIT);
        bs.setCustomParam("edit", (Object)"edit");
        this.getView().showForm((FormShowParameter)bs);
    }

    private void refreshBillList() {
        String modelId = this.getView().getPageCache().get(KEY_MODEL_ID);
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        if (!LongUtil.isvalidLong((Object)this.getModelId())) {
            e.getQFilters().add(new QFilter("1", "=", (Object)2));
            return;
        }
        e.getQFilters().add(new QFilter(Model, "=", (Object)this.getModelId()));
    }
}

