/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.permissionclass;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import org.apache.commons.compress.utils.Lists;

public class PermissionClassImport
extends AbsCommonImport {
    private Map<String, DynamicObject> permClassMap;
    private DynamicObject model;
    private final Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, String> dataPermLogMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final Integer BATCH_INSERT_MAX_SIZE = 500;

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Optional<DynamicObject> dbOld;
        String remark;
        String showNumber = ImportHelper.getImportBillProp(bill, "model.shownumber").toString();
        if (!Objects.equals(this.model.getString("shownumber"), showNumber)) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u5176\u4ed6\u4f53\u7cfb\u3002", (String)"PermissionClassImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String number = ImportHelper.getImportBillProp(bill, "number").toString();
        if (number.length() > 20) {
            return Optional.of(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801 \u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,20]\u3002", (String)"PermissionClassImport_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Object objRemark = ImportHelper.getImportBillProp(bill, "remark");
        if (Objects.nonNull(objRemark) && StringUtils.isNotEmpty((String)objRemark.toString()) && (remark = LocaleString.fromMap((Map)((Map)objRemark)).getLocaleValue()) != null && remark.length() > 100) {
            return Optional.of(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5907\u6ce8\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,100]\u3002", (String)"PermissionClassImport_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.repeatKeys.add(number)) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"PermissionClassImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && (dbOld = this.getDbOld(bill)).isPresent()) {
            return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PermissionClassImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void initData() {
        Long modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        if (Objects.isNull(this.model)) {
            this.model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model");
        }
        DynamicObject[] permissionClass = PermClassEntityHelper.getPermissionClassByLoad((Long)modelId, (String)"model.id");
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        modelFilter.and(new QFilter("modeltype", "=", (Object)"1"));
        this.permClassMap = Arrays.stream(permissionClass).collect(Collectors.toMap(t -> t.getString("number"), Function.identity(), (k1, k2) -> k1));
        DynamicObject fidmModel = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_model", (QFilter[])new QFilter[]{modelFilter});
        if (fidmModel != null) {
            DynamicObject[] fidmPermClass = PermClassEntityHelper.getPermissionClassByLoad((Long)fidmModel.getLong("id"), (String)"fidmmodel.id");
            this.permClassMap.putAll(Arrays.stream(fidmPermClass).collect(Collectors.toMap(t -> t.getString("number"), Function.identity(), (k1, k2) -> k1)));
        }
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        Date now = new Date();
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            JSONObject data = billDataList.get(i).getData();
            DynamicObject old = (DynamicObject)data.get((Object)"existingRecordDy");
            Object remarkObj = data.get((Object)"remark");
            old.set("remark", (Object)(Objects.nonNull(remarkObj) ? LocaleString.fromMap((Map)((Map)remarkObj)).getLocaleValue() : ""));
            old.set("modifier", (Object)RequestContext.get().getCurrUserId());
            old.set("modifytime", (Object)now);
            dys[i] = old;
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        Date now = new Date();
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            dynamicObject.set("id", (Object)billDataList.get(i).getData().getLong("id"));
            dynamicObject.set("number", (Object)billDataList.get(i).getData().getString("number"));
            dynamicObject.set("model", (Object)this.model);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)now);
            Object remark = billDataList.get(i).getData().get((Object)"remark");
            dynamicObject.set("remark", (Object)(Objects.nonNull(remark) ? LocaleString.fromMap((Map)((Map)remark)).getLocaleValue() : ""));
            dys[i] = dynamicObject;
        }
        return dys;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData();
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String number = ImportHelper.getImportBillProp(rowData, "number").toString();
        DynamicObject old = this.permClassMap.get(number);
        return Optional.ofNullable(old);
    }

    @Override
    protected Map<Object, String> batchInsert(List<ImportBillData> billDataList, Map<Object, String> errorMap) {
        Map<Object, String> returnMap = super.batchInsert(billDataList, errorMap);
        this.addDataPermLogMap(billDataList, returnMap, this.addNewDescription());
        return returnMap;
    }

    @Override
    protected Map<Object, String> batchUpdate(List<ImportBillData> billDataList, Map<Object, String> errorMap) {
        Map<Object, String> returnMap = super.batchUpdate(billDataList, errorMap);
        this.addDataPermLogMap(billDataList, returnMap, this.overrideDescription());
        return returnMap;
    }

    private void addDataPermLogMap(List<ImportBillData> billDataList, Map<Object, String> returnMap, String desc) {
        for (ImportBillData billData : billDataList) {
            if (returnMap.containsKey(billData.getData().getLong("id"))) continue;
            this.dataPermLogMap.put(ImportHelper.getImportBillProp(billData, "number").toString(), desc);
        }
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        if (CollectionUtils.isEmpty(this.dataPermLogMap)) {
            return;
        }
        int cur = 0;
        ArrayList logs = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.dataPermLogMap.entrySet()) {
            logs.add(this.buildDataLog(entry.getKey(), entry.getValue()));
            if (++cur != BATCH_INSERT_MAX_SIZE) continue;
            DataPermLogHelper.batchInsertDataPermLog((List)logs);
            logs.clear();
            cur = 0;
        }
        if (!CollectionUtils.isEmpty((Collection)logs)) {
            DataPermLogHelper.batchInsertDataPermLog((List)logs);
        }
    }

    private String addNewDescription() {
        return ResManager.loadKDString((String)"\u65b0\u589e", (String)"PermissionClassImport_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String overrideDescription() {
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"PermissionClassImport_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private DynamicObject buildDataLog(String permClassNumber, String description) {
        String operateName = String.format(ResManager.loadKDString((String)"\u3010\u6a21\u677f\u5bfc\u5165\u3011\u6743\u9650\u7c7b-%s", (String)"PermissionClassImport_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), description);
        return DataPermLogHelper.newPermClassControlLog((Long)this.model.getLong("id"), (String)permClassNumber, (String)operateName, (String)ApplicationTypeEnum.CM.appnum);
    }
}

