/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.prepare;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodConstant;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.batch.BatchInsertService;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class PeriodSettingPlugin
extends AbstractBaseListPlugin
implements TreeNodeQueryListener {
    private static List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static List<String> noLeafKeys = Lists.newArrayList((Object[])new String[]{"entity"});
    private static Set<String> allKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period", "entity"});
    private static final String treeentryentity = "treeentryentity";
    private static final String key_noPermMembers = "noPermMembers";
    private static final String key_rowIndex = "rowIndex";
    private static final String SHOW_STYLE = "showStyle";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        treeEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                PeriodSettingPlugin.this.rowClick();
            }
        });
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(noLeafKeys, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("entity");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("entity")) {
            if (this.getModel().getValue("year") == null || this.getModel().getValue("period") == null || this.getModel().getValue("scenario") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u8d22\u5e74\u3001\u60c5\u666f\u3001\u671f\u95f4\u3002", (String)"PeriodSettingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            FormShowParameter showParameter = beforeF7SelectEvent.getFormShowParameter();
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                List filters = ((ListShowParameter)showParameter).getListFilterParameter().getQFilters();
                ArrayList result = new ArrayList(filters.size());
                filters.forEach(s -> {
                    QFilter[] origin = s.recombine();
                    Arrays.stream(origin).forEach(v -> {
                        if (!v.getProperty().contains("isexchangerate")) {
                            result.add(v);
                        }
                    });
                });
                ((ListShowParameter)showParameter).getListFilterParameter().setQFilters(result);
            }
            showParameter.setCustomParam("isShowCslScheme", (Object)"false");
            showParameter.setCustomParam("needSchemeFlag", (Object)"false");
        }
    }

    @Override
    protected Map<String, Object> getF7CustomData(String f7Key) {
        if ("entity".equals(f7Key)) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
            DynamicObject scenarioDynamicObject = (DynamicObject)this.getModel().getValue("scenario");
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
            if (yearDy != null) {
                customData.put("yearNum", yearDy.getString("number"));
                customData.put("yearId", yearDy.getLong("id"));
            }
            if (periodId != null) {
                customData.put("periodId", periodId);
            }
            if (scenarioDynamicObject != null) {
                customData.put("scenarioId", scenarioDynamicObject.getLong("id"));
            }
            customData.put("org_fuzzySearch_flag", 1);
            return customData;
        }
        return Collections.emptyMap();
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (this.getModel().getEntryEntity(treeentryentity).size() < evt.getRowKey() + 1) {
            return;
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        int[] re = this.addChildRows(evt.getRowKey());
        if (re == null || re.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u4e0b\uff0c\u6ca1\u6709\u6709\u6548\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"PeriodSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            treeEntry.collapse(evt.getRowKey());
            return;
        }
        IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        po.invokeControlMethod(treeentryentity, "collapseAllNode", new Object[]{re});
        treeEntry.selectRows(evt.getRowKey());
    }

    private int[] addChildRows(int rowKey) {
        DynamicObject obj = this.getModel().getEntryRowEntity(treeentryentity, rowKey);
        if (obj == null) {
            return new int[0];
        }
        long pid = (Long)obj.get("id");
        try {
            DynamicObject next = this.getModel().getEntryRowEntity(treeentryentity, rowKey + 1);
            if (next != null && next.getLong("pid") == pid && StringUtils.isNotEmpty((CharSequence)next.getString("number").trim())) {
                return new int[0];
            }
        }
        catch (Throwable t) {
            log.error(String.format("PeriodSettingPlugin - addChildRows:\n%s", ThrowableHelper.toString((Throwable)t)));
        }
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        if (modelId == null || sceneId == null || yearId == null || periodId == null) {
            return new int[0];
        }
        DynamicObjectCollection orgChildren = PeriodSettingHelper.getOrgChildren((boolean)false, (Long)LongUtil.toLong((Object)modelId), (long)pid, null, (boolean)true);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(LongUtil.toLong((Object)modelId).longValue(), LongUtil.toLong((Object)sceneId).longValue(), ((DynamicObject)this.getModel().getValue("year")).getString("number"), LongUtil.toLong((Object)periodId).longValue());
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (List)orgChildren);
        OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgChildren, (String)modelId, (String)sceneId, (String)yearId, (String)periodId);
        String entityType = "org";
        if (!orgChildren.isEmpty()) {
            entityType = null;
            orgChildren = this.queryPeriodManagementEntity(orgChildren, modelId, sceneId, yearId, periodId);
        }
        List properties = PeriodConstant.getProperties((String)entityType);
        int[] re = TreeEntryEntityUtil.insertTreeEntry(this.getView(), orgChildren, properties, rowKey, pid, false);
        return re;
    }

    private DynamicObjectCollection queryPeriodManagementEntity(DynamicObjectCollection orgTree, String modelId, String scenarioId, String yearId, String periodId) {
        EntryType entityType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(treeentryentity);
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet<String> orgNumbers = new HashSet<String>();
        for (DynamicObject org : orgTree) {
            orgNumbers.add(org.getString("number"));
        }
        QFBuilder qf = new QFBuilder();
        qf.add("scenario", "=", (Object)ConvertUtil.convertStrToLong((String)scenarioId));
        qf.add("year", "=", (Object)ConvertUtil.convertStrToLong((String)yearId));
        qf.add("period", "=", (Object)ConvertUtil.convertStrToLong((String)periodId));
        qf.add("model", "=", (Object)ConvertUtil.convertStrToLong((String)modelId));
        qf.add("orgnumber", "in", orgNumbers);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_periodmanageentity", (String)"id,datastatus,entrystatus,executeaction,operator,optime,org.number,orgnumber", (QFilter[])qf.toArray());
        HashMap<String, DynamicObject> mcMap = new HashMap<String, DynamicObject>(docs.length);
        for (DynamicObject mc : docs) {
            mcMap.put(mc.getString("orgnumber"), mc);
        }
        boolean initPeriodStatus = ConfigServiceHelper.getCM012InitPeriodStatus((Long)ConvertUtil.convertStrToLong((String)modelId));
        HashSet<String> showOrgNumber = new HashSet<String>(16);
        for (DynamicObject org : orgTree) {
            if (this.isShowTable() && !showOrgNumber.add(org.getString("number"))) continue;
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            for (String col : PeriodConstant.getProperties((String)"org")) {
                rowObj.set(col, org.get(col));
            }
            rowObj.set("datastatus", (Object)(initPeriodStatus ? "A" : "C"));
            rowObj.set("entrystatus", (Object)(initPeriodStatus ? (org.getBoolean("isexchangerate") ? "D" : "A") : (org.getBoolean("isexchangerate") ? "D" : "C")));
            rowObj.set("executeaction", (Object)"E");
            if (mcMap.containsKey(org.getString("number"))) {
                DynamicObject mc = (DynamicObject)mcMap.get(org.getString("number"));
                for (String col : PeriodConstant.getProperties((String)"periodsetting")) {
                    rowObj.set(col, mc.get(col));
                }
            }
            if ("Entity".equals(org.getString("number"))) {
                rowObj.set("datastatus", null);
                rowObj.set("entrystatus", null);
                rowObj.set("executeaction", null);
                rowObj.set("operator", null);
                rowObj.set("optime", null);
            }
            result.add((Object)rowObj);
        }
        return result;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, true);
        this.setDefaultEntityValue(Long.toString(this.getModelId()), this.getView());
        this.refreshData();
        this.hideButton();
    }

    private void hideButton() {
        if (this.isRPT()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openadjustperiod", "closeadjustperiod", "entrystatus"});
        }
    }

    private void refreshData() {
        this.loadEntityMember();
    }

    private void setDefaultEntityValue(String modelId, IFormView iFormView) {
        IDataModel dataModel = iFormView.getModel();
        String orgId = null;
        UserSelectModel userSelectByForm = UserSelectServiceHelper.getUserSelectByForm((String)RequestContext.get().getUserId(), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM, (String)" ");
        if (userSelectByForm != null) {
            orgId = userSelectByForm.getOrg();
        }
        dataModel.beginInit();
        if (orgId == null || "0".equals(orgId) || !this.existsOrg(orgId, Long.valueOf(modelId))) {
            orgId = null;
        }
        dataModel.setValue("entity", (Object)orgId);
        dataModel.endInit();
    }

    private boolean existsOrg(Object orgId, Long modelId) {
        return QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])QFilter.of((String)"id = ? and model = ? ", (Object[])new Object[]{LongUtil.toLong((Object)orgId), modelId}).toArray());
    }

    private void loadEntityMember() {
        Long dimId;
        this.getPageCache().remove(key_rowIndex);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        String entityId = UserSelectUtil.getF7SelectId(this.getView(), "entity");
        this.getModel().deleteEntryData(treeentryentity);
        if (modelId == null || sceneId == null || yearId == null || periodId == null || entityId == null) {
            return;
        }
        QFilter qcf = new QFilter("model", "=", (Object)ConvertUtil.convertStrToLong((String)modelId));
        QFilter qcf1 = new QFilter("id", "=", (Object)ConvertUtil.convertStrToLong((String)entityId));
        DynamicObject root = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PeriodConstant.getOrgSelectStr(), (QFilter[])new QFilter[]{qcf, qcf1});
        if (null == root) {
            this.getModel().setValue("entity", null);
            return;
        }
        PermissionService instance = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
        if (instance.hasNoPerm(dimId = MemberReader.getDimensionIdByNum((long)LongUtil.toLong((Object)modelId), (String)"Entity"), LongUtil.toLong((Object)entityId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u6743\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"PeriodSettingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("entity", null);
            return;
        }
        DynamicObjectCollection orgTree = this.queryEntityData(LongUtil.toLong((Object)modelId), root);
        if (!orgTree.isEmpty()) {
            List properties = PeriodConstant.getProperties(null);
            orgTree = this.queryPeriodManagementEntity(orgTree, modelId, sceneId, yearId, periodId);
            if (this.isShowTable()) {
                BatchInsertService<DynamicObject> bs = new BatchInsertService<DynamicObject>(treeentryentity, properties.toArray(new String[0]));
                bs.batchCreateNewEntryRow(this.getView(), (Collection<DynamicObject>)orgTree, mcData -> {
                    ArrayList rowData = new ArrayList(10);
                    properties.forEach(p -> {
                        if ("operator".equals(p)) {
                            rowData.add(mcData.getLong(p + ".id"));
                        } else {
                            rowData.add(mcData.get(p));
                        }
                    });
                    return rowData.toArray();
                });
            } else {
                TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
                int parentLevel = (Integer)root.get("level");
                int[] re = TreeEntryEntityUtil.createTreeEntryFp(this.getView(), orgTree, properties, String.valueOf(parentLevel), false);
                treeEntry.setCollapse(false);
                treeEntry.collapse(re);
                treeEntry.selectRows(0);
            }
        }
        this.getView().updateView(treeentryentity);
    }

    DynamicObjectCollection queryEntityData(long modelId, DynamicObject rootOrg) {
        DynamicObjectCollection orgTree = new DynamicObjectCollection();
        orgTree.add((Object)rootOrg);
        long parentId = rootOrg.getLong("id");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        long orgDimId = DimensionServiceHelper.getIdByNum((String)"bcm_dimension", (long)modelId, (String)DimEntityNumEnum.ENTITY.getNumber());
        qFilter.and(PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(Long.valueOf(orgDimId), "bcm_entitymembertree", "id"));
        if (this.isShowTable()) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId);
            ArrayList ids = new ArrayList(orgNode.getAllChildrenIds());
            qFilter.and("id", "in", ids);
        } else {
            qFilter.and("parent", "=", (Object)parentId);
        }
        qFilter.and("cslscheme", "in", (Object)CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme((String)String.valueOf(modelId), (boolean)true));
        orgTree.addAll((Collection)QueryServiceHelper.query((String)"bcm_entitymembertree", (String)PeriodConstant.getOrgSelectStr(), (QFilter[])qFilter.toArray(), (String)"dseq"));
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, LongUtil.toLong((Object)sceneId).longValue(), yearNum, LongUtil.toLong((Object)periodId).longValue());
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (List)orgTree);
        OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgTree, (Long)modelId, (Long)LongUtil.toLong((Object)sceneId), (Long)LongUtil.toLong((Object)yearId), (Long)LongUtil.toLong((Object)periodId));
        return orgTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
        DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
        DynamicObjectCollection doc = new DynamicObjectCollection();
        if (PeriodConstant.getProperties(null).contains(propName)) {
            return;
        }
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getLong("id") == oldValue.getLong("id")) {
            return;
        }
        if ("model".equals(propName)) {
            if (this.getPageCache().get("chooseBackModel") != null) {
                return;
            }
            try {
                this.propertyChangedModelUse(new ArrayList<String>(allKeys));
            }
            finally {
                this.getPageCache().remove("chooseBackModel");
            }
            this.getPageCache().remove(key_noPermMembers);
            this.getModel().deleteEntryData(treeentryentity);
        } else if (dimKeys.contains(propName)) {
            Boolean isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false);
            if (!isSureReturn.booleanValue()) {
                return;
            }
            if (this.getModel().getValue("year") == null || this.getModel().getValue("scenario") == null || this.getModel().getValue("period") == null) {
                this.getModel().setValue("entity", null);
                return;
            }
            DynamicObject entityOld = (DynamicObject)this.getModel().getValue("entity");
            if (entityOld == null) {
                return;
            }
            doc.add((Object)entityOld);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(this.getModelId(), scenarioDy.getLong("id"), yearDy.getString("number"), periodDy.getLong("id"));
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (List)doc);
            if (doc.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u8303\u56f4\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u539f\u6709\u8bb0\u5fc6\u529f\u80fd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"PeriodSettingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
            DynamicObjectCollection noMerge = OrgServiceHelper.getNoMergeOrgList((DynamicObjectCollection)doc, (Long)this.getModelId(), (Long)scenarioDy.getLong("id"), (Long)yearDy.getLong("id"), (Long)periodDy.getLong("id"));
            if (!noMerge.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u5728\u6b64\u671f\u95f4\u4e0d\u53c2\u4e0e\u5408\u5e76\u3002", (String)"PeriodSettingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)noMerge.get(0)).getString("name")));
                if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") || !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") && !ConfigServiceHelper.getNonLeafOfCM030((Long)this.getModelId())) {
                    this.getModel().setValue("entity", null);
                    return;
                }
            }
        } else if ("cslscheme".equals(propName)) {
            this.saveUserChangedCslscheme(newValue);
            this.getModel().setValue("entity", null);
        } else if ("entity".equals(propName)) {
            long modelId = this.loadModelId();
            if (null != newValue && modelId > 0L) {
                QFilter changeOrgFilter = new QFilter("model", "=", (Object)modelId).and("id", "=", (Object)newValue.getLong("id"));
                DynamicObject changeToOrg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PeriodConstant.getOrgSelectStr(), (QFilter[])changeOrgFilter.toArray());
                if (null == changeToOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7\uff0c\u5df2\u91cd\u7f6e\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PeriodSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("entity", null);
                }
                this.savetUserSelectWhenOtherChange("entity", new UserSelectModel());
            }
        }
        this.loadEntityMember();
        if (!doc.isEmpty()) {
            OrgUtils.dealNoMergeOrgList(doc, this.getModel());
            DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("entity");
            entityDyn.set("name", (Object)((DynamicObject)doc.get(0)).getString("name"));
            this.getView().updateView("entity");
        } else {
            DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("entity");
            DynamicObject entryRowEntity = this.getView().getControl(treeentryentity).getModel().getEntryRowEntity(treeentryentity, 0);
            if (entityDyn != null && entryRowEntity != null) {
                entityDyn.set("name", (Object)entryRowEntity.getString("name"));
                this.getView().updateView("entity");
            }
        }
    }

    @Override
    public long getModelId() {
        return this.loadModelId();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeentryentity);
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (!("refresh".equals(key) || "show_table".equals(key) || "show_tree".equals(key) || selectRows.length != 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"PeriodSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012") && (key.equals("opendataperiod") || key.equals("closedataperiod") || key.equals("openadjustperiod") || key.equals("closeadjustperiod"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u671f\u95f4\u7ba1\u7406\u529f\u80fd\u9700\u5f00\u542f\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u524d\u5f80\u53c2\u6570\u5217\u8868\u5f00\u542f\u53c2\u6570CM012\u3002", (String)"PeriodSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "opendataperiod": {
                this.refreshView(treeEntryGrid, "datastatus", true, key);
                break;
            }
            case "closedataperiod": {
                this.refreshView(treeEntryGrid, "datastatus", false, key);
                break;
            }
            case "openadjustperiod": {
                this.refreshView(treeEntryGrid, "entrystatus", true, key);
                break;
            }
            case "closeadjustperiod": {
                this.refreshView(treeEntryGrid, "entrystatus", false, key);
                break;
            }
            case "refresh": {
                this.refreshData();
                break;
            }
            case "show_tree": 
            case "show_table": {
                this.setShowStyle(key);
                this.refreshData();
                break;
            }
        }
    }

    private void setShowStyle(String key) {
        this.getPageCache().put(SHOW_STYLE, key);
    }

    private boolean isShowTable() {
        return "show_table".equals(this.getPageCache().get(SHOW_STYLE));
    }

    private void rowClick() {
        boolean showBtn;
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        int[] selects = treeEntry.getSelectRows();
        boolean bl = showBtn = selects.length > 0;
        if (this.isShowTable() && selects.length == 1 && "Entity".equals(this.getModel().getEntryRowEntity(treeentryentity, selects[0]).get("number"))) {
            showBtn = false;
        }
        this.getView().setEnable(Boolean.valueOf(showBtn), new String[]{"opendataperiod", "closedataperiod", "openadjustperiod", "closeadjustperiod"});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)"bcm_rangeconfirm")) {
            Integer orgRange = (Integer)evt.getReturnData();
            if (orgRange == null) {
                return;
            }
            TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(treeentryentity);
            int[] selects = treeentry.getSelectRows();
            if (selects.length == 0) {
                return;
            }
            DynamicObject modelDy = (DynamicObject)this.getModel().getValue("model");
            DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
            DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
            if (modelDy == null || scenarioDy == null || yearDy == null || periodDy == null) {
                return;
            }
            long modelId = modelDy.getLong("id");
            long sceneId = scenarioDy.getLong("id");
            long yearId = yearDy.getLong("id");
            long periodId = periodDy.getLong("id");
            String operationKey = this.getPageCache().get("selectButton_period");
            boolean switchFlag = Boolean.parseBoolean(this.getPageCache().get("switch_period"));
            DynamicObjectCollection orgs = this.dealOrgDataByRange(modelId, sceneId, yearId, periodId, orgRange);
            this.modifyStatus(modelId, sceneId, yearId, periodId, operationKey, switchFlag, orgs);
        }
    }

    private void modifyStatus(long modelId, long sceneId, long yearId, long periodId, String operationKey, boolean switchFlag, DynamicObjectCollection orgs) {
        String message1;
        HashSet<String> orgNumbers = new HashSet<String>();
        for (DynamicObject org : orgs) {
            if ("Entity".equals(org.getString("number"))) continue;
            orgNumbers.add(org.getString("number"));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("scenario", "=", (Object)sceneId);
        qfBuilder.add("year", "=", (Object)yearId);
        qfBuilder.add("period", "=", (Object)periodId);
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("orgnumber", "in", orgNumbers);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_periodmanageentity", (String)"id,datastatus,entrystatus,executeaction,operator,optime,org.id,org.number,orgnumber", (QFilter[])qfBuilder.toArray());
        HashMap<String, DynamicObject> mcMap = new HashMap<String, DynamicObject>(docs.length);
        for (DynamicObject dmc : docs) {
            mcMap.put(dmc.getString("orgnumber"), dmc);
        }
        Date time = TimeServiceHelper.now();
        ArrayList<DynamicObject> dynamicUpdateList = new ArrayList<DynamicObject>(orgs.size());
        ArrayList<DynamicObject> dynamicSaveList = new ArrayList<DynamicObject>(orgs.size());
        String msg1 = ResManager.loadKDString((String)"\u6570\u636e\u671f\u95f4", (String)"PeriodSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String msg2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u671f\u95f4", (String)"PeriodSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String message = operationKey.equals("datastatus") ? msg1 : msg2;
        orgNumbers.clear();
        StringBuilder sbr = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        StringBuilder sbf = new StringBuilder();
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus((Long)modelId);
        ArrayList<String> rateOrgNumberList = new ArrayList<String>(10);
        for (DynamicObject org : orgs) {
            DynamicObject dyo;
            if (orgNumbers.contains(org.getString("number")) || "Entity".equals(org.getString("number"))) continue;
            DynamicObject mc = null;
            if (mcMap.containsKey(org.getString("number"))) {
                mc = (DynamicObject)mcMap.get(org.getString("number"));
                String status = mc.getString(operationKey);
                if (!switchFlag && "B".equals(status)) {
                    sbf.append(mc.getString("orgnumber")).append(" ");
                    continue;
                }
                if (switchFlag && "A".equals(status)) {
                    sbf.append(mc.getString("orgnumber")).append(" ");
                    continue;
                }
                if (!switchFlag && "C".equals(status)) {
                    sb.append(mc.getString("orgnumber")).append(" ");
                    continue;
                }
                if ("true".equals(org.getString("isexchangerate")) && "entrystatus".equals(operationKey)) {
                    rateOrgNumberList.add(mc.getString("orgnumber"));
                    continue;
                }
                if ("entrystatus".equals(operationKey) && !"A".equals(mc.get("datastatus"))) {
                    sbr.append(mc.getString("orgnumber")).append(" ");
                    continue;
                }
            } else if ("entrystatus".equals(operationKey)) {
                if ("true".equals(org.getString("isexchangerate"))) {
                    rateOrgNumberList.add(org.getString("number"));
                    continue;
                }
                if (!defaultInitPeriod) {
                    if (switchFlag) {
                        sbr.append(org.getString("number")).append(" ");
                        continue;
                    }
                    sb.append(org.getString("number")).append(" ");
                    continue;
                }
            }
            if (!mcMap.containsKey(org.getString("number"))) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmanageentity");
                dyo.set("model", (Object)modelId);
                dyo.set("scenario", (Object)sceneId);
                dyo.set("year", (Object)yearId);
                dyo.set("period", (Object)periodId);
                dyo.set("orgnumber", (Object)(mc == null ? org.getString("number") : mc.getString("orgnumber")));
            } else {
                dyo = mc;
            }
            orgNumbers.add(org.getString("number"));
            if (dyo != null) {
                if ("datastatus".equals(operationKey)) {
                    dyo.set("datastatus", (Object)(switchFlag ? "A" : "B"));
                    if ("false".equals(org.getString("isexchangerate"))) {
                        dyo.set("entrystatus", (Object)(switchFlag ? "A" : "B"));
                    } else {
                        dyo.set("entrystatus", (Object)"D");
                    }
                    dyo.set("executeaction", (Object)(switchFlag ? "A" : "B"));
                } else {
                    dyo.set("entrystatus", (Object)(switchFlag ? "A" : "B"));
                    dyo.set("datastatus", (Object)(mc == null ? (defaultInitPeriod ? "A" : "C") : mc.getString("datastatus")));
                    dyo.set("executeaction", (Object)(switchFlag ? "C" : "D"));
                }
                dyo.set("optime", (Object)time);
                dyo.set("operator", (Object)RequestContext.getOrCreate().getUserId());
            }
            if (mcMap.containsKey(org.getString("number"))) {
                dynamicUpdateList.add(dyo);
                continue;
            }
            dynamicSaveList.add(dyo);
        }
        StringBuilder notificationMessage = new StringBuilder();
        if (sbr.length() > 0) {
            message1 = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u6570\u636e\u671f\u95f4\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u5355\u72ec\u6253\u5f00\u5206\u5f55\u671f\u95f4,\u5982\u9700\u64cd\u4f5c\u8bf7\u5148\u6253\u5f00\u6570\u636e\u671f\u95f4\u3002", (String)"PeriodSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            notificationMessage.append(message1);
        }
        if (sb.length() > 0) {
            message1 = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684%s\u4e3a\u672a\u5f00\u542f\uff0c\u4e0d\u80fd\u76f4\u63a5\u5173\u95ed\uff0c\u5982\u9700\u5173\u95ed\u8bf7\u5148\u6253\u5f00\u540e\u518d\u5173\u95ed\u3002", (String)"PeriodSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message);
            notificationMessage.append(message1);
        }
        if (sbf.length() > 0) {
            message1 = switchFlag ? String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684%s\u5df2\u7ecf\u6253\u5f00\uff0c\u4e0d\u9700\u8981\u518d\u6253\u5f00\u3002", (String)"PeriodSettingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message) : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u201c%s\u201d\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u9700\u8981\u518d\u5173\u95ed\u3002", (String)"PeriodSettingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message);
            notificationMessage.append(message1);
        }
        if (!dynamicSaveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicSaveList.toArray(new DynamicObject[0]));
        }
        if (!dynamicUpdateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])dynamicUpdateList.toArray(new DynamicObject[0]));
        }
        if (this.isShowTable()) {
            this.refreshData();
        } else {
            this.refreshView(orgNumbers);
            this.getView().updateView(treeentryentity);
        }
        String opName = this.getOpName(this.getPageCache().get("operationKey"));
        try {
            String logDes;
            String orgNumber;
            PairList logs = new PairList();
            String sceneNumber = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId).getNumber();
            String fyNumber = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
            String periodNumber = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
            String opDesPre = String.format("%s %s %s", sceneNumber, fyNumber, periodNumber);
            if (!dynamicSaveList.isEmpty()) {
                for (DynamicObject record : dynamicSaveList) {
                    orgNumber = record.getString("orgnumber");
                    logDes = String.format("%s %s %s%s", opDesPre, orgNumber, opName, ResultStatusEnum.SUCCESS.getName());
                    logs.addPair((Object)opName, (Object)logDes);
                }
            }
            if (!dynamicUpdateList.isEmpty()) {
                for (DynamicObject record : dynamicUpdateList) {
                    orgNumber = record.getString("orgnumber");
                    logDes = String.format("%s %s %s%s", opDesPre, orgNumber, opName, ResultStatusEnum.SUCCESS.getName());
                    logs.addPair((Object)opName, (Object)logDes);
                }
            }
            this.writeBatchLogs(logs, modelId);
        }
        catch (Exception e) {
            log.error("batch insert log error:", (Throwable)e);
        }
        if (notificationMessage.length() > 0) {
            this.getView().showTipNotification(notificationMessage.toString());
            this.removeCacheKey();
            return;
        }
        if (rateOrgNumberList.size() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s \u6c47\u7387\u7ec4\u7ec7\u4e0d\u9002\u7528\u5206\u5f55\u671f\u95f4\u7ba1\u7406\u3002", (String)"PeriodSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", rateOrgNumberList));
            this.getView().showTipNotification(msg);
            this.removeCacheKey();
            return;
        }
        this.showOpResult(opName, ResultStatusEnum.SUCCESS);
        this.removeCacheKey();
    }

    private void refreshView(Set<String> orgNumbers) {
        String key = this.getPageCache().get("selectButton_period");
        boolean switchFlag = Boolean.parseBoolean(this.getPageCache().get("switch_period"));
        int size = this.getModel().getEntryEntity(treeentryentity).size();
        int count = 0;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(treeentryentity);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!orgNumbers.contains(dynamicObject.getString("number"))) continue;
            for (int i = 0; i < size; ++i) {
                if (!dynamicObject.get("memberid").equals(this.getModel().getValue("memberid", i))) continue;
                count = i;
                if ("datastatus".equals(key)) {
                    this.getModel().setValue("datastatus", (Object)(switchFlag ? "A" : "B"), count);
                    if ("false".equals(dynamicObject.getString("isexchangerate"))) {
                        this.getModel().setValue("entrystatus", (Object)(switchFlag ? "A" : "B"), count);
                    }
                    this.getModel().setValue("executeaction", (Object)(switchFlag ? "A" : "B"), count);
                } else {
                    this.getModel().setValue("entrystatus", (Object)(switchFlag ? "A" : "B"), count);
                    this.getModel().setValue("executeaction", (Object)(switchFlag ? "C" : "D"), count);
                }
                this.getModel().setValue("operator", (Object)RequestContext.getOrCreate().getUserId(), count);
                this.getModel().setValue("optime", (Object)TimeServiceHelper.now(), count);
            }
        }
    }

    private void removeCacheKey() {
        this.getPageCache().remove("operationKey");
        this.getPageCache().remove("selectButton_period");
        this.getPageCache().remove("switch_period");
    }

    private DynamicObjectCollection dealOrgDataByRange(long modelId, long sceneId, long yearId, long periodId, int orgRange) {
        int[] selects;
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        for (int i : selects = treeEntry.getSelectRows()) {
            DynamicObject selectOrgDy = this.getModel().getEntryRowEntity(treeentryentity, i);
            long orgId = selectOrgDy.getLong("id");
            orgIdSet.add(orgId);
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (orgNode.getId() <= 0L) continue;
            if (orgRange == 2) {
                orgIdSet.addAll(orgNode.getChildrenIds());
                continue;
            }
            if (orgRange != 3) continue;
            orgIdSet.addAll(orgNode.getAllChildrenIds());
        }
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        DynamicObjectCollection orgList = PeriodSettingHelper.getHasPermOrgListByIds((Long)modelId, orgIdSet);
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, sceneId, fyNode.getNumber(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgList);
        return orgList;
    }

    private void refreshView(TreeEntryGrid treeEntryGrid, String key, boolean flag, String operationKey) {
        int[] selectRows = treeEntryGrid.getSelectRows();
        boolean existUnitOrg = false;
        for (int i : selectRows) {
            if (!this.getModel().getEntryRowEntity(treeentryentity, i).get("isleaf").equals("false")) continue;
            existUnitOrg = true;
            break;
        }
        this.getPageCache().put("selectButton_period", key);
        this.getPageCache().put("switch_period", Boolean.toString(flag));
        this.getPageCache().put("operationKey", operationKey);
        if (!this.isShowTable() && existUnitOrg) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_rangeconfirm");
            if (selectRows.length == 1 && "Entity".equals(this.getModel().getEntryRowEntity(treeentryentity, selectRows[0]).get("number"))) {
                param.setCustomParam("isOnlyEntity", (Object)"true");
            }
            param.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PeriodSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_rangeconfirm"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        } else {
            DynamicObject modelDy = (DynamicObject)this.getModel().getValue("model");
            DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
            DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
            if (modelDy == null || scenarioDy == null || yearDy == null || periodDy == null) {
                return;
            }
            long modelId = modelDy.getLong("id");
            long sceneId = scenarioDy.getLong("id");
            long yearId = yearDy.getLong("id");
            long periodId = periodDy.getLong("id");
            HashSet<Long> orgIdSet = new HashSet<Long>(selectRows.length);
            for (int i : selectRows) {
                DynamicObject selectOrgDy = this.getModel().getEntryRowEntity(treeentryentity, i);
                long orgId = selectOrgDy.getLong("id");
                orgIdSet.add(orgId);
            }
            DynamicObjectCollection orgList = PeriodSettingHelper.getHasPermOrgListByIds((Long)modelId, orgIdSet);
            this.modifyStatus(modelId, sceneId, yearId, periodId, key, flag, orgList);
        }
    }

    private String getOpName(String operationKey) {
        String opName = "";
        switch (operationKey) {
            case "opendataperiod": {
                opName = OpItemEnum.OPEN_PERIOD.getName();
                break;
            }
            case "closedataperiod": {
                opName = OpItemEnum.CLOSE_PERIOD.getName();
                break;
            }
            case "openadjustperiod": {
                opName = OpItemEnum.OPEN_ADJUSTPERIOD.getName();
                break;
            }
            case "closeadjustperiod": {
                opName = OpItemEnum.CLOSE_ADJUSTPERIOD.getName();
            }
        }
        return opName;
    }

    private void showOpResult(String opName, ResultStatusEnum statusEnum) {
        if (statusEnum == ResultStatusEnum.SUCCESS) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"PeriodSettingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\u3002", (String)"PeriodSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName));
        }
    }
}

