/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgECTranSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.PeriodRelaMembSupplier;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.extreport.ExtReportModelHandle;
import kd.fi.bcm.formplugin.report.extreport.ExtReportViewHandle;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.util.EnumStyleCellUtils;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.common.util.CellDimFilterUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.EDFormulaUtil;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.ReportDataRefleshService;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.ExtDataHandleService;
import kd.fi.bcm.spread.util.DynamicUtils;
import kd.fi.bcm.spread.util.FillDataUtils;

public abstract class AbstractReportBasePlugin
extends AbstractTemplateBasePlugin {
    private long templateId;
    protected static final String SPREAD_KEY = "report";
    protected static final String SAVE2REFRESH = "save2refresh";
    public static final String CALEXTVFORMULA = "calExtVFormula";
    private Map<String, IRelaMembSupplier<String, String>> pool = null;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected boolean isTemplatePlugin() {
        return false;
    }

    @Override
    public String getSpreadKey() {
        return SPREAD_KEY;
    }

    public boolean isOrgInRanks() {
        String isOrgInRanks = this.getPageCache().get("isOrgInRanks");
        if (!StringUtil.isEmptyString((String)isOrgInRanks)) {
            return Boolean.parseBoolean(isOrgInRanks);
        }
        List viewPointDimensionEntries = this.getTemplateModel().getViewPointDimensionEntries();
        for (ViewPointDimensionEntry viewPointDimensionEntry : viewPointDimensionEntries) {
            if (!StringUtil.equals((String)viewPointDimensionEntry.getDimension().getNumber(), (String)SysDimensionEnum.Entity.getNumber())) continue;
            this.getPageCache().put("isOrgInRanks", String.valueOf(false));
            return false;
        }
        List pageDimensionEntries = this.getTemplateModel().getPageDimensionEntries();
        for (PageDimensionEntry pageDimensionEntry : pageDimensionEntries) {
            if (!StringUtil.equals((String)pageDimensionEntry.getDimension().getNumber(), (String)SysDimensionEnum.Entity.getNumber())) continue;
            this.getPageCache().put("isOrgInRanks", String.valueOf(false));
            return false;
        }
        this.getPageCache().put("isOrgInRanks", String.valueOf(true));
        return true;
    }

    public String[] getECPCByNumber(String number) {
        List virtualCurrs;
        String ECPCCache = this.getPageCache().get("ECPC");
        if (StringUtil.isEmptyString((String)ECPCCache) && (virtualCurrs = FillDataUtils.getVirtualCurr((Object)this.getRealOrgInfo().p1)).size() == 2) {
            ECPCCache = String.format("%s,%s;%s,%s", ((DimMember)virtualCurrs.get(0)).getNumber(), ((DimMember)virtualCurrs.get(0)).getName(), ((DimMember)virtualCurrs.get(1)).getNumber(), ((DimMember)virtualCurrs.get(1)).getName());
            this.getPageCache().put("ECPC", ECPCCache);
        }
        return ECPCCache.split(";")[StringUtil.equals((String)number, (String)CurrencyEnum.EC.getNumber()) ? 0 : 1].split(",");
    }

    @Override
    public TemplateModel getTemplateModel() {
        if (this.template == null) {
            Predicate<String> p = t -> StringUtils.isEmpty((String)t);
            String serial = this.getPageCache().get(this.KEY_TEMPLATE_MODEL);
            this.template = p.test(serial) ? this.loadTemplateById(this.getTemplateId()) : this.getTemplateModelFromSerial(serial);
        }
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(this.template));
        return this.template;
    }

    protected long getTemplateId() {
        this.templateId = (Long)this.getFormCustomParam("template_id");
        if (this.templateId == 0L) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6a21\u677fID\uff1a%s\u65e0\u6548\u3002", (String)"AbstractReportBasePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.template));
        }
        return this.templateId;
    }

    protected TemplateModel loadTemplateById(long templateId) {
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)templateId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    @Override
    public SpreadManager getSpreadModel() {
        SpreadManager spm = super.getSpreadModel();
        this.initSpreadFilter(spm);
        return spm;
    }

    protected String getCommonFilterDimensionInfo() {
        return (String)this.getFormCustomParam("FilterDimensinInfo");
    }

    protected void initSpreadFilter(SpreadManager spm) {
        if (spm.getFilter() == null) {
            Member m;
            IDNumberTreeNode node;
            TemplateModel template = this.getTemplateModel();
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            String filterDimensinInfo = this.getCommonFilterDimensionInfo();
            JSONObject dims = new JSONObject();
            if (StringUtils.isNotEmpty((String)filterDimensinInfo)) {
                dims = JSONObject.parseObject((String)filterDimensinInfo);
            }
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                Optional trans2SpecificFyOrPer;
                JSONObject object;
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                member = ObjectConvertUtils.toDimMember(v.getMember(), dim);
                String tempNumber = v.getDimension().getMemberEntityNumber();
                if ("bcm_fymembertree".equals(tempNumber) && dims.containsKey((Object)tempNumber)) {
                    object = (JSONObject)dims.get((Object)tempNumber);
                    trans2SpecificFyOrPer = PeriodUtils.trans2SpecificFy((String)this.getModelNumber(), (String)object.getString("number"), (String)member.getNumber());
                    member.setName(this.getFyOrPeriodName(tempNumber, (String)trans2SpecificFyOrPer.get()).get());
                    member.setNumber((String)trans2SpecificFyOrPer.get());
                } else if ("bcm_periodmembertree".equals(tempNumber) && dims.containsKey((Object)tempNumber)) {
                    object = (JSONObject)dims.get((Object)tempNumber);
                    trans2SpecificFyOrPer = PeriodUtils.trans2SpecificPeriod((String)this.getModelNumber(), (String)object.getString("number"), (String)member.getNumber(), (boolean)true);
                    member.setName(this.getFyOrPeriodName(tempNumber, (String)trans2SpecificFyOrPer.get()).get());
                    member.setNumber((String)trans2SpecificFyOrPer.get());
                } else if ("bcm_entitymembertree".equals(tempNumber) && dims.containsKey((Object)tempNumber)) {
                    object = (JSONObject)dims.get((Object)tempNumber);
                    node = MemberReader.findEntityMemberById((String)this.getModelNumber(), (Long)object.getLong("id"));
                    ((DimMember)member).setPar_SonNum(node.getParent_SonNumber());
                }
                member.setId(v.getMember().getId());
                dim.addMember(member);
                view.addDimension(dim);
            }
            for (ViewPointDimensionEntry v : template.getPageDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                String entityNumber = v.getDimension().getMemberEntityNumber();
                if (dims.containsKey((Object)entityNumber)) {
                    JSONObject item = (JSONObject)dims.get((Object)entityNumber);
                    Member m2 = new Member();
                    m2.setName(item.getString("name"));
                    m2.setNumber(item.getString("number"));
                    member = ObjectConvertUtils.toDimMember(m2, dim);
                    if (DimTypesEnum.ENTITY.getNumber().equals(dim.getNumber())) {
                        node = MemberReader.findEntityMemberById((String)this.getModelNumber(), (Long)item.getLong("id"));
                        ((DimMember)member).setPar_SonNum(node.getParent_SonNumber());
                    }
                } else if (v.getMembers().isEmpty() && "bcm_entitymembertree".equals(entityNumber)) {
                    member = this.initEntityMember(dim);
                } else {
                    m = (Member)v.getMembers().get(0);
                    Object[] obj = this.getMember(m, dim);
                    member = (IDimMember)obj[0];
                }
                if (member != null) {
                    dim.addMember(member);
                }
                page.addDimension(dim);
            }
            for (ViewPointDimensionEntry v : template.getPagePropEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                if (dims.containsKey((Object)v.getDimension().getMemberEntityNumber())) {
                    JSONObject item = (JSONObject)dims.get((Object)v.getDimension().getMemberEntityNumber());
                    m = new Member();
                    m.setName(item.getString("name"));
                    m.setNumber(item.getString("number"));
                    member = ObjectConvertUtils.toDimMember(m, dim);
                    dim.addMember(member);
                } else {
                    DynamicObjectCollection members = SpreadUtils.queryMemberByMembProperty(v.getCustomProperties(), (List<MembProperty>)v.getAllMembProperties(), v.getDimension());
                    if (members != null && !members.isEmpty()) {
                        m = new Member();
                        m.setName(((DynamicObject)members.get(0)).getString("name"));
                        m.setNumber(((DynamicObject)members.get(0)).getString("number"));
                        member = ObjectConvertUtils.toDimMember(m, dim);
                        dim.addMember(member);
                    }
                }
                page.addDimension(dim);
            }
            spm.setFilter(new FilterView(view, page));
        }
    }

    private Optional<String> getFyOrPeriodName(String entity, String number) {
        QFBuilder qfBuilder = new QFBuilder("model.number", "=", (Object)this.getModelNumber());
        qfBuilder.add("number", "=", (Object)number);
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)entity, (String)"name", (QFilter[])qfBuilder.toArray()).getString("name"));
    }

    protected Object[] getMember(Member m, IDimension dim) {
        int scope = m.getScope();
        long memberid = m.getId();
        DimMember member = null;
        if (scope == RangeEnum.VALUE_20.getValue() || scope == RangeEnum.VALUE_40.getValue()) {
            QFilter qf = new QFilter("parent", "=", (Object)memberid);
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{qf});
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("name"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_60.getValue()) {
            QFilter qf = new QFilter("id", "=", (Object)memberid);
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "parent", new QFilter[]{qf});
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            long parentid = dot.getLong("parent");
            QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
            QFilter qf2 = new QFilter("id", "!=", (Object)memberid);
            dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{qf1, qf2});
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_90.getValue() || scope == RangeEnum.VALUE_110.getValue()) {
            String pLongNum = BusinessDataServiceHelper.loadSingle((Object)m.getId(), (String)m.getDataEntityNumber(), (String)"longnumber").getString("longnumber");
            DynamicObject dot = this.queryOne(m.getDataEntityNumber(), "id,name,number,simpleName", new QFilter[]{new QFilter("longnumber", "like", (Object)(pLongNum + '!' + "%")).or("longnumber", "=", (Object)pLongNum), new QFilter("model", "=", (Object)this.getModelId()), new QFilter("isleaf", "=", (Object)(scope == RangeEnum.VALUE_90.getValue() ? 1 : 0))});
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            ArrayList items = new ArrayList();
            new MembRangeItem(m.getDataEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)this.getModelId()).matchItems(c -> items.add(c.number));
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        member = new DimMember(m.getName(), m.getNumber(), m.getName(), dim);
        return new Object[]{member, memberid};
    }

    private DynamicObject queryOne(String entityName, String selectFields, QFilter[] filters) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])filters, (String)"level, dseq", (int)1);
        return list.isEmpty() ? null : (DynamicObject)list.get(0);
    }

    private void checkRangeMemberExists(Member sourceMemb, DynamicObject targMemb, RangeEnum scope) {
        if (targMemb == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u67e5\u627e\u6210\u5458[%1$s]\u8303\u56f4-->%2$s\u4e0d\u5b58\u5728\u6210\u5458\uff01", (String)"AbstractReportBasePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sourceMemb.getName(), scope.getName()));
            log.error(sb.toString());
            throw new KDBizException(sb.toString());
        }
    }

    protected IDimMember initEntityMember(IDimension dim) {
        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u9ed8\u8ba4\u6210\u5458\u672a\u8bbe\u7f6e\u3002", (String)"AbstractReportBasePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void closeDataSetCache() {
    }

    protected void refreshReport() {
        if (!this.checkFilterConditionIsAllFilled()) {
            return;
        }
        SpreadManager sm = this.getSpreadModel();
        AutoFloatUtil.clearOldSeqInfo(sm);
        if (EDFormulaUtil.checkHasSumCal((SpreadManager)sm)) {
            this.closeDataSetCache();
        }
        if (!ThreadCache.exists((Object)SAVE2REFRESH) || this.getPageCache().get(CALEXTVFORMULA) != null || EDFormulaUtil.checkHasSumCal((SpreadManager)sm)) {
            ExtReportViewHandle viewHandle = new ExtReportViewHandle(this.getClientViewProxy(), SPREAD_KEY, this.getView());
            String modelShowNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
            ExtReportModelHandle modelHandle = new ExtReportModelHandle(this.getModelId(), modelShowNumber, this.getSpreadModel(), this.getTemplateModel(), viewHandle);
            modelHandle.setPageSize(ExtDataHandleService.getPageSizeSetting((long)this.getModelId()));
            this.getSpreadModel().setSheetOnlyRead(this.getTemplateModel().getIsOnlyRead() || this.isFromQuery());
            modelHandle.autoLoadExtReport(this.getSpreadModel(), this.getOrgRelaMembSupplier(), null);
            viewHandle.setExtPosF7Style(this.getModelId(), this.getSpreadModel());
            this.getPageCache().remove(CALEXTVFORMULA);
            this.getPageCache().remove("delExts");
        }
        if (DynamicUtils.isDynamicReport((SpreadManager)sm)) {
            this.autoFloat();
            this.setFloatF7Cell();
            MarkSpecialCell.drawMarkPointForReport(this.getPageCache(), this.getView(), this.getSpreadModel(), SPREAD_KEY);
        }
        if (TemplateTypeEnum.MSN.getType() != this.getTemplateModel().getTemplateType().intValue()) {
            EnumStyleCellUtils.setEnumStyleCell(this, this.getPageCache(), null, null, null);
        }
        CellDimFilterUtil.cellDimFilterBuild((SpreadManager)sm);
        this.checkDimensionMembers();
        boolean isInner = TemplateRangeService.handleViewPointRange((String)"bcm_entitymembertree", (TemplateModel)this.getTemplateModel());
        new ReportDataRefleshService().reflesh(this.getSpreadModel(), this.getModelNumber(), isInner ? this.getViewpointOrgRelaMembSupplier() : this.getOrgRelaMembSupplier(), (IRelaMembSupplier)this.getPeriodRelaMembSupplier());
        if (this.getFormCustomParam("issource") != null) {
            SpreadEasyInvoker.clearAllCornerMark(this.getSpreadModel(), this.getClientViewProxy(), this.getSpreadKey());
            List style = new ReportDataRefleshService().getStyleCells(this.getSpreadModel(), this.getModelNumber(), isInner ? this.getViewpointOrgRelaMembSupplier() : this.getOrgRelaMembSupplier(), (IRelaMembSupplier)this.getPeriodRelaMembSupplier());
            if (style != null && !style.isEmpty()) {
                SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "setCornerMark", this.getSpreadKey(), style.toArray());
            }
        }
        this.handleDebitCreditColum();
        this.afterRefreshData();
    }

    protected boolean isFromQuery() {
        String processType = (String)this.getView().getFormShowParameter().getCustomParam("processtype");
        return "query".equals(processType);
    }

    protected void handleDebitCreditColum() {
    }

    protected void afterRefreshData() {
    }

    protected OrgRelaMembSupplier getViewpointOrgRelaMembSupplier() {
        Long id = ((DynamicObject)this.getModel().getDataEntity().get("bcm_entitymembertree")).getLong("id");
        String number = ((DynamicObject)this.getModel().getDataEntity().get("bcm_entitymembertree")).getString("number");
        Pair orgInfo = Pair.onePair((Object)this.getEntityBaseMemberId(id), (Object)number);
        OrgRelaMembSupplier s = new OrgRelaMembSupplier((Long)orgInfo.p1, (String)orgInfo.p2, Long.valueOf(this.getModelId()));
        return s;
    }

    protected void checkDimensionMembers() {
    }

    protected void autoFloat() {
    }

    protected void setFloatF7Cell() {
    }

    protected void enableControl() {
    }

    protected abstract Pair<Long, String> getCurrentOrgInfo();

    protected Pair<Long, String> getRealOrgInfo() {
        return this.getCurrentOrgInfo();
    }

    protected IRelaMembSupplier<String, String> getOrgRelaMembSupplier() {
        OrgRelaMembSupplier supplier;
        Pair<Long, String> orgInfo = this.getRealOrgInfo();
        if (this.pool == null) {
            String serial = this.getPageCache().get("Rela_Supplier_key");
            this.pool = StringUtils.isEmpty((String)serial) ? new HashMap<String, IRelaMembSupplier<String, String>>(16) : (Map)this.deSerializedBytes(serial);
        }
        if ((supplier = this.pool.get(String.valueOf(orgInfo.p1))) == null) {
            supplier = new OrgRelaMembSupplier((Long)orgInfo.p1, (String)orgInfo.p2, Long.valueOf(this.getModelId()));
            this.pool.put(String.valueOf(orgInfo.p1), (IRelaMembSupplier<String, String>)supplier);
            this.getPageCache().put("Rela_Supplier_key", this.toByteSerialized(this.pool));
        }
        return supplier;
    }

    protected IRelaMembSupplier<String, String> getOrgTranECSupplier() {
        OrgECTranSupplier supplier;
        if (this.pool == null) {
            String serial = this.getPageCache().get("TranEC_Supplier_key");
            this.pool = StringUtils.isEmpty((String)serial) ? new HashMap<String, IRelaMembSupplier<String, String>>(16) : (Map)this.deSerializedBytes(serial);
        }
        if ((supplier = this.pool.get("TranEC_Supplier")) == null) {
            supplier = new OrgECTranSupplier(Long.valueOf(this.getModelId()));
            this.pool.put("TranEC_Supplier", (IRelaMembSupplier<String, String>)supplier);
            this.getPageCache().put("TranEC_Supplier_key", this.toByteSerialized(this.pool));
        }
        return supplier;
    }

    protected DynamicObject getCurrencyDynaObjByOrgId(long orgId, Long yearId, Long periodId) {
        return OrgCurrencyServiceHelper.getCurrencyDynById((Long)orgId, (Long)yearId, (Long)periodId);
    }

    protected boolean checkFilterConditionIsAllFilled() {
        if (this.getSpreadModel().getFilter() != null && this.getSpreadModel().getFilter().getPageDomain() != null) {
            boolean isNotAllFilled = this.getSpreadModel().getFilter().getPageDomain().getDimensions().stream().anyMatch(e -> e.getMembers().isEmpty());
            if (isNotAllFilled) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7ef4\u5ea6\u672a\u8bbe\u7f6e\u6210\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u6570\u636e\u3002", (String)"AbstractReportBasePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"AbstractReportBasePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"AbstractReportBasePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    protected PeriodRelaMembSupplier getPeriodRelaMembSupplier() {
        return null;
    }
}

