/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.MapUtils;

public class BaseTableAdjustplugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    protected static final String FIELD_SET_PANEL = "fieldsetpanelap";
    protected static final String MEMBERMODEL = "membermodel";
    protected static final String NUMBER = "number";
    protected static final String ENTRYENTITY = "entryentity";
    protected static String ADJUST_AT_MEM = "adjustAtMem";
    protected static String SELECTCELL = "selectDimCell";
    protected static String ORI_SELECTCELL = "oriSelectDimCell";
    protected static String COMMONMEMBER = "commonMember";
    protected static String ORI_COMMONMEMBER = "oriCommonMember";
    protected String adjAtMem = "CWP";
    protected String COLOR = "#5582f3";
    protected String adjAtName = ResManager.loadKDString((String)"\u5e95\u7a3f\u5f0f", (String)"DimensionServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public void initialize() {
        super.initialize();
        String datasource = this.getAuditDatasource("CWP");
        String cube = (String)this.getView().getFormShowParameter().getCustomParam("cube");
        Pair<String, String> adjAtNumAndName = this.getAdjAtMemString(cube, datasource);
        this.adjAtMem = (String)adjAtNumAndName.p1;
        this.adjAtName = (String)adjAtNumAndName.p2;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_save");
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Pair<String, String> getAdjAtMemString(String cube, String datasource) {
        String adjAtMem = "CWP";
        String adjAtName = ResManager.loadKDString((String)"\u5e95\u7a3f\u5f0f", (String)"DimensionServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]);
        if (!DataSourceEnum.TABLEADJUSTMENT.index.equals(datasource)) {
            Long adjeId = MemberReader.findMemberByNumber((String)cube, (String)"AuditTrail", (String)"ADJE").getId();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("parent", "=", (Object)adjeId);
            qfBuilder.add("datasource", "=", (Object)DataSourceEnum.TABLEADJUSTMENT.index);
            DynamicObjectCollection atNums = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number, name", (QFilter[])qfBuilder.toArray(), (String)"dseq", (int)1);
            adjAtMem = ((DynamicObject)atNums.get(0)).getString(NUMBER);
            adjAtName = ((DynamicObject)atNums.get(0)).getString("name");
        }
        this.getView().getPageCache().put(ADJUST_AT_MEM, adjAtMem);
        return new Pair((Object)adjAtMem, (Object)adjAtName);
    }

    protected String getAuditDatasource(String number) {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(NUMBER, "=", (Object)number);
        String datasource = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)"datasource", (QFilter[])qFilter.toArray()).getString("datasource");
        return datasource;
    }

    protected void initNewStylePageViewPanel(Map<String, DynamicObject> commonDimModelNum2dimDy) {
        FlexPanelAp fieldsetpanelap = new FlexPanelAp();
        fieldsetpanelap.setKey(FIELD_SET_PANEL);
        fieldsetpanelap.setGrow(0);
        fieldsetpanelap.setName(new LocaleString(ResManager.loadKDString((String)"\u89c6\u70b9\u9875\u9762\u7ef4", (String)"TableAdjustPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        fieldsetpanelap.setOverflow("visible");
        this.addF7Items(fieldsetpanelap, commonDimModelNum2dimDy);
        this.getView().updateControlMetadata(FIELD_SET_PANEL, fieldsetpanelap.createControl());
    }

    protected void addF7Items(FlexPanelAp flexPanelAp, Map<String, DynamicObject> commonDimModelNum2dimDy) {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (Map.Entry<String, DynamicObject> entry : commonDimModelNum2dimDy.entrySet()) {
            String membermodel = entry.getKey();
            String membermodelFieldKdy = this.sugarF7Key(membermodel, entry.getValue().getString(NUMBER));
            if (props.contains((Object)membermodelFieldKdy)) continue;
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setQuickAddNew(false);
            BasedataField basedata = new BasedataField();
            f7Field.setName(new LocaleString(entry.getValue().getString("name")));
            f7Field.setLabelDirection("h");
            f7Field.setKey(membermodelFieldKdy);
            f7Field.setLock("new,edit,view");
            this.initEntryFieldStyle((FieldAp)f7Field);
            basedata.setKey(membermodelFieldKdy);
            basedata.setViewDetail(false);
            f7Field.setField((Field)basedata);
            f7Field.setQuickAddNew(false);
            flexPanelAp.getItems().add(f7Field);
        }
    }

    protected void initEntryFieldStyle(FieldAp f7Field) {
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setWidth(new LocaleString("200px"));
        f7Field.setStyle(this.getDefaultStyle());
    }

    protected Style getDefaultStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("1px");
        margin.setLeft("20px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    protected void bindCtrlMapping(Map<String, DynamicObject> commonDimModelNum2dimDy) {
        if (MapUtils.isNotEmpty(commonDimModelNum2dimDy)) {
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            DataEntityPropertyCollection props = mainEntityType.getProperties();
            commonDimModelNum2dimDy.forEach((dimModelNum, dim) -> {
                String f7Key = this.sugarF7Key((String)dimModelNum, dim.getString(NUMBER));
                if (props.contains((Object)f7Key)) {
                    return;
                }
                DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl(FIELD_SET_PANEL)), (MainEntityType)mainEntityType, (String)f7Key.toLowerCase(Locale.ENGLISH), (String)dimModelNum, (IDataModel)this.getModel(), (IFormView)this.getView());
            });
        }
    }

    protected TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle, boolean lock) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        if (lock) {
            textEditElement.setLock("new,edit,view");
        }
        textEditElement.setFieldTextAlign("center");
        textEditElement.setTextAlign("center");
        return textEditElement;
    }

    protected String dealProcessAndAudit(String dim, String mem, String adjustAtMem) {
        if ("Process".equalsIgnoreCase(dim) && ("EIRpt".equalsIgnoreCase(mem) || "ERpt".equalsIgnoreCase(mem) || "IRpt".equalsIgnoreCase(mem) || "Rpt".equalsIgnoreCase(mem))) {
            mem = "RAdj";
        } else if ("AuditTrail".equalsIgnoreCase(dim)) {
            mem = adjustAtMem;
        }
        return mem;
    }

    protected String dealProcessAndAudit4Attotal(String dim, String mem) {
        if ("Process".equalsIgnoreCase(dim)) {
            mem = "ERpt";
        } else if ("AuditTrail".equalsIgnoreCase(dim)) {
            mem = "ATTotal";
        }
        return mem;
    }

    protected String dealProcessAndAudit4Cell(String dim, String mem) {
        if ("Process".equalsIgnoreCase(dim)) {
            mem = "EIRpt";
        } else if ("AuditTrail".equalsIgnoreCase(dim)) {
            mem = "ATTotal";
        }
        return mem;
    }

    protected String dealProcessAndAuditname(String dim, String adjAtName, String name) {
        if ("bcm_processmembertree".equals(dim) || "Process".equals(dim)) {
            name = AdjustTypeEnum.RPTLEAF.getName();
        }
        if ("bcm_audittrialmembertree".equals(dim) || "AuditTrail".equals(dim)) {
            name = adjAtName;
        }
        return name;
    }

    protected static Object adjAdjValue(Object afterAdjWithoutCwp, Object adjustValue) {
        if (afterAdjWithoutCwp == null || StringUtil.isEmptyString((String)afterAdjWithoutCwp.toString())) {
            return adjustValue;
        }
        if (adjustValue == null || StringUtil.isEmptyString((String)adjustValue.toString())) {
            return afterAdjWithoutCwp;
        }
        if (!NumberUtils.isNumber((String)afterAdjWithoutCwp.toString()) || !NumberUtils.isNumber((String)adjustValue.toString())) {
            return "";
        }
        BigDecimal left = new BigDecimal(afterAdjWithoutCwp.toString());
        BigDecimal right = new BigDecimal(adjustValue.toString());
        return right.add(left);
    }

    protected static Object adjAfterValue(Object afterData, Object afterAdjWithoutCwp) {
        if (afterAdjWithoutCwp == null || StringUtil.isEmptyString((String)afterAdjWithoutCwp.toString())) {
            return afterData;
        }
        if (afterData == null || StringUtil.isEmptyString((String)afterData.toString())) {
            BigDecimal bigDecimal = new BigDecimal(afterAdjWithoutCwp.toString());
            return bigDecimal.negate();
        }
        if (!NumberUtils.isNumber((String)afterAdjWithoutCwp.toString()) || !NumberUtils.isNumber((String)afterData.toString())) {
            return "";
        }
        BigDecimal left = new BigDecimal(afterAdjWithoutCwp.toString());
        BigDecimal right = new BigDecimal(afterData.toString());
        return right.subtract(left);
    }

    protected static Object subtract(Object left, Object right, Object right1) {
        try {
            if (!(right1 != null && !StringUtil.isEmptyString((String)right1.toString()) || right != null && !StringUtil.isEmptyString((String)right.toString()) || left != null && !StringUtil.isEmptyString((String)left.toString()))) {
                return "";
            }
            if (right1 == null || StringUtil.isEmptyString((String)right1.toString())) {
                right1 = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)right1.toString())) {
                return "";
            }
            if (right == null || StringUtil.isEmptyString((String)right.toString())) {
                right = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)right.toString())) {
                return "";
            }
            if (left == null || StringUtil.isEmptyString((String)left.toString())) {
                left = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)left.toString())) {
                return "";
            }
            return new BigDecimal(left.toString()).subtract(new BigDecimal(right1.toString())).subtract(new BigDecimal(right.toString()));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }

    protected static Object add(Object left, Object right, Object right1) {
        try {
            if (!(right1 != null && !StringUtil.isEmptyString((String)right1.toString()) || right != null && !StringUtil.isEmptyString((String)right.toString()) || left != null && !StringUtil.isEmptyString((String)left.toString()))) {
                return "";
            }
            if (right1 == null || StringUtil.isEmptyString((String)right1.toString())) {
                right1 = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)right1.toString())) {
                return "";
            }
            if (right == null || StringUtil.isEmptyString((String)right.toString())) {
                right = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)right.toString())) {
                return "";
            }
            if (left == null || StringUtil.isEmptyString((String)left.toString())) {
                left = new BigDecimal(0);
            } else if (!NumberUtils.isNumber((String)left.toString())) {
                return "";
            }
            return new BigDecimal(left.toString()).add(new BigDecimal(right1.toString())).add(new BigDecimal(right.toString()));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }
}

