/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;

public class BatchExportListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTITYNAME = "entryentity";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_CONFIRM = "btn_confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnDelete = (Button)this.getView().getControl(BTN_DELETE);
        btnDelete.addClickListener((ClickListener)this);
        Button btnConfirm = (Button)this.getView().getControl(BTN_CONFIRM);
        btnConfirm.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTITYNAME);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            Object modelId = customParams.get("model");
            Object userId = customParams.get("userId");
            Object exporttype = customParams.get("exporttype");
            if (modelId != null && userId != null) {
                if (exporttype == null) {
                    exporttype = 0;
                }
                QFilter typeFilter = new QFilter("exporttype", "=", exporttype);
                QFilter filter = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong(modelId));
                filter.and("user", "=", (Object)ConvertUtil.convertObjToLong(userId));
                filter.and("applicationscope", "=", (Object)"1");
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_batchexportplan", (QFilter[])new QFilter[]{filter, typeFilter}, null, (int)-1);
                QFilter filter1 = new QFilter("applicationscope", "=", (Object)"2").and(new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong(modelId)));
                List notDefaultIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_batchexportplan", (QFilter[])new QFilter[]{filter1, typeFilter}, null, (int)-1);
                ids.addAll(notDefaultIds);
                int size = ids.size();
                this.getModel().getEntryEntity(ENTITYNAME).clear();
                if (size > 0) {
                    model.beginInit();
                    model.batchCreateNewEntryRow(ENTITYNAME, size);
                    for (int i = 0; i < size; ++i) {
                        model.setValue("plan", ids.get(i), i);
                    }
                    model.endInit();
                }
                this.getView().updateView();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_confirm": {
                List<DynamicObject> selectedEntry = this.getSelectedEntry();
                if (selectedEntry == null || selectedEntry.isEmpty() || selectedEntry.get(0) == null || selectedEntry.get(0).getDynamicObject("plan") == null || selectedEntry.get(0).getDynamicObject("plan").getDynamicObject("plan") == null) {
                    this.getView().close();
                    return;
                }
                if (!this.checkData(key)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BatchExportListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
                returnDataMap.put("planDetailId", selectedEntry.get(0).getDynamicObject("plan").getDynamicObject("plan").getPkValue());
                returnDataMap.put("planId", selectedEntry.get(0).getDynamicObject("plan").getPkValue());
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject obj = (DynamicObject)this.getModel().getEntryEntity(ENTITYNAME).get(evt.getRowIndex());
        Object planId = obj.getDynamicObject("plan").getPkValue();
        DynamicObject planDetail = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"bcm_batchexportplan");
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        returnDataMap.put("planDetailId", planDetail.getDynamicObject("plan").getPkValue());
        returnDataMap.put("planId", planId);
        this.getView().returnDataToParent(returnDataMap);
        this.getView().close();
    }

    private boolean checkData(String opration) {
        boolean tag = true;
        List<DynamicObject> selectedEntry = this.getSelectedEntry();
        if (selectedEntry != null && !selectedEntry.isEmpty()) {
            if (BTN_CONFIRM.equals(opration)) {
                if (selectedEntry.size() > 1) {
                    tag = false;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u65b9\u6848\u4e0d\u53ef\u9009\u4e2d\u591a\u884c\u3002", (String)"BatchExportListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else if (BTN_DELETE.equals(opration) && selectedEntry.isEmpty()) {
                tag = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"BatchExportListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            tag = false;
        }
        return tag;
    }

    private List<DynamicObject> getSelectedEntry() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTITYNAME);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> entryEntitys = new ArrayList<DynamicObject>(16);
        for (int i : selectedRows) {
            entryEntitys.add(this.getModel().getEntryRowEntity(ENTITYNAME, i));
        }
        return entryEntitys;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOp;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "deleteentry".equals(operateKey = (formOp = (FormOperate)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long modelId = LongUtil.toLong(customParams.get("model"));
            if (customParams.get("actionSign") == null || !"intr".equals(customParams.get("actionSign"))) {
                QueryAnalysisPermHelper.checkModelFunctionPermForExport(modelId, this.getView().getFormShowParameter().getAppId(), !Boolean.parseBoolean(customParams.get("isPrint").toString()), "1".equals(customParams.get("exporttype")));
            }
            if (!this.checkData(BTN_DELETE)) {
                return;
            }
            List<DynamicObject> selectedEntry = this.getSelectedEntry();
            ArrayList<String> ids = new ArrayList<String>(16);
            for (DynamicObject obj : selectedEntry) {
                ids.add(String.valueOf(obj.getDynamicObject("plan").getPkValue()));
            }
            String planId = (String)this.getView().getFormShowParameter().getCustomParam("planId");
            if (planId != null && ids.contains(planId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u5f53\u524d\u5df2\u7ecf\u6253\u5f00\u7684\u65b9\u6848\u3002", (String)"BatchExportListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_batchexportplan").getDynamicObjectType(), (Object[])ids.toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", (String)"BatchExportListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            if ("bcm_reportlistmultiexport".equals(parentFormId)) {
                String pageDes = ResManager.loadKDString((String)"\u7f16\u5236\u6279\u91cf\u5bfc\u51fa\u65b9\u6848\u3002\u8bf7\u70b9\u51fb\u201c\u5bfc\u51fa\u201d\u3002", (String)"BatchExportListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.writeOpDelLog(selectedEntry, pageDes);
            } else if ("bcm_reportlistmultiprint".equals(parentFormId)) {
                String pageDes = ResManager.loadKDString((String)"\u7f16\u5236\u6279\u91cf\u6253\u5370\u65b9\u6848\u3002", (String)"BatchExportListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.writeOpDelLog(selectedEntry, pageDes);
            }
        }
    }

    private void writeOpDelLog(List<DynamicObject> selectedEntry, String pageDes) {
        Long modelId = ((DynamicObject)this.getView().getParentView().getModel().getValue("model")).getLong("id");
        for (DynamicObject dy : selectedEntry) {
            String name = dy.getLocaleString("plan.name").getLocaleValue();
            String logs = String.format("%s %s\uff0c%s%s", pageDes, name, OpItemEnum.DELETE.getName(), ResultStatusEnum.SUCCESS.getName());
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.DELETEPLAN.getName(), (String)logs, (Long)modelId);
        }
    }
}

