/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;

public class BatchExportProjectPlugin
extends AbstractBaseFormPlugin {
    public static final String NAME = "name";
    public static final String APPLICATIONSCOPE = "applicationscope";
    public static final String ISDEFAULTPLAN = "isdefaultplan";
    public static final String DESCRIPTION = "description";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("model", customParams.get("model"));
        this.getModel().setValue("user", customParams.get("userId"));
        this.getModel().setValue("exporttype", customParams.get("exporttype"));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        IDataModel model = this.getModel();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String planDeatilId;
        super.beforeDoOperation(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            args.setCancel(true);
            return;
        }
        if (!this.checkData(customParams)) {
            args.setCancel(true);
            return;
        }
        if (customParams.get("actionSign") == null || !"intr".equals(customParams.get("actionSign"))) {
            QueryAnalysisPermHelper.checkModelFunctionPermForExport(this.getModelId(), this.getBizAppId(), !Boolean.parseBoolean(customParams.get("isPrint").toString()), "1".equals(customParams.get("exporttype")));
        }
        if ((planDeatilId = String.valueOf(customParams.get("planDeatilId"))) == null) {
            args.setCancel(true);
            if (this.isAddNew()) {
                if (this.isSave()) {
                    this.writeOpLog(OpItemEnum.PLANSAVE.getName(), ResultStatusEnum.FAIL.getName());
                } else {
                    this.writeOpLog(OpItemEnum.PLANSAVEAS.getName(), ResultStatusEnum.FAIL.getName());
                }
            } else {
                this.writeOpLog(OpItemEnum.PLANEDIT.getName(), ResultStatusEnum.FAIL.getName());
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BatchExportProjectPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)planDeatilId, (String)"bcm_batchexportplandetail");
        if (dynamicObject != null) {
            dynamicObject.set(NAME, this.getModel().getValue(NAME));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        this.getModel().setValue("plan", (Object)planDeatilId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey)) {
            Boolean result = e.getOperationResult().isSuccess();
            if (result.booleanValue()) {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
                returnDataMap.put("planId", pkValue);
                boolean isdefaultplan = (Boolean)this.getModel().getValue(ISDEFAULTPLAN);
                if (isdefaultplan) {
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    QFilter filter = new QFilter("model", "=", customParams.get("model"));
                    filter.and("user", "=", (Object)ConvertUtil.convertObjToLong(customParams.get("userId")));
                    filter.and("exporttype", "=", this.getView().getFormShowParameter().getCustomParams().get("exporttype"));
                    DynamicObject[] allPlan = BusinessDataServiceHelper.load((String)"bcm_batchexportplan", (String)"id,isdefaultplan,exporttype", (QFilter[])new QFilter[]{filter});
                    ArrayList<DynamicObject> updatePlans = new ArrayList<DynamicObject>(16);
                    for (DynamicObject obj : allPlan) {
                        if (!String.valueOf(obj.getPkValue()).equals(String.valueOf(pkValue))) {
                            obj.set(ISDEFAULTPLAN, (Object)false);
                        }
                        updatePlans.add(obj);
                    }
                    if (!updatePlans.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])updatePlans.toArray(new DynamicObject[0]));
                    }
                }
                if (this.isAddNew()) {
                    if (this.isSave()) {
                        this.writeOpLog(OpItemEnum.PLANSAVE.getName(), ResultStatusEnum.SUCCESS.getName());
                    } else {
                        this.writeOpLog(OpItemEnum.PLANSAVEAS.getName(), ResultStatusEnum.SUCCESS.getName());
                    }
                } else {
                    this.writeOpLog(OpItemEnum.PLANEDIT.getName(), ResultStatusEnum.SUCCESS.getName());
                }
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
            } else if (this.isAddNew()) {
                if (this.isSave()) {
                    this.writeOpLog(OpItemEnum.PLANSAVE.getName(), ResultStatusEnum.FAIL.getName());
                } else {
                    this.writeOpLog(OpItemEnum.PLANSAVEAS.getName(), ResultStatusEnum.FAIL.getName());
                }
            } else {
                this.writeOpLog(OpItemEnum.PLANEDIT.getName(), ResultStatusEnum.FAIL.getName());
            }
        }
    }

    private String getPageOpName() {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (this.isAddNew()) {
            if (this.isSave()) {
                if ("bcm_reportlistmultiexport".equals(parentFormId)) {
                    return OpItemEnum.BATCHEXPORT_PLANSAVE.getName();
                }
                if ("bcm_reportlistmultiprint".equals(parentFormId)) {
                    return OpItemEnum.BATCHPRINT_PLANSAVE.getName();
                }
            } else {
                if ("bcm_reportlistmultiexport".equals(parentFormId)) {
                    return OpItemEnum.BATCHEXPORT_PLANSAVEAS.getName();
                }
                if ("bcm_reportlistmultiprint".equals(parentFormId)) {
                    return OpItemEnum.BATCHPRINT_PLANSAVEAS.getName();
                }
            }
        } else {
            if ("bcm_reportlistmultiexport".equals(parentFormId)) {
                return OpItemEnum.BATCHEXPORT_PLANEDIT.getName();
            }
            if ("bcm_reportlistmultiprint".equals(parentFormId)) {
                return OpItemEnum.BATCHPRINT_PLANEDIT.getName();
            }
        }
        return null;
    }

    private void writeOpLog(String opName, String status) {
        String pageOpName = this.getPageOpName();
        if (StringUtils.isEmpty((CharSequence)pageOpName)) {
            return;
        }
        String name = ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue();
        String logs = String.format("%s %s%s", name, opName, status);
        String opNamePy = "";
        try {
            if (pageOpName != null) {
                opNamePy = PinYinUtil.converterToSpell((String)pageOpName);
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge(pageOpName, "AbstractMultiReportPlugin_80", "fi-bcm-formplugin", opNamePy), new OPDescMultiLangEnumBridge("%1$s %2$s%3$s", "BatchExportProjectPlugin_3", "fi-bcm-formplugin", new String[]{name, opName, status}));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private boolean checkData(Map customParams) {
        boolean result = true;
        IDataModel model = this.getModel();
        String value = String.valueOf(model.getValue(NAME));
        if (value == null || "".equals(value.trim())) {
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5fc5\u987b\u586b\u5199\u3002", (String)"BatchExportProjectPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            QFilter filter = new QFilter(NAME, "=", (Object)value);
            filter.and("model", "=", customParams.get("model"));
            if ("1".equals(this.getModel().getValue(APPLICATIONSCOPE))) {
                filter.and("user", "=", (Object)ConvertUtil.convertObjToLong(customParams.get("userId")));
            } else {
                filter.and(APPLICATIONSCOPE, "=", (Object)"2");
            }
            if (OperationStatus.EDIT == status) {
                filter.and("id", "!=", this.getModel().getDataEntity().getPkValue());
            }
            filter.and("exporttype", "=", this.getView().getFormShowParameter().getCustomParams().get("exporttype"));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_batchexportplan", (String)"id", (QFilter[])new QFilter[]{filter});
            if (query != null && !query.isEmpty()) {
                result = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\u3002", (String)"BatchExportProjectPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private boolean isSave() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get("isSave") != null && "1".equals(map.get("isSave").toString());
    }

    private boolean isAddNew() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get("status") != null && "ADDNEW".equals(map.get("status").toString());
    }
}

