/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckReportListHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.report.AttachmentTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.MultiTabReportProcessPlugin;
import kd.fi.bcm.formplugin.report.style.CellControlerByAttachment;
import kd.fi.bcm.formplugin.report.workBench.util.AttachmentUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.util.TemplateExtDataAreaUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.collections.CollectionUtils;

public class CHKMultiTabReportProcessPlugin
extends MultiTabReportProcessPlugin
implements UploadListener,
AttachmentMarkListener {
    private static final String ANNOTATE_TAB = "annotatetab";
    private static final String TABSELECT = "tabselect";
    private static final String NUMTOMEMS = "numtomems";
    private static final String SELECTCELL = "selectCell";
    private static final String DIMENSION = "dimension";
    private static final String DESCRIPTION = "description";
    private static final String MODEL = "model";
    private static final String NUMBER = "number";
    protected static final String DIMENSION_STR = "dimensionstr";
    private static final String ANNOTATION = "annotation";
    private static final String CHECK_REPORT = "checkkreport";
    private static final String IS_SELECT_ENTITY_TAB = "isselectentitytab";
    private static final String ATTACHMENT_PANELAP = "attachmentpanelap";
    private List<Map<String, Object>> urls;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab reporttab = (Tab)this.getControl(ANNOTATE_TAB);
        reporttab.addTabSelectListener(this::annotateTabSelected);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANELAP);
        panel.addUploadListener((UploadListener)this);
        panel.addMarkListener((AttachmentMarkListener)this);
        if (ANNOTATION.equals(reporttab.getCurrentTab())) {
            this.setAnnotationListen();
        }
        if (CHECK_REPORT.equals(reporttab.getCurrentTab())) {
            this.setCheckReportListen();
        }
    }

    public void selectCurAnnotateTabAgain() {
        Tab tab = (Tab)this.getControl(ANNOTATE_TAB);
        String tabselect = DESCRIPTION;
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(TABSELECT))) {
            tabselect = this.getPageCache().get(TABSELECT);
        }
        TabSelectEvent evt = new TabSelectEvent((Object)tab, tabselect);
        this.annotateTabSelected(evt);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setReportViewVisible(false, ANNOTATION);
    }

    @Override
    protected void afterLoadReport() {
        String processNum;
        Map<String, Pair<Long, String>> pageViewMemMap;
        super.afterLoadReport();
        if (this.hasNumtoMems()) {
            this.fixCellPosition();
        }
        if (this.getFormCustomParam(SELECTCELL) != null) {
            String cell = (String)this.getFormCustomParam(SELECTCELL);
            Point point = ExcelUtils.pos2Point((String)cell);
            this.selectCell(point.y, point.x);
        }
        if ((pageViewMemMap = this.getPageViewMember()).containsKey(DimTypesEnum.PROCESS.getNumber()) && "CSTE".equals(processNum = (String)pageViewMemMap.get((Object)DimTypesEnum.PROCESS.getNumber()).p2)) {
            this.setReportViewVisible(false, "btn_convert");
        }
        String type = "2";
        if (this.getPageCache().get("attachmenttype") != null) {
            type = this.getPageCache().get("attachmenttype");
        }
        this.getModel().setValue("attachmenttype", (Object)type);
        this.getView().updateView("attachmenttype");
    }

    private boolean isHySelect() {
        return this.getPageCache().get("isHySelect") != null;
    }

    private void setHySelect(boolean flag) {
        if (flag) {
            this.getPageCache().put("isHySelect", "1");
        } else {
            this.getPageCache().remove("isHySelect");
        }
    }

    @Override
    public void fixCellPosition() {
        Map<String, String> map = this.getNumToMems();
        if (this.getFormCustomParam(NUMTOMEMS) != null) {
            this.getView().getFormShowParameter().getCustomParams().put(NUMTOMEMS, null);
            this.getView().cacheFormShowParameter();
        }
        this.changeBp(map);
        SpreadManager spreadModel = this.getSpreadModel();
        String extModelNumber = map.get("extendsmodel");
        String extFieldNumber = map.get("extendsfield");
        this.getEffectiveSheet().iteratorCellsByPredicateBreak(c -> {
            if (c.isMdDataDomain() && StringUtils.isEmpty((String)extFieldNumber)) {
                boolean flag = true;
                for (IDimMember dimMember : c.getMemberFromUserObject()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (((String)entry.getKey()).equals(dimMember.getDimension().getNumber()) && !((String)entry.getValue()).equals(dimMember.getNumber())) {
                            flag = false;
                            continue;
                        }
                        if (flag) continue;
                    }
                }
                if (flag) {
                    this.handleCell((Cell)c);
                    return true;
                }
                return false;
            }
            PositionInfo position = spreadModel.getInAreaPositionByRow(c.getRow(), c.getCol());
            if (position != null && position.getExtendInfo() != null && position.getExtendInfo().getExtModelNumber().equals(extModelNumber) && spreadModel.getExtHeadCol2(c.getRow(), c.getCol()).equals(extFieldNumber)) {
                this.handleCell((Cell)c);
                return true;
            }
            return false;
        });
    }

    private void handleCell(Cell c) {
        this.recordChkReportSelectCell(c);
        this.selectCell(c.getRow(), c.getCol());
        this.setCellTag(c);
    }

    private void setCellTag(Cell c) {
        List<Map<String, Object>> markRedPoints = Collections.singletonList(TemplateExtDataAreaUtil.packedCellMap4AllPoint(c.getRow(), c.getCol(), true));
        SpreadClientInvoker.invokeMethod((IClientViewProxy)this.getView().getService(IClientViewProxy.class), "setCellTag", "report", markRedPoints);
        this.getPageCache().put("chkMarkCell", c.getRow() + "@" + c.getCol());
    }

    private void recordChkReportSelectCell(Cell c) {
        try {
            this.getCurrentReportTabInfo().setSelectCell(c.getRow(), c.getCol());
            this.cacherReportTabManager();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    protected void selectCell(int row, int col) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SpreadProperties.FieldInsertMethod.R.k(), row);
        params.put(SpreadProperties.FieldInsertMethod.C.k(), col);
        params.put(SpreadProperties.FieldInsertMethod.RC.k(), 1);
        params.put(SpreadProperties.FieldInsertMethod.CC.k(), 1);
        params.put(SpreadProperties.SetSelectionsMethod.AUTOFOCUS.k(), true);
        HashMap<String, String> pos = new HashMap<String, String>();
        pos.put("row", "center");
        pos.put("col", "center");
        params.put("position", pos);
        SpreadClientInvoker.invokeSetSelectionsMethod(this.getClientViewProxy(), "report", params);
        SpreadSelector selector = new SpreadSelector(row, col, row, col);
        String sj = ObjectSerialUtil.toByteSerialized((Object)selector);
        if (ThreadCache.exists((Object)"reloadReportSchema")) {
            this.getPageCache().put("spread_selector_init", sj);
        }
        this.getPageCache().put("spread_selector", sj);
    }

    @Override
    protected void afterInitPage() {
        super.afterInitPage();
    }

    @Override
    protected void afterInitShortCut() {
        super.afterInitShortCut();
        if (this.isHySelect() || this.hasNumtoMems()) {
            DynamicObject processDy = this.getHyMemb(DimTypesEnum.PROCESS.getNumber(), "bcm_processmembertree");
            if (processDy == null) {
                return;
            }
            boolean hasManualSetting = this.getReportTabInfoManager().getCurrSelectReportTabInfo().containsFilterKey(PresetConstant.PROCESS_DIM);
            if (hasManualSetting && !this.isCsl()) {
                return;
            }
            boolean isExistAssignDim = this.getSpreadModel().getFilter().getPageDomain().getDimensions().stream().anyMatch(d -> d.getNumber().equals(PresetConstant.PROCESS_DIM));
            if (!isExistAssignDim) {
                return;
            }
            IDimension dim = ObjectConvertUtils.toIDimension(processDy.getDynamicObject(DIMENSION));
            IDimMember m = ObjectConvertUtils.toDimMember(processDy, dim);
            dim.addMember(m);
            this.getSpreadModel().getFilter().changePageDim(dim);
            this.getModel().getDataEntity().set("bcm_processmembertree", (Object)processDy);
            this.rememberPageViewDimFilter("bcm_processmembertree", this.convertDyna2Map(processDy));
            this.setHyCYDynamicObject();
            this.setHyATDynamicObject();
            this.setHySelect(false);
        }
    }

    public void selectCell() {
        if (this.getCurrentReportTabInfo().getSelRow() != -1 && this.getCurrentReportTabInfo().getSelCol() != -1) {
            this.selectCell(this.getCurrentReportTabInfo().getSelRow(), this.getCurrentReportTabInfo().getSelCol());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_batchnote".equals(evt.getItemKey())) {
            this.batchNote();
        }
    }

    protected void batchNote() {
        IFormView chkReportView = this.getView().getView(this.buildChkreportListPageId());
        if (chkReportView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CHKMultiTabReportProcessPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)chkReportView.getControl("billlistap");
        if (billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"CHKMultiTabReportProcessPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ChkCheckReportListHelper.openBatchNoteView((IFormPlugin)this, (IFormView)this.getView(), (Object[])billList.getSelectedRows().getPrimaryKeyValues());
    }

    private void setHyCYDynamicObject() {
        DynamicObject cyDy = this.getHyMemb(DimTypesEnum.CURRENCY.getNumber(), "bcm_currencymembertree");
        if (cyDy == null) {
            return;
        }
        IDimension dim = ObjectConvertUtils.toIDimension(cyDy.getDynamicObject(DIMENSION));
        boolean hasCYSetting = this.getReportTabInfoManager().getCurrSelectReportTabInfo().containsFilterKey(DimTypesEnum.CURRENCY.getNumber());
        if (hasCYSetting) {
            return;
        }
        boolean isExistCYAssignDim = this.getSpreadModel().getFilter().getPageDomain().getDimensions().stream().anyMatch(d -> d.getNumber().equals(DimTypesEnum.CURRENCY.getNumber()));
        if (!isExistCYAssignDim) {
            return;
        }
        IDimMember cyM = ObjectConvertUtils.toDimMember(cyDy, dim);
        dim.addMember(cyM);
        this.getSpreadModel().getFilter().changePageDim(dim);
        this.getModel().getDataEntity().set("bcm_currencymembertree", (Object)cyDy);
        this.rememberPageViewDimFilter("bcm_currencymembertree", this.convertDyna2Map(cyDy));
    }

    private void setHyATDynamicObject() {
        DynamicObject atDy = this.getHyMemb(DimTypesEnum.AUDITTRIAL.getNumber(), "bcm_audittrialmembertree");
        if (atDy == null) {
            return;
        }
        IDimension dim = ObjectConvertUtils.toIDimension(atDy.getDynamicObject(DIMENSION));
        boolean hasATSetting = this.getReportTabInfoManager().getCurrSelectReportTabInfo().containsFilterKey(DimTypesEnum.AUDITTRIAL.getNumber());
        if (hasATSetting) {
            return;
        }
        boolean isExistATAssignDim = this.getSpreadModel().getFilter().getPageDomain().getDimensions().stream().anyMatch(d -> d.getNumber().equals(DimTypesEnum.AUDITTRIAL.getNumber()));
        if (!isExistATAssignDim) {
            return;
        }
        IDimMember atM = ObjectConvertUtils.toDimMember(atDy, dim);
        dim.addMember(atM);
        this.getSpreadModel().getFilter().changePageDim(dim);
        this.getModel().getDataEntity().set("bcm_audittrialmembertree", (Object)atDy);
        this.rememberPageViewDimFilter("bcm_audittrialmembertree", this.convertDyna2Map(atDy));
    }

    private DynamicObject getHyMemb(String dimNum, String entity) {
        Map map = this.getFormCustomParam(NUMTOMEMS) == null ? (Map)ThreadCache.get((Object)NUMTOMEMS) : (Map)this.getFormCustomParam(NUMTOMEMS);
        if (map != null && map.get(dimNum) != null) {
            this.changeBp(map);
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)this.getModelId());
            qf.add(NUMBER, "=", map.get(dimNum));
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])qf.toArray());
            return dyna;
        }
        return null;
    }

    private void changeBp(Map<String, String> map) {
        String s = map.get(DimTypesEnum.PROCESS.getNumber());
        if (s != null && s.equals("CS")) {
            map.put(DimTypesEnum.PROCESS.getNumber(), "Rpt");
        }
    }

    public void remove(UploadEvent evt) {
        if (ReportStatusEnum.COMMIT.status().equals(this.getCurrentReportStatus())) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u4e0a\u62a5\uff0c\u4e0d\u53ef\u4fee\u6539\u6570\u636e\u3002", (String)"CHKMultiTabReportProcessPlugin_011", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ReportStatusEnum.COMPLETE.status().equals(this.getCurrentReportStatus())) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u7f16\u5236\u5b8c\u6210\u3002\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CHKMultiTabReportProcessPlugin_013", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void setCheckReportListen() {
    }

    private void setAnnotationListen() {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bcm_chknoteedit": {
                this.checkReportTab();
                break;
            }
            case "btn_batchnote": {
                if (evt.getReturnData() == null) break;
                String note = (String)this.deSerializedBytes(evt.getReturnData().toString());
                Object[] ids = (Object[])this.deSerializedBytes(this.getPageCache().get("batchNoteIds"));
                ChkCheckReportListHelper.batchNoteReports((IFormView)this.getView(), (Object[])ids, (String)note, (long)this.getModelId(), (long)this.getCslschemeId());
                this.checkReportTab();
                break;
            }
            case "chkTask": {
                this.selectCurAnnotateTabAgain();
                break;
            }
        }
    }

    private void annotateTabSelected(TabSelectEvent e) {
        if (this.noEntity()) {
            return;
        }
        String tabKey = e.getTabKey();
        this.getPageCache().put(TABSELECT, tabKey);
        switch (tabKey) {
            case "description": {
                this.editDescriptionAction();
                break;
            }
            case "checkkreport": {
                this.checkReportTab();
                break;
            }
            case "annotation": {
                this.setAnnotationListen();
                this.showNotePanel();
                break;
            }
            case "attachment": {
                this.showAttachmentPanel();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propname = e.getProperty().getName();
        if ("bcm_scenemembertree".equals(propname) || "bcm_fymembertree".equals(propname) || "bcm_periodmembertree".equals(propname)) {
            String tabKey = ((Tab)this.getControl(ANNOTATE_TAB)).getCurrentTab();
            Tab t = (Tab)this.getControl(ANNOTATE_TAB);
            if (t != null) {
                t.activeTab(tabKey);
                t.selectTab(tabKey);
            }
        }
        if ("bcm_processmembertree".equals(propname) || "bcm_audittrialmembertree".equals(propname) || "bcm_currencymembertree".equals(propname)) {
            this.checkReportTab();
        } else if ("attachmenttype".equals(propname)) {
            String type = (String)this.getModel().getValue("attachmenttype");
            this.getPageCache().put("attachmenttype", type);
            this.showAttachmentPanel();
        }
    }

    private void checkReportTab() {
        String pageId;
        FormShowParameter para = new FormShowParameter();
        long cslschemeId = this.getCslschemeId();
        IFormView view = this.getView();
        if (view.getView(pageId = this.buildChkreportListPageId()) == null) {
            para.setFormId("bcm_checkreport");
            para.getOpenStyle().setTargetKey(CHECK_REPORT);
            para.getOpenStyle().setShowType(ShowType.InContainer);
            para.setCustomParam("commonFilter", (Object)this.getCommonFilter().recombine());
            para.setCustomParam("tempNumber", (Object)this.getTemplateModel().getNumber());
            para.setCustomParam("modelid", (Object)this.getModelId());
            para.setCustomParam(IS_SELECT_ENTITY_TAB, this.getView().getFormShowParameter().getCustomParam(IS_SELECT_ENTITY_TAB));
            Map<DimTypesEnum, Object> idMap = this.getCurrentReportCommonParam("id");
            Map<DimTypesEnum, Object> numberMap = this.getCurrentReportCommonParam(NUMBER);
            para.setCustomParam("report_period_id", idMap.get(DimTypesEnum.PERIOD));
            para.setCustomParam("report_period_number", numberMap.get(DimTypesEnum.PERIOD));
            para.setCustomParam("report_year_id", idMap.get(DimTypesEnum.YEAR));
            para.setCustomParam("report_year_number", numberMap.get(DimTypesEnum.YEAR));
            para.setCustomParam("report_entity", numberMap.get(DimTypesEnum.ENTITY));
            para.setCustomParam("cslscheme", (Object)cslschemeId);
            para.setCustomParam("currrentreport", (Object)((Tab)this.getControl("reporttab")).getCurrentTab());
            para.setParentPageId(view.getPageId());
            para.setPageId(this.buildChkreportListPageId());
            this.getView().showForm(para);
        } else {
            IFormView chkReportView = view.getView(pageId);
            chkReportView.getFormShowParameter().setCustomParam("commonFilter", (Object)this.getCommonFilter().recombine());
            BillList billlistap = (BillList)chkReportView.getControl("billlistap");
            billlistap.getFilterParameter().setFilter(this.getFilter().and(new QFilter("cslscheme", "in", Arrays.asList(cslschemeId, 0L))));
            billlistap.refresh();
            chkReportView.activate();
            view.sendFormAction(chkReportView);
        }
    }

    protected long getCslschemeId() {
        if (this.getApplicationType() == ApplicationTypeEnum.RPT) {
            return CslSchemeServiceHelper.getRptDefaultSchemeId((long)this.getModelId());
        }
        return LongUtil.toLong((Object)this.getFormCustomParam("cslscheme"));
    }

    protected String buildChkreportListPageId() {
        Map<DimTypesEnum, Object> currentReportCommonParam = this.getCurrentReportCommonParam(NUMBER);
        return "bcm_checkreport" + currentReportCommonParam.get(DimTypesEnum.ENTITY) + currentReportCommonParam.get(DimTypesEnum.YEAR) + currentReportCommonParam.get(DimTypesEnum.PERIOD) + this.getTemplateId() + this.getView().getPageId();
    }

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        super.reportTabSelected(evt);
        this.cacheSpreadModel();
        String tabselect = DESCRIPTION;
        Tab reporttab = (Tab)this.getControl(ANNOTATE_TAB);
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(TABSELECT))) {
            tabselect = this.getPageCache().get(TABSELECT);
        }
        reporttab.selectTab(tabselect);
        reporttab.activeTab(tabselect);
        reporttab.click();
        this.invokeCallBack(SELECTCELL);
    }

    private QFilter getFilter() {
        return this.getCommonFilter().and(this.getIdsFilter());
    }

    private QFilter getCommonFilter() {
        boolean auditPermValid;
        long currUserId = Long.parseLong(RequestContext.get().getUserId());
        boolean checkMGStatus = (Boolean)ThreadCache.get((Object)("checkMGStatus_" + currUserId + this.getModelId()), () -> BcmFunPermissionHelper.needCheckMGStatus((long)currUserId, (long)this.getModelId()));
        if (checkMGStatus && (auditPermValid = ((Boolean)ThreadCache.get((Object)("checkMGStatus_noperm_" + currUserId + this.getModelId()), () -> {
            AbstractMultiReportPlugin.OrgFlowArchiveStatus orgCommit2Archive = this.checkECSubmitStatus();
            return !orgCommit2Archive.isFlowArchive && !orgCommit2Archive.isFlowCommit;
        })).booleanValue())) {
            return new QFilter("1", "=", (Object)0);
        }
        Map<DimTypesEnum, Object> commonParams = this.getCurrentReportCommonParam("id");
        Object scenarioid = commonParams.get(DimTypesEnum.SCENARIO);
        Object yearid = commonParams.get(DimTypesEnum.YEAR);
        Object periodid = commonParams.get(DimTypesEnum.PERIOD);
        Object currencyid = commonParams.get(DimTypesEnum.CURRENCY);
        Map<DimTypesEnum, Object> commonNumber = this.getCurrentReportCommonParam(NUMBER);
        String cyNum = commonNumber.get(DimTypesEnum.CURRENCY).toString();
        String process = SpreadMemUtil.getMemFromFilter((SpreadManager)this.getSpreadModel(), (String)DimTypesEnum.PROCESS.getNumber());
        List<Long> processIds = this.getProcessIds(process);
        Map<DimTypesEnum, Object> ids = this.getCurrentReportCommonParam("id");
        Object orgId = ids.get(DimTypesEnum.ENTITY);
        if (CurrencyEnum.EC.getNumber().equals(cyNum) || CurrencyEnum.DC.getNumber().equals(cyNum)) {
            if (!this.getTemplateModel().isSaveByDim()) {
                cyNum = CurrencyEnum.EC.getNumber();
            }
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId(), (long)((Long)orgId), (String)process, (String)cyNum, (long)0L, (long)0L);
            QFilter numberFilter = new QFilter(NUMBER, "=", pair.p2);
            QFilter modelFilter = new QFilter("model.id", "=", (Object)this.getModelId());
            DynamicObject currencyDynaObj = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
            currencyid = currencyDynaObj.getLong("id");
        }
        QFilter modelqf = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection orgDoc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,parent.id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", commonNumber.get(DimTypesEnum.ENTITY)), modelqf});
        Map<Object, DynamicObject> orgs = orgDoc.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        QFilter qFilter = new QFilter("org", "in", (Object)orgs.keySet().toArray());
        qFilter.and("orgparent", "in", Arrays.asList(orgs.get(orgId).getLong("parent.id"), 0L));
        qFilter.and("scenario", "=", scenarioid);
        qFilter.and("year", "=", yearid);
        qFilter.and("period", "=", periodid);
        qFilter.and("currency", "=", currencyid);
        if (CollectionUtils.isNotEmpty(processIds)) {
            qFilter.and("process", "in", processIds);
        }
        return qFilter;
    }

    private QFilter getIdsFilter() {
        QFilter qFilter = new QFilter("chkformula", "!=", (Object)0);
        List settingIds = ChkCheckServiceHelper.getFormulaSettingIdsByNum((Collection)Lists.newArrayList((Object[])new String[]{this.getTemplateModel().getNumber()}), (long)this.getModelId());
        qFilter.and("chkformula", "in", (Object)settingIds);
        return qFilter;
    }

    private List<Long> getProcessIds(String process) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (ParamConstant.ERptProcess.contains(process)) {
            ParamConstant.ERptProcess.forEach(p -> list.add(MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)p).getId()));
        } else if (ParamConstant.RptProcess.contains(process)) {
            ParamConstant.RptProcess.forEach(p -> list.add(MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)p).getId()));
        } else {
            list.add(MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)process).getId());
        }
        list.removeIf(id -> id < 0L);
        return list;
    }

    private void editDescriptionAction() {
        long tempId = this.getTemplateId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)tempId);
        DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)DESCRIPTION, (QFilter[])qfBuilder.toArray());
        RichTextEditor rap = (RichTextEditor)this.getControl("editdescription");
        rap.setText(temp.getString(DESCRIPTION));
    }

    @Override
    protected void chkNote(NotifyEvent e) {
        super.chkNote(e);
        Tab reporttab = (Tab)this.getControl(ANNOTATE_TAB);
        if (ANNOTATION.equals(reporttab.getCurrentTab())) {
            this.showNotePanel();
        }
        if ("attachment".equals(reporttab.getCurrentTab())) {
            this.showAttachmentPanel();
        }
    }

    private void showNotePanel() {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_notelist");
        para.getOpenStyle().setTargetKey(ANNOTATION);
        para.getOpenStyle().setShowType(ShowType.InContainer);
        para.setCustomParam("qfilter", (Object)this.getNoteFilter().recombine());
        this.getView().showForm(para);
    }

    private QFilter getNoteFilter() {
        DimensionCombination dc = this.pakageDimensionCombination();
        if (dc == null) {
            return new QFilter("1", "like", (Object)"-1");
        }
        QFilter filter = new QFilter(MODEL, "like", (Object)this.getModelId());
        QFilter dimStrFilter = new QFilter(DIMENSION_STR, "like", (Object)dc.getDimensionCombineStr());
        QFilter qFilter = filter.and(dimStrFilter);
        return qFilter;
    }

    public void upload(UploadEvent evt) {
        if (ReportStatusEnum.COMMIT.status().equals(this.getCurrentReportStatus())) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u4e0a\u62a5\uff0c\u4e0d\u53ef\u4fee\u6539\u6570\u636e\u3002", (String)"CHKMultiTabReportProcessPlugin_011", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ReportStatusEnum.COMPLETE.status().equals(this.getCurrentReportStatus())) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u7f16\u5236\u5b8c\u6210\u3002\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CHKMultiTabReportProcessPlugin_013", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((this.isOnlyReadTemplate() || this.isUsageQueryTemplate()) && !this.isEPM()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4e3a\u53ea\u8bfb\u6216\u67e5\u8be2\u7528\u9014\u7684\u62a5\u8868\uff0c\u4e0d\u53ef\u4fee\u6539\u5f53\u524d\u62a5\u8868\u4efb\u4f55\u5355\u5143\u683c\u7684\u5185\u5bb9\u3002", (String)"AbstractMultiReportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String type = (String)this.getModel().getValue("attachmenttype");
        DimensionCombination dimCombination = this.pakageDimensionCombination();
        if (dimCombination == null && "1".equals(type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)this.getModelId());
        QFilter type1Filter = new QFilter(DIMENSION_STR, "in", this.getReportCellsCombineStr());
        QFilter type2Filter = AttachmentUtil.getAttachmentReportFilter(this.getRecordFilter(), this.getTemplateId(), false);
        type1Filter.or(type2Filter);
        qfBuilder.add(type1Filter);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chknoteinfo", (String)"id", (QFilter[])qfBuilder.toArray());
        Set ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bcm_chkattachment", (String)"name", (QFilter[])new QFilter[]{new QFilter("noteinfo", "in", ids)});
        Set names = attachments.stream().map(a -> a.getString("name")).collect(Collectors.toSet());
        for (Object url : evt.getUrls()) {
            LinkedHashMap urlMap = (LinkedHashMap)url;
            String tempName = urlMap.get("name").toString();
            if (!names.contains(tempName)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u79f0\u91cd\u590d\u3002", (String)"CHKMultiTabReportProcessPlugin_012", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.urls = new ArrayList<Map<String, Object>>(10);
        for (Object o : evt.getUrls()) {
            this.urls.add((Map)o);
        }
        try {
            this.getPageCache().put("urls", JSONUtils.toString(this.urls));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        boolean isSuecess = this.saveAttachment();
        if (isSuecess) {
            String type = (String)this.getModel().getValue("attachmenttype");
            if ("1".equals(type)) {
                ArrayList<Map<String, Object>> rangedetails = new ArrayList<Map<String, Object>>(16);
                HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(16);
                rangedetail.put("r", this.getSpreadSelector().getStartRow());
                rangedetail.put("c", this.getSpreadSelector().getStartCol());
                rangedetail.put("rc", 1);
                rangedetail.put("cc", 1);
                rangedetails.add(rangedetail);
                this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol()).setUserObject("setCornerMark", (Object)true);
                this.cacheSpreadModel();
                CellControlerByAttachment.setAttachmentMark(this.getClientViewProxy(), rangedetails, "A", true);
            }
        } else {
            evt.setCancel(true);
        }
    }

    public void afterRemove(UploadEvent evt) {
        HashSet uids = new HashSet(16);
        for (Object o : evt.getUrls()) {
            uids.add(((Map)o).get("uid"));
        }
        QFilter filter = new QFilter("uid", "in", uids);
        DeleteServiceHelper.delete((String)"bcm_chkattachment", (QFilter[])new QFilter[]{filter});
        String type = (String)this.getModel().getValue("attachmenttype");
        DimensionCombination dimCombination = this.pakageDimensionCombination();
        boolean isReport = AttachmentTypeEnum.REPORT.getNumber().equals(type);
        if (!isReport && dimCombination == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject noteInfo = AttachmentUtil.getCHKNoteInfo(this.getModelId(), this.getTemplateId(), this.getRecordFilter(), dimCombination, isReport);
        for (String uid : uids) {
            AttachmentServiceHelper.remove((String)"bcm_chknoteinfo", (Object)noteInfo.getLong("id"), (Object)uid);
        }
        DynamicObject[] dys = this.getAttachmentDys();
        if ((dys == null || dys.length == 0) && "1".equals(type)) {
            ArrayList<Map<String, Object>> rangedetails = new ArrayList<Map<String, Object>>(16);
            HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(16);
            rangedetail.put("r", this.getSpreadSelector().getStartRow());
            rangedetail.put("c", this.getSpreadSelector().getStartCol());
            rangedetail.put("rc", 1);
            rangedetail.put("cc", 1);
            rangedetails.add(rangedetail);
            CellControlerByAttachment.setAttachmentMark(this.getClientViewProxy(), rangedetails, "", false);
            this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol()).removeUserObject("setCornerMark");
            this.cacheSpreadModel();
        }
    }

    protected void showAttachmentPanel() {
        DynamicObject[] dys;
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANELAP);
        String type = (String)this.getModel().getValue("attachmenttype");
        if ("1".equals(type)) {
            attachmentPanel.bindData(new ArrayList(16));
        }
        if ((dys = this.getAttachmentDys()) == null) {
            return;
        }
        HashSet<Long> notefoIds = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            notefoIds.add(dy.getLong("noteinfo.id"));
        }
        ArrayList attachs = new ArrayList(16);
        for (Long notefoId : notefoIds) {
            attachs.addAll(AttachmentServiceHelper.getAttachments((String)"bcm_chknoteinfo", (Object)notefoId, (String)ATTACHMENT_PANELAP));
        }
        attachmentPanel.bindData(attachs);
    }

    private DynamicObject[] getAttachmentDys() {
        String type = (String)this.getModel().getValue("attachmenttype");
        DimensionCombination dc = this.pakageDimensionCombination();
        boolean isCellAtt = AttachmentTypeEnum.CELL.getNumber().equals(type);
        if (isCellAtt && dc == null) {
            return null;
        }
        QFilter filter = new QFilter("noteinfo.model", "=", (Object)this.getModelId());
        QFilter dimStrFilter = new QFilter("noteinfo.dimensionstr", "=", (Object)(dc != null ? dc.getDimensionCombineStr() : ""));
        QFilter reportFilter = AttachmentUtil.getAttachmentReportFilter(this.getRecordFilter(), this.getTemplateId(), true);
        QFilter[] filters = new QFilter[]{filter, isCellAtt ? dimStrFilter : reportFilter};
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_chkattachment", (String)this.getSelectedProperties(), (QFilter[])filters);
        return dys;
    }

    public void mark(AttachmentMarkEvent evt) {
        QFilter filter = new QFilter("FNUMBER", "=", (Object)evt.getUid());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"FATTACHMENTDES,fdescription", (QFilter[])new QFilter[]{filter});
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        dy.set("fdescription", (Object)evt.getDescription());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
    }

    private boolean saveAttachment() {
        String type = (String)this.getModel().getValue("attachmenttype");
        DimensionCombination dimCombination = this.pakageDimensionCombination();
        boolean isReport = AttachmentTypeEnum.REPORT.getNumber().equals(type);
        if (dimCombination == null && !isReport) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getPageCache().get("urls") == null) {
            return false;
        }
        try {
            this.urls = (List)JSONUtils.cast((String)this.getPageCache().get("urls"), List.class);
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
        }
        AttachmentUtil.saveAttachmentDataForReport(this.urls, AttachmentUtil.getCHKNoteInfo(this.getModelId(), this.getTemplateId(), this.getRecordFilter(), dimCombination, isReport));
        return true;
    }

    private String getSelectedProperties() {
        return "url,name,size,uid,type,description,modifier,modifydate,noteinfo";
    }

    protected Map<String, Long> getRecordFilter() {
        Map<String, Long> filterMap = this.commonFilterMap();
        filterMap.entrySet().forEach(e -> {
            if ("bcm_entitymembertree".equals(e.getKey())) {
                filterMap.put((String)e.getKey(), this.getEntityBaseMemberId(this.getFilterVal((String)e.getKey(), filterMap)));
            } else {
                filterMap.put((String)e.getKey(), (Long)this.getFilterVal((String)e.getKey(), filterMap));
            }
        });
        return filterMap;
    }

    @Override
    protected void beforeDelReport(DynamicObject report) {
        super.beforeDelReport(report);
        Map<DimTypesEnum, Object> nummap = this.getCurrentReportCommonParam(NUMBER);
        Map<DimTypesEnum, Object> idmap = this.getCurrentReportCommonParam("id");
        CalContext ctx = new CalContext(this.getModelNumber(), Long.valueOf(this.getModelId()), (Long)idmap.get(DimTypesEnum.YEAR), (Long)idmap.get(DimTypesEnum.PERIOD), (Long)idmap.get(DimTypesEnum.SCENARIO));
        HashMap<Object, List<String>> org2TempNums = new HashMap<Object, List<String>>();
        org2TempNums.put(this.getRealOrgInfo().p2, Collections.singletonList(this.getTemplateModel().getNumber()));
        ctx.setProperty("org2TempNums", org2TempNums);
        ctx.setProperty("currency", nummap.get(DimTypesEnum.CURRENCY));
        ctx.setProperty("year", nummap.get(DimTypesEnum.YEAR));
        ctx.setProperty("period", nummap.get(DimTypesEnum.PERIOD));
        ChkCheckStatusHelper.resetCheckStatus((ICalContext)ctx);
    }

    public DimensionCombination pakageDimensionCombination() {
        try {
            this.getSpreadSelector();
        }
        catch (KDBizException e) {
            return null;
        }
        Cell cell = this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
        if (!cell.isMdDataDomain()) {
            return null;
        }
        DimensionCombination dimCombination = new DimensionCombination(this.getModelId());
        Map dimMemberMap = SpreadMemberUtil.getCellDimMemberMap((SpreadManager)this.getSpreadModel(), this.getCurrentReportCommonParam(NUMBER, true), (Cell)cell, (long)this.getModelId(), (boolean)false);
        SpreadMemberUtil.dealCellOrgDimMemMap((Map)dimMemberMap);
        dimCombination.putAll(dimMemberMap);
        return dimCombination;
    }

    public List<String> getReportCellsCombineStr() {
        ArrayList<String> dimsStr = new ArrayList<String>(16);
        SpreadManager sm = this.getSpreadModel();
        Map<DimTypesEnum, Object> commonParam = this.getCurrentReportCommonParam(NUMBER, true);
        long modelId = this.getModelId();
        HashMap pageMemberMap = new HashMap(16);
        String orgNum = SpreadMemberUtil.fillPageDimMembers((long)modelId, (SpreadManager)sm, pageMemberMap);
        this.getEffectiveSheet().iteratorCells(cell -> {
            if (cell.isMdDataDomain()) {
                DimensionCombination dimCombination = new DimensionCombination(modelId);
                Map dimMemberMap = SpreadMemberUtil.getCellDimMemberMap((Map)pageMemberMap, (String)orgNum, (Map)commonParam, (Cell)cell, (long)modelId, (boolean)false);
                SpreadMemberUtil.dealCellOrgDimMemMap((Map)dimMemberMap);
                dimCombination.putAll(dimMemberMap);
                dimsStr.add(dimCombination.getDimensionCombineStr());
            }
        });
        return dimsStr;
    }
}

