/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.enumvalue.EnumAndMembModel;
import kd.fi.bcm.business.dimension.enumvalue.EnumItemServiceHelper;
import kd.fi.bcm.business.dimension.enumvalue.Enumvalue;
import kd.fi.bcm.business.dimension.enumvalue.MemberEnum;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CellEventService {
    private static final String MEMENUM = "memenum";

    public static Map<String, Object> setEnumValues(Long modelId, SpreadManager sm, IPageCache pageCache, LookUpDataArgs args) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        Cell cell = sm.getBook().getSheet(0).getCell(args.getR(), args.getC());
        if (CellEventService.isInExtAreaRecord(sm, Collections.singletonList(cell.getRow()))) {
            return CellEventService.setEnumForExtCell(modelId, sm, args);
        }
        HashMap cachemap = CellDataTypeUtil.getDataTypeCache((IPageCache)pageCache);
        EnumAndMembModel enumAndMembModel = CellDataTypeUtil.getCellDataType4EnumStyle((long)modelId, (Cell)cell, (IPageCache)pageCache, (SpreadManager)sm, (HashMap)cachemap);
        CellDataTypeUtil.cacheDataTypeInfo((IPageCache)pageCache, (HashMap)cachemap);
        if (DataTypeEnum.ENUMTP.index == enumAndMembModel.getDataTypeEnum().index) {
            Map map;
            if (pageCache.get(MEMENUM) != null) {
                map = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(MEMENUM));
            } else {
                map = EnumItemServiceHelper.getAllEnumDimensionMember((long)modelId);
                pageCache.put(MEMENUM, ObjectSerialUtil.toByteSerialized((Object)map));
            }
            String key = enumAndMembModel.getDimNum() + "|" + enumAndMembModel.getMemNum();
            MemberEnum memberEnum = (MemberEnum)map.get(key);
            if (memberEnum != null) {
                boolean isNummic = memberEnum.getDataType() == DataTypeEnum.DEFAULT || memberEnum.getDataType() == DataTypeEnum.CURRENCY;
                ArrayList arrs = new ArrayList(10);
                for (Enumvalue enumvalue : memberEnum.getEnumItem().getEnumvalues()) {
                    if (!StringUtils.isEmpty((String)args.getValue()) && !enumvalue.getName().contains(args.getValue())) continue;
                    ArrayList<Object> arr = new ArrayList<Object>();
                    arr.add(String.valueOf(enumvalue.getId()));
                    arr.add(enumvalue.getInnerNum());
                    if (isNummic) {
                        arr.add(new BigDecimal(enumvalue.getName()));
                    } else {
                        arr.add(enumvalue.getName());
                    }
                    arrs.add(arr);
                }
                data.put("data", arrs);
                data.put("r", args.getR());
                data.put("c", args.getC());
            }
        }
        return data;
    }

    public static ListShowParameter getEnumTreeListShowParameter(Long modelId, SpreadManager sm, IPageCache pageCache, LookUpDataArgs args) {
        Cell cell = sm.getBook().getSheet(0).getCell(args.getR(), args.getC());
        if (CellEventService.isInExtAreaRecord(sm, Collections.singletonList(cell.getRow()))) {
            return CellEventService.getExtEnumTreeListShowParameter(modelId, sm, args);
        }
        HashMap cachemap = CellDataTypeUtil.getDataTypeCache((IPageCache)pageCache);
        EnumAndMembModel enumAndMembModel = CellDataTypeUtil.getCellDataType4EnumStyle((long)modelId, (Cell)cell, (IPageCache)pageCache, (SpreadManager)sm, (HashMap)cachemap);
        CellDataTypeUtil.cacheDataTypeInfo((IPageCache)pageCache, (HashMap)cachemap);
        ListShowParameter enumTreeF7Param = ShowFormHelper.createShowListForm((String)"bcm_enumvalue_new", (boolean)false, (int)0, (boolean)true);
        if (DataTypeEnum.ENUMTP.index == enumAndMembModel.getDataTypeEnum().index) {
            Map map;
            if (pageCache.get(MEMENUM) != null) {
                map = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(MEMENUM));
            } else {
                map = EnumItemServiceHelper.getAllEnumDimensionMember((long)modelId);
                pageCache.put(MEMENUM, ObjectSerialUtil.toByteSerialized((Object)map));
            }
            String key = enumAndMembModel.getDimNum() + "|" + enumAndMembModel.getMemNum();
            MemberEnum memberEnum = (MemberEnum)map.get(key);
            if (memberEnum != null && memberEnum.getEnumItem() != null) {
                enumTreeF7Param.setCustomParam("enumitemKey", (Object)memberEnum.getEnumItem().getId());
                ArrayList<Long> enumvalueIds = new ArrayList<Long>(16);
                HashMap<String, Long> enumvalue2IDs = new HashMap<String, Long>(16);
                for (Enumvalue enumvalue : memberEnum.getEnumItem().getEnumvalues()) {
                    enumvalueIds.add(enumvalue.getId());
                    enumvalue2IDs.put(enumvalue.getName(), enumvalue.getId());
                }
                DynamicObject enumItem = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"isallowmulti,isonlyleaf,multiseparator", (QFilter[])new QFilter("id", "=", (Object)memberEnum.getEnumItem().getId()).toArray());
                QFilter isonlyLeafFilter = null;
                if (enumItem != null) {
                    String cellVal;
                    boolean isonlyleaf = enumItem.getBoolean("isonlyleaf");
                    if (isonlyleaf) {
                        isonlyLeafFilter = new QFilter("isleaf", "=", (Object)isonlyleaf);
                    }
                    String multiseparator = enumItem.getString("multiseparator");
                    String string = cellVal = cell.getValue() != null ? cell.getValue().toString() : "";
                    if (cell.getValue() != null) {
                        String[] numbers;
                        try {
                            numbers = cellVal.split(multiseparator);
                        }
                        catch (Exception e) {
                            try {
                                numbers = cellVal.split(String.format("\\%s", multiseparator));
                            }
                            catch (Exception e1) {
                                numbers = new String[]{cellVal};
                            }
                        }
                        Object[] pkids = new Object[numbers.length];
                        for (int i = 0; i < numbers.length; ++i) {
                            pkids[i] = enumvalue2IDs.get(numbers[i]);
                        }
                        enumTreeF7Param.setSelectedRows(pkids);
                    }
                    enumTreeF7Param.setMultiSelect(enumItem.getBoolean("isallowmulti"));
                }
                QFilter qFilter = new QFilter("id", "in", enumvalueIds);
                if (isonlyLeafFilter != null) {
                    qFilter.and(isonlyLeafFilter);
                }
                enumTreeF7Param.getListFilterParameter().setFilter(qFilter);
            }
        } else {
            return null;
        }
        return enumTreeF7Param;
    }

    public static ListShowParameter getExtEnumTreeListShowParameter(Long modelId, SpreadManager sm, LookUpDataArgs args) {
        int headerRowIndex = 0;
        ExtendInfo extendInfo = null;
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            String position = ExcelUtils.xy2Pos((int)args.getC(), (int)args.getR());
            if (!ExcelUtils.isWithInScope((String)posInfo.getAreaRange(), (String)position)) continue;
            int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
            headerRowIndex = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            extendInfo = posInfo.getExtendInfo();
            break;
        }
        Cell headCell = sm.getBook().getSheet(0).getCell(headerRowIndex, args.getC());
        Map extCellMap = null;
        Object extCell = headCell.getUserObject().get((Object)"extdim_cell_enumtype");
        if (extCell != null) {
            String extCellStr = (String)extCell;
            extCellMap = (Map)ObjectSerialUtil.deSerializedBytes((String)extCellStr);
        }
        Cell cell = sm.getBook().getSheet(0).getCell(args.getR(), args.getC());
        ListShowParameter enumTreeF7Param = ShowFormHelper.createShowListForm((String)"bcm_enumvalue_new", (boolean)false, (int)0, (boolean)true);
        if (extCellMap != null && !extCellMap.isEmpty() && extendInfo != null) {
            String number = (String)extCellMap.get("number");
            String extGroup = (String)extCellMap.get("extGroup");
            Map extMemberEnumValueMap = ExtDimensionHelper.getExtMemberEnumValueByNumber((Long)modelId, (String)extGroup, Collections.singletonList(number));
            ArrayList<Long> enumvalueIds = new ArrayList<Long>(extMemberEnumValueMap.size());
            QFilter isonlyLeafFilter = null;
            if (MapUtils.isNotEmpty((Map)extMemberEnumValueMap)) {
                List enumValues = (List)extMemberEnumValueMap.get(number);
                HashMap<String, Long> enumvalue2IDs = new HashMap<String, Long>(16);
                List ids = extendInfo.getEnumValueRange(number);
                boolean isExitEnumRange = CollectionUtils.isNotEmpty((Collection)ids);
                for (DynamicObject enumvalue : enumValues) {
                    if (isExitEnumRange && !ids.contains(enumvalue.getLong("id"))) continue;
                    enumvalue2IDs.put(enumvalue.getString("enumvalue"), enumvalue.getLong("id"));
                    if (!StringUtils.isEmpty((String)args.getValue()) && (enumvalue.getString("enumvalue") == null || !enumvalue.getString("enumvalue").contains(args.getValue()))) continue;
                    enumvalueIds.add(enumvalue.getLong("id"));
                }
                if (CollectionUtils.isNotEmpty((Collection)enumValues)) {
                    Long enumitemId = ((DynamicObject)enumValues.get(0)).getLong("enumitemid");
                    DynamicObject enumItem = QueryServiceHelper.queryOne((String)"bcm_enumitem_new", (String)"isallowmulti,isonlyleaf,multiseparator", (QFilter[])new QFilter("id", "=", (Object)enumitemId).toArray());
                    if (enumItem != null) {
                        String cellVal;
                        boolean isonlyleaf = enumItem.getBoolean("isonlyleaf");
                        if (isonlyleaf) {
                            isonlyLeafFilter = new QFilter("isleaf", "=", (Object)isonlyleaf);
                        }
                        String multiseparator = enumItem.getString("multiseparator");
                        String string = cellVal = cell.getValue() != null ? cell.getValue().toString() : "";
                        if (cell.getValue() != null) {
                            String[] numbers = cellVal.split(multiseparator);
                            Object[] pkids = new Object[numbers.length];
                            for (int i = 0; i < numbers.length; ++i) {
                                pkids[i] = enumvalue2IDs.get(numbers[i]);
                            }
                            enumTreeF7Param.setSelectedRows(pkids);
                        }
                        enumTreeF7Param.setMultiSelect(enumItem.getBoolean("isallowmulti"));
                    }
                    enumTreeF7Param.setCustomParam("enumitemKey", (Object)enumitemId);
                }
            }
            QFilter qFilter = new QFilter("id", "in", enumvalueIds);
            if (isonlyLeafFilter != null) {
                qFilter.and(isonlyLeafFilter);
            }
            enumTreeF7Param.getListFilterParameter().setFilter(qFilter);
        }
        if (enumTreeF7Param.getListFilterParameter() != null && enumTreeF7Param.getListFilterParameter().getQFilters().isEmpty()) {
            return null;
        }
        return enumTreeF7Param;
    }

    public static List<LinkedHashMap<String, Object>> validateEnumValues(Long modelId, SpreadManager sm, IPageCache pageCache, SpreadPostDataInfo data) {
        Map map;
        ArrayList<LinkedHashMap<String, Object>> clearValues = new ArrayList<LinkedHashMap<String, Object>>(16);
        if (CollectionUtils.isEmpty((Collection)sm.getAreaManager().getPostionInfoSet())) {
            return clearValues;
        }
        HashMap cachemap = CellDataTypeUtil.getDataTypeCache((IPageCache)pageCache);
        if (pageCache.get(MEMENUM) != null) {
            map = (Map)ObjectSerialUtil.deSerializedBytes((String)pageCache.get(MEMENUM));
        } else {
            map = EnumItemServiceHelper.getAllEnumDimensionMember((long)modelId);
            pageCache.put(MEMENUM, ObjectSerialUtil.toByteSerialized((Object)map));
        }
        FormulaChecker formulaChecker = new FormulaChecker();
        for (LinkedHashMap value : data.getValues()) {
            DataTypeEnum datatype;
            int row = (Integer)value.get("r");
            int col = (Integer)value.get("c");
            Object updatevalue = value.get("v");
            Cell cell = sm.getBook().getSheet(0).getCell(row, col);
            PositionInfo positionInfo = sm.getInAreaPositionByRow(cell.getRow(), cell.getCol());
            if (cell.isMdDataDomain()) {
                EnumAndMembModel enumAndMembModel = CellDataTypeUtil.getCellDataType4EnumStyle((long)modelId, (Cell)cell, (IPageCache)pageCache, (SpreadManager)sm, (HashMap)cachemap);
                if (DataTypeEnum.ENUMTP.index != enumAndMembModel.getDataTypeEnum().index) continue;
                String key = enumAndMembModel.getDimNum() + "|" + enumAndMembModel.getMemNum();
                MemberEnum memberEnum = (MemberEnum)map.get(key);
                if (memberEnum == null || memberEnum.getEnumItem() == null || memberEnum.getEnumItem().getEnumvalues() == null) {
                    if (!cell.hasFormula() || formulaChecker.checkIsOnlyExcel(cell.getFormula())) continue;
                    clearValues.add(value);
                    continue;
                }
                List values = memberEnum.getEnumItem().getEnumvalues().stream().map(v -> v.getName()).collect(Collectors.toList());
                if (memberEnum == null || values.contains(updatevalue) || !cell.hasFormula() || formulaChecker.checkIsOnlyExcel(cell.getFormula())) continue;
                value.put("v", null);
                clearValues.add(value);
                continue;
            }
            if (positionInfo == null || positionInfo.getExtendInfo() == null || (datatype = CellDataTypeUtil.getCellDataType((long)modelId, (Cell)cell, (IPageCache)pageCache, (SpreadManager)sm, (HashMap)cachemap)) != DataTypeEnum.ENUMTP) continue;
            String headCol = sm.getExtHeadCol2(cell.getRow(), cell.getCol());
            List<Object> enumItems = CellEventService.getExtColEnumItems(modelId, positionInfo.getExtendInfo().getExtGroup(), headCol, positionInfo.getExtendInfo().getEnumValueRange(headCol));
            if (enumItems.isEmpty()) {
                return clearValues;
            }
            if (updatevalue instanceof Number) {
                boolean isEqualValue = enumItems.stream().anyMatch(e -> new Variant(e).equals(updatevalue));
                if (isEqualValue) continue;
                value.put("v", null);
                clearValues.add(value);
                continue;
            }
            if (updatevalue == null || enumItems.contains(updatevalue) || enumItems.contains(updatevalue.toString())) continue;
            value.put("v", null);
            clearValues.add(value);
        }
        CellDataTypeUtil.cacheDataTypeInfo((IPageCache)pageCache, (HashMap)cachemap);
        return clearValues;
    }

    public static Map<String, Object> setEnumForExtCell(Long modelId, SpreadManager sm, LookUpDataArgs args) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        int headerRowIndex = 0;
        ExtendInfo extendInfo = null;
        for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
            String position = ExcelUtils.xy2Pos((int)args.getC(), (int)args.getR());
            if (!ExcelUtils.isWithInScope((String)posInfo.getAreaRange(), (String)position)) continue;
            int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
            headerRowIndex = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            extendInfo = posInfo.getExtendInfo();
            break;
        }
        Cell headCell = sm.getBook().getSheet(0).getCell(headerRowIndex, args.getC());
        Map extCellMap = null;
        Object extCell = headCell.getUserObject().get((Object)"extdim_cell_enumtype");
        if (extCell != null) {
            String extCellStr = (String)extCell;
            extCellMap = (Map)ObjectSerialUtil.deSerializedBytes((String)extCellStr);
        }
        if (extCellMap != null && !extCellMap.isEmpty() && extendInfo != null) {
            String number = (String)extCellMap.get("number");
            String extGroup = (String)extCellMap.get("extGroup");
            Map extMemberEnumValueMap = ExtDimensionHelper.getExtMemberEnumValueByNumber((Long)modelId, (String)extGroup, Collections.singletonList(number));
            ArrayList arrs = new ArrayList(extMemberEnumValueMap.size());
            if (MapUtils.isNotEmpty((Map)extMemberEnumValueMap)) {
                List enumValues = (List)extMemberEnumValueMap.get(number);
                List ids = extendInfo.getEnumValueRange(number);
                boolean isExitEnumRange = CollectionUtils.isNotEmpty((Collection)ids);
                for (DynamicObject enumvalue : enumValues) {
                    if (isExitEnumRange && !ids.contains(enumvalue.getLong("id")) || !StringUtils.isEmpty((String)args.getValue()) && (enumvalue.getString("enumvalue") == null || !enumvalue.getString("enumvalue").contains(args.getValue()))) continue;
                    ArrayList<String> arr = new ArrayList<String>();
                    arr.add(String.valueOf(enumvalue.getLong("id")));
                    arr.add(enumvalue.getString("name"));
                    arr.add(enumvalue.getString("enumvalue"));
                    arrs.add(arr);
                }
            }
            data.put("data", arrs);
            data.put("r", args.getR());
            data.put("c", args.getC());
        }
        return data;
    }

    public static List<Object> getExtColEnumItems(Long modelId, String groupNum, String number, List<Long> ids) {
        Map extMemberEnumValueMap = (Map)ThreadCache.get((Object)String.join((CharSequence)"|", "" + modelId, groupNum, number), () -> ExtDimensionHelper.getExtMemberEnumValueByNumber((Long)modelId, (String)groupNum, Collections.singletonList(number)));
        ArrayList<Object> arrs = new ArrayList<Object>(extMemberEnumValueMap.size());
        if (MapUtils.isNotEmpty((Map)extMemberEnumValueMap)) {
            List enumValues = (List)extMemberEnumValueMap.get(number);
            if (CollectionUtils.isEmpty((Collection)enumValues)) {
                return arrs;
            }
            if (CollectionUtils.isNotEmpty(ids) && CollectionUtils.isEmpty(enumValues = enumValues.stream().filter(e -> ids.contains(e.getLong("id"))).collect(Collectors.toList()))) {
                enumValues = (List)extMemberEnumValueMap.get(number);
            }
            if (!enumValues.isEmpty()) {
                enumValues.sort(Comparator.comparingInt(c -> c.getInt("dseq")));
                for (DynamicObject enumvalue : enumValues) {
                    arrs.add(enumvalue.get("enumvalue"));
                }
            }
        }
        return arrs;
    }

    public static boolean isInExtAreaRecord(SpreadManager sm, List<Integer> selrows) {
        Boolean isInExt = Boolean.FALSE;
        block0: for (PositionInfo position : sm.getAreaManager().getPostionInfoSet()) {
            if (position.getExtendInfo() == null) continue;
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)position.getAreaRange());
            for (Integer it : selrows) {
                if (it < rangemodel.getY_start() || it > rangemodel.getY_end()) continue;
                isInExt = Boolean.TRUE;
                continue block0;
            }
        }
        return isInExt;
    }

    public static boolean extFloatF7LookUpData(LookUpDataArgs args, AbstractMultiReportPlugin plugin, SpreadManager sm, String spreadKey, IClientViewProxy viewProxy) {
        PositionInfo posInfo = plugin.getSpreadModel().getInAreaPositionByRow(args.getR(), args.getC());
        if (posInfo == null || posInfo.getExtendInfo() == null || posInfo.getExtendInfo().getFloatdims() == null) {
            return Boolean.FALSE;
        }
        int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
        int headerRow = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
        String dimNumber = sm.getBook().getSheet(0).getCell(headerRow, args.getC()).getEXTColNumber();
        for (FloatDimInfo floatdim : posInfo.getExtendInfo().getFloatdims()) {
            if (!floatdim.getDimension().getNumber().equals(dimNumber)) continue;
            if (floatdim.getMember() != null && floatdim.getDynaMembScopes().isEmpty()) {
                String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber);
                QFilter filterdetail = new QFilter("number", "=", (Object)floatdim.getMember().getNumber()).and("model", "=", (Object)plugin.getModelId());
                SpreadUtils.spreadF7lookUpData(viewProxy, spreadKey, entityNum, dimNumber, args, plugin.getModelId(), filterdetail, null, null, null);
                return Boolean.TRUE;
            }
            CellEventService.setFloatLookUpMembers(args, plugin, spreadKey, viewProxy, dimNumber, null, floatdim.getDynaMembScopes());
            return Boolean.TRUE;
        }
        MultiF7Results multiF7ValueByExtMem = ExtDataUtil.getMultiF7ValueByExtMem((String)dimNumber, (long)plugin.getModelId());
        DynamicObject dimDy = multiF7ValueByExtMem.getDimDy();
        if (dimDy != null) {
            CellEventService.setExtFloatLookUpMembers(args, plugin, spreadKey, viewProxy, multiF7ValueByExtMem);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setFloatLookUpMembers(LookUpDataArgs args, AbstractMultiReportPlugin plugin, String spreadKey, IClientViewProxy viewProxy, String dimNumber, BasePointInnerLineInfo info, List<DynaMembScopeInfo> dynaMembScopes) {
        QFilter numberFilter = new QFilter("number", "=", (Object)dimNumber);
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)plugin.getModelId()), numberFilter});
        String entityNum = dimObj.getString("membermodel");
        String dimNum = dimObj.getString("number");
        if (entityNum == null || dimNum == null) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ef4\u5ea6\u5b9e\u4f53\u3002", (String)"AbstractMultiReportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            QFilter filterdetail;
            PositionInfo posInfo = plugin.getSpreadModel().getInAreaPositionByRow(args.getR(), args.getC());
            if (posInfo != null && posInfo.getExtendInfo() != null) {
                try {
                    filterdetail = TemplateFloatUtil.getFloatQFilter(plugin.getSpreadModel(), plugin.getTemplateModel().getModelId(), dimObj.getLong("id"), dynaMembScopes, dimNumber);
                }
                catch (Exception e) {
                    filterdetail = TemplateFloatUtil.getFloatQFilter(plugin.getTemplateModel().getModelId(), dimObj.getLong("id"), dynaMembScopes, dimNumber);
                }
            } else {
                if (info == null) {
                    return;
                }
                filterdetail = TemplateFloatUtil.getFilterByInnerInfo_All(plugin.getSpreadModel(), null, info.getDynaMembScopes(), plugin.getTemplateModel().getModelId(), dimObj.getLong("id"));
            }
            SpreadUtils.spreadF7lookUpData(viewProxy, spreadKey, entityNum, dimNum, args, plugin.getModelId(), filterdetail, null, null, null);
        }
        catch (Exception e) {
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6a21\u677f\u6d6e\u52a8\u8bbe\u7f6e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%2$s\u3002", (String)"AbstractMultiReportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), plugin.getTemplateModel().getName(), e.getMessage()));
        }
    }

    public static void setExtFloatLookUpMembers(LookUpDataArgs args, AbstractMultiReportPlugin plugin, String spreadKey, IClientViewProxy viewProxy, MultiF7Results multiF7ValueByExtMem) {
        DynamicObject dimDy = multiF7ValueByExtMem.getDimDy();
        String number = dimDy.getString("number");
        QFilter qFilter = new QFilter("model", "=", (Object)plugin.getModelId());
        qFilter.and("number", "=", (Object)number);
        DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])qFilter.toArray());
        if (dim == null) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ef4\u5ea6\u5b9e\u4f53\u3002", (String)"AbstractMultiReportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNum = dim.getString("membermodel");
        String dimNum = dim.getString("number");
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)dimNum)) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ef4\u5ea6\u5b9e\u4f53\u3002", (String)"AbstractMultiReportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            List<DynaMembScopeInfo> scopeInfos = TemplateFloatUtil.getDynaMembScopeInfos(multiF7ValueByExtMem);
            QFilter filterdetail = TemplateFloatUtil.getFloatQFilter(plugin.getTemplateModel().getModelId(), dim.getLong("id"), scopeInfos, dimNum);
            SpreadUtils.spreadF7lookUpData(viewProxy, spreadKey, entityNum, dimNum, args, plugin.getModelId(), filterdetail, null, null, null);
        }
        catch (Exception e) {
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6a21\u677f\u6d6e\u52a8\u8bbe\u7f6e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%2$s\u3002", (String)"AbstractMultiReportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), plugin.getTemplateModel().getName(), e.getMessage()));
        }
    }
}

